// lockvirt.cpp : Defines the exported functions for the DLL application.
//

#include "stdafx.h"
#include "lockvirt.h"

using namespace std;

list<HANDLE> drvHandle;
typedef list<HANDLE>::iterator Iterator;
CHAR RedHat[] = "Red Hat ";



LOCKVIRT_API void lock_viostor(void)
{
    TCHAR drvLetter;
    TCHAR drvName[DRIVE_NAME];
    HANDLE handle;
    DWORD cbRet;
    PSTORAGE_DEVICE_DESCRIPTOR devDescr = NULL;
    STORAGE_DESCRIPTOR_HEADER header = {0}; 
    for (drvLetter = 'C'; drvLetter <= 'Z'; drvLetter++)
    {
        HRESULT hr;
        LPCSTR VendorID = "";
        BOOL viostor = FALSE;
        hr = StringCchPrintf(drvName, DRIVE_NAME, L"\\\\.\\%c:", drvLetter);
        handle = CreateFile (drvName,
                            GENERIC_READ,
                            FILE_SHARE_READ | FILE_SHARE_WRITE,
                            NULL,
                            OPEN_EXISTING,
                            0,//FILE_FLAG_NO_BUFFERING,
                            NULL);

        if (handle == INVALID_HANDLE_VALUE)
        {
            continue;
        }

        for (int i = 0; i < 2; i++)
        {
            PVOID buffer = NULL;
            ULONG bufSize = 0;
            STORAGE_PROPERTY_QUERY query;

            query.QueryType = PropertyStandardQuery;
            query.PropertyId = StorageDeviceProperty;

            if (i == 0)
            {
                bufSize = sizeof(STORAGE_DESCRIPTOR_HEADER);
                buffer = &header;
            }
            else
            {
                bufSize = header.Size;
                if (bufSize != 0)
                {
                    devDescr = (PSTORAGE_DEVICE_DESCRIPTOR) LocalAlloc(LPTR, bufSize);
                    if (devDescr == NULL)
                    {
                        break;
                    }
                    buffer = devDescr;
                }
            }

            if (buffer != NULL)
            {
                ZeroMemory(buffer, bufSize);
                if(!DeviceIoControl(handle,
                                    IOCTL_STORAGE_QUERY_PROPERTY,
                                    &query,
                                    sizeof(STORAGE_PROPERTY_QUERY),
                                    buffer,
                                    bufSize,
                                    &cbRet,
                                    NULL))
                {
                    DWORD lastErr = GetLastError();
                    if( lastErr == ERROR_MORE_DATA ||
                        lastErr == ERROR_INVALID_FUNCTION ||
                        lastErr == ERROR_NOT_SUPPORTED)
                    {

                    }
                    else
                    {
                        CloseHandle(handle);
                        continue;
                    }
                }
            }
        }
        if ((devDescr == NULL) ||
            (devDescr->BusType != BusTypeScsi))
        {
            CloseHandle(handle);
            continue;
        }

        if ((devDescr->VendorIdOffset != 0) &&
            (devDescr->VendorIdOffset != -1))
        {
            VendorID = (LPCSTR )devDescr;
            VendorID +=(ULONG_PTR)devDescr->VendorIdOffset;
            if (!strcmp(RedHat, VendorID))
            {
                viostor = TRUE;
            }
        }
        
        LocalFree(devDescr);
        if (!viostor)
        {
            CloseHandle(handle);
            continue;
        }
        if (!DeviceIoControl(handle,
                            FSCTL_LOCK_VOLUME,
                            NULL,
                            0,
                            NULL,
                            0,
                            &cbRet,
                            NULL))
        {
            CloseHandle(handle);
            continue;
        }
        drvHandle.push_back(handle);
        printf ("push_back. Handle = %x\n", handle);
    }
}

LOCKVIRT_API void unlock_viostor(void)
{
    DWORD cbRet;
    for (Iterator it = drvHandle.begin(); it != drvHandle.end(); it++)
    {
        if (DeviceIoControl(*it,
                            FSCTL_UNLOCK_VOLUME,
                            NULL,
                            0,
                            NULL,
                            0,
                            &cbRet,
                            NULL))
        {
            printf ("CloseHandle = %x\n", *it);
            CloseHandle(*it);
            continue;
        }
        printf ("Error unlocking drive. Handle = %x\n", *it);
    }
    drvHandle.clear();
}
