"use strict";
/**
 * Kubernetes
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v1.13.7
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const localVarRequest = require("request");
let defaultBasePath = 'https://localhost';
// ===============================================
// This file is autogenerated - Please do not edit
// ===============================================
/* tslint:disable:no-unused-variable */
let primitives = [
    "string",
    "boolean",
    "double",
    "integer",
    "long",
    "float",
    "number",
    "any"
];
class ObjectSerializer {
    static findCorrectType(data, expectedType) {
        if (data == undefined) {
            return expectedType;
        }
        else if (primitives.indexOf(expectedType.toLowerCase()) !== -1) {
            return expectedType;
        }
        else if (expectedType === "Date") {
            return expectedType;
        }
        else {
            if (enumsMap[expectedType]) {
                return expectedType;
            }
            if (!typeMap[expectedType]) {
                return expectedType; // w/e we don't know the type
            }
            // Check the discriminator
            let discriminatorProperty = typeMap[expectedType].discriminator;
            if (discriminatorProperty == null) {
                return expectedType; // the type does not have a discriminator. use it.
            }
            else {
                if (data[discriminatorProperty]) {
                    return data[discriminatorProperty]; // use the type given in the discriminator
                }
                else {
                    return expectedType; // discriminator was not present (or an empty string)
                }
            }
        }
    }
    static serialize(data, type) {
        if (data == undefined) {
            return data;
        }
        else if (primitives.indexOf(type.toLowerCase()) !== -1) {
            return data;
        }
        else if (type.lastIndexOf("Array<", 0) === 0) { // string.startsWith pre es6
            let subType = type.replace("Array<", ""); // Array<Type> => Type>
            subType = subType.substring(0, subType.length - 1); // Type> => Type
            let transformedData = [];
            for (let index in data) {
                let date = data[index];
                transformedData.push(ObjectSerializer.serialize(date, subType));
            }
            return transformedData;
        }
        else if (type === "Date") {
            return data.toString();
        }
        else {
            if (enumsMap[type]) {
                return data;
            }
            if (!typeMap[type]) { // in case we dont know the type
                return data;
            }
            // get the map for the correct type.
            let attributeTypes = typeMap[type].getAttributeTypeMap();
            let instance = {};
            for (let index in attributeTypes) {
                let attributeType = attributeTypes[index];
                instance[attributeType.baseName] = ObjectSerializer.serialize(data[attributeType.name], attributeType.type);
            }
            return instance;
        }
    }
    static deserialize(data, type) {
        // polymorphism may change the actual type.
        type = ObjectSerializer.findCorrectType(data, type);
        if (data == undefined) {
            return data;
        }
        else if (primitives.indexOf(type.toLowerCase()) !== -1) {
            return data;
        }
        else if (type.lastIndexOf("Array<", 0) === 0) { // string.startsWith pre es6
            let subType = type.replace("Array<", ""); // Array<Type> => Type>
            subType = subType.substring(0, subType.length - 1); // Type> => Type
            let transformedData = [];
            for (let index in data) {
                let date = data[index];
                transformedData.push(ObjectSerializer.deserialize(date, subType));
            }
            return transformedData;
        }
        else if (type === "Date") {
            return new Date(data);
        }
        else {
            if (enumsMap[type]) { // is Enum
                return data;
            }
            if (!typeMap[type]) { // dont know the type
                return data;
            }
            let instance = new typeMap[type]();
            let attributeTypes = typeMap[type].getAttributeTypeMap();
            for (let index in attributeTypes) {
                let attributeType = attributeTypes[index];
                instance[attributeType.name] = ObjectSerializer.deserialize(data[attributeType.baseName], attributeType.type);
            }
            return instance;
        }
    }
}
/**
* ServiceReference holds a reference to Service.legacy.k8s.io
*/
class AdmissionregistrationV1beta1ServiceReference {
    static getAttributeTypeMap() {
        return AdmissionregistrationV1beta1ServiceReference.attributeTypeMap;
    }
}
AdmissionregistrationV1beta1ServiceReference.discriminator = undefined;
AdmissionregistrationV1beta1ServiceReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.AdmissionregistrationV1beta1ServiceReference = AdmissionregistrationV1beta1ServiceReference;
/**
* WebhookClientConfig contains the information to make a TLS connection with the webhook
*/
class AdmissionregistrationV1beta1WebhookClientConfig {
    static getAttributeTypeMap() {
        return AdmissionregistrationV1beta1WebhookClientConfig.attributeTypeMap;
    }
}
AdmissionregistrationV1beta1WebhookClientConfig.discriminator = undefined;
AdmissionregistrationV1beta1WebhookClientConfig.attributeTypeMap = [
    {
        "name": "caBundle",
        "baseName": "caBundle",
        "type": "string"
    },
    {
        "name": "service",
        "baseName": "service",
        "type": "AdmissionregistrationV1beta1ServiceReference"
    },
    {
        "name": "url",
        "baseName": "url",
        "type": "string"
    }
];
exports.AdmissionregistrationV1beta1WebhookClientConfig = AdmissionregistrationV1beta1WebhookClientConfig;
/**
* ServiceReference holds a reference to Service.legacy.k8s.io
*/
class ApiextensionsV1beta1ServiceReference {
    static getAttributeTypeMap() {
        return ApiextensionsV1beta1ServiceReference.attributeTypeMap;
    }
}
ApiextensionsV1beta1ServiceReference.discriminator = undefined;
ApiextensionsV1beta1ServiceReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.ApiextensionsV1beta1ServiceReference = ApiextensionsV1beta1ServiceReference;
/**
* WebhookClientConfig contains the information to make a TLS connection with the webhook. It has the same field as admissionregistration.v1beta1.WebhookClientConfig.
*/
class ApiextensionsV1beta1WebhookClientConfig {
    static getAttributeTypeMap() {
        return ApiextensionsV1beta1WebhookClientConfig.attributeTypeMap;
    }
}
ApiextensionsV1beta1WebhookClientConfig.discriminator = undefined;
ApiextensionsV1beta1WebhookClientConfig.attributeTypeMap = [
    {
        "name": "caBundle",
        "baseName": "caBundle",
        "type": "string"
    },
    {
        "name": "service",
        "baseName": "service",
        "type": "ApiextensionsV1beta1ServiceReference"
    },
    {
        "name": "url",
        "baseName": "url",
        "type": "string"
    }
];
exports.ApiextensionsV1beta1WebhookClientConfig = ApiextensionsV1beta1WebhookClientConfig;
/**
* ServiceReference holds a reference to Service.legacy.k8s.io
*/
class ApiregistrationV1beta1ServiceReference {
    static getAttributeTypeMap() {
        return ApiregistrationV1beta1ServiceReference.attributeTypeMap;
    }
}
ApiregistrationV1beta1ServiceReference.discriminator = undefined;
ApiregistrationV1beta1ServiceReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.ApiregistrationV1beta1ServiceReference = ApiregistrationV1beta1ServiceReference;
/**
* DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.
*/
class AppsV1beta1Deployment {
    static getAttributeTypeMap() {
        return AppsV1beta1Deployment.attributeTypeMap;
    }
}
AppsV1beta1Deployment.discriminator = undefined;
AppsV1beta1Deployment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "AppsV1beta1DeploymentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "AppsV1beta1DeploymentStatus"
    }
];
exports.AppsV1beta1Deployment = AppsV1beta1Deployment;
/**
* DeploymentCondition describes the state of a deployment at a certain point.
*/
class AppsV1beta1DeploymentCondition {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentCondition.attributeTypeMap;
    }
}
AppsV1beta1DeploymentCondition.discriminator = undefined;
AppsV1beta1DeploymentCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "lastUpdateTime",
        "baseName": "lastUpdateTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.AppsV1beta1DeploymentCondition = AppsV1beta1DeploymentCondition;
/**
* DeploymentList is a list of Deployments.
*/
class AppsV1beta1DeploymentList {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentList.attributeTypeMap;
    }
}
AppsV1beta1DeploymentList.discriminator = undefined;
AppsV1beta1DeploymentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<AppsV1beta1Deployment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.AppsV1beta1DeploymentList = AppsV1beta1DeploymentList;
/**
* DEPRECATED. DeploymentRollback stores the information required to rollback a deployment.
*/
class AppsV1beta1DeploymentRollback {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentRollback.attributeTypeMap;
    }
}
AppsV1beta1DeploymentRollback.discriminator = undefined;
AppsV1beta1DeploymentRollback.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "rollbackTo",
        "baseName": "rollbackTo",
        "type": "AppsV1beta1RollbackConfig"
    },
    {
        "name": "updatedAnnotations",
        "baseName": "updatedAnnotations",
        "type": "{ [key: string]: string; }"
    }
];
exports.AppsV1beta1DeploymentRollback = AppsV1beta1DeploymentRollback;
/**
* DeploymentSpec is the specification of the desired behavior of the Deployment.
*/
class AppsV1beta1DeploymentSpec {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentSpec.attributeTypeMap;
    }
}
AppsV1beta1DeploymentSpec.discriminator = undefined;
AppsV1beta1DeploymentSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "paused",
        "baseName": "paused",
        "type": "boolean"
    },
    {
        "name": "progressDeadlineSeconds",
        "baseName": "progressDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "rollbackTo",
        "baseName": "rollbackTo",
        "type": "AppsV1beta1RollbackConfig"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "strategy",
        "baseName": "strategy",
        "type": "AppsV1beta1DeploymentStrategy"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.AppsV1beta1DeploymentSpec = AppsV1beta1DeploymentSpec;
/**
* DeploymentStatus is the most recently observed status of the Deployment.
*/
class AppsV1beta1DeploymentStatus {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentStatus.attributeTypeMap;
    }
}
AppsV1beta1DeploymentStatus.discriminator = undefined;
AppsV1beta1DeploymentStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<AppsV1beta1DeploymentCondition>"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "unavailableReplicas",
        "baseName": "unavailableReplicas",
        "type": "number"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.AppsV1beta1DeploymentStatus = AppsV1beta1DeploymentStatus;
/**
* DeploymentStrategy describes how to replace existing pods with new ones.
*/
class AppsV1beta1DeploymentStrategy {
    static getAttributeTypeMap() {
        return AppsV1beta1DeploymentStrategy.attributeTypeMap;
    }
}
AppsV1beta1DeploymentStrategy.discriminator = undefined;
AppsV1beta1DeploymentStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "AppsV1beta1RollingUpdateDeployment"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.AppsV1beta1DeploymentStrategy = AppsV1beta1DeploymentStrategy;
/**
* DEPRECATED.
*/
class AppsV1beta1RollbackConfig {
    static getAttributeTypeMap() {
        return AppsV1beta1RollbackConfig.attributeTypeMap;
    }
}
AppsV1beta1RollbackConfig.discriminator = undefined;
AppsV1beta1RollbackConfig.attributeTypeMap = [
    {
        "name": "revision",
        "baseName": "revision",
        "type": "number"
    }
];
exports.AppsV1beta1RollbackConfig = AppsV1beta1RollbackConfig;
/**
* Spec to control the desired behavior of rolling update.
*/
class AppsV1beta1RollingUpdateDeployment {
    static getAttributeTypeMap() {
        return AppsV1beta1RollingUpdateDeployment.attributeTypeMap;
    }
}
AppsV1beta1RollingUpdateDeployment.discriminator = undefined;
AppsV1beta1RollingUpdateDeployment.attributeTypeMap = [
    {
        "name": "maxSurge",
        "baseName": "maxSurge",
        "type": "any"
    },
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.AppsV1beta1RollingUpdateDeployment = AppsV1beta1RollingUpdateDeployment;
/**
* Scale represents a scaling request for a resource.
*/
class AppsV1beta1Scale {
    static getAttributeTypeMap() {
        return AppsV1beta1Scale.attributeTypeMap;
    }
}
AppsV1beta1Scale.discriminator = undefined;
AppsV1beta1Scale.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "AppsV1beta1ScaleSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "AppsV1beta1ScaleStatus"
    }
];
exports.AppsV1beta1Scale = AppsV1beta1Scale;
/**
* ScaleSpec describes the attributes of a scale subresource
*/
class AppsV1beta1ScaleSpec {
    static getAttributeTypeMap() {
        return AppsV1beta1ScaleSpec.attributeTypeMap;
    }
}
AppsV1beta1ScaleSpec.discriminator = undefined;
AppsV1beta1ScaleSpec.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.AppsV1beta1ScaleSpec = AppsV1beta1ScaleSpec;
/**
* ScaleStatus represents the current status of a scale subresource.
*/
class AppsV1beta1ScaleStatus {
    static getAttributeTypeMap() {
        return AppsV1beta1ScaleStatus.attributeTypeMap;
    }
}
AppsV1beta1ScaleStatus.discriminator = undefined;
AppsV1beta1ScaleStatus.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "targetSelector",
        "baseName": "targetSelector",
        "type": "string"
    }
];
exports.AppsV1beta1ScaleStatus = AppsV1beta1ScaleStatus;
/**
* AllowedFlexVolume represents a single Flexvolume that is allowed to be used. Deprecated: use AllowedFlexVolume from policy API Group instead.
*/
class ExtensionsV1beta1AllowedFlexVolume {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1AllowedFlexVolume.attributeTypeMap;
    }
}
ExtensionsV1beta1AllowedFlexVolume.discriminator = undefined;
ExtensionsV1beta1AllowedFlexVolume.attributeTypeMap = [
    {
        "name": "driver",
        "baseName": "driver",
        "type": "string"
    }
];
exports.ExtensionsV1beta1AllowedFlexVolume = ExtensionsV1beta1AllowedFlexVolume;
/**
* AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined. Deprecated: use AllowedHostPath from policy API Group instead.
*/
class ExtensionsV1beta1AllowedHostPath {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1AllowedHostPath.attributeTypeMap;
    }
}
ExtensionsV1beta1AllowedHostPath.discriminator = undefined;
ExtensionsV1beta1AllowedHostPath.attributeTypeMap = [
    {
        "name": "pathPrefix",
        "baseName": "pathPrefix",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.ExtensionsV1beta1AllowedHostPath = ExtensionsV1beta1AllowedHostPath;
/**
* DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.
*/
class ExtensionsV1beta1Deployment {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1Deployment.attributeTypeMap;
    }
}
ExtensionsV1beta1Deployment.discriminator = undefined;
ExtensionsV1beta1Deployment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "ExtensionsV1beta1DeploymentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "ExtensionsV1beta1DeploymentStatus"
    }
];
exports.ExtensionsV1beta1Deployment = ExtensionsV1beta1Deployment;
/**
* DeploymentCondition describes the state of a deployment at a certain point.
*/
class ExtensionsV1beta1DeploymentCondition {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentCondition.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentCondition.discriminator = undefined;
ExtensionsV1beta1DeploymentCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "lastUpdateTime",
        "baseName": "lastUpdateTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.ExtensionsV1beta1DeploymentCondition = ExtensionsV1beta1DeploymentCondition;
/**
* DeploymentList is a list of Deployments.
*/
class ExtensionsV1beta1DeploymentList {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentList.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentList.discriminator = undefined;
ExtensionsV1beta1DeploymentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<ExtensionsV1beta1Deployment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.ExtensionsV1beta1DeploymentList = ExtensionsV1beta1DeploymentList;
/**
* DEPRECATED. DeploymentRollback stores the information required to rollback a deployment.
*/
class ExtensionsV1beta1DeploymentRollback {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentRollback.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentRollback.discriminator = undefined;
ExtensionsV1beta1DeploymentRollback.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "rollbackTo",
        "baseName": "rollbackTo",
        "type": "ExtensionsV1beta1RollbackConfig"
    },
    {
        "name": "updatedAnnotations",
        "baseName": "updatedAnnotations",
        "type": "{ [key: string]: string; }"
    }
];
exports.ExtensionsV1beta1DeploymentRollback = ExtensionsV1beta1DeploymentRollback;
/**
* DeploymentSpec is the specification of the desired behavior of the Deployment.
*/
class ExtensionsV1beta1DeploymentSpec {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentSpec.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentSpec.discriminator = undefined;
ExtensionsV1beta1DeploymentSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "paused",
        "baseName": "paused",
        "type": "boolean"
    },
    {
        "name": "progressDeadlineSeconds",
        "baseName": "progressDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "rollbackTo",
        "baseName": "rollbackTo",
        "type": "ExtensionsV1beta1RollbackConfig"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "strategy",
        "baseName": "strategy",
        "type": "ExtensionsV1beta1DeploymentStrategy"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.ExtensionsV1beta1DeploymentSpec = ExtensionsV1beta1DeploymentSpec;
/**
* DeploymentStatus is the most recently observed status of the Deployment.
*/
class ExtensionsV1beta1DeploymentStatus {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentStatus.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentStatus.discriminator = undefined;
ExtensionsV1beta1DeploymentStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<ExtensionsV1beta1DeploymentCondition>"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "unavailableReplicas",
        "baseName": "unavailableReplicas",
        "type": "number"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.ExtensionsV1beta1DeploymentStatus = ExtensionsV1beta1DeploymentStatus;
/**
* DeploymentStrategy describes how to replace existing pods with new ones.
*/
class ExtensionsV1beta1DeploymentStrategy {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1DeploymentStrategy.attributeTypeMap;
    }
}
ExtensionsV1beta1DeploymentStrategy.discriminator = undefined;
ExtensionsV1beta1DeploymentStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "ExtensionsV1beta1RollingUpdateDeployment"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.ExtensionsV1beta1DeploymentStrategy = ExtensionsV1beta1DeploymentStrategy;
/**
* FSGroupStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use FSGroupStrategyOptions from policy API Group instead.
*/
class ExtensionsV1beta1FSGroupStrategyOptions {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1FSGroupStrategyOptions.attributeTypeMap;
    }
}
ExtensionsV1beta1FSGroupStrategyOptions.discriminator = undefined;
ExtensionsV1beta1FSGroupStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<ExtensionsV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.ExtensionsV1beta1FSGroupStrategyOptions = ExtensionsV1beta1FSGroupStrategyOptions;
/**
* HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined. Deprecated: use HostPortRange from policy API Group instead.
*/
class ExtensionsV1beta1HostPortRange {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1HostPortRange.attributeTypeMap;
    }
}
ExtensionsV1beta1HostPortRange.discriminator = undefined;
ExtensionsV1beta1HostPortRange.attributeTypeMap = [
    {
        "name": "max",
        "baseName": "max",
        "type": "number"
    },
    {
        "name": "min",
        "baseName": "min",
        "type": "number"
    }
];
exports.ExtensionsV1beta1HostPortRange = ExtensionsV1beta1HostPortRange;
/**
* IDRange provides a min/max of an allowed range of IDs. Deprecated: use IDRange from policy API Group instead.
*/
class ExtensionsV1beta1IDRange {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1IDRange.attributeTypeMap;
    }
}
ExtensionsV1beta1IDRange.discriminator = undefined;
ExtensionsV1beta1IDRange.attributeTypeMap = [
    {
        "name": "max",
        "baseName": "max",
        "type": "number"
    },
    {
        "name": "min",
        "baseName": "min",
        "type": "number"
    }
];
exports.ExtensionsV1beta1IDRange = ExtensionsV1beta1IDRange;
/**
* PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container. Deprecated: use PodSecurityPolicy from policy API Group instead.
*/
class ExtensionsV1beta1PodSecurityPolicy {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1PodSecurityPolicy.attributeTypeMap;
    }
}
ExtensionsV1beta1PodSecurityPolicy.discriminator = undefined;
ExtensionsV1beta1PodSecurityPolicy.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "ExtensionsV1beta1PodSecurityPolicySpec"
    }
];
exports.ExtensionsV1beta1PodSecurityPolicy = ExtensionsV1beta1PodSecurityPolicy;
/**
* PodSecurityPolicyList is a list of PodSecurityPolicy objects. Deprecated: use PodSecurityPolicyList from policy API Group instead.
*/
class ExtensionsV1beta1PodSecurityPolicyList {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1PodSecurityPolicyList.attributeTypeMap;
    }
}
ExtensionsV1beta1PodSecurityPolicyList.discriminator = undefined;
ExtensionsV1beta1PodSecurityPolicyList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<ExtensionsV1beta1PodSecurityPolicy>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.ExtensionsV1beta1PodSecurityPolicyList = ExtensionsV1beta1PodSecurityPolicyList;
/**
* PodSecurityPolicySpec defines the policy enforced. Deprecated: use PodSecurityPolicySpec from policy API Group instead.
*/
class ExtensionsV1beta1PodSecurityPolicySpec {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1PodSecurityPolicySpec.attributeTypeMap;
    }
}
ExtensionsV1beta1PodSecurityPolicySpec.discriminator = undefined;
ExtensionsV1beta1PodSecurityPolicySpec.attributeTypeMap = [
    {
        "name": "allowPrivilegeEscalation",
        "baseName": "allowPrivilegeEscalation",
        "type": "boolean"
    },
    {
        "name": "allowedCapabilities",
        "baseName": "allowedCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "allowedFlexVolumes",
        "baseName": "allowedFlexVolumes",
        "type": "Array<ExtensionsV1beta1AllowedFlexVolume>"
    },
    {
        "name": "allowedHostPaths",
        "baseName": "allowedHostPaths",
        "type": "Array<ExtensionsV1beta1AllowedHostPath>"
    },
    {
        "name": "allowedProcMountTypes",
        "baseName": "allowedProcMountTypes",
        "type": "Array<string>"
    },
    {
        "name": "allowedUnsafeSysctls",
        "baseName": "allowedUnsafeSysctls",
        "type": "Array<string>"
    },
    {
        "name": "defaultAddCapabilities",
        "baseName": "defaultAddCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "defaultAllowPrivilegeEscalation",
        "baseName": "defaultAllowPrivilegeEscalation",
        "type": "boolean"
    },
    {
        "name": "forbiddenSysctls",
        "baseName": "forbiddenSysctls",
        "type": "Array<string>"
    },
    {
        "name": "fsGroup",
        "baseName": "fsGroup",
        "type": "ExtensionsV1beta1FSGroupStrategyOptions"
    },
    {
        "name": "hostIPC",
        "baseName": "hostIPC",
        "type": "boolean"
    },
    {
        "name": "hostNetwork",
        "baseName": "hostNetwork",
        "type": "boolean"
    },
    {
        "name": "hostPID",
        "baseName": "hostPID",
        "type": "boolean"
    },
    {
        "name": "hostPorts",
        "baseName": "hostPorts",
        "type": "Array<ExtensionsV1beta1HostPortRange>"
    },
    {
        "name": "privileged",
        "baseName": "privileged",
        "type": "boolean"
    },
    {
        "name": "readOnlyRootFilesystem",
        "baseName": "readOnlyRootFilesystem",
        "type": "boolean"
    },
    {
        "name": "requiredDropCapabilities",
        "baseName": "requiredDropCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "runAsGroup",
        "baseName": "runAsGroup",
        "type": "ExtensionsV1beta1RunAsGroupStrategyOptions"
    },
    {
        "name": "runAsUser",
        "baseName": "runAsUser",
        "type": "ExtensionsV1beta1RunAsUserStrategyOptions"
    },
    {
        "name": "seLinux",
        "baseName": "seLinux",
        "type": "ExtensionsV1beta1SELinuxStrategyOptions"
    },
    {
        "name": "supplementalGroups",
        "baseName": "supplementalGroups",
        "type": "ExtensionsV1beta1SupplementalGroupsStrategyOptions"
    },
    {
        "name": "volumes",
        "baseName": "volumes",
        "type": "Array<string>"
    }
];
exports.ExtensionsV1beta1PodSecurityPolicySpec = ExtensionsV1beta1PodSecurityPolicySpec;
/**
* DEPRECATED.
*/
class ExtensionsV1beta1RollbackConfig {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1RollbackConfig.attributeTypeMap;
    }
}
ExtensionsV1beta1RollbackConfig.discriminator = undefined;
ExtensionsV1beta1RollbackConfig.attributeTypeMap = [
    {
        "name": "revision",
        "baseName": "revision",
        "type": "number"
    }
];
exports.ExtensionsV1beta1RollbackConfig = ExtensionsV1beta1RollbackConfig;
/**
* Spec to control the desired behavior of rolling update.
*/
class ExtensionsV1beta1RollingUpdateDeployment {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1RollingUpdateDeployment.attributeTypeMap;
    }
}
ExtensionsV1beta1RollingUpdateDeployment.discriminator = undefined;
ExtensionsV1beta1RollingUpdateDeployment.attributeTypeMap = [
    {
        "name": "maxSurge",
        "baseName": "maxSurge",
        "type": "any"
    },
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.ExtensionsV1beta1RollingUpdateDeployment = ExtensionsV1beta1RollingUpdateDeployment;
/**
* RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsGroupStrategyOptions from policy API Group instead.
*/
class ExtensionsV1beta1RunAsGroupStrategyOptions {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1RunAsGroupStrategyOptions.attributeTypeMap;
    }
}
ExtensionsV1beta1RunAsGroupStrategyOptions.discriminator = undefined;
ExtensionsV1beta1RunAsGroupStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<ExtensionsV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.ExtensionsV1beta1RunAsGroupStrategyOptions = ExtensionsV1beta1RunAsGroupStrategyOptions;
/**
* RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use RunAsUserStrategyOptions from policy API Group instead.
*/
class ExtensionsV1beta1RunAsUserStrategyOptions {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1RunAsUserStrategyOptions.attributeTypeMap;
    }
}
ExtensionsV1beta1RunAsUserStrategyOptions.discriminator = undefined;
ExtensionsV1beta1RunAsUserStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<ExtensionsV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.ExtensionsV1beta1RunAsUserStrategyOptions = ExtensionsV1beta1RunAsUserStrategyOptions;
/**
* SELinuxStrategyOptions defines the strategy type and any options used to create the strategy. Deprecated: use SELinuxStrategyOptions from policy API Group instead.
*/
class ExtensionsV1beta1SELinuxStrategyOptions {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1SELinuxStrategyOptions.attributeTypeMap;
    }
}
ExtensionsV1beta1SELinuxStrategyOptions.discriminator = undefined;
ExtensionsV1beta1SELinuxStrategyOptions.attributeTypeMap = [
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    },
    {
        "name": "seLinuxOptions",
        "baseName": "seLinuxOptions",
        "type": "V1SELinuxOptions"
    }
];
exports.ExtensionsV1beta1SELinuxStrategyOptions = ExtensionsV1beta1SELinuxStrategyOptions;
/**
* represents a scaling request for a resource.
*/
class ExtensionsV1beta1Scale {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1Scale.attributeTypeMap;
    }
}
ExtensionsV1beta1Scale.discriminator = undefined;
ExtensionsV1beta1Scale.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "ExtensionsV1beta1ScaleSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "ExtensionsV1beta1ScaleStatus"
    }
];
exports.ExtensionsV1beta1Scale = ExtensionsV1beta1Scale;
/**
* describes the attributes of a scale subresource
*/
class ExtensionsV1beta1ScaleSpec {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1ScaleSpec.attributeTypeMap;
    }
}
ExtensionsV1beta1ScaleSpec.discriminator = undefined;
ExtensionsV1beta1ScaleSpec.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.ExtensionsV1beta1ScaleSpec = ExtensionsV1beta1ScaleSpec;
/**
* represents the current status of a scale subresource.
*/
class ExtensionsV1beta1ScaleStatus {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1ScaleStatus.attributeTypeMap;
    }
}
ExtensionsV1beta1ScaleStatus.discriminator = undefined;
ExtensionsV1beta1ScaleStatus.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "targetSelector",
        "baseName": "targetSelector",
        "type": "string"
    }
];
exports.ExtensionsV1beta1ScaleStatus = ExtensionsV1beta1ScaleStatus;
/**
* SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy. Deprecated: use SupplementalGroupsStrategyOptions from policy API Group instead.
*/
class ExtensionsV1beta1SupplementalGroupsStrategyOptions {
    static getAttributeTypeMap() {
        return ExtensionsV1beta1SupplementalGroupsStrategyOptions.attributeTypeMap;
    }
}
ExtensionsV1beta1SupplementalGroupsStrategyOptions.discriminator = undefined;
ExtensionsV1beta1SupplementalGroupsStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<ExtensionsV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.ExtensionsV1beta1SupplementalGroupsStrategyOptions = ExtensionsV1beta1SupplementalGroupsStrategyOptions;
/**
* AllowedFlexVolume represents a single Flexvolume that is allowed to be used.
*/
class PolicyV1beta1AllowedFlexVolume {
    static getAttributeTypeMap() {
        return PolicyV1beta1AllowedFlexVolume.attributeTypeMap;
    }
}
PolicyV1beta1AllowedFlexVolume.discriminator = undefined;
PolicyV1beta1AllowedFlexVolume.attributeTypeMap = [
    {
        "name": "driver",
        "baseName": "driver",
        "type": "string"
    }
];
exports.PolicyV1beta1AllowedFlexVolume = PolicyV1beta1AllowedFlexVolume;
/**
* AllowedHostPath defines the host volume conditions that will be enabled by a policy for pods to use. It requires the path prefix to be defined.
*/
class PolicyV1beta1AllowedHostPath {
    static getAttributeTypeMap() {
        return PolicyV1beta1AllowedHostPath.attributeTypeMap;
    }
}
PolicyV1beta1AllowedHostPath.discriminator = undefined;
PolicyV1beta1AllowedHostPath.attributeTypeMap = [
    {
        "name": "pathPrefix",
        "baseName": "pathPrefix",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.PolicyV1beta1AllowedHostPath = PolicyV1beta1AllowedHostPath;
/**
* FSGroupStrategyOptions defines the strategy type and options used to create the strategy.
*/
class PolicyV1beta1FSGroupStrategyOptions {
    static getAttributeTypeMap() {
        return PolicyV1beta1FSGroupStrategyOptions.attributeTypeMap;
    }
}
PolicyV1beta1FSGroupStrategyOptions.discriminator = undefined;
PolicyV1beta1FSGroupStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<PolicyV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.PolicyV1beta1FSGroupStrategyOptions = PolicyV1beta1FSGroupStrategyOptions;
/**
* HostPortRange defines a range of host ports that will be enabled by a policy for pods to use.  It requires both the start and end to be defined.
*/
class PolicyV1beta1HostPortRange {
    static getAttributeTypeMap() {
        return PolicyV1beta1HostPortRange.attributeTypeMap;
    }
}
PolicyV1beta1HostPortRange.discriminator = undefined;
PolicyV1beta1HostPortRange.attributeTypeMap = [
    {
        "name": "max",
        "baseName": "max",
        "type": "number"
    },
    {
        "name": "min",
        "baseName": "min",
        "type": "number"
    }
];
exports.PolicyV1beta1HostPortRange = PolicyV1beta1HostPortRange;
/**
* IDRange provides a min/max of an allowed range of IDs.
*/
class PolicyV1beta1IDRange {
    static getAttributeTypeMap() {
        return PolicyV1beta1IDRange.attributeTypeMap;
    }
}
PolicyV1beta1IDRange.discriminator = undefined;
PolicyV1beta1IDRange.attributeTypeMap = [
    {
        "name": "max",
        "baseName": "max",
        "type": "number"
    },
    {
        "name": "min",
        "baseName": "min",
        "type": "number"
    }
];
exports.PolicyV1beta1IDRange = PolicyV1beta1IDRange;
/**
* PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.
*/
class PolicyV1beta1PodSecurityPolicy {
    static getAttributeTypeMap() {
        return PolicyV1beta1PodSecurityPolicy.attributeTypeMap;
    }
}
PolicyV1beta1PodSecurityPolicy.discriminator = undefined;
PolicyV1beta1PodSecurityPolicy.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "PolicyV1beta1PodSecurityPolicySpec"
    }
];
exports.PolicyV1beta1PodSecurityPolicy = PolicyV1beta1PodSecurityPolicy;
/**
* PodSecurityPolicyList is a list of PodSecurityPolicy objects.
*/
class PolicyV1beta1PodSecurityPolicyList {
    static getAttributeTypeMap() {
        return PolicyV1beta1PodSecurityPolicyList.attributeTypeMap;
    }
}
PolicyV1beta1PodSecurityPolicyList.discriminator = undefined;
PolicyV1beta1PodSecurityPolicyList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<PolicyV1beta1PodSecurityPolicy>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.PolicyV1beta1PodSecurityPolicyList = PolicyV1beta1PodSecurityPolicyList;
/**
* PodSecurityPolicySpec defines the policy enforced.
*/
class PolicyV1beta1PodSecurityPolicySpec {
    static getAttributeTypeMap() {
        return PolicyV1beta1PodSecurityPolicySpec.attributeTypeMap;
    }
}
PolicyV1beta1PodSecurityPolicySpec.discriminator = undefined;
PolicyV1beta1PodSecurityPolicySpec.attributeTypeMap = [
    {
        "name": "allowPrivilegeEscalation",
        "baseName": "allowPrivilegeEscalation",
        "type": "boolean"
    },
    {
        "name": "allowedCapabilities",
        "baseName": "allowedCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "allowedFlexVolumes",
        "baseName": "allowedFlexVolumes",
        "type": "Array<PolicyV1beta1AllowedFlexVolume>"
    },
    {
        "name": "allowedHostPaths",
        "baseName": "allowedHostPaths",
        "type": "Array<PolicyV1beta1AllowedHostPath>"
    },
    {
        "name": "allowedProcMountTypes",
        "baseName": "allowedProcMountTypes",
        "type": "Array<string>"
    },
    {
        "name": "allowedUnsafeSysctls",
        "baseName": "allowedUnsafeSysctls",
        "type": "Array<string>"
    },
    {
        "name": "defaultAddCapabilities",
        "baseName": "defaultAddCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "defaultAllowPrivilegeEscalation",
        "baseName": "defaultAllowPrivilegeEscalation",
        "type": "boolean"
    },
    {
        "name": "forbiddenSysctls",
        "baseName": "forbiddenSysctls",
        "type": "Array<string>"
    },
    {
        "name": "fsGroup",
        "baseName": "fsGroup",
        "type": "PolicyV1beta1FSGroupStrategyOptions"
    },
    {
        "name": "hostIPC",
        "baseName": "hostIPC",
        "type": "boolean"
    },
    {
        "name": "hostNetwork",
        "baseName": "hostNetwork",
        "type": "boolean"
    },
    {
        "name": "hostPID",
        "baseName": "hostPID",
        "type": "boolean"
    },
    {
        "name": "hostPorts",
        "baseName": "hostPorts",
        "type": "Array<PolicyV1beta1HostPortRange>"
    },
    {
        "name": "privileged",
        "baseName": "privileged",
        "type": "boolean"
    },
    {
        "name": "readOnlyRootFilesystem",
        "baseName": "readOnlyRootFilesystem",
        "type": "boolean"
    },
    {
        "name": "requiredDropCapabilities",
        "baseName": "requiredDropCapabilities",
        "type": "Array<string>"
    },
    {
        "name": "runAsGroup",
        "baseName": "runAsGroup",
        "type": "PolicyV1beta1RunAsGroupStrategyOptions"
    },
    {
        "name": "runAsUser",
        "baseName": "runAsUser",
        "type": "PolicyV1beta1RunAsUserStrategyOptions"
    },
    {
        "name": "seLinux",
        "baseName": "seLinux",
        "type": "PolicyV1beta1SELinuxStrategyOptions"
    },
    {
        "name": "supplementalGroups",
        "baseName": "supplementalGroups",
        "type": "PolicyV1beta1SupplementalGroupsStrategyOptions"
    },
    {
        "name": "volumes",
        "baseName": "volumes",
        "type": "Array<string>"
    }
];
exports.PolicyV1beta1PodSecurityPolicySpec = PolicyV1beta1PodSecurityPolicySpec;
/**
* RunAsGroupStrategyOptions defines the strategy type and any options used to create the strategy.
*/
class PolicyV1beta1RunAsGroupStrategyOptions {
    static getAttributeTypeMap() {
        return PolicyV1beta1RunAsGroupStrategyOptions.attributeTypeMap;
    }
}
PolicyV1beta1RunAsGroupStrategyOptions.discriminator = undefined;
PolicyV1beta1RunAsGroupStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<PolicyV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.PolicyV1beta1RunAsGroupStrategyOptions = PolicyV1beta1RunAsGroupStrategyOptions;
/**
* RunAsUserStrategyOptions defines the strategy type and any options used to create the strategy.
*/
class PolicyV1beta1RunAsUserStrategyOptions {
    static getAttributeTypeMap() {
        return PolicyV1beta1RunAsUserStrategyOptions.attributeTypeMap;
    }
}
PolicyV1beta1RunAsUserStrategyOptions.discriminator = undefined;
PolicyV1beta1RunAsUserStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<PolicyV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.PolicyV1beta1RunAsUserStrategyOptions = PolicyV1beta1RunAsUserStrategyOptions;
/**
* SELinuxStrategyOptions defines the strategy type and any options used to create the strategy.
*/
class PolicyV1beta1SELinuxStrategyOptions {
    static getAttributeTypeMap() {
        return PolicyV1beta1SELinuxStrategyOptions.attributeTypeMap;
    }
}
PolicyV1beta1SELinuxStrategyOptions.discriminator = undefined;
PolicyV1beta1SELinuxStrategyOptions.attributeTypeMap = [
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    },
    {
        "name": "seLinuxOptions",
        "baseName": "seLinuxOptions",
        "type": "V1SELinuxOptions"
    }
];
exports.PolicyV1beta1SELinuxStrategyOptions = PolicyV1beta1SELinuxStrategyOptions;
/**
* SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.
*/
class PolicyV1beta1SupplementalGroupsStrategyOptions {
    static getAttributeTypeMap() {
        return PolicyV1beta1SupplementalGroupsStrategyOptions.attributeTypeMap;
    }
}
PolicyV1beta1SupplementalGroupsStrategyOptions.discriminator = undefined;
PolicyV1beta1SupplementalGroupsStrategyOptions.attributeTypeMap = [
    {
        "name": "ranges",
        "baseName": "ranges",
        "type": "Array<PolicyV1beta1IDRange>"
    },
    {
        "name": "rule",
        "baseName": "rule",
        "type": "string"
    }
];
exports.PolicyV1beta1SupplementalGroupsStrategyOptions = PolicyV1beta1SupplementalGroupsStrategyOptions;
/**
* RawExtension is used to hold extensions in external versions.  To use this, make a field which has RawExtension as its type in your external, versioned struct, and Object in your internal struct. You also need to register your various plugin types.  // Internal package: type MyAPIObject struct {  runtime.TypeMeta `json:\",inline\"`  MyPlugin runtime.Object `json:\"myPlugin\"` } type PluginA struct {  AOption string `json:\"aOption\"` }  // External package: type MyAPIObject struct {  runtime.TypeMeta `json:\",inline\"`  MyPlugin runtime.RawExtension `json:\"myPlugin\"` } type PluginA struct {  AOption string `json:\"aOption\"` }  // On the wire, the JSON will look something like this: {  \"kind\":\"MyAPIObject\",  \"apiVersion\":\"v1\",  \"myPlugin\": {   \"kind\":\"PluginA\",   \"aOption\":\"foo\",  }, }  So what happens? Decode first uses json or yaml to unmarshal the serialized data into your external MyAPIObject. That causes the raw JSON to be stored, but not unpacked. The next step is to copy (using pkg/conversion) into the internal struct. The runtime package's DefaultScheme has conversion functions installed which will unpack the JSON stored in RawExtension, turning it into the correct object type, and storing it in the Object. (TODO: In the case where the object is of an unknown type, a runtime.Unknown object will be created and stored.)
*/
class RuntimeRawExtension {
    static getAttributeTypeMap() {
        return RuntimeRawExtension.attributeTypeMap;
    }
}
RuntimeRawExtension.discriminator = undefined;
RuntimeRawExtension.attributeTypeMap = [
    {
        "name": "raw",
        "baseName": "Raw",
        "type": "string"
    }
];
exports.RuntimeRawExtension = RuntimeRawExtension;
/**
* APIGroup contains the name, the supported versions, and the preferred version of a group.
*/
class V1APIGroup {
    static getAttributeTypeMap() {
        return V1APIGroup.attributeTypeMap;
    }
}
V1APIGroup.discriminator = undefined;
V1APIGroup.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "preferredVersion",
        "baseName": "preferredVersion",
        "type": "V1GroupVersionForDiscovery"
    },
    {
        "name": "serverAddressByClientCIDRs",
        "baseName": "serverAddressByClientCIDRs",
        "type": "Array<V1ServerAddressByClientCIDR>"
    },
    {
        "name": "versions",
        "baseName": "versions",
        "type": "Array<V1GroupVersionForDiscovery>"
    }
];
exports.V1APIGroup = V1APIGroup;
/**
* APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.
*/
class V1APIGroupList {
    static getAttributeTypeMap() {
        return V1APIGroupList.attributeTypeMap;
    }
}
V1APIGroupList.discriminator = undefined;
V1APIGroupList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "groups",
        "baseName": "groups",
        "type": "Array<V1APIGroup>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    }
];
exports.V1APIGroupList = V1APIGroupList;
/**
* APIResource specifies the name of a resource and whether it is namespaced.
*/
class V1APIResource {
    static getAttributeTypeMap() {
        return V1APIResource.attributeTypeMap;
    }
}
V1APIResource.discriminator = undefined;
V1APIResource.attributeTypeMap = [
    {
        "name": "categories",
        "baseName": "categories",
        "type": "Array<string>"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespaced",
        "baseName": "namespaced",
        "type": "boolean"
    },
    {
        "name": "shortNames",
        "baseName": "shortNames",
        "type": "Array<string>"
    },
    {
        "name": "singularName",
        "baseName": "singularName",
        "type": "string"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    }
];
exports.V1APIResource = V1APIResource;
/**
* APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.
*/
class V1APIResourceList {
    static getAttributeTypeMap() {
        return V1APIResourceList.attributeTypeMap;
    }
}
V1APIResourceList.discriminator = undefined;
V1APIResourceList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "groupVersion",
        "baseName": "groupVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<V1APIResource>"
    }
];
exports.V1APIResourceList = V1APIResourceList;
/**
* APIService represents a server for a particular GroupVersion. Name must be \"version.group\".
*/
class V1APIService {
    static getAttributeTypeMap() {
        return V1APIService.attributeTypeMap;
    }
}
V1APIService.discriminator = undefined;
V1APIService.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1APIServiceSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1APIServiceStatus"
    }
];
exports.V1APIService = V1APIService;
class V1APIServiceCondition {
    static getAttributeTypeMap() {
        return V1APIServiceCondition.attributeTypeMap;
    }
}
V1APIServiceCondition.discriminator = undefined;
V1APIServiceCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1APIServiceCondition = V1APIServiceCondition;
/**
* APIServiceList is a list of APIService objects.
*/
class V1APIServiceList {
    static getAttributeTypeMap() {
        return V1APIServiceList.attributeTypeMap;
    }
}
V1APIServiceList.discriminator = undefined;
V1APIServiceList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1APIService>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1APIServiceList = V1APIServiceList;
/**
* APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification.
*/
class V1APIServiceSpec {
    static getAttributeTypeMap() {
        return V1APIServiceSpec.attributeTypeMap;
    }
}
V1APIServiceSpec.discriminator = undefined;
V1APIServiceSpec.attributeTypeMap = [
    {
        "name": "caBundle",
        "baseName": "caBundle",
        "type": "string"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "groupPriorityMinimum",
        "baseName": "groupPriorityMinimum",
        "type": "number"
    },
    {
        "name": "insecureSkipTLSVerify",
        "baseName": "insecureSkipTLSVerify",
        "type": "boolean"
    },
    {
        "name": "service",
        "baseName": "service",
        "type": "V1ServiceReference"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    },
    {
        "name": "versionPriority",
        "baseName": "versionPriority",
        "type": "number"
    }
];
exports.V1APIServiceSpec = V1APIServiceSpec;
/**
* APIServiceStatus contains derived information about an API server
*/
class V1APIServiceStatus {
    static getAttributeTypeMap() {
        return V1APIServiceStatus.attributeTypeMap;
    }
}
V1APIServiceStatus.discriminator = undefined;
V1APIServiceStatus.attributeTypeMap = [
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1APIServiceCondition>"
    }
];
exports.V1APIServiceStatus = V1APIServiceStatus;
/**
* APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API.
*/
class V1APIVersions {
    static getAttributeTypeMap() {
        return V1APIVersions.attributeTypeMap;
    }
}
V1APIVersions.discriminator = undefined;
V1APIVersions.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "serverAddressByClientCIDRs",
        "baseName": "serverAddressByClientCIDRs",
        "type": "Array<V1ServerAddressByClientCIDR>"
    },
    {
        "name": "versions",
        "baseName": "versions",
        "type": "Array<string>"
    }
];
exports.V1APIVersions = V1APIVersions;
/**
* Represents a Persistent Disk resource in AWS.  An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
*/
class V1AWSElasticBlockStoreVolumeSource {
    static getAttributeTypeMap() {
        return V1AWSElasticBlockStoreVolumeSource.attributeTypeMap;
    }
}
V1AWSElasticBlockStoreVolumeSource.discriminator = undefined;
V1AWSElasticBlockStoreVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "partition",
        "baseName": "partition",
        "type": "number"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "volumeID",
        "baseName": "volumeID",
        "type": "string"
    }
];
exports.V1AWSElasticBlockStoreVolumeSource = V1AWSElasticBlockStoreVolumeSource;
/**
* Affinity is a group of affinity scheduling rules.
*/
class V1Affinity {
    static getAttributeTypeMap() {
        return V1Affinity.attributeTypeMap;
    }
}
V1Affinity.discriminator = undefined;
V1Affinity.attributeTypeMap = [
    {
        "name": "nodeAffinity",
        "baseName": "nodeAffinity",
        "type": "V1NodeAffinity"
    },
    {
        "name": "podAffinity",
        "baseName": "podAffinity",
        "type": "V1PodAffinity"
    },
    {
        "name": "podAntiAffinity",
        "baseName": "podAntiAffinity",
        "type": "V1PodAntiAffinity"
    }
];
exports.V1Affinity = V1Affinity;
/**
* AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole
*/
class V1AggregationRule {
    static getAttributeTypeMap() {
        return V1AggregationRule.attributeTypeMap;
    }
}
V1AggregationRule.discriminator = undefined;
V1AggregationRule.attributeTypeMap = [
    {
        "name": "clusterRoleSelectors",
        "baseName": "clusterRoleSelectors",
        "type": "Array<V1LabelSelector>"
    }
];
exports.V1AggregationRule = V1AggregationRule;
/**
* AttachedVolume describes a volume attached to a node
*/
class V1AttachedVolume {
    static getAttributeTypeMap() {
        return V1AttachedVolume.attributeTypeMap;
    }
}
V1AttachedVolume.discriminator = undefined;
V1AttachedVolume.attributeTypeMap = [
    {
        "name": "devicePath",
        "baseName": "devicePath",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1AttachedVolume = V1AttachedVolume;
/**
* AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
*/
class V1AzureDiskVolumeSource {
    static getAttributeTypeMap() {
        return V1AzureDiskVolumeSource.attributeTypeMap;
    }
}
V1AzureDiskVolumeSource.discriminator = undefined;
V1AzureDiskVolumeSource.attributeTypeMap = [
    {
        "name": "cachingMode",
        "baseName": "cachingMode",
        "type": "string"
    },
    {
        "name": "diskName",
        "baseName": "diskName",
        "type": "string"
    },
    {
        "name": "diskURI",
        "baseName": "diskURI",
        "type": "string"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.V1AzureDiskVolumeSource = V1AzureDiskVolumeSource;
/**
* AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
*/
class V1AzureFilePersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1AzureFilePersistentVolumeSource.attributeTypeMap;
    }
}
V1AzureFilePersistentVolumeSource.discriminator = undefined;
V1AzureFilePersistentVolumeSource.attributeTypeMap = [
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretName",
        "baseName": "secretName",
        "type": "string"
    },
    {
        "name": "secretNamespace",
        "baseName": "secretNamespace",
        "type": "string"
    },
    {
        "name": "shareName",
        "baseName": "shareName",
        "type": "string"
    }
];
exports.V1AzureFilePersistentVolumeSource = V1AzureFilePersistentVolumeSource;
/**
* AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
*/
class V1AzureFileVolumeSource {
    static getAttributeTypeMap() {
        return V1AzureFileVolumeSource.attributeTypeMap;
    }
}
V1AzureFileVolumeSource.discriminator = undefined;
V1AzureFileVolumeSource.attributeTypeMap = [
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretName",
        "baseName": "secretName",
        "type": "string"
    },
    {
        "name": "shareName",
        "baseName": "shareName",
        "type": "string"
    }
];
exports.V1AzureFileVolumeSource = V1AzureFileVolumeSource;
/**
* Binding ties one object to another; for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.
*/
class V1Binding {
    static getAttributeTypeMap() {
        return V1Binding.attributeTypeMap;
    }
}
V1Binding.discriminator = undefined;
V1Binding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V1ObjectReference"
    }
];
exports.V1Binding = V1Binding;
/**
* Represents storage that is managed by an external CSI volume driver (Beta feature)
*/
class V1CSIPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1CSIPersistentVolumeSource.attributeTypeMap;
    }
}
V1CSIPersistentVolumeSource.discriminator = undefined;
V1CSIPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "controllerPublishSecretRef",
        "baseName": "controllerPublishSecretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "driver",
        "baseName": "driver",
        "type": "string"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "nodePublishSecretRef",
        "baseName": "nodePublishSecretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "nodeStageSecretRef",
        "baseName": "nodeStageSecretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "volumeAttributes",
        "baseName": "volumeAttributes",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "volumeHandle",
        "baseName": "volumeHandle",
        "type": "string"
    }
];
exports.V1CSIPersistentVolumeSource = V1CSIPersistentVolumeSource;
/**
* Adds and removes POSIX capabilities from running containers.
*/
class V1Capabilities {
    static getAttributeTypeMap() {
        return V1Capabilities.attributeTypeMap;
    }
}
V1Capabilities.discriminator = undefined;
V1Capabilities.attributeTypeMap = [
    {
        "name": "add",
        "baseName": "add",
        "type": "Array<string>"
    },
    {
        "name": "drop",
        "baseName": "drop",
        "type": "Array<string>"
    }
];
exports.V1Capabilities = V1Capabilities;
/**
* Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
*/
class V1CephFSPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1CephFSPersistentVolumeSource.attributeTypeMap;
    }
}
V1CephFSPersistentVolumeSource.discriminator = undefined;
V1CephFSPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "monitors",
        "baseName": "monitors",
        "type": "Array<string>"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretFile",
        "baseName": "secretFile",
        "type": "string"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1CephFSPersistentVolumeSource = V1CephFSPersistentVolumeSource;
/**
* Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
*/
class V1CephFSVolumeSource {
    static getAttributeTypeMap() {
        return V1CephFSVolumeSource.attributeTypeMap;
    }
}
V1CephFSVolumeSource.discriminator = undefined;
V1CephFSVolumeSource.attributeTypeMap = [
    {
        "name": "monitors",
        "baseName": "monitors",
        "type": "Array<string>"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretFile",
        "baseName": "secretFile",
        "type": "string"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1CephFSVolumeSource = V1CephFSVolumeSource;
/**
* Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
*/
class V1CinderPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1CinderPersistentVolumeSource.attributeTypeMap;
    }
}
V1CinderPersistentVolumeSource.discriminator = undefined;
V1CinderPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "volumeID",
        "baseName": "volumeID",
        "type": "string"
    }
];
exports.V1CinderPersistentVolumeSource = V1CinderPersistentVolumeSource;
/**
* Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
*/
class V1CinderVolumeSource {
    static getAttributeTypeMap() {
        return V1CinderVolumeSource.attributeTypeMap;
    }
}
V1CinderVolumeSource.discriminator = undefined;
V1CinderVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "volumeID",
        "baseName": "volumeID",
        "type": "string"
    }
];
exports.V1CinderVolumeSource = V1CinderVolumeSource;
/**
* ClientIPConfig represents the configurations of Client IP based session affinity.
*/
class V1ClientIPConfig {
    static getAttributeTypeMap() {
        return V1ClientIPConfig.attributeTypeMap;
    }
}
V1ClientIPConfig.discriminator = undefined;
V1ClientIPConfig.attributeTypeMap = [
    {
        "name": "timeoutSeconds",
        "baseName": "timeoutSeconds",
        "type": "number"
    }
];
exports.V1ClientIPConfig = V1ClientIPConfig;
/**
* ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
*/
class V1ClusterRole {
    static getAttributeTypeMap() {
        return V1ClusterRole.attributeTypeMap;
    }
}
V1ClusterRole.discriminator = undefined;
V1ClusterRole.attributeTypeMap = [
    {
        "name": "aggregationRule",
        "baseName": "aggregationRule",
        "type": "V1AggregationRule"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1PolicyRule>"
    }
];
exports.V1ClusterRole = V1ClusterRole;
/**
* ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.
*/
class V1ClusterRoleBinding {
    static getAttributeTypeMap() {
        return V1ClusterRoleBinding.attributeTypeMap;
    }
}
V1ClusterRoleBinding.discriminator = undefined;
V1ClusterRoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1Subject>"
    }
];
exports.V1ClusterRoleBinding = V1ClusterRoleBinding;
/**
* ClusterRoleBindingList is a collection of ClusterRoleBindings
*/
class V1ClusterRoleBindingList {
    static getAttributeTypeMap() {
        return V1ClusterRoleBindingList.attributeTypeMap;
    }
}
V1ClusterRoleBindingList.discriminator = undefined;
V1ClusterRoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ClusterRoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ClusterRoleBindingList = V1ClusterRoleBindingList;
/**
* ClusterRoleList is a collection of ClusterRoles
*/
class V1ClusterRoleList {
    static getAttributeTypeMap() {
        return V1ClusterRoleList.attributeTypeMap;
    }
}
V1ClusterRoleList.discriminator = undefined;
V1ClusterRoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ClusterRole>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ClusterRoleList = V1ClusterRoleList;
/**
* Information about the condition of a component.
*/
class V1ComponentCondition {
    static getAttributeTypeMap() {
        return V1ComponentCondition.attributeTypeMap;
    }
}
V1ComponentCondition.discriminator = undefined;
V1ComponentCondition.attributeTypeMap = [
    {
        "name": "error",
        "baseName": "error",
        "type": "string"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1ComponentCondition = V1ComponentCondition;
/**
* ComponentStatus (and ComponentStatusList) holds the cluster validation info.
*/
class V1ComponentStatus {
    static getAttributeTypeMap() {
        return V1ComponentStatus.attributeTypeMap;
    }
}
V1ComponentStatus.discriminator = undefined;
V1ComponentStatus.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1ComponentCondition>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    }
];
exports.V1ComponentStatus = V1ComponentStatus;
/**
* Status of all the conditions for the component as a list of ComponentStatus objects.
*/
class V1ComponentStatusList {
    static getAttributeTypeMap() {
        return V1ComponentStatusList.attributeTypeMap;
    }
}
V1ComponentStatusList.discriminator = undefined;
V1ComponentStatusList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ComponentStatus>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ComponentStatusList = V1ComponentStatusList;
/**
* ConfigMap holds configuration data for pods to consume.
*/
class V1ConfigMap {
    static getAttributeTypeMap() {
        return V1ConfigMap.attributeTypeMap;
    }
}
V1ConfigMap.discriminator = undefined;
V1ConfigMap.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "binaryData",
        "baseName": "binaryData",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "data",
        "baseName": "data",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    }
];
exports.V1ConfigMap = V1ConfigMap;
/**
* ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.  The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
*/
class V1ConfigMapEnvSource {
    static getAttributeTypeMap() {
        return V1ConfigMapEnvSource.attributeTypeMap;
    }
}
V1ConfigMapEnvSource.discriminator = undefined;
V1ConfigMapEnvSource.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1ConfigMapEnvSource = V1ConfigMapEnvSource;
/**
* Selects a key from a ConfigMap.
*/
class V1ConfigMapKeySelector {
    static getAttributeTypeMap() {
        return V1ConfigMapKeySelector.attributeTypeMap;
    }
}
V1ConfigMapKeySelector.discriminator = undefined;
V1ConfigMapKeySelector.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1ConfigMapKeySelector = V1ConfigMapKeySelector;
/**
* ConfigMapList is a resource containing a list of ConfigMap objects.
*/
class V1ConfigMapList {
    static getAttributeTypeMap() {
        return V1ConfigMapList.attributeTypeMap;
    }
}
V1ConfigMapList.discriminator = undefined;
V1ConfigMapList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ConfigMap>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ConfigMapList = V1ConfigMapList;
/**
* ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.
*/
class V1ConfigMapNodeConfigSource {
    static getAttributeTypeMap() {
        return V1ConfigMapNodeConfigSource.attributeTypeMap;
    }
}
V1ConfigMapNodeConfigSource.discriminator = undefined;
V1ConfigMapNodeConfigSource.attributeTypeMap = [
    {
        "name": "kubeletConfigKey",
        "baseName": "kubeletConfigKey",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "resourceVersion",
        "baseName": "resourceVersion",
        "type": "string"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1ConfigMapNodeConfigSource = V1ConfigMapNodeConfigSource;
/**
* Adapts a ConfigMap into a projected volume.  The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
*/
class V1ConfigMapProjection {
    static getAttributeTypeMap() {
        return V1ConfigMapProjection.attributeTypeMap;
    }
}
V1ConfigMapProjection.discriminator = undefined;
V1ConfigMapProjection.attributeTypeMap = [
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1KeyToPath>"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1ConfigMapProjection = V1ConfigMapProjection;
/**
* Adapts a ConfigMap into a volume.  The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
*/
class V1ConfigMapVolumeSource {
    static getAttributeTypeMap() {
        return V1ConfigMapVolumeSource.attributeTypeMap;
    }
}
V1ConfigMapVolumeSource.discriminator = undefined;
V1ConfigMapVolumeSource.attributeTypeMap = [
    {
        "name": "defaultMode",
        "baseName": "defaultMode",
        "type": "number"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1KeyToPath>"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1ConfigMapVolumeSource = V1ConfigMapVolumeSource;
/**
* A single application container that you want to run within a pod.
*/
class V1Container {
    static getAttributeTypeMap() {
        return V1Container.attributeTypeMap;
    }
}
V1Container.discriminator = undefined;
V1Container.attributeTypeMap = [
    {
        "name": "args",
        "baseName": "args",
        "type": "Array<string>"
    },
    {
        "name": "command",
        "baseName": "command",
        "type": "Array<string>"
    },
    {
        "name": "env",
        "baseName": "env",
        "type": "Array<V1EnvVar>"
    },
    {
        "name": "envFrom",
        "baseName": "envFrom",
        "type": "Array<V1EnvFromSource>"
    },
    {
        "name": "image",
        "baseName": "image",
        "type": "string"
    },
    {
        "name": "imagePullPolicy",
        "baseName": "imagePullPolicy",
        "type": "string"
    },
    {
        "name": "lifecycle",
        "baseName": "lifecycle",
        "type": "V1Lifecycle"
    },
    {
        "name": "livenessProbe",
        "baseName": "livenessProbe",
        "type": "V1Probe"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1ContainerPort>"
    },
    {
        "name": "readinessProbe",
        "baseName": "readinessProbe",
        "type": "V1Probe"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "V1ResourceRequirements"
    },
    {
        "name": "securityContext",
        "baseName": "securityContext",
        "type": "V1SecurityContext"
    },
    {
        "name": "stdin",
        "baseName": "stdin",
        "type": "boolean"
    },
    {
        "name": "stdinOnce",
        "baseName": "stdinOnce",
        "type": "boolean"
    },
    {
        "name": "terminationMessagePath",
        "baseName": "terminationMessagePath",
        "type": "string"
    },
    {
        "name": "terminationMessagePolicy",
        "baseName": "terminationMessagePolicy",
        "type": "string"
    },
    {
        "name": "tty",
        "baseName": "tty",
        "type": "boolean"
    },
    {
        "name": "volumeDevices",
        "baseName": "volumeDevices",
        "type": "Array<V1VolumeDevice>"
    },
    {
        "name": "volumeMounts",
        "baseName": "volumeMounts",
        "type": "Array<V1VolumeMount>"
    },
    {
        "name": "workingDir",
        "baseName": "workingDir",
        "type": "string"
    }
];
exports.V1Container = V1Container;
/**
* Describe a container image
*/
class V1ContainerImage {
    static getAttributeTypeMap() {
        return V1ContainerImage.attributeTypeMap;
    }
}
V1ContainerImage.discriminator = undefined;
V1ContainerImage.attributeTypeMap = [
    {
        "name": "names",
        "baseName": "names",
        "type": "Array<string>"
    },
    {
        "name": "sizeBytes",
        "baseName": "sizeBytes",
        "type": "number"
    }
];
exports.V1ContainerImage = V1ContainerImage;
/**
* ContainerPort represents a network port in a single container.
*/
class V1ContainerPort {
    static getAttributeTypeMap() {
        return V1ContainerPort.attributeTypeMap;
    }
}
V1ContainerPort.discriminator = undefined;
V1ContainerPort.attributeTypeMap = [
    {
        "name": "containerPort",
        "baseName": "containerPort",
        "type": "number"
    },
    {
        "name": "hostIP",
        "baseName": "hostIP",
        "type": "string"
    },
    {
        "name": "hostPort",
        "baseName": "hostPort",
        "type": "number"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "protocol",
        "baseName": "protocol",
        "type": "string"
    }
];
exports.V1ContainerPort = V1ContainerPort;
/**
* ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
*/
class V1ContainerState {
    static getAttributeTypeMap() {
        return V1ContainerState.attributeTypeMap;
    }
}
V1ContainerState.discriminator = undefined;
V1ContainerState.attributeTypeMap = [
    {
        "name": "running",
        "baseName": "running",
        "type": "V1ContainerStateRunning"
    },
    {
        "name": "terminated",
        "baseName": "terminated",
        "type": "V1ContainerStateTerminated"
    },
    {
        "name": "waiting",
        "baseName": "waiting",
        "type": "V1ContainerStateWaiting"
    }
];
exports.V1ContainerState = V1ContainerState;
/**
* ContainerStateRunning is a running state of a container.
*/
class V1ContainerStateRunning {
    static getAttributeTypeMap() {
        return V1ContainerStateRunning.attributeTypeMap;
    }
}
V1ContainerStateRunning.discriminator = undefined;
V1ContainerStateRunning.attributeTypeMap = [
    {
        "name": "startedAt",
        "baseName": "startedAt",
        "type": "Date"
    }
];
exports.V1ContainerStateRunning = V1ContainerStateRunning;
/**
* ContainerStateTerminated is a terminated state of a container.
*/
class V1ContainerStateTerminated {
    static getAttributeTypeMap() {
        return V1ContainerStateTerminated.attributeTypeMap;
    }
}
V1ContainerStateTerminated.discriminator = undefined;
V1ContainerStateTerminated.attributeTypeMap = [
    {
        "name": "containerID",
        "baseName": "containerID",
        "type": "string"
    },
    {
        "name": "exitCode",
        "baseName": "exitCode",
        "type": "number"
    },
    {
        "name": "finishedAt",
        "baseName": "finishedAt",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "signal",
        "baseName": "signal",
        "type": "number"
    },
    {
        "name": "startedAt",
        "baseName": "startedAt",
        "type": "Date"
    }
];
exports.V1ContainerStateTerminated = V1ContainerStateTerminated;
/**
* ContainerStateWaiting is a waiting state of a container.
*/
class V1ContainerStateWaiting {
    static getAttributeTypeMap() {
        return V1ContainerStateWaiting.attributeTypeMap;
    }
}
V1ContainerStateWaiting.discriminator = undefined;
V1ContainerStateWaiting.attributeTypeMap = [
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    }
];
exports.V1ContainerStateWaiting = V1ContainerStateWaiting;
/**
* ContainerStatus contains details for the current status of this container.
*/
class V1ContainerStatus {
    static getAttributeTypeMap() {
        return V1ContainerStatus.attributeTypeMap;
    }
}
V1ContainerStatus.discriminator = undefined;
V1ContainerStatus.attributeTypeMap = [
    {
        "name": "containerID",
        "baseName": "containerID",
        "type": "string"
    },
    {
        "name": "image",
        "baseName": "image",
        "type": "string"
    },
    {
        "name": "imageID",
        "baseName": "imageID",
        "type": "string"
    },
    {
        "name": "lastState",
        "baseName": "lastState",
        "type": "V1ContainerState"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "ready",
        "baseName": "ready",
        "type": "boolean"
    },
    {
        "name": "restartCount",
        "baseName": "restartCount",
        "type": "number"
    },
    {
        "name": "state",
        "baseName": "state",
        "type": "V1ContainerState"
    }
];
exports.V1ContainerStatus = V1ContainerStatus;
/**
* ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
*/
class V1ControllerRevision {
    static getAttributeTypeMap() {
        return V1ControllerRevision.attributeTypeMap;
    }
}
V1ControllerRevision.discriminator = undefined;
V1ControllerRevision.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "data",
        "baseName": "data",
        "type": "RuntimeRawExtension"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "revision",
        "baseName": "revision",
        "type": "number"
    }
];
exports.V1ControllerRevision = V1ControllerRevision;
/**
* ControllerRevisionList is a resource containing a list of ControllerRevision objects.
*/
class V1ControllerRevisionList {
    static getAttributeTypeMap() {
        return V1ControllerRevisionList.attributeTypeMap;
    }
}
V1ControllerRevisionList.discriminator = undefined;
V1ControllerRevisionList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ControllerRevision>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ControllerRevisionList = V1ControllerRevisionList;
/**
* CrossVersionObjectReference contains enough information to let you identify the referred resource.
*/
class V1CrossVersionObjectReference {
    static getAttributeTypeMap() {
        return V1CrossVersionObjectReference.attributeTypeMap;
    }
}
V1CrossVersionObjectReference.discriminator = undefined;
V1CrossVersionObjectReference.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1CrossVersionObjectReference = V1CrossVersionObjectReference;
/**
* DaemonEndpoint contains information about a single Daemon endpoint.
*/
class V1DaemonEndpoint {
    static getAttributeTypeMap() {
        return V1DaemonEndpoint.attributeTypeMap;
    }
}
V1DaemonEndpoint.discriminator = undefined;
V1DaemonEndpoint.attributeTypeMap = [
    {
        "name": "port",
        "baseName": "Port",
        "type": "number"
    }
];
exports.V1DaemonEndpoint = V1DaemonEndpoint;
/**
* DaemonSet represents the configuration of a daemon set.
*/
class V1DaemonSet {
    static getAttributeTypeMap() {
        return V1DaemonSet.attributeTypeMap;
    }
}
V1DaemonSet.discriminator = undefined;
V1DaemonSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1DaemonSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1DaemonSetStatus"
    }
];
exports.V1DaemonSet = V1DaemonSet;
/**
* DaemonSetCondition describes the state of a DaemonSet at a certain point.
*/
class V1DaemonSetCondition {
    static getAttributeTypeMap() {
        return V1DaemonSetCondition.attributeTypeMap;
    }
}
V1DaemonSetCondition.discriminator = undefined;
V1DaemonSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1DaemonSetCondition = V1DaemonSetCondition;
/**
* DaemonSetList is a collection of daemon sets.
*/
class V1DaemonSetList {
    static getAttributeTypeMap() {
        return V1DaemonSetList.attributeTypeMap;
    }
}
V1DaemonSetList.discriminator = undefined;
V1DaemonSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1DaemonSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1DaemonSetList = V1DaemonSetList;
/**
* DaemonSetSpec is the specification of a daemon set.
*/
class V1DaemonSetSpec {
    static getAttributeTypeMap() {
        return V1DaemonSetSpec.attributeTypeMap;
    }
}
V1DaemonSetSpec.discriminator = undefined;
V1DaemonSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1DaemonSetUpdateStrategy"
    }
];
exports.V1DaemonSetSpec = V1DaemonSetSpec;
/**
* DaemonSetStatus represents the current status of a daemon set.
*/
class V1DaemonSetStatus {
    static getAttributeTypeMap() {
        return V1DaemonSetStatus.attributeTypeMap;
    }
}
V1DaemonSetStatus.discriminator = undefined;
V1DaemonSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1DaemonSetCondition>"
    },
    {
        "name": "currentNumberScheduled",
        "baseName": "currentNumberScheduled",
        "type": "number"
    },
    {
        "name": "desiredNumberScheduled",
        "baseName": "desiredNumberScheduled",
        "type": "number"
    },
    {
        "name": "numberAvailable",
        "baseName": "numberAvailable",
        "type": "number"
    },
    {
        "name": "numberMisscheduled",
        "baseName": "numberMisscheduled",
        "type": "number"
    },
    {
        "name": "numberReady",
        "baseName": "numberReady",
        "type": "number"
    },
    {
        "name": "numberUnavailable",
        "baseName": "numberUnavailable",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "updatedNumberScheduled",
        "baseName": "updatedNumberScheduled",
        "type": "number"
    }
];
exports.V1DaemonSetStatus = V1DaemonSetStatus;
/**
* DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
*/
class V1DaemonSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1DaemonSetUpdateStrategy.attributeTypeMap;
    }
}
V1DaemonSetUpdateStrategy.discriminator = undefined;
V1DaemonSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1RollingUpdateDaemonSet"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1DaemonSetUpdateStrategy = V1DaemonSetUpdateStrategy;
/**
* DeleteOptions may be provided when deleting an API object.
*/
class V1DeleteOptions {
    static getAttributeTypeMap() {
        return V1DeleteOptions.attributeTypeMap;
    }
}
V1DeleteOptions.discriminator = undefined;
V1DeleteOptions.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "dryRun",
        "baseName": "dryRun",
        "type": "Array<string>"
    },
    {
        "name": "gracePeriodSeconds",
        "baseName": "gracePeriodSeconds",
        "type": "number"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "orphanDependents",
        "baseName": "orphanDependents",
        "type": "boolean"
    },
    {
        "name": "preconditions",
        "baseName": "preconditions",
        "type": "V1Preconditions"
    },
    {
        "name": "propagationPolicy",
        "baseName": "propagationPolicy",
        "type": "string"
    }
];
exports.V1DeleteOptions = V1DeleteOptions;
/**
* Deployment enables declarative updates for Pods and ReplicaSets.
*/
class V1Deployment {
    static getAttributeTypeMap() {
        return V1Deployment.attributeTypeMap;
    }
}
V1Deployment.discriminator = undefined;
V1Deployment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1DeploymentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1DeploymentStatus"
    }
];
exports.V1Deployment = V1Deployment;
/**
* DeploymentCondition describes the state of a deployment at a certain point.
*/
class V1DeploymentCondition {
    static getAttributeTypeMap() {
        return V1DeploymentCondition.attributeTypeMap;
    }
}
V1DeploymentCondition.discriminator = undefined;
V1DeploymentCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "lastUpdateTime",
        "baseName": "lastUpdateTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1DeploymentCondition = V1DeploymentCondition;
/**
* DeploymentList is a list of Deployments.
*/
class V1DeploymentList {
    static getAttributeTypeMap() {
        return V1DeploymentList.attributeTypeMap;
    }
}
V1DeploymentList.discriminator = undefined;
V1DeploymentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Deployment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1DeploymentList = V1DeploymentList;
/**
* DeploymentSpec is the specification of the desired behavior of the Deployment.
*/
class V1DeploymentSpec {
    static getAttributeTypeMap() {
        return V1DeploymentSpec.attributeTypeMap;
    }
}
V1DeploymentSpec.discriminator = undefined;
V1DeploymentSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "paused",
        "baseName": "paused",
        "type": "boolean"
    },
    {
        "name": "progressDeadlineSeconds",
        "baseName": "progressDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "strategy",
        "baseName": "strategy",
        "type": "V1DeploymentStrategy"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1DeploymentSpec = V1DeploymentSpec;
/**
* DeploymentStatus is the most recently observed status of the Deployment.
*/
class V1DeploymentStatus {
    static getAttributeTypeMap() {
        return V1DeploymentStatus.attributeTypeMap;
    }
}
V1DeploymentStatus.discriminator = undefined;
V1DeploymentStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1DeploymentCondition>"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "unavailableReplicas",
        "baseName": "unavailableReplicas",
        "type": "number"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.V1DeploymentStatus = V1DeploymentStatus;
/**
* DeploymentStrategy describes how to replace existing pods with new ones.
*/
class V1DeploymentStrategy {
    static getAttributeTypeMap() {
        return V1DeploymentStrategy.attributeTypeMap;
    }
}
V1DeploymentStrategy.discriminator = undefined;
V1DeploymentStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1RollingUpdateDeployment"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1DeploymentStrategy = V1DeploymentStrategy;
/**
* Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
*/
class V1DownwardAPIProjection {
    static getAttributeTypeMap() {
        return V1DownwardAPIProjection.attributeTypeMap;
    }
}
V1DownwardAPIProjection.discriminator = undefined;
V1DownwardAPIProjection.attributeTypeMap = [
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1DownwardAPIVolumeFile>"
    }
];
exports.V1DownwardAPIProjection = V1DownwardAPIProjection;
/**
* DownwardAPIVolumeFile represents information to create the file containing the pod field
*/
class V1DownwardAPIVolumeFile {
    static getAttributeTypeMap() {
        return V1DownwardAPIVolumeFile.attributeTypeMap;
    }
}
V1DownwardAPIVolumeFile.discriminator = undefined;
V1DownwardAPIVolumeFile.attributeTypeMap = [
    {
        "name": "fieldRef",
        "baseName": "fieldRef",
        "type": "V1ObjectFieldSelector"
    },
    {
        "name": "mode",
        "baseName": "mode",
        "type": "number"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "resourceFieldRef",
        "baseName": "resourceFieldRef",
        "type": "V1ResourceFieldSelector"
    }
];
exports.V1DownwardAPIVolumeFile = V1DownwardAPIVolumeFile;
/**
* DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
*/
class V1DownwardAPIVolumeSource {
    static getAttributeTypeMap() {
        return V1DownwardAPIVolumeSource.attributeTypeMap;
    }
}
V1DownwardAPIVolumeSource.discriminator = undefined;
V1DownwardAPIVolumeSource.attributeTypeMap = [
    {
        "name": "defaultMode",
        "baseName": "defaultMode",
        "type": "number"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1DownwardAPIVolumeFile>"
    }
];
exports.V1DownwardAPIVolumeSource = V1DownwardAPIVolumeSource;
/**
* Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
*/
class V1EmptyDirVolumeSource {
    static getAttributeTypeMap() {
        return V1EmptyDirVolumeSource.attributeTypeMap;
    }
}
V1EmptyDirVolumeSource.discriminator = undefined;
V1EmptyDirVolumeSource.attributeTypeMap = [
    {
        "name": "medium",
        "baseName": "medium",
        "type": "string"
    },
    {
        "name": "sizeLimit",
        "baseName": "sizeLimit",
        "type": "string"
    }
];
exports.V1EmptyDirVolumeSource = V1EmptyDirVolumeSource;
/**
* EndpointAddress is a tuple that describes single IP address.
*/
class V1EndpointAddress {
    static getAttributeTypeMap() {
        return V1EndpointAddress.attributeTypeMap;
    }
}
V1EndpointAddress.discriminator = undefined;
V1EndpointAddress.attributeTypeMap = [
    {
        "name": "hostname",
        "baseName": "hostname",
        "type": "string"
    },
    {
        "name": "ip",
        "baseName": "ip",
        "type": "string"
    },
    {
        "name": "nodeName",
        "baseName": "nodeName",
        "type": "string"
    },
    {
        "name": "targetRef",
        "baseName": "targetRef",
        "type": "V1ObjectReference"
    }
];
exports.V1EndpointAddress = V1EndpointAddress;
/**
* EndpointPort is a tuple that describes a single port.
*/
class V1EndpointPort {
    static getAttributeTypeMap() {
        return V1EndpointPort.attributeTypeMap;
    }
}
V1EndpointPort.discriminator = undefined;
V1EndpointPort.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "port",
        "baseName": "port",
        "type": "number"
    },
    {
        "name": "protocol",
        "baseName": "protocol",
        "type": "string"
    }
];
exports.V1EndpointPort = V1EndpointPort;
/**
* EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:   {     Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],     Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]   } The resulting set of endpoints can be viewed as:     a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],     b: [ 10.10.1.1:309, 10.10.2.2:309 ]
*/
class V1EndpointSubset {
    static getAttributeTypeMap() {
        return V1EndpointSubset.attributeTypeMap;
    }
}
V1EndpointSubset.discriminator = undefined;
V1EndpointSubset.attributeTypeMap = [
    {
        "name": "addresses",
        "baseName": "addresses",
        "type": "Array<V1EndpointAddress>"
    },
    {
        "name": "notReadyAddresses",
        "baseName": "notReadyAddresses",
        "type": "Array<V1EndpointAddress>"
    },
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1EndpointPort>"
    }
];
exports.V1EndpointSubset = V1EndpointSubset;
/**
* Endpoints is a collection of endpoints that implement the actual service. Example:   Name: \"mysvc\",   Subsets: [     {       Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],       Ports: [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]     },     {       Addresses: [{\"ip\": \"10.10.3.3\"}],       Ports: [{\"name\": \"a\", \"port\": 93}, {\"name\": \"b\", \"port\": 76}]     },  ]
*/
class V1Endpoints {
    static getAttributeTypeMap() {
        return V1Endpoints.attributeTypeMap;
    }
}
V1Endpoints.discriminator = undefined;
V1Endpoints.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "subsets",
        "baseName": "subsets",
        "type": "Array<V1EndpointSubset>"
    }
];
exports.V1Endpoints = V1Endpoints;
/**
* EndpointsList is a list of endpoints.
*/
class V1EndpointsList {
    static getAttributeTypeMap() {
        return V1EndpointsList.attributeTypeMap;
    }
}
V1EndpointsList.discriminator = undefined;
V1EndpointsList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Endpoints>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1EndpointsList = V1EndpointsList;
/**
* EnvFromSource represents the source of a set of ConfigMaps
*/
class V1EnvFromSource {
    static getAttributeTypeMap() {
        return V1EnvFromSource.attributeTypeMap;
    }
}
V1EnvFromSource.discriminator = undefined;
V1EnvFromSource.attributeTypeMap = [
    {
        "name": "configMapRef",
        "baseName": "configMapRef",
        "type": "V1ConfigMapEnvSource"
    },
    {
        "name": "prefix",
        "baseName": "prefix",
        "type": "string"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretEnvSource"
    }
];
exports.V1EnvFromSource = V1EnvFromSource;
/**
* EnvVar represents an environment variable present in a Container.
*/
class V1EnvVar {
    static getAttributeTypeMap() {
        return V1EnvVar.attributeTypeMap;
    }
}
V1EnvVar.discriminator = undefined;
V1EnvVar.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    },
    {
        "name": "valueFrom",
        "baseName": "valueFrom",
        "type": "V1EnvVarSource"
    }
];
exports.V1EnvVar = V1EnvVar;
/**
* EnvVarSource represents a source for the value of an EnvVar.
*/
class V1EnvVarSource {
    static getAttributeTypeMap() {
        return V1EnvVarSource.attributeTypeMap;
    }
}
V1EnvVarSource.discriminator = undefined;
V1EnvVarSource.attributeTypeMap = [
    {
        "name": "configMapKeyRef",
        "baseName": "configMapKeyRef",
        "type": "V1ConfigMapKeySelector"
    },
    {
        "name": "fieldRef",
        "baseName": "fieldRef",
        "type": "V1ObjectFieldSelector"
    },
    {
        "name": "resourceFieldRef",
        "baseName": "resourceFieldRef",
        "type": "V1ResourceFieldSelector"
    },
    {
        "name": "secretKeyRef",
        "baseName": "secretKeyRef",
        "type": "V1SecretKeySelector"
    }
];
exports.V1EnvVarSource = V1EnvVarSource;
/**
* Event is a report of an event somewhere in the cluster.
*/
class V1Event {
    static getAttributeTypeMap() {
        return V1Event.attributeTypeMap;
    }
}
V1Event.discriminator = undefined;
V1Event.attributeTypeMap = [
    {
        "name": "action",
        "baseName": "action",
        "type": "string"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "count",
        "baseName": "count",
        "type": "number"
    },
    {
        "name": "eventTime",
        "baseName": "eventTime",
        "type": "Date"
    },
    {
        "name": "firstTimestamp",
        "baseName": "firstTimestamp",
        "type": "Date"
    },
    {
        "name": "involvedObject",
        "baseName": "involvedObject",
        "type": "V1ObjectReference"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "lastTimestamp",
        "baseName": "lastTimestamp",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "related",
        "baseName": "related",
        "type": "V1ObjectReference"
    },
    {
        "name": "reportingComponent",
        "baseName": "reportingComponent",
        "type": "string"
    },
    {
        "name": "reportingInstance",
        "baseName": "reportingInstance",
        "type": "string"
    },
    {
        "name": "series",
        "baseName": "series",
        "type": "V1EventSeries"
    },
    {
        "name": "source",
        "baseName": "source",
        "type": "V1EventSource"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1Event = V1Event;
/**
* EventList is a list of events.
*/
class V1EventList {
    static getAttributeTypeMap() {
        return V1EventList.attributeTypeMap;
    }
}
V1EventList.discriminator = undefined;
V1EventList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Event>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1EventList = V1EventList;
/**
* EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
*/
class V1EventSeries {
    static getAttributeTypeMap() {
        return V1EventSeries.attributeTypeMap;
    }
}
V1EventSeries.discriminator = undefined;
V1EventSeries.attributeTypeMap = [
    {
        "name": "count",
        "baseName": "count",
        "type": "number"
    },
    {
        "name": "lastObservedTime",
        "baseName": "lastObservedTime",
        "type": "Date"
    },
    {
        "name": "state",
        "baseName": "state",
        "type": "string"
    }
];
exports.V1EventSeries = V1EventSeries;
/**
* EventSource contains information for an event.
*/
class V1EventSource {
    static getAttributeTypeMap() {
        return V1EventSource.attributeTypeMap;
    }
}
V1EventSource.discriminator = undefined;
V1EventSource.attributeTypeMap = [
    {
        "name": "component",
        "baseName": "component",
        "type": "string"
    },
    {
        "name": "host",
        "baseName": "host",
        "type": "string"
    }
];
exports.V1EventSource = V1EventSource;
/**
* ExecAction describes a \"run in container\" action.
*/
class V1ExecAction {
    static getAttributeTypeMap() {
        return V1ExecAction.attributeTypeMap;
    }
}
V1ExecAction.discriminator = undefined;
V1ExecAction.attributeTypeMap = [
    {
        "name": "command",
        "baseName": "command",
        "type": "Array<string>"
    }
];
exports.V1ExecAction = V1ExecAction;
/**
* Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
*/
class V1FCVolumeSource {
    static getAttributeTypeMap() {
        return V1FCVolumeSource.attributeTypeMap;
    }
}
V1FCVolumeSource.discriminator = undefined;
V1FCVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "lun",
        "baseName": "lun",
        "type": "number"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "targetWWNs",
        "baseName": "targetWWNs",
        "type": "Array<string>"
    },
    {
        "name": "wwids",
        "baseName": "wwids",
        "type": "Array<string>"
    }
];
exports.V1FCVolumeSource = V1FCVolumeSource;
/**
* FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
*/
class V1FlexPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1FlexPersistentVolumeSource.attributeTypeMap;
    }
}
V1FlexPersistentVolumeSource.discriminator = undefined;
V1FlexPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "driver",
        "baseName": "driver",
        "type": "string"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "options",
        "baseName": "options",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    }
];
exports.V1FlexPersistentVolumeSource = V1FlexPersistentVolumeSource;
/**
* FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
*/
class V1FlexVolumeSource {
    static getAttributeTypeMap() {
        return V1FlexVolumeSource.attributeTypeMap;
    }
}
V1FlexVolumeSource.discriminator = undefined;
V1FlexVolumeSource.attributeTypeMap = [
    {
        "name": "driver",
        "baseName": "driver",
        "type": "string"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "options",
        "baseName": "options",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    }
];
exports.V1FlexVolumeSource = V1FlexVolumeSource;
/**
* Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
*/
class V1FlockerVolumeSource {
    static getAttributeTypeMap() {
        return V1FlockerVolumeSource.attributeTypeMap;
    }
}
V1FlockerVolumeSource.discriminator = undefined;
V1FlockerVolumeSource.attributeTypeMap = [
    {
        "name": "datasetName",
        "baseName": "datasetName",
        "type": "string"
    },
    {
        "name": "datasetUUID",
        "baseName": "datasetUUID",
        "type": "string"
    }
];
exports.V1FlockerVolumeSource = V1FlockerVolumeSource;
/**
* Represents a Persistent Disk resource in Google Compute Engine.  A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
*/
class V1GCEPersistentDiskVolumeSource {
    static getAttributeTypeMap() {
        return V1GCEPersistentDiskVolumeSource.attributeTypeMap;
    }
}
V1GCEPersistentDiskVolumeSource.discriminator = undefined;
V1GCEPersistentDiskVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "partition",
        "baseName": "partition",
        "type": "number"
    },
    {
        "name": "pdName",
        "baseName": "pdName",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.V1GCEPersistentDiskVolumeSource = V1GCEPersistentDiskVolumeSource;
/**
* Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.  DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
*/
class V1GitRepoVolumeSource {
    static getAttributeTypeMap() {
        return V1GitRepoVolumeSource.attributeTypeMap;
    }
}
V1GitRepoVolumeSource.discriminator = undefined;
V1GitRepoVolumeSource.attributeTypeMap = [
    {
        "name": "directory",
        "baseName": "directory",
        "type": "string"
    },
    {
        "name": "repository",
        "baseName": "repository",
        "type": "string"
    },
    {
        "name": "revision",
        "baseName": "revision",
        "type": "string"
    }
];
exports.V1GitRepoVolumeSource = V1GitRepoVolumeSource;
/**
* Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
*/
class V1GlusterfsPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1GlusterfsPersistentVolumeSource.attributeTypeMap;
    }
}
V1GlusterfsPersistentVolumeSource.discriminator = undefined;
V1GlusterfsPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "endpoints",
        "baseName": "endpoints",
        "type": "string"
    },
    {
        "name": "endpointsNamespace",
        "baseName": "endpointsNamespace",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.V1GlusterfsPersistentVolumeSource = V1GlusterfsPersistentVolumeSource;
/**
* Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
*/
class V1GlusterfsVolumeSource {
    static getAttributeTypeMap() {
        return V1GlusterfsVolumeSource.attributeTypeMap;
    }
}
V1GlusterfsVolumeSource.discriminator = undefined;
V1GlusterfsVolumeSource.attributeTypeMap = [
    {
        "name": "endpoints",
        "baseName": "endpoints",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.V1GlusterfsVolumeSource = V1GlusterfsVolumeSource;
/**
* GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.
*/
class V1GroupVersionForDiscovery {
    static getAttributeTypeMap() {
        return V1GroupVersionForDiscovery.attributeTypeMap;
    }
}
V1GroupVersionForDiscovery.discriminator = undefined;
V1GroupVersionForDiscovery.attributeTypeMap = [
    {
        "name": "groupVersion",
        "baseName": "groupVersion",
        "type": "string"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    }
];
exports.V1GroupVersionForDiscovery = V1GroupVersionForDiscovery;
/**
* HTTPGetAction describes an action based on HTTP Get requests.
*/
class V1HTTPGetAction {
    static getAttributeTypeMap() {
        return V1HTTPGetAction.attributeTypeMap;
    }
}
V1HTTPGetAction.discriminator = undefined;
V1HTTPGetAction.attributeTypeMap = [
    {
        "name": "host",
        "baseName": "host",
        "type": "string"
    },
    {
        "name": "httpHeaders",
        "baseName": "httpHeaders",
        "type": "Array<V1HTTPHeader>"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "port",
        "baseName": "port",
        "type": "any"
    },
    {
        "name": "scheme",
        "baseName": "scheme",
        "type": "string"
    }
];
exports.V1HTTPGetAction = V1HTTPGetAction;
/**
* HTTPHeader describes a custom header to be used in HTTP probes
*/
class V1HTTPHeader {
    static getAttributeTypeMap() {
        return V1HTTPHeader.attributeTypeMap;
    }
}
V1HTTPHeader.discriminator = undefined;
V1HTTPHeader.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V1HTTPHeader = V1HTTPHeader;
/**
* Handler defines a specific action that should be taken
*/
class V1Handler {
    static getAttributeTypeMap() {
        return V1Handler.attributeTypeMap;
    }
}
V1Handler.discriminator = undefined;
V1Handler.attributeTypeMap = [
    {
        "name": "exec",
        "baseName": "exec",
        "type": "V1ExecAction"
    },
    {
        "name": "httpGet",
        "baseName": "httpGet",
        "type": "V1HTTPGetAction"
    },
    {
        "name": "tcpSocket",
        "baseName": "tcpSocket",
        "type": "V1TCPSocketAction"
    }
];
exports.V1Handler = V1Handler;
/**
* configuration of a horizontal pod autoscaler.
*/
class V1HorizontalPodAutoscaler {
    static getAttributeTypeMap() {
        return V1HorizontalPodAutoscaler.attributeTypeMap;
    }
}
V1HorizontalPodAutoscaler.discriminator = undefined;
V1HorizontalPodAutoscaler.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1HorizontalPodAutoscalerSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1HorizontalPodAutoscalerStatus"
    }
];
exports.V1HorizontalPodAutoscaler = V1HorizontalPodAutoscaler;
/**
* list of horizontal pod autoscaler objects.
*/
class V1HorizontalPodAutoscalerList {
    static getAttributeTypeMap() {
        return V1HorizontalPodAutoscalerList.attributeTypeMap;
    }
}
V1HorizontalPodAutoscalerList.discriminator = undefined;
V1HorizontalPodAutoscalerList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1HorizontalPodAutoscaler>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1HorizontalPodAutoscalerList = V1HorizontalPodAutoscalerList;
/**
* specification of a horizontal pod autoscaler.
*/
class V1HorizontalPodAutoscalerSpec {
    static getAttributeTypeMap() {
        return V1HorizontalPodAutoscalerSpec.attributeTypeMap;
    }
}
V1HorizontalPodAutoscalerSpec.discriminator = undefined;
V1HorizontalPodAutoscalerSpec.attributeTypeMap = [
    {
        "name": "maxReplicas",
        "baseName": "maxReplicas",
        "type": "number"
    },
    {
        "name": "minReplicas",
        "baseName": "minReplicas",
        "type": "number"
    },
    {
        "name": "scaleTargetRef",
        "baseName": "scaleTargetRef",
        "type": "V1CrossVersionObjectReference"
    },
    {
        "name": "targetCPUUtilizationPercentage",
        "baseName": "targetCPUUtilizationPercentage",
        "type": "number"
    }
];
exports.V1HorizontalPodAutoscalerSpec = V1HorizontalPodAutoscalerSpec;
/**
* current status of a horizontal pod autoscaler
*/
class V1HorizontalPodAutoscalerStatus {
    static getAttributeTypeMap() {
        return V1HorizontalPodAutoscalerStatus.attributeTypeMap;
    }
}
V1HorizontalPodAutoscalerStatus.discriminator = undefined;
V1HorizontalPodAutoscalerStatus.attributeTypeMap = [
    {
        "name": "currentCPUUtilizationPercentage",
        "baseName": "currentCPUUtilizationPercentage",
        "type": "number"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "desiredReplicas",
        "baseName": "desiredReplicas",
        "type": "number"
    },
    {
        "name": "lastScaleTime",
        "baseName": "lastScaleTime",
        "type": "Date"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    }
];
exports.V1HorizontalPodAutoscalerStatus = V1HorizontalPodAutoscalerStatus;
/**
* HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
*/
class V1HostAlias {
    static getAttributeTypeMap() {
        return V1HostAlias.attributeTypeMap;
    }
}
V1HostAlias.discriminator = undefined;
V1HostAlias.attributeTypeMap = [
    {
        "name": "hostnames",
        "baseName": "hostnames",
        "type": "Array<string>"
    },
    {
        "name": "ip",
        "baseName": "ip",
        "type": "string"
    }
];
exports.V1HostAlias = V1HostAlias;
/**
* Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
*/
class V1HostPathVolumeSource {
    static getAttributeTypeMap() {
        return V1HostPathVolumeSource.attributeTypeMap;
    }
}
V1HostPathVolumeSource.discriminator = undefined;
V1HostPathVolumeSource.attributeTypeMap = [
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1HostPathVolumeSource = V1HostPathVolumeSource;
/**
* IPBlock describes a particular CIDR (Ex. \"192.168.1.1/24\") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
*/
class V1IPBlock {
    static getAttributeTypeMap() {
        return V1IPBlock.attributeTypeMap;
    }
}
V1IPBlock.discriminator = undefined;
V1IPBlock.attributeTypeMap = [
    {
        "name": "cidr",
        "baseName": "cidr",
        "type": "string"
    },
    {
        "name": "except",
        "baseName": "except",
        "type": "Array<string>"
    }
];
exports.V1IPBlock = V1IPBlock;
/**
* ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
*/
class V1ISCSIPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1ISCSIPersistentVolumeSource.attributeTypeMap;
    }
}
V1ISCSIPersistentVolumeSource.discriminator = undefined;
V1ISCSIPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "chapAuthDiscovery",
        "baseName": "chapAuthDiscovery",
        "type": "boolean"
    },
    {
        "name": "chapAuthSession",
        "baseName": "chapAuthSession",
        "type": "boolean"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "initiatorName",
        "baseName": "initiatorName",
        "type": "string"
    },
    {
        "name": "iqn",
        "baseName": "iqn",
        "type": "string"
    },
    {
        "name": "iscsiInterface",
        "baseName": "iscsiInterface",
        "type": "string"
    },
    {
        "name": "lun",
        "baseName": "lun",
        "type": "number"
    },
    {
        "name": "portals",
        "baseName": "portals",
        "type": "Array<string>"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "targetPortal",
        "baseName": "targetPortal",
        "type": "string"
    }
];
exports.V1ISCSIPersistentVolumeSource = V1ISCSIPersistentVolumeSource;
/**
* Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
*/
class V1ISCSIVolumeSource {
    static getAttributeTypeMap() {
        return V1ISCSIVolumeSource.attributeTypeMap;
    }
}
V1ISCSIVolumeSource.discriminator = undefined;
V1ISCSIVolumeSource.attributeTypeMap = [
    {
        "name": "chapAuthDiscovery",
        "baseName": "chapAuthDiscovery",
        "type": "boolean"
    },
    {
        "name": "chapAuthSession",
        "baseName": "chapAuthSession",
        "type": "boolean"
    },
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "initiatorName",
        "baseName": "initiatorName",
        "type": "string"
    },
    {
        "name": "iqn",
        "baseName": "iqn",
        "type": "string"
    },
    {
        "name": "iscsiInterface",
        "baseName": "iscsiInterface",
        "type": "string"
    },
    {
        "name": "lun",
        "baseName": "lun",
        "type": "number"
    },
    {
        "name": "portals",
        "baseName": "portals",
        "type": "Array<string>"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "targetPortal",
        "baseName": "targetPortal",
        "type": "string"
    }
];
exports.V1ISCSIVolumeSource = V1ISCSIVolumeSource;
/**
* Initializer is information about an initializer that has not yet completed.
*/
class V1Initializer {
    static getAttributeTypeMap() {
        return V1Initializer.attributeTypeMap;
    }
}
V1Initializer.discriminator = undefined;
V1Initializer.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1Initializer = V1Initializer;
/**
* Initializers tracks the progress of initialization.
*/
class V1Initializers {
    static getAttributeTypeMap() {
        return V1Initializers.attributeTypeMap;
    }
}
V1Initializers.discriminator = undefined;
V1Initializers.attributeTypeMap = [
    {
        "name": "pending",
        "baseName": "pending",
        "type": "Array<V1Initializer>"
    },
    {
        "name": "result",
        "baseName": "result",
        "type": "V1Status"
    }
];
exports.V1Initializers = V1Initializers;
/**
* Job represents the configuration of a single job.
*/
class V1Job {
    static getAttributeTypeMap() {
        return V1Job.attributeTypeMap;
    }
}
V1Job.discriminator = undefined;
V1Job.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1JobSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1JobStatus"
    }
];
exports.V1Job = V1Job;
/**
* JobCondition describes current state of a job.
*/
class V1JobCondition {
    static getAttributeTypeMap() {
        return V1JobCondition.attributeTypeMap;
    }
}
V1JobCondition.discriminator = undefined;
V1JobCondition.attributeTypeMap = [
    {
        "name": "lastProbeTime",
        "baseName": "lastProbeTime",
        "type": "Date"
    },
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1JobCondition = V1JobCondition;
/**
* JobList is a collection of jobs.
*/
class V1JobList {
    static getAttributeTypeMap() {
        return V1JobList.attributeTypeMap;
    }
}
V1JobList.discriminator = undefined;
V1JobList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Job>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1JobList = V1JobList;
/**
* JobSpec describes how the job execution will look like.
*/
class V1JobSpec {
    static getAttributeTypeMap() {
        return V1JobSpec.attributeTypeMap;
    }
}
V1JobSpec.discriminator = undefined;
V1JobSpec.attributeTypeMap = [
    {
        "name": "activeDeadlineSeconds",
        "baseName": "activeDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "backoffLimit",
        "baseName": "backoffLimit",
        "type": "number"
    },
    {
        "name": "completions",
        "baseName": "completions",
        "type": "number"
    },
    {
        "name": "manualSelector",
        "baseName": "manualSelector",
        "type": "boolean"
    },
    {
        "name": "parallelism",
        "baseName": "parallelism",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "ttlSecondsAfterFinished",
        "baseName": "ttlSecondsAfterFinished",
        "type": "number"
    }
];
exports.V1JobSpec = V1JobSpec;
/**
* JobStatus represents the current state of a Job.
*/
class V1JobStatus {
    static getAttributeTypeMap() {
        return V1JobStatus.attributeTypeMap;
    }
}
V1JobStatus.discriminator = undefined;
V1JobStatus.attributeTypeMap = [
    {
        "name": "active",
        "baseName": "active",
        "type": "number"
    },
    {
        "name": "completionTime",
        "baseName": "completionTime",
        "type": "Date"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1JobCondition>"
    },
    {
        "name": "failed",
        "baseName": "failed",
        "type": "number"
    },
    {
        "name": "startTime",
        "baseName": "startTime",
        "type": "Date"
    },
    {
        "name": "succeeded",
        "baseName": "succeeded",
        "type": "number"
    }
];
exports.V1JobStatus = V1JobStatus;
/**
* Maps a string key to a path within a volume.
*/
class V1KeyToPath {
    static getAttributeTypeMap() {
        return V1KeyToPath.attributeTypeMap;
    }
}
V1KeyToPath.discriminator = undefined;
V1KeyToPath.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "mode",
        "baseName": "mode",
        "type": "number"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.V1KeyToPath = V1KeyToPath;
/**
* A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.
*/
class V1LabelSelector {
    static getAttributeTypeMap() {
        return V1LabelSelector.attributeTypeMap;
    }
}
V1LabelSelector.discriminator = undefined;
V1LabelSelector.attributeTypeMap = [
    {
        "name": "matchExpressions",
        "baseName": "matchExpressions",
        "type": "Array<V1LabelSelectorRequirement>"
    },
    {
        "name": "matchLabels",
        "baseName": "matchLabels",
        "type": "{ [key: string]: string; }"
    }
];
exports.V1LabelSelector = V1LabelSelector;
/**
* A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
*/
class V1LabelSelectorRequirement {
    static getAttributeTypeMap() {
        return V1LabelSelectorRequirement.attributeTypeMap;
    }
}
V1LabelSelectorRequirement.discriminator = undefined;
V1LabelSelectorRequirement.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "operator",
        "baseName": "operator",
        "type": "string"
    },
    {
        "name": "values",
        "baseName": "values",
        "type": "Array<string>"
    }
];
exports.V1LabelSelectorRequirement = V1LabelSelectorRequirement;
/**
* Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
*/
class V1Lifecycle {
    static getAttributeTypeMap() {
        return V1Lifecycle.attributeTypeMap;
    }
}
V1Lifecycle.discriminator = undefined;
V1Lifecycle.attributeTypeMap = [
    {
        "name": "postStart",
        "baseName": "postStart",
        "type": "V1Handler"
    },
    {
        "name": "preStop",
        "baseName": "preStop",
        "type": "V1Handler"
    }
];
exports.V1Lifecycle = V1Lifecycle;
/**
* LimitRange sets resource usage limits for each kind of resource in a Namespace.
*/
class V1LimitRange {
    static getAttributeTypeMap() {
        return V1LimitRange.attributeTypeMap;
    }
}
V1LimitRange.discriminator = undefined;
V1LimitRange.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1LimitRangeSpec"
    }
];
exports.V1LimitRange = V1LimitRange;
/**
* LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
*/
class V1LimitRangeItem {
    static getAttributeTypeMap() {
        return V1LimitRangeItem.attributeTypeMap;
    }
}
V1LimitRangeItem.discriminator = undefined;
V1LimitRangeItem.attributeTypeMap = [
    {
        "name": "_default",
        "baseName": "default",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "defaultRequest",
        "baseName": "defaultRequest",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "max",
        "baseName": "max",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "maxLimitRequestRatio",
        "baseName": "maxLimitRequestRatio",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "min",
        "baseName": "min",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1LimitRangeItem = V1LimitRangeItem;
/**
* LimitRangeList is a list of LimitRange items.
*/
class V1LimitRangeList {
    static getAttributeTypeMap() {
        return V1LimitRangeList.attributeTypeMap;
    }
}
V1LimitRangeList.discriminator = undefined;
V1LimitRangeList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1LimitRange>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1LimitRangeList = V1LimitRangeList;
/**
* LimitRangeSpec defines a min/max usage limit for resources that match on kind.
*/
class V1LimitRangeSpec {
    static getAttributeTypeMap() {
        return V1LimitRangeSpec.attributeTypeMap;
    }
}
V1LimitRangeSpec.discriminator = undefined;
V1LimitRangeSpec.attributeTypeMap = [
    {
        "name": "limits",
        "baseName": "limits",
        "type": "Array<V1LimitRangeItem>"
    }
];
exports.V1LimitRangeSpec = V1LimitRangeSpec;
/**
* ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
*/
class V1ListMeta {
    static getAttributeTypeMap() {
        return V1ListMeta.attributeTypeMap;
    }
}
V1ListMeta.discriminator = undefined;
V1ListMeta.attributeTypeMap = [
    {
        "name": "_continue",
        "baseName": "continue",
        "type": "string"
    },
    {
        "name": "resourceVersion",
        "baseName": "resourceVersion",
        "type": "string"
    },
    {
        "name": "selfLink",
        "baseName": "selfLink",
        "type": "string"
    }
];
exports.V1ListMeta = V1ListMeta;
/**
* LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
*/
class V1LoadBalancerIngress {
    static getAttributeTypeMap() {
        return V1LoadBalancerIngress.attributeTypeMap;
    }
}
V1LoadBalancerIngress.discriminator = undefined;
V1LoadBalancerIngress.attributeTypeMap = [
    {
        "name": "hostname",
        "baseName": "hostname",
        "type": "string"
    },
    {
        "name": "ip",
        "baseName": "ip",
        "type": "string"
    }
];
exports.V1LoadBalancerIngress = V1LoadBalancerIngress;
/**
* LoadBalancerStatus represents the status of a load-balancer.
*/
class V1LoadBalancerStatus {
    static getAttributeTypeMap() {
        return V1LoadBalancerStatus.attributeTypeMap;
    }
}
V1LoadBalancerStatus.discriminator = undefined;
V1LoadBalancerStatus.attributeTypeMap = [
    {
        "name": "ingress",
        "baseName": "ingress",
        "type": "Array<V1LoadBalancerIngress>"
    }
];
exports.V1LoadBalancerStatus = V1LoadBalancerStatus;
/**
* LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
*/
class V1LocalObjectReference {
    static getAttributeTypeMap() {
        return V1LocalObjectReference.attributeTypeMap;
    }
}
V1LocalObjectReference.discriminator = undefined;
V1LocalObjectReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1LocalObjectReference = V1LocalObjectReference;
/**
* LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
*/
class V1LocalSubjectAccessReview {
    static getAttributeTypeMap() {
        return V1LocalSubjectAccessReview.attributeTypeMap;
    }
}
V1LocalSubjectAccessReview.discriminator = undefined;
V1LocalSubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1SubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1SubjectAccessReviewStatus"
    }
];
exports.V1LocalSubjectAccessReview = V1LocalSubjectAccessReview;
/**
* Local represents directly-attached storage with node affinity (Beta feature)
*/
class V1LocalVolumeSource {
    static getAttributeTypeMap() {
        return V1LocalVolumeSource.attributeTypeMap;
    }
}
V1LocalVolumeSource.discriminator = undefined;
V1LocalVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.V1LocalVolumeSource = V1LocalVolumeSource;
/**
* Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
*/
class V1NFSVolumeSource {
    static getAttributeTypeMap() {
        return V1NFSVolumeSource.attributeTypeMap;
    }
}
V1NFSVolumeSource.discriminator = undefined;
V1NFSVolumeSource.attributeTypeMap = [
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "server",
        "baseName": "server",
        "type": "string"
    }
];
exports.V1NFSVolumeSource = V1NFSVolumeSource;
/**
* Namespace provides a scope for Names. Use of multiple namespaces is optional.
*/
class V1Namespace {
    static getAttributeTypeMap() {
        return V1Namespace.attributeTypeMap;
    }
}
V1Namespace.discriminator = undefined;
V1Namespace.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1NamespaceSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1NamespaceStatus"
    }
];
exports.V1Namespace = V1Namespace;
/**
* NamespaceList is a list of Namespaces.
*/
class V1NamespaceList {
    static getAttributeTypeMap() {
        return V1NamespaceList.attributeTypeMap;
    }
}
V1NamespaceList.discriminator = undefined;
V1NamespaceList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Namespace>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1NamespaceList = V1NamespaceList;
/**
* NamespaceSpec describes the attributes on a Namespace.
*/
class V1NamespaceSpec {
    static getAttributeTypeMap() {
        return V1NamespaceSpec.attributeTypeMap;
    }
}
V1NamespaceSpec.discriminator = undefined;
V1NamespaceSpec.attributeTypeMap = [
    {
        "name": "finalizers",
        "baseName": "finalizers",
        "type": "Array<string>"
    }
];
exports.V1NamespaceSpec = V1NamespaceSpec;
/**
* NamespaceStatus is information about the current status of a Namespace.
*/
class V1NamespaceStatus {
    static getAttributeTypeMap() {
        return V1NamespaceStatus.attributeTypeMap;
    }
}
V1NamespaceStatus.discriminator = undefined;
V1NamespaceStatus.attributeTypeMap = [
    {
        "name": "phase",
        "baseName": "phase",
        "type": "string"
    }
];
exports.V1NamespaceStatus = V1NamespaceStatus;
/**
* NetworkPolicy describes what network traffic is allowed for a set of Pods
*/
class V1NetworkPolicy {
    static getAttributeTypeMap() {
        return V1NetworkPolicy.attributeTypeMap;
    }
}
V1NetworkPolicy.discriminator = undefined;
V1NetworkPolicy.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1NetworkPolicySpec"
    }
];
exports.V1NetworkPolicy = V1NetworkPolicy;
/**
* NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
*/
class V1NetworkPolicyEgressRule {
    static getAttributeTypeMap() {
        return V1NetworkPolicyEgressRule.attributeTypeMap;
    }
}
V1NetworkPolicyEgressRule.discriminator = undefined;
V1NetworkPolicyEgressRule.attributeTypeMap = [
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1NetworkPolicyPort>"
    },
    {
        "name": "to",
        "baseName": "to",
        "type": "Array<V1NetworkPolicyPeer>"
    }
];
exports.V1NetworkPolicyEgressRule = V1NetworkPolicyEgressRule;
/**
* NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
*/
class V1NetworkPolicyIngressRule {
    static getAttributeTypeMap() {
        return V1NetworkPolicyIngressRule.attributeTypeMap;
    }
}
V1NetworkPolicyIngressRule.discriminator = undefined;
V1NetworkPolicyIngressRule.attributeTypeMap = [
    {
        "name": "from",
        "baseName": "from",
        "type": "Array<V1NetworkPolicyPeer>"
    },
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1NetworkPolicyPort>"
    }
];
exports.V1NetworkPolicyIngressRule = V1NetworkPolicyIngressRule;
/**
* NetworkPolicyList is a list of NetworkPolicy objects.
*/
class V1NetworkPolicyList {
    static getAttributeTypeMap() {
        return V1NetworkPolicyList.attributeTypeMap;
    }
}
V1NetworkPolicyList.discriminator = undefined;
V1NetworkPolicyList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1NetworkPolicy>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1NetworkPolicyList = V1NetworkPolicyList;
/**
* NetworkPolicyPeer describes a peer to allow traffic from. Only certain combinations of fields are allowed
*/
class V1NetworkPolicyPeer {
    static getAttributeTypeMap() {
        return V1NetworkPolicyPeer.attributeTypeMap;
    }
}
V1NetworkPolicyPeer.discriminator = undefined;
V1NetworkPolicyPeer.attributeTypeMap = [
    {
        "name": "ipBlock",
        "baseName": "ipBlock",
        "type": "V1IPBlock"
    },
    {
        "name": "namespaceSelector",
        "baseName": "namespaceSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "podSelector",
        "baseName": "podSelector",
        "type": "V1LabelSelector"
    }
];
exports.V1NetworkPolicyPeer = V1NetworkPolicyPeer;
/**
* NetworkPolicyPort describes a port to allow traffic on
*/
class V1NetworkPolicyPort {
    static getAttributeTypeMap() {
        return V1NetworkPolicyPort.attributeTypeMap;
    }
}
V1NetworkPolicyPort.discriminator = undefined;
V1NetworkPolicyPort.attributeTypeMap = [
    {
        "name": "port",
        "baseName": "port",
        "type": "any"
    },
    {
        "name": "protocol",
        "baseName": "protocol",
        "type": "string"
    }
];
exports.V1NetworkPolicyPort = V1NetworkPolicyPort;
/**
* NetworkPolicySpec provides the specification of a NetworkPolicy
*/
class V1NetworkPolicySpec {
    static getAttributeTypeMap() {
        return V1NetworkPolicySpec.attributeTypeMap;
    }
}
V1NetworkPolicySpec.discriminator = undefined;
V1NetworkPolicySpec.attributeTypeMap = [
    {
        "name": "egress",
        "baseName": "egress",
        "type": "Array<V1NetworkPolicyEgressRule>"
    },
    {
        "name": "ingress",
        "baseName": "ingress",
        "type": "Array<V1NetworkPolicyIngressRule>"
    },
    {
        "name": "podSelector",
        "baseName": "podSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "policyTypes",
        "baseName": "policyTypes",
        "type": "Array<string>"
    }
];
exports.V1NetworkPolicySpec = V1NetworkPolicySpec;
/**
* Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).
*/
class V1Node {
    static getAttributeTypeMap() {
        return V1Node.attributeTypeMap;
    }
}
V1Node.discriminator = undefined;
V1Node.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1NodeSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1NodeStatus"
    }
];
exports.V1Node = V1Node;
/**
* NodeAddress contains information for the node's address.
*/
class V1NodeAddress {
    static getAttributeTypeMap() {
        return V1NodeAddress.attributeTypeMap;
    }
}
V1NodeAddress.discriminator = undefined;
V1NodeAddress.attributeTypeMap = [
    {
        "name": "address",
        "baseName": "address",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1NodeAddress = V1NodeAddress;
/**
* Node affinity is a group of node affinity scheduling rules.
*/
class V1NodeAffinity {
    static getAttributeTypeMap() {
        return V1NodeAffinity.attributeTypeMap;
    }
}
V1NodeAffinity.discriminator = undefined;
V1NodeAffinity.attributeTypeMap = [
    {
        "name": "preferredDuringSchedulingIgnoredDuringExecution",
        "baseName": "preferredDuringSchedulingIgnoredDuringExecution",
        "type": "Array<V1PreferredSchedulingTerm>"
    },
    {
        "name": "requiredDuringSchedulingIgnoredDuringExecution",
        "baseName": "requiredDuringSchedulingIgnoredDuringExecution",
        "type": "V1NodeSelector"
    }
];
exports.V1NodeAffinity = V1NodeAffinity;
/**
* NodeCondition contains condition information for a node.
*/
class V1NodeCondition {
    static getAttributeTypeMap() {
        return V1NodeCondition.attributeTypeMap;
    }
}
V1NodeCondition.discriminator = undefined;
V1NodeCondition.attributeTypeMap = [
    {
        "name": "lastHeartbeatTime",
        "baseName": "lastHeartbeatTime",
        "type": "Date"
    },
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1NodeCondition = V1NodeCondition;
/**
* NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.
*/
class V1NodeConfigSource {
    static getAttributeTypeMap() {
        return V1NodeConfigSource.attributeTypeMap;
    }
}
V1NodeConfigSource.discriminator = undefined;
V1NodeConfigSource.attributeTypeMap = [
    {
        "name": "configMap",
        "baseName": "configMap",
        "type": "V1ConfigMapNodeConfigSource"
    }
];
exports.V1NodeConfigSource = V1NodeConfigSource;
/**
* NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
*/
class V1NodeConfigStatus {
    static getAttributeTypeMap() {
        return V1NodeConfigStatus.attributeTypeMap;
    }
}
V1NodeConfigStatus.discriminator = undefined;
V1NodeConfigStatus.attributeTypeMap = [
    {
        "name": "active",
        "baseName": "active",
        "type": "V1NodeConfigSource"
    },
    {
        "name": "assigned",
        "baseName": "assigned",
        "type": "V1NodeConfigSource"
    },
    {
        "name": "error",
        "baseName": "error",
        "type": "string"
    },
    {
        "name": "lastKnownGood",
        "baseName": "lastKnownGood",
        "type": "V1NodeConfigSource"
    }
];
exports.V1NodeConfigStatus = V1NodeConfigStatus;
/**
* NodeDaemonEndpoints lists ports opened by daemons running on the Node.
*/
class V1NodeDaemonEndpoints {
    static getAttributeTypeMap() {
        return V1NodeDaemonEndpoints.attributeTypeMap;
    }
}
V1NodeDaemonEndpoints.discriminator = undefined;
V1NodeDaemonEndpoints.attributeTypeMap = [
    {
        "name": "kubeletEndpoint",
        "baseName": "kubeletEndpoint",
        "type": "V1DaemonEndpoint"
    }
];
exports.V1NodeDaemonEndpoints = V1NodeDaemonEndpoints;
/**
* NodeList is the whole list of all Nodes which have been registered with master.
*/
class V1NodeList {
    static getAttributeTypeMap() {
        return V1NodeList.attributeTypeMap;
    }
}
V1NodeList.discriminator = undefined;
V1NodeList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Node>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1NodeList = V1NodeList;
/**
* A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
*/
class V1NodeSelector {
    static getAttributeTypeMap() {
        return V1NodeSelector.attributeTypeMap;
    }
}
V1NodeSelector.discriminator = undefined;
V1NodeSelector.attributeTypeMap = [
    {
        "name": "nodeSelectorTerms",
        "baseName": "nodeSelectorTerms",
        "type": "Array<V1NodeSelectorTerm>"
    }
];
exports.V1NodeSelector = V1NodeSelector;
/**
* A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
*/
class V1NodeSelectorRequirement {
    static getAttributeTypeMap() {
        return V1NodeSelectorRequirement.attributeTypeMap;
    }
}
V1NodeSelectorRequirement.discriminator = undefined;
V1NodeSelectorRequirement.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "operator",
        "baseName": "operator",
        "type": "string"
    },
    {
        "name": "values",
        "baseName": "values",
        "type": "Array<string>"
    }
];
exports.V1NodeSelectorRequirement = V1NodeSelectorRequirement;
/**
* A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
*/
class V1NodeSelectorTerm {
    static getAttributeTypeMap() {
        return V1NodeSelectorTerm.attributeTypeMap;
    }
}
V1NodeSelectorTerm.discriminator = undefined;
V1NodeSelectorTerm.attributeTypeMap = [
    {
        "name": "matchExpressions",
        "baseName": "matchExpressions",
        "type": "Array<V1NodeSelectorRequirement>"
    },
    {
        "name": "matchFields",
        "baseName": "matchFields",
        "type": "Array<V1NodeSelectorRequirement>"
    }
];
exports.V1NodeSelectorTerm = V1NodeSelectorTerm;
/**
* NodeSpec describes the attributes that a node is created with.
*/
class V1NodeSpec {
    static getAttributeTypeMap() {
        return V1NodeSpec.attributeTypeMap;
    }
}
V1NodeSpec.discriminator = undefined;
V1NodeSpec.attributeTypeMap = [
    {
        "name": "configSource",
        "baseName": "configSource",
        "type": "V1NodeConfigSource"
    },
    {
        "name": "externalID",
        "baseName": "externalID",
        "type": "string"
    },
    {
        "name": "podCIDR",
        "baseName": "podCIDR",
        "type": "string"
    },
    {
        "name": "providerID",
        "baseName": "providerID",
        "type": "string"
    },
    {
        "name": "taints",
        "baseName": "taints",
        "type": "Array<V1Taint>"
    },
    {
        "name": "unschedulable",
        "baseName": "unschedulable",
        "type": "boolean"
    }
];
exports.V1NodeSpec = V1NodeSpec;
/**
* NodeStatus is information about the current status of a node.
*/
class V1NodeStatus {
    static getAttributeTypeMap() {
        return V1NodeStatus.attributeTypeMap;
    }
}
V1NodeStatus.discriminator = undefined;
V1NodeStatus.attributeTypeMap = [
    {
        "name": "addresses",
        "baseName": "addresses",
        "type": "Array<V1NodeAddress>"
    },
    {
        "name": "allocatable",
        "baseName": "allocatable",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "capacity",
        "baseName": "capacity",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1NodeCondition>"
    },
    {
        "name": "config",
        "baseName": "config",
        "type": "V1NodeConfigStatus"
    },
    {
        "name": "daemonEndpoints",
        "baseName": "daemonEndpoints",
        "type": "V1NodeDaemonEndpoints"
    },
    {
        "name": "images",
        "baseName": "images",
        "type": "Array<V1ContainerImage>"
    },
    {
        "name": "nodeInfo",
        "baseName": "nodeInfo",
        "type": "V1NodeSystemInfo"
    },
    {
        "name": "phase",
        "baseName": "phase",
        "type": "string"
    },
    {
        "name": "volumesAttached",
        "baseName": "volumesAttached",
        "type": "Array<V1AttachedVolume>"
    },
    {
        "name": "volumesInUse",
        "baseName": "volumesInUse",
        "type": "Array<string>"
    }
];
exports.V1NodeStatus = V1NodeStatus;
/**
* NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
*/
class V1NodeSystemInfo {
    static getAttributeTypeMap() {
        return V1NodeSystemInfo.attributeTypeMap;
    }
}
V1NodeSystemInfo.discriminator = undefined;
V1NodeSystemInfo.attributeTypeMap = [
    {
        "name": "architecture",
        "baseName": "architecture",
        "type": "string"
    },
    {
        "name": "bootID",
        "baseName": "bootID",
        "type": "string"
    },
    {
        "name": "containerRuntimeVersion",
        "baseName": "containerRuntimeVersion",
        "type": "string"
    },
    {
        "name": "kernelVersion",
        "baseName": "kernelVersion",
        "type": "string"
    },
    {
        "name": "kubeProxyVersion",
        "baseName": "kubeProxyVersion",
        "type": "string"
    },
    {
        "name": "kubeletVersion",
        "baseName": "kubeletVersion",
        "type": "string"
    },
    {
        "name": "machineID",
        "baseName": "machineID",
        "type": "string"
    },
    {
        "name": "operatingSystem",
        "baseName": "operatingSystem",
        "type": "string"
    },
    {
        "name": "osImage",
        "baseName": "osImage",
        "type": "string"
    },
    {
        "name": "systemUUID",
        "baseName": "systemUUID",
        "type": "string"
    }
];
exports.V1NodeSystemInfo = V1NodeSystemInfo;
/**
* NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface
*/
class V1NonResourceAttributes {
    static getAttributeTypeMap() {
        return V1NonResourceAttributes.attributeTypeMap;
    }
}
V1NonResourceAttributes.discriminator = undefined;
V1NonResourceAttributes.attributeTypeMap = [
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "verb",
        "baseName": "verb",
        "type": "string"
    }
];
exports.V1NonResourceAttributes = V1NonResourceAttributes;
/**
* NonResourceRule holds information that describes a rule for the non-resource
*/
class V1NonResourceRule {
    static getAttributeTypeMap() {
        return V1NonResourceRule.attributeTypeMap;
    }
}
V1NonResourceRule.discriminator = undefined;
V1NonResourceRule.attributeTypeMap = [
    {
        "name": "nonResourceURLs",
        "baseName": "nonResourceURLs",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1NonResourceRule = V1NonResourceRule;
/**
* ObjectFieldSelector selects an APIVersioned field of an object.
*/
class V1ObjectFieldSelector {
    static getAttributeTypeMap() {
        return V1ObjectFieldSelector.attributeTypeMap;
    }
}
V1ObjectFieldSelector.discriminator = undefined;
V1ObjectFieldSelector.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "fieldPath",
        "baseName": "fieldPath",
        "type": "string"
    }
];
exports.V1ObjectFieldSelector = V1ObjectFieldSelector;
/**
* ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
*/
class V1ObjectMeta {
    static getAttributeTypeMap() {
        return V1ObjectMeta.attributeTypeMap;
    }
}
V1ObjectMeta.discriminator = undefined;
V1ObjectMeta.attributeTypeMap = [
    {
        "name": "annotations",
        "baseName": "annotations",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "clusterName",
        "baseName": "clusterName",
        "type": "string"
    },
    {
        "name": "creationTimestamp",
        "baseName": "creationTimestamp",
        "type": "Date"
    },
    {
        "name": "deletionGracePeriodSeconds",
        "baseName": "deletionGracePeriodSeconds",
        "type": "number"
    },
    {
        "name": "deletionTimestamp",
        "baseName": "deletionTimestamp",
        "type": "Date"
    },
    {
        "name": "finalizers",
        "baseName": "finalizers",
        "type": "Array<string>"
    },
    {
        "name": "generateName",
        "baseName": "generateName",
        "type": "string"
    },
    {
        "name": "generation",
        "baseName": "generation",
        "type": "number"
    },
    {
        "name": "initializers",
        "baseName": "initializers",
        "type": "V1Initializers"
    },
    {
        "name": "labels",
        "baseName": "labels",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "ownerReferences",
        "baseName": "ownerReferences",
        "type": "Array<V1OwnerReference>"
    },
    {
        "name": "resourceVersion",
        "baseName": "resourceVersion",
        "type": "string"
    },
    {
        "name": "selfLink",
        "baseName": "selfLink",
        "type": "string"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1ObjectMeta = V1ObjectMeta;
/**
* ObjectReference contains enough information to let you inspect or modify the referred object.
*/
class V1ObjectReference {
    static getAttributeTypeMap() {
        return V1ObjectReference.attributeTypeMap;
    }
}
V1ObjectReference.discriminator = undefined;
V1ObjectReference.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "fieldPath",
        "baseName": "fieldPath",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "resourceVersion",
        "baseName": "resourceVersion",
        "type": "string"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1ObjectReference = V1ObjectReference;
/**
* OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field.
*/
class V1OwnerReference {
    static getAttributeTypeMap() {
        return V1OwnerReference.attributeTypeMap;
    }
}
V1OwnerReference.discriminator = undefined;
V1OwnerReference.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "blockOwnerDeletion",
        "baseName": "blockOwnerDeletion",
        "type": "boolean"
    },
    {
        "name": "controller",
        "baseName": "controller",
        "type": "boolean"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1OwnerReference = V1OwnerReference;
/**
* PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
*/
class V1PersistentVolume {
    static getAttributeTypeMap() {
        return V1PersistentVolume.attributeTypeMap;
    }
}
V1PersistentVolume.discriminator = undefined;
V1PersistentVolume.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1PersistentVolumeSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1PersistentVolumeStatus"
    }
];
exports.V1PersistentVolume = V1PersistentVolume;
/**
* PersistentVolumeClaim is a user's request for and claim to a persistent volume
*/
class V1PersistentVolumeClaim {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaim.attributeTypeMap;
    }
}
V1PersistentVolumeClaim.discriminator = undefined;
V1PersistentVolumeClaim.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1PersistentVolumeClaimSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1PersistentVolumeClaimStatus"
    }
];
exports.V1PersistentVolumeClaim = V1PersistentVolumeClaim;
/**
* PersistentVolumeClaimCondition contails details about state of pvc
*/
class V1PersistentVolumeClaimCondition {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaimCondition.attributeTypeMap;
    }
}
V1PersistentVolumeClaimCondition.discriminator = undefined;
V1PersistentVolumeClaimCondition.attributeTypeMap = [
    {
        "name": "lastProbeTime",
        "baseName": "lastProbeTime",
        "type": "Date"
    },
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1PersistentVolumeClaimCondition = V1PersistentVolumeClaimCondition;
/**
* PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
*/
class V1PersistentVolumeClaimList {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaimList.attributeTypeMap;
    }
}
V1PersistentVolumeClaimList.discriminator = undefined;
V1PersistentVolumeClaimList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1PersistentVolumeClaim>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1PersistentVolumeClaimList = V1PersistentVolumeClaimList;
/**
* PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
*/
class V1PersistentVolumeClaimSpec {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaimSpec.attributeTypeMap;
    }
}
V1PersistentVolumeClaimSpec.discriminator = undefined;
V1PersistentVolumeClaimSpec.attributeTypeMap = [
    {
        "name": "accessModes",
        "baseName": "accessModes",
        "type": "Array<string>"
    },
    {
        "name": "dataSource",
        "baseName": "dataSource",
        "type": "V1TypedLocalObjectReference"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "V1ResourceRequirements"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "storageClassName",
        "baseName": "storageClassName",
        "type": "string"
    },
    {
        "name": "volumeMode",
        "baseName": "volumeMode",
        "type": "string"
    },
    {
        "name": "volumeName",
        "baseName": "volumeName",
        "type": "string"
    }
];
exports.V1PersistentVolumeClaimSpec = V1PersistentVolumeClaimSpec;
/**
* PersistentVolumeClaimStatus is the current status of a persistent volume claim.
*/
class V1PersistentVolumeClaimStatus {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaimStatus.attributeTypeMap;
    }
}
V1PersistentVolumeClaimStatus.discriminator = undefined;
V1PersistentVolumeClaimStatus.attributeTypeMap = [
    {
        "name": "accessModes",
        "baseName": "accessModes",
        "type": "Array<string>"
    },
    {
        "name": "capacity",
        "baseName": "capacity",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1PersistentVolumeClaimCondition>"
    },
    {
        "name": "phase",
        "baseName": "phase",
        "type": "string"
    }
];
exports.V1PersistentVolumeClaimStatus = V1PersistentVolumeClaimStatus;
/**
* PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
*/
class V1PersistentVolumeClaimVolumeSource {
    static getAttributeTypeMap() {
        return V1PersistentVolumeClaimVolumeSource.attributeTypeMap;
    }
}
V1PersistentVolumeClaimVolumeSource.discriminator = undefined;
V1PersistentVolumeClaimVolumeSource.attributeTypeMap = [
    {
        "name": "claimName",
        "baseName": "claimName",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    }
];
exports.V1PersistentVolumeClaimVolumeSource = V1PersistentVolumeClaimVolumeSource;
/**
* PersistentVolumeList is a list of PersistentVolume items.
*/
class V1PersistentVolumeList {
    static getAttributeTypeMap() {
        return V1PersistentVolumeList.attributeTypeMap;
    }
}
V1PersistentVolumeList.discriminator = undefined;
V1PersistentVolumeList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1PersistentVolume>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1PersistentVolumeList = V1PersistentVolumeList;
/**
* PersistentVolumeSpec is the specification of a persistent volume.
*/
class V1PersistentVolumeSpec {
    static getAttributeTypeMap() {
        return V1PersistentVolumeSpec.attributeTypeMap;
    }
}
V1PersistentVolumeSpec.discriminator = undefined;
V1PersistentVolumeSpec.attributeTypeMap = [
    {
        "name": "accessModes",
        "baseName": "accessModes",
        "type": "Array<string>"
    },
    {
        "name": "awsElasticBlockStore",
        "baseName": "awsElasticBlockStore",
        "type": "V1AWSElasticBlockStoreVolumeSource"
    },
    {
        "name": "azureDisk",
        "baseName": "azureDisk",
        "type": "V1AzureDiskVolumeSource"
    },
    {
        "name": "azureFile",
        "baseName": "azureFile",
        "type": "V1AzureFilePersistentVolumeSource"
    },
    {
        "name": "capacity",
        "baseName": "capacity",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "cephfs",
        "baseName": "cephfs",
        "type": "V1CephFSPersistentVolumeSource"
    },
    {
        "name": "cinder",
        "baseName": "cinder",
        "type": "V1CinderPersistentVolumeSource"
    },
    {
        "name": "claimRef",
        "baseName": "claimRef",
        "type": "V1ObjectReference"
    },
    {
        "name": "csi",
        "baseName": "csi",
        "type": "V1CSIPersistentVolumeSource"
    },
    {
        "name": "fc",
        "baseName": "fc",
        "type": "V1FCVolumeSource"
    },
    {
        "name": "flexVolume",
        "baseName": "flexVolume",
        "type": "V1FlexPersistentVolumeSource"
    },
    {
        "name": "flocker",
        "baseName": "flocker",
        "type": "V1FlockerVolumeSource"
    },
    {
        "name": "gcePersistentDisk",
        "baseName": "gcePersistentDisk",
        "type": "V1GCEPersistentDiskVolumeSource"
    },
    {
        "name": "glusterfs",
        "baseName": "glusterfs",
        "type": "V1GlusterfsPersistentVolumeSource"
    },
    {
        "name": "hostPath",
        "baseName": "hostPath",
        "type": "V1HostPathVolumeSource"
    },
    {
        "name": "iscsi",
        "baseName": "iscsi",
        "type": "V1ISCSIPersistentVolumeSource"
    },
    {
        "name": "local",
        "baseName": "local",
        "type": "V1LocalVolumeSource"
    },
    {
        "name": "mountOptions",
        "baseName": "mountOptions",
        "type": "Array<string>"
    },
    {
        "name": "nfs",
        "baseName": "nfs",
        "type": "V1NFSVolumeSource"
    },
    {
        "name": "nodeAffinity",
        "baseName": "nodeAffinity",
        "type": "V1VolumeNodeAffinity"
    },
    {
        "name": "persistentVolumeReclaimPolicy",
        "baseName": "persistentVolumeReclaimPolicy",
        "type": "string"
    },
    {
        "name": "photonPersistentDisk",
        "baseName": "photonPersistentDisk",
        "type": "V1PhotonPersistentDiskVolumeSource"
    },
    {
        "name": "portworxVolume",
        "baseName": "portworxVolume",
        "type": "V1PortworxVolumeSource"
    },
    {
        "name": "quobyte",
        "baseName": "quobyte",
        "type": "V1QuobyteVolumeSource"
    },
    {
        "name": "rbd",
        "baseName": "rbd",
        "type": "V1RBDPersistentVolumeSource"
    },
    {
        "name": "scaleIO",
        "baseName": "scaleIO",
        "type": "V1ScaleIOPersistentVolumeSource"
    },
    {
        "name": "storageClassName",
        "baseName": "storageClassName",
        "type": "string"
    },
    {
        "name": "storageos",
        "baseName": "storageos",
        "type": "V1StorageOSPersistentVolumeSource"
    },
    {
        "name": "volumeMode",
        "baseName": "volumeMode",
        "type": "string"
    },
    {
        "name": "vsphereVolume",
        "baseName": "vsphereVolume",
        "type": "V1VsphereVirtualDiskVolumeSource"
    }
];
exports.V1PersistentVolumeSpec = V1PersistentVolumeSpec;
/**
* PersistentVolumeStatus is the current status of a persistent volume.
*/
class V1PersistentVolumeStatus {
    static getAttributeTypeMap() {
        return V1PersistentVolumeStatus.attributeTypeMap;
    }
}
V1PersistentVolumeStatus.discriminator = undefined;
V1PersistentVolumeStatus.attributeTypeMap = [
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "phase",
        "baseName": "phase",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    }
];
exports.V1PersistentVolumeStatus = V1PersistentVolumeStatus;
/**
* Represents a Photon Controller persistent disk resource.
*/
class V1PhotonPersistentDiskVolumeSource {
    static getAttributeTypeMap() {
        return V1PhotonPersistentDiskVolumeSource.attributeTypeMap;
    }
}
V1PhotonPersistentDiskVolumeSource.discriminator = undefined;
V1PhotonPersistentDiskVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "pdID",
        "baseName": "pdID",
        "type": "string"
    }
];
exports.V1PhotonPersistentDiskVolumeSource = V1PhotonPersistentDiskVolumeSource;
/**
* Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.
*/
class V1Pod {
    static getAttributeTypeMap() {
        return V1Pod.attributeTypeMap;
    }
}
V1Pod.discriminator = undefined;
V1Pod.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1PodSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1PodStatus"
    }
];
exports.V1Pod = V1Pod;
/**
* Pod affinity is a group of inter pod affinity scheduling rules.
*/
class V1PodAffinity {
    static getAttributeTypeMap() {
        return V1PodAffinity.attributeTypeMap;
    }
}
V1PodAffinity.discriminator = undefined;
V1PodAffinity.attributeTypeMap = [
    {
        "name": "preferredDuringSchedulingIgnoredDuringExecution",
        "baseName": "preferredDuringSchedulingIgnoredDuringExecution",
        "type": "Array<V1WeightedPodAffinityTerm>"
    },
    {
        "name": "requiredDuringSchedulingIgnoredDuringExecution",
        "baseName": "requiredDuringSchedulingIgnoredDuringExecution",
        "type": "Array<V1PodAffinityTerm>"
    }
];
exports.V1PodAffinity = V1PodAffinity;
/**
* Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
*/
class V1PodAffinityTerm {
    static getAttributeTypeMap() {
        return V1PodAffinityTerm.attributeTypeMap;
    }
}
V1PodAffinityTerm.discriminator = undefined;
V1PodAffinityTerm.attributeTypeMap = [
    {
        "name": "labelSelector",
        "baseName": "labelSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "namespaces",
        "baseName": "namespaces",
        "type": "Array<string>"
    },
    {
        "name": "topologyKey",
        "baseName": "topologyKey",
        "type": "string"
    }
];
exports.V1PodAffinityTerm = V1PodAffinityTerm;
/**
* Pod anti affinity is a group of inter pod anti affinity scheduling rules.
*/
class V1PodAntiAffinity {
    static getAttributeTypeMap() {
        return V1PodAntiAffinity.attributeTypeMap;
    }
}
V1PodAntiAffinity.discriminator = undefined;
V1PodAntiAffinity.attributeTypeMap = [
    {
        "name": "preferredDuringSchedulingIgnoredDuringExecution",
        "baseName": "preferredDuringSchedulingIgnoredDuringExecution",
        "type": "Array<V1WeightedPodAffinityTerm>"
    },
    {
        "name": "requiredDuringSchedulingIgnoredDuringExecution",
        "baseName": "requiredDuringSchedulingIgnoredDuringExecution",
        "type": "Array<V1PodAffinityTerm>"
    }
];
exports.V1PodAntiAffinity = V1PodAntiAffinity;
/**
* PodCondition contains details for the current condition of this pod.
*/
class V1PodCondition {
    static getAttributeTypeMap() {
        return V1PodCondition.attributeTypeMap;
    }
}
V1PodCondition.discriminator = undefined;
V1PodCondition.attributeTypeMap = [
    {
        "name": "lastProbeTime",
        "baseName": "lastProbeTime",
        "type": "Date"
    },
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1PodCondition = V1PodCondition;
/**
* PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.
*/
class V1PodDNSConfig {
    static getAttributeTypeMap() {
        return V1PodDNSConfig.attributeTypeMap;
    }
}
V1PodDNSConfig.discriminator = undefined;
V1PodDNSConfig.attributeTypeMap = [
    {
        "name": "nameservers",
        "baseName": "nameservers",
        "type": "Array<string>"
    },
    {
        "name": "options",
        "baseName": "options",
        "type": "Array<V1PodDNSConfigOption>"
    },
    {
        "name": "searches",
        "baseName": "searches",
        "type": "Array<string>"
    }
];
exports.V1PodDNSConfig = V1PodDNSConfig;
/**
* PodDNSConfigOption defines DNS resolver options of a pod.
*/
class V1PodDNSConfigOption {
    static getAttributeTypeMap() {
        return V1PodDNSConfigOption.attributeTypeMap;
    }
}
V1PodDNSConfigOption.discriminator = undefined;
V1PodDNSConfigOption.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V1PodDNSConfigOption = V1PodDNSConfigOption;
/**
* PodList is a list of Pods.
*/
class V1PodList {
    static getAttributeTypeMap() {
        return V1PodList.attributeTypeMap;
    }
}
V1PodList.discriminator = undefined;
V1PodList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Pod>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1PodList = V1PodList;
/**
* PodReadinessGate contains the reference to a pod condition
*/
class V1PodReadinessGate {
    static getAttributeTypeMap() {
        return V1PodReadinessGate.attributeTypeMap;
    }
}
V1PodReadinessGate.discriminator = undefined;
V1PodReadinessGate.attributeTypeMap = [
    {
        "name": "conditionType",
        "baseName": "conditionType",
        "type": "string"
    }
];
exports.V1PodReadinessGate = V1PodReadinessGate;
/**
* PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.
*/
class V1PodSecurityContext {
    static getAttributeTypeMap() {
        return V1PodSecurityContext.attributeTypeMap;
    }
}
V1PodSecurityContext.discriminator = undefined;
V1PodSecurityContext.attributeTypeMap = [
    {
        "name": "fsGroup",
        "baseName": "fsGroup",
        "type": "number"
    },
    {
        "name": "runAsGroup",
        "baseName": "runAsGroup",
        "type": "number"
    },
    {
        "name": "runAsNonRoot",
        "baseName": "runAsNonRoot",
        "type": "boolean"
    },
    {
        "name": "runAsUser",
        "baseName": "runAsUser",
        "type": "number"
    },
    {
        "name": "seLinuxOptions",
        "baseName": "seLinuxOptions",
        "type": "V1SELinuxOptions"
    },
    {
        "name": "supplementalGroups",
        "baseName": "supplementalGroups",
        "type": "Array<number>"
    },
    {
        "name": "sysctls",
        "baseName": "sysctls",
        "type": "Array<V1Sysctl>"
    }
];
exports.V1PodSecurityContext = V1PodSecurityContext;
/**
* PodSpec is a description of a pod.
*/
class V1PodSpec {
    static getAttributeTypeMap() {
        return V1PodSpec.attributeTypeMap;
    }
}
V1PodSpec.discriminator = undefined;
V1PodSpec.attributeTypeMap = [
    {
        "name": "activeDeadlineSeconds",
        "baseName": "activeDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "affinity",
        "baseName": "affinity",
        "type": "V1Affinity"
    },
    {
        "name": "automountServiceAccountToken",
        "baseName": "automountServiceAccountToken",
        "type": "boolean"
    },
    {
        "name": "containers",
        "baseName": "containers",
        "type": "Array<V1Container>"
    },
    {
        "name": "dnsConfig",
        "baseName": "dnsConfig",
        "type": "V1PodDNSConfig"
    },
    {
        "name": "dnsPolicy",
        "baseName": "dnsPolicy",
        "type": "string"
    },
    {
        "name": "enableServiceLinks",
        "baseName": "enableServiceLinks",
        "type": "boolean"
    },
    {
        "name": "hostAliases",
        "baseName": "hostAliases",
        "type": "Array<V1HostAlias>"
    },
    {
        "name": "hostIPC",
        "baseName": "hostIPC",
        "type": "boolean"
    },
    {
        "name": "hostNetwork",
        "baseName": "hostNetwork",
        "type": "boolean"
    },
    {
        "name": "hostPID",
        "baseName": "hostPID",
        "type": "boolean"
    },
    {
        "name": "hostname",
        "baseName": "hostname",
        "type": "string"
    },
    {
        "name": "imagePullSecrets",
        "baseName": "imagePullSecrets",
        "type": "Array<V1LocalObjectReference>"
    },
    {
        "name": "initContainers",
        "baseName": "initContainers",
        "type": "Array<V1Container>"
    },
    {
        "name": "nodeName",
        "baseName": "nodeName",
        "type": "string"
    },
    {
        "name": "nodeSelector",
        "baseName": "nodeSelector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "priority",
        "baseName": "priority",
        "type": "number"
    },
    {
        "name": "priorityClassName",
        "baseName": "priorityClassName",
        "type": "string"
    },
    {
        "name": "readinessGates",
        "baseName": "readinessGates",
        "type": "Array<V1PodReadinessGate>"
    },
    {
        "name": "restartPolicy",
        "baseName": "restartPolicy",
        "type": "string"
    },
    {
        "name": "runtimeClassName",
        "baseName": "runtimeClassName",
        "type": "string"
    },
    {
        "name": "schedulerName",
        "baseName": "schedulerName",
        "type": "string"
    },
    {
        "name": "securityContext",
        "baseName": "securityContext",
        "type": "V1PodSecurityContext"
    },
    {
        "name": "serviceAccount",
        "baseName": "serviceAccount",
        "type": "string"
    },
    {
        "name": "serviceAccountName",
        "baseName": "serviceAccountName",
        "type": "string"
    },
    {
        "name": "shareProcessNamespace",
        "baseName": "shareProcessNamespace",
        "type": "boolean"
    },
    {
        "name": "subdomain",
        "baseName": "subdomain",
        "type": "string"
    },
    {
        "name": "terminationGracePeriodSeconds",
        "baseName": "terminationGracePeriodSeconds",
        "type": "number"
    },
    {
        "name": "tolerations",
        "baseName": "tolerations",
        "type": "Array<V1Toleration>"
    },
    {
        "name": "volumes",
        "baseName": "volumes",
        "type": "Array<V1Volume>"
    }
];
exports.V1PodSpec = V1PodSpec;
/**
* PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.
*/
class V1PodStatus {
    static getAttributeTypeMap() {
        return V1PodStatus.attributeTypeMap;
    }
}
V1PodStatus.discriminator = undefined;
V1PodStatus.attributeTypeMap = [
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1PodCondition>"
    },
    {
        "name": "containerStatuses",
        "baseName": "containerStatuses",
        "type": "Array<V1ContainerStatus>"
    },
    {
        "name": "hostIP",
        "baseName": "hostIP",
        "type": "string"
    },
    {
        "name": "initContainerStatuses",
        "baseName": "initContainerStatuses",
        "type": "Array<V1ContainerStatus>"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "nominatedNodeName",
        "baseName": "nominatedNodeName",
        "type": "string"
    },
    {
        "name": "phase",
        "baseName": "phase",
        "type": "string"
    },
    {
        "name": "podIP",
        "baseName": "podIP",
        "type": "string"
    },
    {
        "name": "qosClass",
        "baseName": "qosClass",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "startTime",
        "baseName": "startTime",
        "type": "Date"
    }
];
exports.V1PodStatus = V1PodStatus;
/**
* PodTemplate describes a template for creating copies of a predefined pod.
*/
class V1PodTemplate {
    static getAttributeTypeMap() {
        return V1PodTemplate.attributeTypeMap;
    }
}
V1PodTemplate.discriminator = undefined;
V1PodTemplate.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1PodTemplate = V1PodTemplate;
/**
* PodTemplateList is a list of PodTemplates.
*/
class V1PodTemplateList {
    static getAttributeTypeMap() {
        return V1PodTemplateList.attributeTypeMap;
    }
}
V1PodTemplateList.discriminator = undefined;
V1PodTemplateList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1PodTemplate>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1PodTemplateList = V1PodTemplateList;
/**
* PodTemplateSpec describes the data a pod should have when created from a template
*/
class V1PodTemplateSpec {
    static getAttributeTypeMap() {
        return V1PodTemplateSpec.attributeTypeMap;
    }
}
V1PodTemplateSpec.discriminator = undefined;
V1PodTemplateSpec.attributeTypeMap = [
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1PodSpec"
    }
];
exports.V1PodTemplateSpec = V1PodTemplateSpec;
/**
* PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
*/
class V1PolicyRule {
    static getAttributeTypeMap() {
        return V1PolicyRule.attributeTypeMap;
    }
}
V1PolicyRule.discriminator = undefined;
V1PolicyRule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "nonResourceURLs",
        "baseName": "nonResourceURLs",
        "type": "Array<string>"
    },
    {
        "name": "resourceNames",
        "baseName": "resourceNames",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1PolicyRule = V1PolicyRule;
/**
* PortworxVolumeSource represents a Portworx volume resource.
*/
class V1PortworxVolumeSource {
    static getAttributeTypeMap() {
        return V1PortworxVolumeSource.attributeTypeMap;
    }
}
V1PortworxVolumeSource.discriminator = undefined;
V1PortworxVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "volumeID",
        "baseName": "volumeID",
        "type": "string"
    }
];
exports.V1PortworxVolumeSource = V1PortworxVolumeSource;
/**
* Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
*/
class V1Preconditions {
    static getAttributeTypeMap() {
        return V1Preconditions.attributeTypeMap;
    }
}
V1Preconditions.discriminator = undefined;
V1Preconditions.attributeTypeMap = [
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1Preconditions = V1Preconditions;
/**
* An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
*/
class V1PreferredSchedulingTerm {
    static getAttributeTypeMap() {
        return V1PreferredSchedulingTerm.attributeTypeMap;
    }
}
V1PreferredSchedulingTerm.discriminator = undefined;
V1PreferredSchedulingTerm.attributeTypeMap = [
    {
        "name": "preference",
        "baseName": "preference",
        "type": "V1NodeSelectorTerm"
    },
    {
        "name": "weight",
        "baseName": "weight",
        "type": "number"
    }
];
exports.V1PreferredSchedulingTerm = V1PreferredSchedulingTerm;
/**
* Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
*/
class V1Probe {
    static getAttributeTypeMap() {
        return V1Probe.attributeTypeMap;
    }
}
V1Probe.discriminator = undefined;
V1Probe.attributeTypeMap = [
    {
        "name": "exec",
        "baseName": "exec",
        "type": "V1ExecAction"
    },
    {
        "name": "failureThreshold",
        "baseName": "failureThreshold",
        "type": "number"
    },
    {
        "name": "httpGet",
        "baseName": "httpGet",
        "type": "V1HTTPGetAction"
    },
    {
        "name": "initialDelaySeconds",
        "baseName": "initialDelaySeconds",
        "type": "number"
    },
    {
        "name": "periodSeconds",
        "baseName": "periodSeconds",
        "type": "number"
    },
    {
        "name": "successThreshold",
        "baseName": "successThreshold",
        "type": "number"
    },
    {
        "name": "tcpSocket",
        "baseName": "tcpSocket",
        "type": "V1TCPSocketAction"
    },
    {
        "name": "timeoutSeconds",
        "baseName": "timeoutSeconds",
        "type": "number"
    }
];
exports.V1Probe = V1Probe;
/**
* Represents a projected volume source
*/
class V1ProjectedVolumeSource {
    static getAttributeTypeMap() {
        return V1ProjectedVolumeSource.attributeTypeMap;
    }
}
V1ProjectedVolumeSource.discriminator = undefined;
V1ProjectedVolumeSource.attributeTypeMap = [
    {
        "name": "defaultMode",
        "baseName": "defaultMode",
        "type": "number"
    },
    {
        "name": "sources",
        "baseName": "sources",
        "type": "Array<V1VolumeProjection>"
    }
];
exports.V1ProjectedVolumeSource = V1ProjectedVolumeSource;
/**
* Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.
*/
class V1QuobyteVolumeSource {
    static getAttributeTypeMap() {
        return V1QuobyteVolumeSource.attributeTypeMap;
    }
}
V1QuobyteVolumeSource.discriminator = undefined;
V1QuobyteVolumeSource.attributeTypeMap = [
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "registry",
        "baseName": "registry",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    },
    {
        "name": "volume",
        "baseName": "volume",
        "type": "string"
    }
];
exports.V1QuobyteVolumeSource = V1QuobyteVolumeSource;
/**
* Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
*/
class V1RBDPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1RBDPersistentVolumeSource.attributeTypeMap;
    }
}
V1RBDPersistentVolumeSource.discriminator = undefined;
V1RBDPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "image",
        "baseName": "image",
        "type": "string"
    },
    {
        "name": "keyring",
        "baseName": "keyring",
        "type": "string"
    },
    {
        "name": "monitors",
        "baseName": "monitors",
        "type": "Array<string>"
    },
    {
        "name": "pool",
        "baseName": "pool",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1RBDPersistentVolumeSource = V1RBDPersistentVolumeSource;
/**
* Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
*/
class V1RBDVolumeSource {
    static getAttributeTypeMap() {
        return V1RBDVolumeSource.attributeTypeMap;
    }
}
V1RBDVolumeSource.discriminator = undefined;
V1RBDVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "image",
        "baseName": "image",
        "type": "string"
    },
    {
        "name": "keyring",
        "baseName": "keyring",
        "type": "string"
    },
    {
        "name": "monitors",
        "baseName": "monitors",
        "type": "Array<string>"
    },
    {
        "name": "pool",
        "baseName": "pool",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1RBDVolumeSource = V1RBDVolumeSource;
/**
* ReplicaSet ensures that a specified number of pod replicas are running at any given time.
*/
class V1ReplicaSet {
    static getAttributeTypeMap() {
        return V1ReplicaSet.attributeTypeMap;
    }
}
V1ReplicaSet.discriminator = undefined;
V1ReplicaSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1ReplicaSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1ReplicaSetStatus"
    }
];
exports.V1ReplicaSet = V1ReplicaSet;
/**
* ReplicaSetCondition describes the state of a replica set at a certain point.
*/
class V1ReplicaSetCondition {
    static getAttributeTypeMap() {
        return V1ReplicaSetCondition.attributeTypeMap;
    }
}
V1ReplicaSetCondition.discriminator = undefined;
V1ReplicaSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1ReplicaSetCondition = V1ReplicaSetCondition;
/**
* ReplicaSetList is a collection of ReplicaSets.
*/
class V1ReplicaSetList {
    static getAttributeTypeMap() {
        return V1ReplicaSetList.attributeTypeMap;
    }
}
V1ReplicaSetList.discriminator = undefined;
V1ReplicaSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ReplicaSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ReplicaSetList = V1ReplicaSetList;
/**
* ReplicaSetSpec is the specification of a ReplicaSet.
*/
class V1ReplicaSetSpec {
    static getAttributeTypeMap() {
        return V1ReplicaSetSpec.attributeTypeMap;
    }
}
V1ReplicaSetSpec.discriminator = undefined;
V1ReplicaSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1ReplicaSetSpec = V1ReplicaSetSpec;
/**
* ReplicaSetStatus represents the current status of a ReplicaSet.
*/
class V1ReplicaSetStatus {
    static getAttributeTypeMap() {
        return V1ReplicaSetStatus.attributeTypeMap;
    }
}
V1ReplicaSetStatus.discriminator = undefined;
V1ReplicaSetStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1ReplicaSetCondition>"
    },
    {
        "name": "fullyLabeledReplicas",
        "baseName": "fullyLabeledReplicas",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1ReplicaSetStatus = V1ReplicaSetStatus;
/**
* ReplicationController represents the configuration of a replication controller.
*/
class V1ReplicationController {
    static getAttributeTypeMap() {
        return V1ReplicationController.attributeTypeMap;
    }
}
V1ReplicationController.discriminator = undefined;
V1ReplicationController.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1ReplicationControllerSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1ReplicationControllerStatus"
    }
];
exports.V1ReplicationController = V1ReplicationController;
/**
* ReplicationControllerCondition describes the state of a replication controller at a certain point.
*/
class V1ReplicationControllerCondition {
    static getAttributeTypeMap() {
        return V1ReplicationControllerCondition.attributeTypeMap;
    }
}
V1ReplicationControllerCondition.discriminator = undefined;
V1ReplicationControllerCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1ReplicationControllerCondition = V1ReplicationControllerCondition;
/**
* ReplicationControllerList is a collection of replication controllers.
*/
class V1ReplicationControllerList {
    static getAttributeTypeMap() {
        return V1ReplicationControllerList.attributeTypeMap;
    }
}
V1ReplicationControllerList.discriminator = undefined;
V1ReplicationControllerList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ReplicationController>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ReplicationControllerList = V1ReplicationControllerList;
/**
* ReplicationControllerSpec is the specification of a replication controller.
*/
class V1ReplicationControllerSpec {
    static getAttributeTypeMap() {
        return V1ReplicationControllerSpec.attributeTypeMap;
    }
}
V1ReplicationControllerSpec.discriminator = undefined;
V1ReplicationControllerSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1ReplicationControllerSpec = V1ReplicationControllerSpec;
/**
* ReplicationControllerStatus represents the current status of a replication controller.
*/
class V1ReplicationControllerStatus {
    static getAttributeTypeMap() {
        return V1ReplicationControllerStatus.attributeTypeMap;
    }
}
V1ReplicationControllerStatus.discriminator = undefined;
V1ReplicationControllerStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1ReplicationControllerCondition>"
    },
    {
        "name": "fullyLabeledReplicas",
        "baseName": "fullyLabeledReplicas",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1ReplicationControllerStatus = V1ReplicationControllerStatus;
/**
* ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface
*/
class V1ResourceAttributes {
    static getAttributeTypeMap() {
        return V1ResourceAttributes.attributeTypeMap;
    }
}
V1ResourceAttributes.discriminator = undefined;
V1ResourceAttributes.attributeTypeMap = [
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "string"
    },
    {
        "name": "subresource",
        "baseName": "subresource",
        "type": "string"
    },
    {
        "name": "verb",
        "baseName": "verb",
        "type": "string"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    }
];
exports.V1ResourceAttributes = V1ResourceAttributes;
/**
* ResourceFieldSelector represents container resources (cpu, memory) and their output format
*/
class V1ResourceFieldSelector {
    static getAttributeTypeMap() {
        return V1ResourceFieldSelector.attributeTypeMap;
    }
}
V1ResourceFieldSelector.discriminator = undefined;
V1ResourceFieldSelector.attributeTypeMap = [
    {
        "name": "containerName",
        "baseName": "containerName",
        "type": "string"
    },
    {
        "name": "divisor",
        "baseName": "divisor",
        "type": "string"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "string"
    }
];
exports.V1ResourceFieldSelector = V1ResourceFieldSelector;
/**
* ResourceQuota sets aggregate quota restrictions enforced per namespace
*/
class V1ResourceQuota {
    static getAttributeTypeMap() {
        return V1ResourceQuota.attributeTypeMap;
    }
}
V1ResourceQuota.discriminator = undefined;
V1ResourceQuota.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1ResourceQuotaSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1ResourceQuotaStatus"
    }
];
exports.V1ResourceQuota = V1ResourceQuota;
/**
* ResourceQuotaList is a list of ResourceQuota items.
*/
class V1ResourceQuotaList {
    static getAttributeTypeMap() {
        return V1ResourceQuotaList.attributeTypeMap;
    }
}
V1ResourceQuotaList.discriminator = undefined;
V1ResourceQuotaList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ResourceQuota>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ResourceQuotaList = V1ResourceQuotaList;
/**
* ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
*/
class V1ResourceQuotaSpec {
    static getAttributeTypeMap() {
        return V1ResourceQuotaSpec.attributeTypeMap;
    }
}
V1ResourceQuotaSpec.discriminator = undefined;
V1ResourceQuotaSpec.attributeTypeMap = [
    {
        "name": "hard",
        "baseName": "hard",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "scopeSelector",
        "baseName": "scopeSelector",
        "type": "V1ScopeSelector"
    },
    {
        "name": "scopes",
        "baseName": "scopes",
        "type": "Array<string>"
    }
];
exports.V1ResourceQuotaSpec = V1ResourceQuotaSpec;
/**
* ResourceQuotaStatus defines the enforced hard limits and observed use.
*/
class V1ResourceQuotaStatus {
    static getAttributeTypeMap() {
        return V1ResourceQuotaStatus.attributeTypeMap;
    }
}
V1ResourceQuotaStatus.discriminator = undefined;
V1ResourceQuotaStatus.attributeTypeMap = [
    {
        "name": "hard",
        "baseName": "hard",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "used",
        "baseName": "used",
        "type": "{ [key: string]: string; }"
    }
];
exports.V1ResourceQuotaStatus = V1ResourceQuotaStatus;
/**
* ResourceRequirements describes the compute resource requirements.
*/
class V1ResourceRequirements {
    static getAttributeTypeMap() {
        return V1ResourceRequirements.attributeTypeMap;
    }
}
V1ResourceRequirements.discriminator = undefined;
V1ResourceRequirements.attributeTypeMap = [
    {
        "name": "limits",
        "baseName": "limits",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "requests",
        "baseName": "requests",
        "type": "{ [key: string]: string; }"
    }
];
exports.V1ResourceRequirements = V1ResourceRequirements;
/**
* ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
*/
class V1ResourceRule {
    static getAttributeTypeMap() {
        return V1ResourceRule.attributeTypeMap;
    }
}
V1ResourceRule.discriminator = undefined;
V1ResourceRule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "resourceNames",
        "baseName": "resourceNames",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1ResourceRule = V1ResourceRule;
/**
* Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
*/
class V1Role {
    static getAttributeTypeMap() {
        return V1Role.attributeTypeMap;
    }
}
V1Role.discriminator = undefined;
V1Role.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1PolicyRule>"
    }
];
exports.V1Role = V1Role;
/**
* RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.
*/
class V1RoleBinding {
    static getAttributeTypeMap() {
        return V1RoleBinding.attributeTypeMap;
    }
}
V1RoleBinding.discriminator = undefined;
V1RoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1Subject>"
    }
];
exports.V1RoleBinding = V1RoleBinding;
/**
* RoleBindingList is a collection of RoleBindings
*/
class V1RoleBindingList {
    static getAttributeTypeMap() {
        return V1RoleBindingList.attributeTypeMap;
    }
}
V1RoleBindingList.discriminator = undefined;
V1RoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1RoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1RoleBindingList = V1RoleBindingList;
/**
* RoleList is a collection of Roles
*/
class V1RoleList {
    static getAttributeTypeMap() {
        return V1RoleList.attributeTypeMap;
    }
}
V1RoleList.discriminator = undefined;
V1RoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Role>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1RoleList = V1RoleList;
/**
* RoleRef contains information that points to the role being used
*/
class V1RoleRef {
    static getAttributeTypeMap() {
        return V1RoleRef.attributeTypeMap;
    }
}
V1RoleRef.discriminator = undefined;
V1RoleRef.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1RoleRef = V1RoleRef;
/**
* Spec to control the desired behavior of daemon set rolling update.
*/
class V1RollingUpdateDaemonSet {
    static getAttributeTypeMap() {
        return V1RollingUpdateDaemonSet.attributeTypeMap;
    }
}
V1RollingUpdateDaemonSet.discriminator = undefined;
V1RollingUpdateDaemonSet.attributeTypeMap = [
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.V1RollingUpdateDaemonSet = V1RollingUpdateDaemonSet;
/**
* Spec to control the desired behavior of rolling update.
*/
class V1RollingUpdateDeployment {
    static getAttributeTypeMap() {
        return V1RollingUpdateDeployment.attributeTypeMap;
    }
}
V1RollingUpdateDeployment.discriminator = undefined;
V1RollingUpdateDeployment.attributeTypeMap = [
    {
        "name": "maxSurge",
        "baseName": "maxSurge",
        "type": "any"
    },
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.V1RollingUpdateDeployment = V1RollingUpdateDeployment;
/**
* RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
*/
class V1RollingUpdateStatefulSetStrategy {
    static getAttributeTypeMap() {
        return V1RollingUpdateStatefulSetStrategy.attributeTypeMap;
    }
}
V1RollingUpdateStatefulSetStrategy.discriminator = undefined;
V1RollingUpdateStatefulSetStrategy.attributeTypeMap = [
    {
        "name": "partition",
        "baseName": "partition",
        "type": "number"
    }
];
exports.V1RollingUpdateStatefulSetStrategy = V1RollingUpdateStatefulSetStrategy;
/**
* SELinuxOptions are the labels to be applied to the container
*/
class V1SELinuxOptions {
    static getAttributeTypeMap() {
        return V1SELinuxOptions.attributeTypeMap;
    }
}
V1SELinuxOptions.discriminator = undefined;
V1SELinuxOptions.attributeTypeMap = [
    {
        "name": "level",
        "baseName": "level",
        "type": "string"
    },
    {
        "name": "role",
        "baseName": "role",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1SELinuxOptions = V1SELinuxOptions;
/**
* Scale represents a scaling request for a resource.
*/
class V1Scale {
    static getAttributeTypeMap() {
        return V1Scale.attributeTypeMap;
    }
}
V1Scale.discriminator = undefined;
V1Scale.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1ScaleSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1ScaleStatus"
    }
];
exports.V1Scale = V1Scale;
/**
* ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
*/
class V1ScaleIOPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1ScaleIOPersistentVolumeSource.attributeTypeMap;
    }
}
V1ScaleIOPersistentVolumeSource.discriminator = undefined;
V1ScaleIOPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "gateway",
        "baseName": "gateway",
        "type": "string"
    },
    {
        "name": "protectionDomain",
        "baseName": "protectionDomain",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1SecretReference"
    },
    {
        "name": "sslEnabled",
        "baseName": "sslEnabled",
        "type": "boolean"
    },
    {
        "name": "storageMode",
        "baseName": "storageMode",
        "type": "string"
    },
    {
        "name": "storagePool",
        "baseName": "storagePool",
        "type": "string"
    },
    {
        "name": "system",
        "baseName": "system",
        "type": "string"
    },
    {
        "name": "volumeName",
        "baseName": "volumeName",
        "type": "string"
    }
];
exports.V1ScaleIOPersistentVolumeSource = V1ScaleIOPersistentVolumeSource;
/**
* ScaleIOVolumeSource represents a persistent ScaleIO volume
*/
class V1ScaleIOVolumeSource {
    static getAttributeTypeMap() {
        return V1ScaleIOVolumeSource.attributeTypeMap;
    }
}
V1ScaleIOVolumeSource.discriminator = undefined;
V1ScaleIOVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "gateway",
        "baseName": "gateway",
        "type": "string"
    },
    {
        "name": "protectionDomain",
        "baseName": "protectionDomain",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "sslEnabled",
        "baseName": "sslEnabled",
        "type": "boolean"
    },
    {
        "name": "storageMode",
        "baseName": "storageMode",
        "type": "string"
    },
    {
        "name": "storagePool",
        "baseName": "storagePool",
        "type": "string"
    },
    {
        "name": "system",
        "baseName": "system",
        "type": "string"
    },
    {
        "name": "volumeName",
        "baseName": "volumeName",
        "type": "string"
    }
];
exports.V1ScaleIOVolumeSource = V1ScaleIOVolumeSource;
/**
* ScaleSpec describes the attributes of a scale subresource.
*/
class V1ScaleSpec {
    static getAttributeTypeMap() {
        return V1ScaleSpec.attributeTypeMap;
    }
}
V1ScaleSpec.discriminator = undefined;
V1ScaleSpec.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1ScaleSpec = V1ScaleSpec;
/**
* ScaleStatus represents the current status of a scale subresource.
*/
class V1ScaleStatus {
    static getAttributeTypeMap() {
        return V1ScaleStatus.attributeTypeMap;
    }
}
V1ScaleStatus.discriminator = undefined;
V1ScaleStatus.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "string"
    }
];
exports.V1ScaleStatus = V1ScaleStatus;
/**
* A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.
*/
class V1ScopeSelector {
    static getAttributeTypeMap() {
        return V1ScopeSelector.attributeTypeMap;
    }
}
V1ScopeSelector.discriminator = undefined;
V1ScopeSelector.attributeTypeMap = [
    {
        "name": "matchExpressions",
        "baseName": "matchExpressions",
        "type": "Array<V1ScopedResourceSelectorRequirement>"
    }
];
exports.V1ScopeSelector = V1ScopeSelector;
/**
* A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.
*/
class V1ScopedResourceSelectorRequirement {
    static getAttributeTypeMap() {
        return V1ScopedResourceSelectorRequirement.attributeTypeMap;
    }
}
V1ScopedResourceSelectorRequirement.discriminator = undefined;
V1ScopedResourceSelectorRequirement.attributeTypeMap = [
    {
        "name": "operator",
        "baseName": "operator",
        "type": "string"
    },
    {
        "name": "scopeName",
        "baseName": "scopeName",
        "type": "string"
    },
    {
        "name": "values",
        "baseName": "values",
        "type": "Array<string>"
    }
];
exports.V1ScopedResourceSelectorRequirement = V1ScopedResourceSelectorRequirement;
/**
* Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.
*/
class V1Secret {
    static getAttributeTypeMap() {
        return V1Secret.attributeTypeMap;
    }
}
V1Secret.discriminator = undefined;
V1Secret.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "data",
        "baseName": "data",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "stringData",
        "baseName": "stringData",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1Secret = V1Secret;
/**
* SecretEnvSource selects a Secret to populate the environment variables with.  The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
*/
class V1SecretEnvSource {
    static getAttributeTypeMap() {
        return V1SecretEnvSource.attributeTypeMap;
    }
}
V1SecretEnvSource.discriminator = undefined;
V1SecretEnvSource.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1SecretEnvSource = V1SecretEnvSource;
/**
* SecretKeySelector selects a key of a Secret.
*/
class V1SecretKeySelector {
    static getAttributeTypeMap() {
        return V1SecretKeySelector.attributeTypeMap;
    }
}
V1SecretKeySelector.discriminator = undefined;
V1SecretKeySelector.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1SecretKeySelector = V1SecretKeySelector;
/**
* SecretList is a list of Secret.
*/
class V1SecretList {
    static getAttributeTypeMap() {
        return V1SecretList.attributeTypeMap;
    }
}
V1SecretList.discriminator = undefined;
V1SecretList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Secret>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1SecretList = V1SecretList;
/**
* Adapts a secret into a projected volume.  The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.
*/
class V1SecretProjection {
    static getAttributeTypeMap() {
        return V1SecretProjection.attributeTypeMap;
    }
}
V1SecretProjection.discriminator = undefined;
V1SecretProjection.attributeTypeMap = [
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1KeyToPath>"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    }
];
exports.V1SecretProjection = V1SecretProjection;
/**
* SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace
*/
class V1SecretReference {
    static getAttributeTypeMap() {
        return V1SecretReference.attributeTypeMap;
    }
}
V1SecretReference.discriminator = undefined;
V1SecretReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1SecretReference = V1SecretReference;
/**
* Adapts a Secret into a volume.  The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.
*/
class V1SecretVolumeSource {
    static getAttributeTypeMap() {
        return V1SecretVolumeSource.attributeTypeMap;
    }
}
V1SecretVolumeSource.discriminator = undefined;
V1SecretVolumeSource.attributeTypeMap = [
    {
        "name": "defaultMode",
        "baseName": "defaultMode",
        "type": "number"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1KeyToPath>"
    },
    {
        "name": "optional",
        "baseName": "optional",
        "type": "boolean"
    },
    {
        "name": "secretName",
        "baseName": "secretName",
        "type": "string"
    }
];
exports.V1SecretVolumeSource = V1SecretVolumeSource;
/**
* SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.
*/
class V1SecurityContext {
    static getAttributeTypeMap() {
        return V1SecurityContext.attributeTypeMap;
    }
}
V1SecurityContext.discriminator = undefined;
V1SecurityContext.attributeTypeMap = [
    {
        "name": "allowPrivilegeEscalation",
        "baseName": "allowPrivilegeEscalation",
        "type": "boolean"
    },
    {
        "name": "capabilities",
        "baseName": "capabilities",
        "type": "V1Capabilities"
    },
    {
        "name": "privileged",
        "baseName": "privileged",
        "type": "boolean"
    },
    {
        "name": "procMount",
        "baseName": "procMount",
        "type": "string"
    },
    {
        "name": "readOnlyRootFilesystem",
        "baseName": "readOnlyRootFilesystem",
        "type": "boolean"
    },
    {
        "name": "runAsGroup",
        "baseName": "runAsGroup",
        "type": "number"
    },
    {
        "name": "runAsNonRoot",
        "baseName": "runAsNonRoot",
        "type": "boolean"
    },
    {
        "name": "runAsUser",
        "baseName": "runAsUser",
        "type": "number"
    },
    {
        "name": "seLinuxOptions",
        "baseName": "seLinuxOptions",
        "type": "V1SELinuxOptions"
    }
];
exports.V1SecurityContext = V1SecurityContext;
/**
* SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action
*/
class V1SelfSubjectAccessReview {
    static getAttributeTypeMap() {
        return V1SelfSubjectAccessReview.attributeTypeMap;
    }
}
V1SelfSubjectAccessReview.discriminator = undefined;
V1SelfSubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1SelfSubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1SubjectAccessReviewStatus"
    }
];
exports.V1SelfSubjectAccessReview = V1SelfSubjectAccessReview;
/**
* SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
*/
class V1SelfSubjectAccessReviewSpec {
    static getAttributeTypeMap() {
        return V1SelfSubjectAccessReviewSpec.attributeTypeMap;
    }
}
V1SelfSubjectAccessReviewSpec.discriminator = undefined;
V1SelfSubjectAccessReviewSpec.attributeTypeMap = [
    {
        "name": "nonResourceAttributes",
        "baseName": "nonResourceAttributes",
        "type": "V1NonResourceAttributes"
    },
    {
        "name": "resourceAttributes",
        "baseName": "resourceAttributes",
        "type": "V1ResourceAttributes"
    }
];
exports.V1SelfSubjectAccessReviewSpec = V1SelfSubjectAccessReviewSpec;
/**
* SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
*/
class V1SelfSubjectRulesReview {
    static getAttributeTypeMap() {
        return V1SelfSubjectRulesReview.attributeTypeMap;
    }
}
V1SelfSubjectRulesReview.discriminator = undefined;
V1SelfSubjectRulesReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1SelfSubjectRulesReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1SubjectRulesReviewStatus"
    }
];
exports.V1SelfSubjectRulesReview = V1SelfSubjectRulesReview;
class V1SelfSubjectRulesReviewSpec {
    static getAttributeTypeMap() {
        return V1SelfSubjectRulesReviewSpec.attributeTypeMap;
    }
}
V1SelfSubjectRulesReviewSpec.discriminator = undefined;
V1SelfSubjectRulesReviewSpec.attributeTypeMap = [
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1SelfSubjectRulesReviewSpec = V1SelfSubjectRulesReviewSpec;
/**
* ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.
*/
class V1ServerAddressByClientCIDR {
    static getAttributeTypeMap() {
        return V1ServerAddressByClientCIDR.attributeTypeMap;
    }
}
V1ServerAddressByClientCIDR.discriminator = undefined;
V1ServerAddressByClientCIDR.attributeTypeMap = [
    {
        "name": "clientCIDR",
        "baseName": "clientCIDR",
        "type": "string"
    },
    {
        "name": "serverAddress",
        "baseName": "serverAddress",
        "type": "string"
    }
];
exports.V1ServerAddressByClientCIDR = V1ServerAddressByClientCIDR;
/**
* Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.
*/
class V1Service {
    static getAttributeTypeMap() {
        return V1Service.attributeTypeMap;
    }
}
V1Service.discriminator = undefined;
V1Service.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1ServiceSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1ServiceStatus"
    }
];
exports.V1Service = V1Service;
/**
* ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets
*/
class V1ServiceAccount {
    static getAttributeTypeMap() {
        return V1ServiceAccount.attributeTypeMap;
    }
}
V1ServiceAccount.discriminator = undefined;
V1ServiceAccount.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "automountServiceAccountToken",
        "baseName": "automountServiceAccountToken",
        "type": "boolean"
    },
    {
        "name": "imagePullSecrets",
        "baseName": "imagePullSecrets",
        "type": "Array<V1LocalObjectReference>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "secrets",
        "baseName": "secrets",
        "type": "Array<V1ObjectReference>"
    }
];
exports.V1ServiceAccount = V1ServiceAccount;
/**
* ServiceAccountList is a list of ServiceAccount objects
*/
class V1ServiceAccountList {
    static getAttributeTypeMap() {
        return V1ServiceAccountList.attributeTypeMap;
    }
}
V1ServiceAccountList.discriminator = undefined;
V1ServiceAccountList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1ServiceAccount>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ServiceAccountList = V1ServiceAccountList;
/**
* ServiceAccountTokenProjection represents a projected service account token volume. This projection can be used to insert a service account token into the pods runtime filesystem for use against APIs (Kubernetes API Server or otherwise).
*/
class V1ServiceAccountTokenProjection {
    static getAttributeTypeMap() {
        return V1ServiceAccountTokenProjection.attributeTypeMap;
    }
}
V1ServiceAccountTokenProjection.discriminator = undefined;
V1ServiceAccountTokenProjection.attributeTypeMap = [
    {
        "name": "audience",
        "baseName": "audience",
        "type": "string"
    },
    {
        "name": "expirationSeconds",
        "baseName": "expirationSeconds",
        "type": "number"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.V1ServiceAccountTokenProjection = V1ServiceAccountTokenProjection;
/**
* ServiceList holds a list of services.
*/
class V1ServiceList {
    static getAttributeTypeMap() {
        return V1ServiceList.attributeTypeMap;
    }
}
V1ServiceList.discriminator = undefined;
V1ServiceList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1Service>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1ServiceList = V1ServiceList;
/**
* ServicePort contains information on service's port.
*/
class V1ServicePort {
    static getAttributeTypeMap() {
        return V1ServicePort.attributeTypeMap;
    }
}
V1ServicePort.discriminator = undefined;
V1ServicePort.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "nodePort",
        "baseName": "nodePort",
        "type": "number"
    },
    {
        "name": "port",
        "baseName": "port",
        "type": "number"
    },
    {
        "name": "protocol",
        "baseName": "protocol",
        "type": "string"
    },
    {
        "name": "targetPort",
        "baseName": "targetPort",
        "type": "any"
    }
];
exports.V1ServicePort = V1ServicePort;
/**
* ServiceReference holds a reference to Service.legacy.k8s.io
*/
class V1ServiceReference {
    static getAttributeTypeMap() {
        return V1ServiceReference.attributeTypeMap;
    }
}
V1ServiceReference.discriminator = undefined;
V1ServiceReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1ServiceReference = V1ServiceReference;
/**
* ServiceSpec describes the attributes that a user creates on a service.
*/
class V1ServiceSpec {
    static getAttributeTypeMap() {
        return V1ServiceSpec.attributeTypeMap;
    }
}
V1ServiceSpec.discriminator = undefined;
V1ServiceSpec.attributeTypeMap = [
    {
        "name": "clusterIP",
        "baseName": "clusterIP",
        "type": "string"
    },
    {
        "name": "externalIPs",
        "baseName": "externalIPs",
        "type": "Array<string>"
    },
    {
        "name": "externalName",
        "baseName": "externalName",
        "type": "string"
    },
    {
        "name": "externalTrafficPolicy",
        "baseName": "externalTrafficPolicy",
        "type": "string"
    },
    {
        "name": "healthCheckNodePort",
        "baseName": "healthCheckNodePort",
        "type": "number"
    },
    {
        "name": "loadBalancerIP",
        "baseName": "loadBalancerIP",
        "type": "string"
    },
    {
        "name": "loadBalancerSourceRanges",
        "baseName": "loadBalancerSourceRanges",
        "type": "Array<string>"
    },
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1ServicePort>"
    },
    {
        "name": "publishNotReadyAddresses",
        "baseName": "publishNotReadyAddresses",
        "type": "boolean"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "sessionAffinity",
        "baseName": "sessionAffinity",
        "type": "string"
    },
    {
        "name": "sessionAffinityConfig",
        "baseName": "sessionAffinityConfig",
        "type": "V1SessionAffinityConfig"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1ServiceSpec = V1ServiceSpec;
/**
* ServiceStatus represents the current status of a service.
*/
class V1ServiceStatus {
    static getAttributeTypeMap() {
        return V1ServiceStatus.attributeTypeMap;
    }
}
V1ServiceStatus.discriminator = undefined;
V1ServiceStatus.attributeTypeMap = [
    {
        "name": "loadBalancer",
        "baseName": "loadBalancer",
        "type": "V1LoadBalancerStatus"
    }
];
exports.V1ServiceStatus = V1ServiceStatus;
/**
* SessionAffinityConfig represents the configurations of session affinity.
*/
class V1SessionAffinityConfig {
    static getAttributeTypeMap() {
        return V1SessionAffinityConfig.attributeTypeMap;
    }
}
V1SessionAffinityConfig.discriminator = undefined;
V1SessionAffinityConfig.attributeTypeMap = [
    {
        "name": "clientIP",
        "baseName": "clientIP",
        "type": "V1ClientIPConfig"
    }
];
exports.V1SessionAffinityConfig = V1SessionAffinityConfig;
/**
* StatefulSet represents a set of pods with consistent identities. Identities are defined as:  - Network: A single stable DNS and hostname.  - Storage: As many VolumeClaims as requested. The StatefulSet guarantees that a given network identity will always map to the same storage identity.
*/
class V1StatefulSet {
    static getAttributeTypeMap() {
        return V1StatefulSet.attributeTypeMap;
    }
}
V1StatefulSet.discriminator = undefined;
V1StatefulSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1StatefulSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1StatefulSetStatus"
    }
];
exports.V1StatefulSet = V1StatefulSet;
/**
* StatefulSetCondition describes the state of a statefulset at a certain point.
*/
class V1StatefulSetCondition {
    static getAttributeTypeMap() {
        return V1StatefulSetCondition.attributeTypeMap;
    }
}
V1StatefulSetCondition.discriminator = undefined;
V1StatefulSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1StatefulSetCondition = V1StatefulSetCondition;
/**
* StatefulSetList is a collection of StatefulSets.
*/
class V1StatefulSetList {
    static getAttributeTypeMap() {
        return V1StatefulSetList.attributeTypeMap;
    }
}
V1StatefulSetList.discriminator = undefined;
V1StatefulSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1StatefulSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1StatefulSetList = V1StatefulSetList;
/**
* A StatefulSetSpec is the specification of a StatefulSet.
*/
class V1StatefulSetSpec {
    static getAttributeTypeMap() {
        return V1StatefulSetSpec.attributeTypeMap;
    }
}
V1StatefulSetSpec.discriminator = undefined;
V1StatefulSetSpec.attributeTypeMap = [
    {
        "name": "podManagementPolicy",
        "baseName": "podManagementPolicy",
        "type": "string"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "serviceName",
        "baseName": "serviceName",
        "type": "string"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1StatefulSetUpdateStrategy"
    },
    {
        "name": "volumeClaimTemplates",
        "baseName": "volumeClaimTemplates",
        "type": "Array<V1PersistentVolumeClaim>"
    }
];
exports.V1StatefulSetSpec = V1StatefulSetSpec;
/**
* StatefulSetStatus represents the current state of a StatefulSet.
*/
class V1StatefulSetStatus {
    static getAttributeTypeMap() {
        return V1StatefulSetStatus.attributeTypeMap;
    }
}
V1StatefulSetStatus.discriminator = undefined;
V1StatefulSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1StatefulSetCondition>"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "currentRevision",
        "baseName": "currentRevision",
        "type": "string"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "updateRevision",
        "baseName": "updateRevision",
        "type": "string"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.V1StatefulSetStatus = V1StatefulSetStatus;
/**
* StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
*/
class V1StatefulSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1StatefulSetUpdateStrategy.attributeTypeMap;
    }
}
V1StatefulSetUpdateStrategy.discriminator = undefined;
V1StatefulSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1RollingUpdateStatefulSetStrategy"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1StatefulSetUpdateStrategy = V1StatefulSetUpdateStrategy;
/**
* Status is a return value for calls that don't return other objects.
*/
class V1Status {
    static getAttributeTypeMap() {
        return V1Status.attributeTypeMap;
    }
}
V1Status.discriminator = undefined;
V1Status.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "code",
        "baseName": "code",
        "type": "number"
    },
    {
        "name": "details",
        "baseName": "details",
        "type": "V1StatusDetails"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    }
];
exports.V1Status = V1Status;
/**
* StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.
*/
class V1StatusCause {
    static getAttributeTypeMap() {
        return V1StatusCause.attributeTypeMap;
    }
}
V1StatusCause.discriminator = undefined;
V1StatusCause.attributeTypeMap = [
    {
        "name": "field",
        "baseName": "field",
        "type": "string"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    }
];
exports.V1StatusCause = V1StatusCause;
/**
* StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.
*/
class V1StatusDetails {
    static getAttributeTypeMap() {
        return V1StatusDetails.attributeTypeMap;
    }
}
V1StatusDetails.discriminator = undefined;
V1StatusDetails.attributeTypeMap = [
    {
        "name": "causes",
        "baseName": "causes",
        "type": "Array<V1StatusCause>"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "retryAfterSeconds",
        "baseName": "retryAfterSeconds",
        "type": "number"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    }
];
exports.V1StatusDetails = V1StatusDetails;
/**
* StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
*/
class V1StorageClass {
    static getAttributeTypeMap() {
        return V1StorageClass.attributeTypeMap;
    }
}
V1StorageClass.discriminator = undefined;
V1StorageClass.attributeTypeMap = [
    {
        "name": "allowVolumeExpansion",
        "baseName": "allowVolumeExpansion",
        "type": "boolean"
    },
    {
        "name": "allowedTopologies",
        "baseName": "allowedTopologies",
        "type": "Array<V1TopologySelectorTerm>"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "mountOptions",
        "baseName": "mountOptions",
        "type": "Array<string>"
    },
    {
        "name": "parameters",
        "baseName": "parameters",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "provisioner",
        "baseName": "provisioner",
        "type": "string"
    },
    {
        "name": "reclaimPolicy",
        "baseName": "reclaimPolicy",
        "type": "string"
    },
    {
        "name": "volumeBindingMode",
        "baseName": "volumeBindingMode",
        "type": "string"
    }
];
exports.V1StorageClass = V1StorageClass;
/**
* StorageClassList is a collection of storage classes.
*/
class V1StorageClassList {
    static getAttributeTypeMap() {
        return V1StorageClassList.attributeTypeMap;
    }
}
V1StorageClassList.discriminator = undefined;
V1StorageClassList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1StorageClass>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1StorageClassList = V1StorageClassList;
/**
* Represents a StorageOS persistent volume resource.
*/
class V1StorageOSPersistentVolumeSource {
    static getAttributeTypeMap() {
        return V1StorageOSPersistentVolumeSource.attributeTypeMap;
    }
}
V1StorageOSPersistentVolumeSource.discriminator = undefined;
V1StorageOSPersistentVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1ObjectReference"
    },
    {
        "name": "volumeName",
        "baseName": "volumeName",
        "type": "string"
    },
    {
        "name": "volumeNamespace",
        "baseName": "volumeNamespace",
        "type": "string"
    }
];
exports.V1StorageOSPersistentVolumeSource = V1StorageOSPersistentVolumeSource;
/**
* Represents a StorageOS persistent volume resource.
*/
class V1StorageOSVolumeSource {
    static getAttributeTypeMap() {
        return V1StorageOSVolumeSource.attributeTypeMap;
    }
}
V1StorageOSVolumeSource.discriminator = undefined;
V1StorageOSVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "secretRef",
        "baseName": "secretRef",
        "type": "V1LocalObjectReference"
    },
    {
        "name": "volumeName",
        "baseName": "volumeName",
        "type": "string"
    },
    {
        "name": "volumeNamespace",
        "baseName": "volumeNamespace",
        "type": "string"
    }
];
exports.V1StorageOSVolumeSource = V1StorageOSVolumeSource;
/**
* Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.
*/
class V1Subject {
    static getAttributeTypeMap() {
        return V1Subject.attributeTypeMap;
    }
}
V1Subject.discriminator = undefined;
V1Subject.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1Subject = V1Subject;
/**
* SubjectAccessReview checks whether or not a user or group can perform an action.
*/
class V1SubjectAccessReview {
    static getAttributeTypeMap() {
        return V1SubjectAccessReview.attributeTypeMap;
    }
}
V1SubjectAccessReview.discriminator = undefined;
V1SubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1SubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1SubjectAccessReviewStatus"
    }
];
exports.V1SubjectAccessReview = V1SubjectAccessReview;
/**
* SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
*/
class V1SubjectAccessReviewSpec {
    static getAttributeTypeMap() {
        return V1SubjectAccessReviewSpec.attributeTypeMap;
    }
}
V1SubjectAccessReviewSpec.discriminator = undefined;
V1SubjectAccessReviewSpec.attributeTypeMap = [
    {
        "name": "extra",
        "baseName": "extra",
        "type": "{ [key: string]: Array<string>; }"
    },
    {
        "name": "groups",
        "baseName": "groups",
        "type": "Array<string>"
    },
    {
        "name": "nonResourceAttributes",
        "baseName": "nonResourceAttributes",
        "type": "V1NonResourceAttributes"
    },
    {
        "name": "resourceAttributes",
        "baseName": "resourceAttributes",
        "type": "V1ResourceAttributes"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1SubjectAccessReviewSpec = V1SubjectAccessReviewSpec;
/**
* SubjectAccessReviewStatus
*/
class V1SubjectAccessReviewStatus {
    static getAttributeTypeMap() {
        return V1SubjectAccessReviewStatus.attributeTypeMap;
    }
}
V1SubjectAccessReviewStatus.discriminator = undefined;
V1SubjectAccessReviewStatus.attributeTypeMap = [
    {
        "name": "allowed",
        "baseName": "allowed",
        "type": "boolean"
    },
    {
        "name": "denied",
        "baseName": "denied",
        "type": "boolean"
    },
    {
        "name": "evaluationError",
        "baseName": "evaluationError",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    }
];
exports.V1SubjectAccessReviewStatus = V1SubjectAccessReviewStatus;
/**
* SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.
*/
class V1SubjectRulesReviewStatus {
    static getAttributeTypeMap() {
        return V1SubjectRulesReviewStatus.attributeTypeMap;
    }
}
V1SubjectRulesReviewStatus.discriminator = undefined;
V1SubjectRulesReviewStatus.attributeTypeMap = [
    {
        "name": "evaluationError",
        "baseName": "evaluationError",
        "type": "string"
    },
    {
        "name": "incomplete",
        "baseName": "incomplete",
        "type": "boolean"
    },
    {
        "name": "nonResourceRules",
        "baseName": "nonResourceRules",
        "type": "Array<V1NonResourceRule>"
    },
    {
        "name": "resourceRules",
        "baseName": "resourceRules",
        "type": "Array<V1ResourceRule>"
    }
];
exports.V1SubjectRulesReviewStatus = V1SubjectRulesReviewStatus;
/**
* Sysctl defines a kernel parameter to be set
*/
class V1Sysctl {
    static getAttributeTypeMap() {
        return V1Sysctl.attributeTypeMap;
    }
}
V1Sysctl.discriminator = undefined;
V1Sysctl.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V1Sysctl = V1Sysctl;
/**
* TCPSocketAction describes an action based on opening a socket
*/
class V1TCPSocketAction {
    static getAttributeTypeMap() {
        return V1TCPSocketAction.attributeTypeMap;
    }
}
V1TCPSocketAction.discriminator = undefined;
V1TCPSocketAction.attributeTypeMap = [
    {
        "name": "host",
        "baseName": "host",
        "type": "string"
    },
    {
        "name": "port",
        "baseName": "port",
        "type": "any"
    }
];
exports.V1TCPSocketAction = V1TCPSocketAction;
/**
* The node this Taint is attached to has the \"effect\" on any pod that does not tolerate the Taint.
*/
class V1Taint {
    static getAttributeTypeMap() {
        return V1Taint.attributeTypeMap;
    }
}
V1Taint.discriminator = undefined;
V1Taint.attributeTypeMap = [
    {
        "name": "effect",
        "baseName": "effect",
        "type": "string"
    },
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "timeAdded",
        "baseName": "timeAdded",
        "type": "Date"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V1Taint = V1Taint;
/**
* TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
*/
class V1TokenReview {
    static getAttributeTypeMap() {
        return V1TokenReview.attributeTypeMap;
    }
}
V1TokenReview.discriminator = undefined;
V1TokenReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1TokenReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1TokenReviewStatus"
    }
];
exports.V1TokenReview = V1TokenReview;
/**
* TokenReviewSpec is a description of the token authentication request.
*/
class V1TokenReviewSpec {
    static getAttributeTypeMap() {
        return V1TokenReviewSpec.attributeTypeMap;
    }
}
V1TokenReviewSpec.discriminator = undefined;
V1TokenReviewSpec.attributeTypeMap = [
    {
        "name": "audiences",
        "baseName": "audiences",
        "type": "Array<string>"
    },
    {
        "name": "token",
        "baseName": "token",
        "type": "string"
    }
];
exports.V1TokenReviewSpec = V1TokenReviewSpec;
/**
* TokenReviewStatus is the result of the token authentication request.
*/
class V1TokenReviewStatus {
    static getAttributeTypeMap() {
        return V1TokenReviewStatus.attributeTypeMap;
    }
}
V1TokenReviewStatus.discriminator = undefined;
V1TokenReviewStatus.attributeTypeMap = [
    {
        "name": "audiences",
        "baseName": "audiences",
        "type": "Array<string>"
    },
    {
        "name": "authenticated",
        "baseName": "authenticated",
        "type": "boolean"
    },
    {
        "name": "error",
        "baseName": "error",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "V1UserInfo"
    }
];
exports.V1TokenReviewStatus = V1TokenReviewStatus;
/**
* The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
*/
class V1Toleration {
    static getAttributeTypeMap() {
        return V1Toleration.attributeTypeMap;
    }
}
V1Toleration.discriminator = undefined;
V1Toleration.attributeTypeMap = [
    {
        "name": "effect",
        "baseName": "effect",
        "type": "string"
    },
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "operator",
        "baseName": "operator",
        "type": "string"
    },
    {
        "name": "tolerationSeconds",
        "baseName": "tolerationSeconds",
        "type": "number"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V1Toleration = V1Toleration;
/**
* A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future.
*/
class V1TopologySelectorLabelRequirement {
    static getAttributeTypeMap() {
        return V1TopologySelectorLabelRequirement.attributeTypeMap;
    }
}
V1TopologySelectorLabelRequirement.discriminator = undefined;
V1TopologySelectorLabelRequirement.attributeTypeMap = [
    {
        "name": "key",
        "baseName": "key",
        "type": "string"
    },
    {
        "name": "values",
        "baseName": "values",
        "type": "Array<string>"
    }
];
exports.V1TopologySelectorLabelRequirement = V1TopologySelectorLabelRequirement;
/**
* A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future.
*/
class V1TopologySelectorTerm {
    static getAttributeTypeMap() {
        return V1TopologySelectorTerm.attributeTypeMap;
    }
}
V1TopologySelectorTerm.discriminator = undefined;
V1TopologySelectorTerm.attributeTypeMap = [
    {
        "name": "matchLabelExpressions",
        "baseName": "matchLabelExpressions",
        "type": "Array<V1TopologySelectorLabelRequirement>"
    }
];
exports.V1TopologySelectorTerm = V1TopologySelectorTerm;
/**
* TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace.
*/
class V1TypedLocalObjectReference {
    static getAttributeTypeMap() {
        return V1TypedLocalObjectReference.attributeTypeMap;
    }
}
V1TypedLocalObjectReference.discriminator = undefined;
V1TypedLocalObjectReference.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1TypedLocalObjectReference = V1TypedLocalObjectReference;
/**
* UserInfo holds the information about the user needed to implement the user.Info interface.
*/
class V1UserInfo {
    static getAttributeTypeMap() {
        return V1UserInfo.attributeTypeMap;
    }
}
V1UserInfo.discriminator = undefined;
V1UserInfo.attributeTypeMap = [
    {
        "name": "extra",
        "baseName": "extra",
        "type": "{ [key: string]: Array<string>; }"
    },
    {
        "name": "groups",
        "baseName": "groups",
        "type": "Array<string>"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    },
    {
        "name": "username",
        "baseName": "username",
        "type": "string"
    }
];
exports.V1UserInfo = V1UserInfo;
/**
* Volume represents a named volume in a pod that may be accessed by any container in the pod.
*/
class V1Volume {
    static getAttributeTypeMap() {
        return V1Volume.attributeTypeMap;
    }
}
V1Volume.discriminator = undefined;
V1Volume.attributeTypeMap = [
    {
        "name": "awsElasticBlockStore",
        "baseName": "awsElasticBlockStore",
        "type": "V1AWSElasticBlockStoreVolumeSource"
    },
    {
        "name": "azureDisk",
        "baseName": "azureDisk",
        "type": "V1AzureDiskVolumeSource"
    },
    {
        "name": "azureFile",
        "baseName": "azureFile",
        "type": "V1AzureFileVolumeSource"
    },
    {
        "name": "cephfs",
        "baseName": "cephfs",
        "type": "V1CephFSVolumeSource"
    },
    {
        "name": "cinder",
        "baseName": "cinder",
        "type": "V1CinderVolumeSource"
    },
    {
        "name": "configMap",
        "baseName": "configMap",
        "type": "V1ConfigMapVolumeSource"
    },
    {
        "name": "downwardAPI",
        "baseName": "downwardAPI",
        "type": "V1DownwardAPIVolumeSource"
    },
    {
        "name": "emptyDir",
        "baseName": "emptyDir",
        "type": "V1EmptyDirVolumeSource"
    },
    {
        "name": "fc",
        "baseName": "fc",
        "type": "V1FCVolumeSource"
    },
    {
        "name": "flexVolume",
        "baseName": "flexVolume",
        "type": "V1FlexVolumeSource"
    },
    {
        "name": "flocker",
        "baseName": "flocker",
        "type": "V1FlockerVolumeSource"
    },
    {
        "name": "gcePersistentDisk",
        "baseName": "gcePersistentDisk",
        "type": "V1GCEPersistentDiskVolumeSource"
    },
    {
        "name": "gitRepo",
        "baseName": "gitRepo",
        "type": "V1GitRepoVolumeSource"
    },
    {
        "name": "glusterfs",
        "baseName": "glusterfs",
        "type": "V1GlusterfsVolumeSource"
    },
    {
        "name": "hostPath",
        "baseName": "hostPath",
        "type": "V1HostPathVolumeSource"
    },
    {
        "name": "iscsi",
        "baseName": "iscsi",
        "type": "V1ISCSIVolumeSource"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "nfs",
        "baseName": "nfs",
        "type": "V1NFSVolumeSource"
    },
    {
        "name": "persistentVolumeClaim",
        "baseName": "persistentVolumeClaim",
        "type": "V1PersistentVolumeClaimVolumeSource"
    },
    {
        "name": "photonPersistentDisk",
        "baseName": "photonPersistentDisk",
        "type": "V1PhotonPersistentDiskVolumeSource"
    },
    {
        "name": "portworxVolume",
        "baseName": "portworxVolume",
        "type": "V1PortworxVolumeSource"
    },
    {
        "name": "projected",
        "baseName": "projected",
        "type": "V1ProjectedVolumeSource"
    },
    {
        "name": "quobyte",
        "baseName": "quobyte",
        "type": "V1QuobyteVolumeSource"
    },
    {
        "name": "rbd",
        "baseName": "rbd",
        "type": "V1RBDVolumeSource"
    },
    {
        "name": "scaleIO",
        "baseName": "scaleIO",
        "type": "V1ScaleIOVolumeSource"
    },
    {
        "name": "secret",
        "baseName": "secret",
        "type": "V1SecretVolumeSource"
    },
    {
        "name": "storageos",
        "baseName": "storageos",
        "type": "V1StorageOSVolumeSource"
    },
    {
        "name": "vsphereVolume",
        "baseName": "vsphereVolume",
        "type": "V1VsphereVirtualDiskVolumeSource"
    }
];
exports.V1Volume = V1Volume;
/**
* VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.  VolumeAttachment objects are non-namespaced.
*/
class V1VolumeAttachment {
    static getAttributeTypeMap() {
        return V1VolumeAttachment.attributeTypeMap;
    }
}
V1VolumeAttachment.discriminator = undefined;
V1VolumeAttachment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1VolumeAttachmentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1VolumeAttachmentStatus"
    }
];
exports.V1VolumeAttachment = V1VolumeAttachment;
/**
* VolumeAttachmentList is a collection of VolumeAttachment objects.
*/
class V1VolumeAttachmentList {
    static getAttributeTypeMap() {
        return V1VolumeAttachmentList.attributeTypeMap;
    }
}
V1VolumeAttachmentList.discriminator = undefined;
V1VolumeAttachmentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1VolumeAttachment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1VolumeAttachmentList = V1VolumeAttachmentList;
/**
* VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
*/
class V1VolumeAttachmentSource {
    static getAttributeTypeMap() {
        return V1VolumeAttachmentSource.attributeTypeMap;
    }
}
V1VolumeAttachmentSource.discriminator = undefined;
V1VolumeAttachmentSource.attributeTypeMap = [
    {
        "name": "persistentVolumeName",
        "baseName": "persistentVolumeName",
        "type": "string"
    }
];
exports.V1VolumeAttachmentSource = V1VolumeAttachmentSource;
/**
* VolumeAttachmentSpec is the specification of a VolumeAttachment request.
*/
class V1VolumeAttachmentSpec {
    static getAttributeTypeMap() {
        return V1VolumeAttachmentSpec.attributeTypeMap;
    }
}
V1VolumeAttachmentSpec.discriminator = undefined;
V1VolumeAttachmentSpec.attributeTypeMap = [
    {
        "name": "attacher",
        "baseName": "attacher",
        "type": "string"
    },
    {
        "name": "nodeName",
        "baseName": "nodeName",
        "type": "string"
    },
    {
        "name": "source",
        "baseName": "source",
        "type": "V1VolumeAttachmentSource"
    }
];
exports.V1VolumeAttachmentSpec = V1VolumeAttachmentSpec;
/**
* VolumeAttachmentStatus is the status of a VolumeAttachment request.
*/
class V1VolumeAttachmentStatus {
    static getAttributeTypeMap() {
        return V1VolumeAttachmentStatus.attributeTypeMap;
    }
}
V1VolumeAttachmentStatus.discriminator = undefined;
V1VolumeAttachmentStatus.attributeTypeMap = [
    {
        "name": "attachError",
        "baseName": "attachError",
        "type": "V1VolumeError"
    },
    {
        "name": "attached",
        "baseName": "attached",
        "type": "boolean"
    },
    {
        "name": "attachmentMetadata",
        "baseName": "attachmentMetadata",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "detachError",
        "baseName": "detachError",
        "type": "V1VolumeError"
    }
];
exports.V1VolumeAttachmentStatus = V1VolumeAttachmentStatus;
/**
* volumeDevice describes a mapping of a raw block device within a container.
*/
class V1VolumeDevice {
    static getAttributeTypeMap() {
        return V1VolumeDevice.attributeTypeMap;
    }
}
V1VolumeDevice.discriminator = undefined;
V1VolumeDevice.attributeTypeMap = [
    {
        "name": "devicePath",
        "baseName": "devicePath",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1VolumeDevice = V1VolumeDevice;
/**
* VolumeError captures an error encountered during a volume operation.
*/
class V1VolumeError {
    static getAttributeTypeMap() {
        return V1VolumeError.attributeTypeMap;
    }
}
V1VolumeError.discriminator = undefined;
V1VolumeError.attributeTypeMap = [
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "time",
        "baseName": "time",
        "type": "Date"
    }
];
exports.V1VolumeError = V1VolumeError;
/**
* VolumeMount describes a mounting of a Volume within a container.
*/
class V1VolumeMount {
    static getAttributeTypeMap() {
        return V1VolumeMount.attributeTypeMap;
    }
}
V1VolumeMount.discriminator = undefined;
V1VolumeMount.attributeTypeMap = [
    {
        "name": "mountPath",
        "baseName": "mountPath",
        "type": "string"
    },
    {
        "name": "mountPropagation",
        "baseName": "mountPropagation",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "readOnly",
        "baseName": "readOnly",
        "type": "boolean"
    },
    {
        "name": "subPath",
        "baseName": "subPath",
        "type": "string"
    }
];
exports.V1VolumeMount = V1VolumeMount;
/**
* VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
*/
class V1VolumeNodeAffinity {
    static getAttributeTypeMap() {
        return V1VolumeNodeAffinity.attributeTypeMap;
    }
}
V1VolumeNodeAffinity.discriminator = undefined;
V1VolumeNodeAffinity.attributeTypeMap = [
    {
        "name": "required",
        "baseName": "required",
        "type": "V1NodeSelector"
    }
];
exports.V1VolumeNodeAffinity = V1VolumeNodeAffinity;
/**
* Projection that may be projected along with other supported volume types
*/
class V1VolumeProjection {
    static getAttributeTypeMap() {
        return V1VolumeProjection.attributeTypeMap;
    }
}
V1VolumeProjection.discriminator = undefined;
V1VolumeProjection.attributeTypeMap = [
    {
        "name": "configMap",
        "baseName": "configMap",
        "type": "V1ConfigMapProjection"
    },
    {
        "name": "downwardAPI",
        "baseName": "downwardAPI",
        "type": "V1DownwardAPIProjection"
    },
    {
        "name": "secret",
        "baseName": "secret",
        "type": "V1SecretProjection"
    },
    {
        "name": "serviceAccountToken",
        "baseName": "serviceAccountToken",
        "type": "V1ServiceAccountTokenProjection"
    }
];
exports.V1VolumeProjection = V1VolumeProjection;
/**
* Represents a vSphere volume resource.
*/
class V1VsphereVirtualDiskVolumeSource {
    static getAttributeTypeMap() {
        return V1VsphereVirtualDiskVolumeSource.attributeTypeMap;
    }
}
V1VsphereVirtualDiskVolumeSource.discriminator = undefined;
V1VsphereVirtualDiskVolumeSource.attributeTypeMap = [
    {
        "name": "fsType",
        "baseName": "fsType",
        "type": "string"
    },
    {
        "name": "storagePolicyID",
        "baseName": "storagePolicyID",
        "type": "string"
    },
    {
        "name": "storagePolicyName",
        "baseName": "storagePolicyName",
        "type": "string"
    },
    {
        "name": "volumePath",
        "baseName": "volumePath",
        "type": "string"
    }
];
exports.V1VsphereVirtualDiskVolumeSource = V1VsphereVirtualDiskVolumeSource;
/**
* Event represents a single event to a watched resource.
*/
class V1WatchEvent {
    static getAttributeTypeMap() {
        return V1WatchEvent.attributeTypeMap;
    }
}
V1WatchEvent.discriminator = undefined;
V1WatchEvent.attributeTypeMap = [
    {
        "name": "object",
        "baseName": "object",
        "type": "RuntimeRawExtension"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1WatchEvent = V1WatchEvent;
/**
* The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
*/
class V1WeightedPodAffinityTerm {
    static getAttributeTypeMap() {
        return V1WeightedPodAffinityTerm.attributeTypeMap;
    }
}
V1WeightedPodAffinityTerm.discriminator = undefined;
V1WeightedPodAffinityTerm.attributeTypeMap = [
    {
        "name": "podAffinityTerm",
        "baseName": "podAffinityTerm",
        "type": "V1PodAffinityTerm"
    },
    {
        "name": "weight",
        "baseName": "weight",
        "type": "number"
    }
];
exports.V1WeightedPodAffinityTerm = V1WeightedPodAffinityTerm;
/**
* AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole
*/
class V1alpha1AggregationRule {
    static getAttributeTypeMap() {
        return V1alpha1AggregationRule.attributeTypeMap;
    }
}
V1alpha1AggregationRule.discriminator = undefined;
V1alpha1AggregationRule.attributeTypeMap = [
    {
        "name": "clusterRoleSelectors",
        "baseName": "clusterRoleSelectors",
        "type": "Array<V1LabelSelector>"
    }
];
exports.V1alpha1AggregationRule = V1alpha1AggregationRule;
/**
* AuditSink represents a cluster level audit sink
*/
class V1alpha1AuditSink {
    static getAttributeTypeMap() {
        return V1alpha1AuditSink.attributeTypeMap;
    }
}
V1alpha1AuditSink.discriminator = undefined;
V1alpha1AuditSink.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1alpha1AuditSinkSpec"
    }
];
exports.V1alpha1AuditSink = V1alpha1AuditSink;
/**
* AuditSinkList is a list of AuditSink items.
*/
class V1alpha1AuditSinkList {
    static getAttributeTypeMap() {
        return V1alpha1AuditSinkList.attributeTypeMap;
    }
}
V1alpha1AuditSinkList.discriminator = undefined;
V1alpha1AuditSinkList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1AuditSink>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1AuditSinkList = V1alpha1AuditSinkList;
/**
* AuditSinkSpec holds the spec for the audit sink
*/
class V1alpha1AuditSinkSpec {
    static getAttributeTypeMap() {
        return V1alpha1AuditSinkSpec.attributeTypeMap;
    }
}
V1alpha1AuditSinkSpec.discriminator = undefined;
V1alpha1AuditSinkSpec.attributeTypeMap = [
    {
        "name": "policy",
        "baseName": "policy",
        "type": "V1alpha1Policy"
    },
    {
        "name": "webhook",
        "baseName": "webhook",
        "type": "V1alpha1Webhook"
    }
];
exports.V1alpha1AuditSinkSpec = V1alpha1AuditSinkSpec;
/**
* ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
*/
class V1alpha1ClusterRole {
    static getAttributeTypeMap() {
        return V1alpha1ClusterRole.attributeTypeMap;
    }
}
V1alpha1ClusterRole.discriminator = undefined;
V1alpha1ClusterRole.attributeTypeMap = [
    {
        "name": "aggregationRule",
        "baseName": "aggregationRule",
        "type": "V1alpha1AggregationRule"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1alpha1PolicyRule>"
    }
];
exports.V1alpha1ClusterRole = V1alpha1ClusterRole;
/**
* ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.
*/
class V1alpha1ClusterRoleBinding {
    static getAttributeTypeMap() {
        return V1alpha1ClusterRoleBinding.attributeTypeMap;
    }
}
V1alpha1ClusterRoleBinding.discriminator = undefined;
V1alpha1ClusterRoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1alpha1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1alpha1Subject>"
    }
];
exports.V1alpha1ClusterRoleBinding = V1alpha1ClusterRoleBinding;
/**
* ClusterRoleBindingList is a collection of ClusterRoleBindings
*/
class V1alpha1ClusterRoleBindingList {
    static getAttributeTypeMap() {
        return V1alpha1ClusterRoleBindingList.attributeTypeMap;
    }
}
V1alpha1ClusterRoleBindingList.discriminator = undefined;
V1alpha1ClusterRoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1ClusterRoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1ClusterRoleBindingList = V1alpha1ClusterRoleBindingList;
/**
* ClusterRoleList is a collection of ClusterRoles
*/
class V1alpha1ClusterRoleList {
    static getAttributeTypeMap() {
        return V1alpha1ClusterRoleList.attributeTypeMap;
    }
}
V1alpha1ClusterRoleList.discriminator = undefined;
V1alpha1ClusterRoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1ClusterRole>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1ClusterRoleList = V1alpha1ClusterRoleList;
/**
* Initializer describes the name and the failure policy of an initializer, and what resources it applies to.
*/
class V1alpha1Initializer {
    static getAttributeTypeMap() {
        return V1alpha1Initializer.attributeTypeMap;
    }
}
V1alpha1Initializer.discriminator = undefined;
V1alpha1Initializer.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1alpha1Rule>"
    }
];
exports.V1alpha1Initializer = V1alpha1Initializer;
/**
* InitializerConfiguration describes the configuration of initializers.
*/
class V1alpha1InitializerConfiguration {
    static getAttributeTypeMap() {
        return V1alpha1InitializerConfiguration.attributeTypeMap;
    }
}
V1alpha1InitializerConfiguration.discriminator = undefined;
V1alpha1InitializerConfiguration.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "initializers",
        "baseName": "initializers",
        "type": "Array<V1alpha1Initializer>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    }
];
exports.V1alpha1InitializerConfiguration = V1alpha1InitializerConfiguration;
/**
* InitializerConfigurationList is a list of InitializerConfiguration.
*/
class V1alpha1InitializerConfigurationList {
    static getAttributeTypeMap() {
        return V1alpha1InitializerConfigurationList.attributeTypeMap;
    }
}
V1alpha1InitializerConfigurationList.discriminator = undefined;
V1alpha1InitializerConfigurationList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1InitializerConfiguration>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1InitializerConfigurationList = V1alpha1InitializerConfigurationList;
/**
* PodPreset is a policy resource that defines additional runtime requirements for a Pod.
*/
class V1alpha1PodPreset {
    static getAttributeTypeMap() {
        return V1alpha1PodPreset.attributeTypeMap;
    }
}
V1alpha1PodPreset.discriminator = undefined;
V1alpha1PodPreset.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1alpha1PodPresetSpec"
    }
];
exports.V1alpha1PodPreset = V1alpha1PodPreset;
/**
* PodPresetList is a list of PodPreset objects.
*/
class V1alpha1PodPresetList {
    static getAttributeTypeMap() {
        return V1alpha1PodPresetList.attributeTypeMap;
    }
}
V1alpha1PodPresetList.discriminator = undefined;
V1alpha1PodPresetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1PodPreset>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1PodPresetList = V1alpha1PodPresetList;
/**
* PodPresetSpec is a description of a pod preset.
*/
class V1alpha1PodPresetSpec {
    static getAttributeTypeMap() {
        return V1alpha1PodPresetSpec.attributeTypeMap;
    }
}
V1alpha1PodPresetSpec.discriminator = undefined;
V1alpha1PodPresetSpec.attributeTypeMap = [
    {
        "name": "env",
        "baseName": "env",
        "type": "Array<V1EnvVar>"
    },
    {
        "name": "envFrom",
        "baseName": "envFrom",
        "type": "Array<V1EnvFromSource>"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "volumeMounts",
        "baseName": "volumeMounts",
        "type": "Array<V1VolumeMount>"
    },
    {
        "name": "volumes",
        "baseName": "volumes",
        "type": "Array<V1Volume>"
    }
];
exports.V1alpha1PodPresetSpec = V1alpha1PodPresetSpec;
/**
* Policy defines the configuration of how audit events are logged
*/
class V1alpha1Policy {
    static getAttributeTypeMap() {
        return V1alpha1Policy.attributeTypeMap;
    }
}
V1alpha1Policy.discriminator = undefined;
V1alpha1Policy.attributeTypeMap = [
    {
        "name": "level",
        "baseName": "level",
        "type": "string"
    },
    {
        "name": "stages",
        "baseName": "stages",
        "type": "Array<string>"
    }
];
exports.V1alpha1Policy = V1alpha1Policy;
/**
* PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
*/
class V1alpha1PolicyRule {
    static getAttributeTypeMap() {
        return V1alpha1PolicyRule.attributeTypeMap;
    }
}
V1alpha1PolicyRule.discriminator = undefined;
V1alpha1PolicyRule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "nonResourceURLs",
        "baseName": "nonResourceURLs",
        "type": "Array<string>"
    },
    {
        "name": "resourceNames",
        "baseName": "resourceNames",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1alpha1PolicyRule = V1alpha1PolicyRule;
/**
* PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
*/
class V1alpha1PriorityClass {
    static getAttributeTypeMap() {
        return V1alpha1PriorityClass.attributeTypeMap;
    }
}
V1alpha1PriorityClass.discriminator = undefined;
V1alpha1PriorityClass.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "description",
        "baseName": "description",
        "type": "string"
    },
    {
        "name": "globalDefault",
        "baseName": "globalDefault",
        "type": "boolean"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "number"
    }
];
exports.V1alpha1PriorityClass = V1alpha1PriorityClass;
/**
* PriorityClassList is a collection of priority classes.
*/
class V1alpha1PriorityClassList {
    static getAttributeTypeMap() {
        return V1alpha1PriorityClassList.attributeTypeMap;
    }
}
V1alpha1PriorityClassList.discriminator = undefined;
V1alpha1PriorityClassList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1PriorityClass>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1PriorityClassList = V1alpha1PriorityClassList;
/**
* Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
*/
class V1alpha1Role {
    static getAttributeTypeMap() {
        return V1alpha1Role.attributeTypeMap;
    }
}
V1alpha1Role.discriminator = undefined;
V1alpha1Role.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1alpha1PolicyRule>"
    }
];
exports.V1alpha1Role = V1alpha1Role;
/**
* RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.
*/
class V1alpha1RoleBinding {
    static getAttributeTypeMap() {
        return V1alpha1RoleBinding.attributeTypeMap;
    }
}
V1alpha1RoleBinding.discriminator = undefined;
V1alpha1RoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1alpha1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1alpha1Subject>"
    }
];
exports.V1alpha1RoleBinding = V1alpha1RoleBinding;
/**
* RoleBindingList is a collection of RoleBindings
*/
class V1alpha1RoleBindingList {
    static getAttributeTypeMap() {
        return V1alpha1RoleBindingList.attributeTypeMap;
    }
}
V1alpha1RoleBindingList.discriminator = undefined;
V1alpha1RoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1RoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1RoleBindingList = V1alpha1RoleBindingList;
/**
* RoleList is a collection of Roles
*/
class V1alpha1RoleList {
    static getAttributeTypeMap() {
        return V1alpha1RoleList.attributeTypeMap;
    }
}
V1alpha1RoleList.discriminator = undefined;
V1alpha1RoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1Role>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1RoleList = V1alpha1RoleList;
/**
* RoleRef contains information that points to the role being used
*/
class V1alpha1RoleRef {
    static getAttributeTypeMap() {
        return V1alpha1RoleRef.attributeTypeMap;
    }
}
V1alpha1RoleRef.discriminator = undefined;
V1alpha1RoleRef.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1alpha1RoleRef = V1alpha1RoleRef;
/**
* Rule is a tuple of APIGroups, APIVersion, and Resources.It is recommended to make sure that all the tuple expansions are valid.
*/
class V1alpha1Rule {
    static getAttributeTypeMap() {
        return V1alpha1Rule.attributeTypeMap;
    }
}
V1alpha1Rule.discriminator = undefined;
V1alpha1Rule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "apiVersions",
        "baseName": "apiVersions",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    }
];
exports.V1alpha1Rule = V1alpha1Rule;
/**
* ServiceReference holds a reference to Service.legacy.k8s.io
*/
class V1alpha1ServiceReference {
    static getAttributeTypeMap() {
        return V1alpha1ServiceReference.attributeTypeMap;
    }
}
V1alpha1ServiceReference.discriminator = undefined;
V1alpha1ServiceReference.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.V1alpha1ServiceReference = V1alpha1ServiceReference;
/**
* Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.
*/
class V1alpha1Subject {
    static getAttributeTypeMap() {
        return V1alpha1Subject.attributeTypeMap;
    }
}
V1alpha1Subject.discriminator = undefined;
V1alpha1Subject.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1alpha1Subject = V1alpha1Subject;
/**
* VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.  VolumeAttachment objects are non-namespaced.
*/
class V1alpha1VolumeAttachment {
    static getAttributeTypeMap() {
        return V1alpha1VolumeAttachment.attributeTypeMap;
    }
}
V1alpha1VolumeAttachment.discriminator = undefined;
V1alpha1VolumeAttachment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1alpha1VolumeAttachmentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1alpha1VolumeAttachmentStatus"
    }
];
exports.V1alpha1VolumeAttachment = V1alpha1VolumeAttachment;
/**
* VolumeAttachmentList is a collection of VolumeAttachment objects.
*/
class V1alpha1VolumeAttachmentList {
    static getAttributeTypeMap() {
        return V1alpha1VolumeAttachmentList.attributeTypeMap;
    }
}
V1alpha1VolumeAttachmentList.discriminator = undefined;
V1alpha1VolumeAttachmentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1alpha1VolumeAttachment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1alpha1VolumeAttachmentList = V1alpha1VolumeAttachmentList;
/**
* VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
*/
class V1alpha1VolumeAttachmentSource {
    static getAttributeTypeMap() {
        return V1alpha1VolumeAttachmentSource.attributeTypeMap;
    }
}
V1alpha1VolumeAttachmentSource.discriminator = undefined;
V1alpha1VolumeAttachmentSource.attributeTypeMap = [
    {
        "name": "persistentVolumeName",
        "baseName": "persistentVolumeName",
        "type": "string"
    }
];
exports.V1alpha1VolumeAttachmentSource = V1alpha1VolumeAttachmentSource;
/**
* VolumeAttachmentSpec is the specification of a VolumeAttachment request.
*/
class V1alpha1VolumeAttachmentSpec {
    static getAttributeTypeMap() {
        return V1alpha1VolumeAttachmentSpec.attributeTypeMap;
    }
}
V1alpha1VolumeAttachmentSpec.discriminator = undefined;
V1alpha1VolumeAttachmentSpec.attributeTypeMap = [
    {
        "name": "attacher",
        "baseName": "attacher",
        "type": "string"
    },
    {
        "name": "nodeName",
        "baseName": "nodeName",
        "type": "string"
    },
    {
        "name": "source",
        "baseName": "source",
        "type": "V1alpha1VolumeAttachmentSource"
    }
];
exports.V1alpha1VolumeAttachmentSpec = V1alpha1VolumeAttachmentSpec;
/**
* VolumeAttachmentStatus is the status of a VolumeAttachment request.
*/
class V1alpha1VolumeAttachmentStatus {
    static getAttributeTypeMap() {
        return V1alpha1VolumeAttachmentStatus.attributeTypeMap;
    }
}
V1alpha1VolumeAttachmentStatus.discriminator = undefined;
V1alpha1VolumeAttachmentStatus.attributeTypeMap = [
    {
        "name": "attachError",
        "baseName": "attachError",
        "type": "V1alpha1VolumeError"
    },
    {
        "name": "attached",
        "baseName": "attached",
        "type": "boolean"
    },
    {
        "name": "attachmentMetadata",
        "baseName": "attachmentMetadata",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "detachError",
        "baseName": "detachError",
        "type": "V1alpha1VolumeError"
    }
];
exports.V1alpha1VolumeAttachmentStatus = V1alpha1VolumeAttachmentStatus;
/**
* VolumeError captures an error encountered during a volume operation.
*/
class V1alpha1VolumeError {
    static getAttributeTypeMap() {
        return V1alpha1VolumeError.attributeTypeMap;
    }
}
V1alpha1VolumeError.discriminator = undefined;
V1alpha1VolumeError.attributeTypeMap = [
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "time",
        "baseName": "time",
        "type": "Date"
    }
];
exports.V1alpha1VolumeError = V1alpha1VolumeError;
/**
* Webhook holds the configuration of the webhook
*/
class V1alpha1Webhook {
    static getAttributeTypeMap() {
        return V1alpha1Webhook.attributeTypeMap;
    }
}
V1alpha1Webhook.discriminator = undefined;
V1alpha1Webhook.attributeTypeMap = [
    {
        "name": "clientConfig",
        "baseName": "clientConfig",
        "type": "V1alpha1WebhookClientConfig"
    },
    {
        "name": "throttle",
        "baseName": "throttle",
        "type": "V1alpha1WebhookThrottleConfig"
    }
];
exports.V1alpha1Webhook = V1alpha1Webhook;
/**
* WebhookClientConfig contains the information to make a connection with the webhook
*/
class V1alpha1WebhookClientConfig {
    static getAttributeTypeMap() {
        return V1alpha1WebhookClientConfig.attributeTypeMap;
    }
}
V1alpha1WebhookClientConfig.discriminator = undefined;
V1alpha1WebhookClientConfig.attributeTypeMap = [
    {
        "name": "caBundle",
        "baseName": "caBundle",
        "type": "string"
    },
    {
        "name": "service",
        "baseName": "service",
        "type": "V1alpha1ServiceReference"
    },
    {
        "name": "url",
        "baseName": "url",
        "type": "string"
    }
];
exports.V1alpha1WebhookClientConfig = V1alpha1WebhookClientConfig;
/**
* WebhookThrottleConfig holds the configuration for throttling events
*/
class V1alpha1WebhookThrottleConfig {
    static getAttributeTypeMap() {
        return V1alpha1WebhookThrottleConfig.attributeTypeMap;
    }
}
V1alpha1WebhookThrottleConfig.discriminator = undefined;
V1alpha1WebhookThrottleConfig.attributeTypeMap = [
    {
        "name": "burst",
        "baseName": "burst",
        "type": "number"
    },
    {
        "name": "qps",
        "baseName": "qps",
        "type": "number"
    }
];
exports.V1alpha1WebhookThrottleConfig = V1alpha1WebhookThrottleConfig;
/**
* APIService represents a server for a particular GroupVersion. Name must be \"version.group\".
*/
class V1beta1APIService {
    static getAttributeTypeMap() {
        return V1beta1APIService.attributeTypeMap;
    }
}
V1beta1APIService.discriminator = undefined;
V1beta1APIService.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1APIServiceSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1APIServiceStatus"
    }
];
exports.V1beta1APIService = V1beta1APIService;
class V1beta1APIServiceCondition {
    static getAttributeTypeMap() {
        return V1beta1APIServiceCondition.attributeTypeMap;
    }
}
V1beta1APIServiceCondition.discriminator = undefined;
V1beta1APIServiceCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1APIServiceCondition = V1beta1APIServiceCondition;
/**
* APIServiceList is a list of APIService objects.
*/
class V1beta1APIServiceList {
    static getAttributeTypeMap() {
        return V1beta1APIServiceList.attributeTypeMap;
    }
}
V1beta1APIServiceList.discriminator = undefined;
V1beta1APIServiceList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1APIService>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1APIServiceList = V1beta1APIServiceList;
/**
* APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification.
*/
class V1beta1APIServiceSpec {
    static getAttributeTypeMap() {
        return V1beta1APIServiceSpec.attributeTypeMap;
    }
}
V1beta1APIServiceSpec.discriminator = undefined;
V1beta1APIServiceSpec.attributeTypeMap = [
    {
        "name": "caBundle",
        "baseName": "caBundle",
        "type": "string"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "groupPriorityMinimum",
        "baseName": "groupPriorityMinimum",
        "type": "number"
    },
    {
        "name": "insecureSkipTLSVerify",
        "baseName": "insecureSkipTLSVerify",
        "type": "boolean"
    },
    {
        "name": "service",
        "baseName": "service",
        "type": "ApiregistrationV1beta1ServiceReference"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    },
    {
        "name": "versionPriority",
        "baseName": "versionPriority",
        "type": "number"
    }
];
exports.V1beta1APIServiceSpec = V1beta1APIServiceSpec;
/**
* APIServiceStatus contains derived information about an API server
*/
class V1beta1APIServiceStatus {
    static getAttributeTypeMap() {
        return V1beta1APIServiceStatus.attributeTypeMap;
    }
}
V1beta1APIServiceStatus.discriminator = undefined;
V1beta1APIServiceStatus.attributeTypeMap = [
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1APIServiceCondition>"
    }
];
exports.V1beta1APIServiceStatus = V1beta1APIServiceStatus;
/**
* AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole
*/
class V1beta1AggregationRule {
    static getAttributeTypeMap() {
        return V1beta1AggregationRule.attributeTypeMap;
    }
}
V1beta1AggregationRule.discriminator = undefined;
V1beta1AggregationRule.attributeTypeMap = [
    {
        "name": "clusterRoleSelectors",
        "baseName": "clusterRoleSelectors",
        "type": "Array<V1LabelSelector>"
    }
];
exports.V1beta1AggregationRule = V1beta1AggregationRule;
/**
* Describes a certificate signing request
*/
class V1beta1CertificateSigningRequest {
    static getAttributeTypeMap() {
        return V1beta1CertificateSigningRequest.attributeTypeMap;
    }
}
V1beta1CertificateSigningRequest.discriminator = undefined;
V1beta1CertificateSigningRequest.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1CertificateSigningRequestSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1CertificateSigningRequestStatus"
    }
];
exports.V1beta1CertificateSigningRequest = V1beta1CertificateSigningRequest;
class V1beta1CertificateSigningRequestCondition {
    static getAttributeTypeMap() {
        return V1beta1CertificateSigningRequestCondition.attributeTypeMap;
    }
}
V1beta1CertificateSigningRequestCondition.discriminator = undefined;
V1beta1CertificateSigningRequestCondition.attributeTypeMap = [
    {
        "name": "lastUpdateTime",
        "baseName": "lastUpdateTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1CertificateSigningRequestCondition = V1beta1CertificateSigningRequestCondition;
class V1beta1CertificateSigningRequestList {
    static getAttributeTypeMap() {
        return V1beta1CertificateSigningRequestList.attributeTypeMap;
    }
}
V1beta1CertificateSigningRequestList.discriminator = undefined;
V1beta1CertificateSigningRequestList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1CertificateSigningRequest>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1CertificateSigningRequestList = V1beta1CertificateSigningRequestList;
/**
* This information is immutable after the request is created. Only the Request and Usages fields can be set on creation, other fields are derived by Kubernetes and cannot be modified by users.
*/
class V1beta1CertificateSigningRequestSpec {
    static getAttributeTypeMap() {
        return V1beta1CertificateSigningRequestSpec.attributeTypeMap;
    }
}
V1beta1CertificateSigningRequestSpec.discriminator = undefined;
V1beta1CertificateSigningRequestSpec.attributeTypeMap = [
    {
        "name": "extra",
        "baseName": "extra",
        "type": "{ [key: string]: Array<string>; }"
    },
    {
        "name": "groups",
        "baseName": "groups",
        "type": "Array<string>"
    },
    {
        "name": "request",
        "baseName": "request",
        "type": "string"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    },
    {
        "name": "usages",
        "baseName": "usages",
        "type": "Array<string>"
    },
    {
        "name": "username",
        "baseName": "username",
        "type": "string"
    }
];
exports.V1beta1CertificateSigningRequestSpec = V1beta1CertificateSigningRequestSpec;
class V1beta1CertificateSigningRequestStatus {
    static getAttributeTypeMap() {
        return V1beta1CertificateSigningRequestStatus.attributeTypeMap;
    }
}
V1beta1CertificateSigningRequestStatus.discriminator = undefined;
V1beta1CertificateSigningRequestStatus.attributeTypeMap = [
    {
        "name": "certificate",
        "baseName": "certificate",
        "type": "string"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1CertificateSigningRequestCondition>"
    }
];
exports.V1beta1CertificateSigningRequestStatus = V1beta1CertificateSigningRequestStatus;
/**
* ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.
*/
class V1beta1ClusterRole {
    static getAttributeTypeMap() {
        return V1beta1ClusterRole.attributeTypeMap;
    }
}
V1beta1ClusterRole.discriminator = undefined;
V1beta1ClusterRole.attributeTypeMap = [
    {
        "name": "aggregationRule",
        "baseName": "aggregationRule",
        "type": "V1beta1AggregationRule"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1beta1PolicyRule>"
    }
];
exports.V1beta1ClusterRole = V1beta1ClusterRole;
/**
* ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.
*/
class V1beta1ClusterRoleBinding {
    static getAttributeTypeMap() {
        return V1beta1ClusterRoleBinding.attributeTypeMap;
    }
}
V1beta1ClusterRoleBinding.discriminator = undefined;
V1beta1ClusterRoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1beta1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1beta1Subject>"
    }
];
exports.V1beta1ClusterRoleBinding = V1beta1ClusterRoleBinding;
/**
* ClusterRoleBindingList is a collection of ClusterRoleBindings
*/
class V1beta1ClusterRoleBindingList {
    static getAttributeTypeMap() {
        return V1beta1ClusterRoleBindingList.attributeTypeMap;
    }
}
V1beta1ClusterRoleBindingList.discriminator = undefined;
V1beta1ClusterRoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1ClusterRoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1ClusterRoleBindingList = V1beta1ClusterRoleBindingList;
/**
* ClusterRoleList is a collection of ClusterRoles
*/
class V1beta1ClusterRoleList {
    static getAttributeTypeMap() {
        return V1beta1ClusterRoleList.attributeTypeMap;
    }
}
V1beta1ClusterRoleList.discriminator = undefined;
V1beta1ClusterRoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1ClusterRole>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1ClusterRoleList = V1beta1ClusterRoleList;
/**
* DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
*/
class V1beta1ControllerRevision {
    static getAttributeTypeMap() {
        return V1beta1ControllerRevision.attributeTypeMap;
    }
}
V1beta1ControllerRevision.discriminator = undefined;
V1beta1ControllerRevision.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "data",
        "baseName": "data",
        "type": "RuntimeRawExtension"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "revision",
        "baseName": "revision",
        "type": "number"
    }
];
exports.V1beta1ControllerRevision = V1beta1ControllerRevision;
/**
* ControllerRevisionList is a resource containing a list of ControllerRevision objects.
*/
class V1beta1ControllerRevisionList {
    static getAttributeTypeMap() {
        return V1beta1ControllerRevisionList.attributeTypeMap;
    }
}
V1beta1ControllerRevisionList.discriminator = undefined;
V1beta1ControllerRevisionList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1ControllerRevision>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1ControllerRevisionList = V1beta1ControllerRevisionList;
/**
* CronJob represents the configuration of a single cron job.
*/
class V1beta1CronJob {
    static getAttributeTypeMap() {
        return V1beta1CronJob.attributeTypeMap;
    }
}
V1beta1CronJob.discriminator = undefined;
V1beta1CronJob.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1CronJobSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1CronJobStatus"
    }
];
exports.V1beta1CronJob = V1beta1CronJob;
/**
* CronJobList is a collection of cron jobs.
*/
class V1beta1CronJobList {
    static getAttributeTypeMap() {
        return V1beta1CronJobList.attributeTypeMap;
    }
}
V1beta1CronJobList.discriminator = undefined;
V1beta1CronJobList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1CronJob>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1CronJobList = V1beta1CronJobList;
/**
* CronJobSpec describes how the job execution will look like and when it will actually run.
*/
class V1beta1CronJobSpec {
    static getAttributeTypeMap() {
        return V1beta1CronJobSpec.attributeTypeMap;
    }
}
V1beta1CronJobSpec.discriminator = undefined;
V1beta1CronJobSpec.attributeTypeMap = [
    {
        "name": "concurrencyPolicy",
        "baseName": "concurrencyPolicy",
        "type": "string"
    },
    {
        "name": "failedJobsHistoryLimit",
        "baseName": "failedJobsHistoryLimit",
        "type": "number"
    },
    {
        "name": "jobTemplate",
        "baseName": "jobTemplate",
        "type": "V1beta1JobTemplateSpec"
    },
    {
        "name": "schedule",
        "baseName": "schedule",
        "type": "string"
    },
    {
        "name": "startingDeadlineSeconds",
        "baseName": "startingDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "successfulJobsHistoryLimit",
        "baseName": "successfulJobsHistoryLimit",
        "type": "number"
    },
    {
        "name": "suspend",
        "baseName": "suspend",
        "type": "boolean"
    }
];
exports.V1beta1CronJobSpec = V1beta1CronJobSpec;
/**
* CronJobStatus represents the current state of a cron job.
*/
class V1beta1CronJobStatus {
    static getAttributeTypeMap() {
        return V1beta1CronJobStatus.attributeTypeMap;
    }
}
V1beta1CronJobStatus.discriminator = undefined;
V1beta1CronJobStatus.attributeTypeMap = [
    {
        "name": "active",
        "baseName": "active",
        "type": "Array<V1ObjectReference>"
    },
    {
        "name": "lastScheduleTime",
        "baseName": "lastScheduleTime",
        "type": "Date"
    }
];
exports.V1beta1CronJobStatus = V1beta1CronJobStatus;
/**
* CustomResourceColumnDefinition specifies a column for server side printing.
*/
class V1beta1CustomResourceColumnDefinition {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceColumnDefinition.attributeTypeMap;
    }
}
V1beta1CustomResourceColumnDefinition.discriminator = undefined;
V1beta1CustomResourceColumnDefinition.attributeTypeMap = [
    {
        "name": "jSONPath",
        "baseName": "JSONPath",
        "type": "string"
    },
    {
        "name": "description",
        "baseName": "description",
        "type": "string"
    },
    {
        "name": "format",
        "baseName": "format",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "priority",
        "baseName": "priority",
        "type": "number"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1CustomResourceColumnDefinition = V1beta1CustomResourceColumnDefinition;
/**
* CustomResourceConversion describes how to convert different versions of a CR.
*/
class V1beta1CustomResourceConversion {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceConversion.attributeTypeMap;
    }
}
V1beta1CustomResourceConversion.discriminator = undefined;
V1beta1CustomResourceConversion.attributeTypeMap = [
    {
        "name": "strategy",
        "baseName": "strategy",
        "type": "string"
    },
    {
        "name": "webhookClientConfig",
        "baseName": "webhookClientConfig",
        "type": "ApiextensionsV1beta1WebhookClientConfig"
    }
];
exports.V1beta1CustomResourceConversion = V1beta1CustomResourceConversion;
/**
* CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>.
*/
class V1beta1CustomResourceDefinition {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinition.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinition.discriminator = undefined;
V1beta1CustomResourceDefinition.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1CustomResourceDefinitionSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1CustomResourceDefinitionStatus"
    }
];
exports.V1beta1CustomResourceDefinition = V1beta1CustomResourceDefinition;
/**
* CustomResourceDefinitionCondition contains details for the current condition of this pod.
*/
class V1beta1CustomResourceDefinitionCondition {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionCondition.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionCondition.discriminator = undefined;
V1beta1CustomResourceDefinitionCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1CustomResourceDefinitionCondition = V1beta1CustomResourceDefinitionCondition;
/**
* CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
*/
class V1beta1CustomResourceDefinitionList {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionList.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionList.discriminator = undefined;
V1beta1CustomResourceDefinitionList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1CustomResourceDefinition>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1CustomResourceDefinitionList = V1beta1CustomResourceDefinitionList;
/**
* CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
*/
class V1beta1CustomResourceDefinitionNames {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionNames.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionNames.discriminator = undefined;
V1beta1CustomResourceDefinitionNames.attributeTypeMap = [
    {
        "name": "categories",
        "baseName": "categories",
        "type": "Array<string>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "listKind",
        "baseName": "listKind",
        "type": "string"
    },
    {
        "name": "plural",
        "baseName": "plural",
        "type": "string"
    },
    {
        "name": "shortNames",
        "baseName": "shortNames",
        "type": "Array<string>"
    },
    {
        "name": "singular",
        "baseName": "singular",
        "type": "string"
    }
];
exports.V1beta1CustomResourceDefinitionNames = V1beta1CustomResourceDefinitionNames;
/**
* CustomResourceDefinitionSpec describes how a user wants their resource to appear
*/
class V1beta1CustomResourceDefinitionSpec {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionSpec.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionSpec.discriminator = undefined;
V1beta1CustomResourceDefinitionSpec.attributeTypeMap = [
    {
        "name": "additionalPrinterColumns",
        "baseName": "additionalPrinterColumns",
        "type": "Array<V1beta1CustomResourceColumnDefinition>"
    },
    {
        "name": "conversion",
        "baseName": "conversion",
        "type": "V1beta1CustomResourceConversion"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "names",
        "baseName": "names",
        "type": "V1beta1CustomResourceDefinitionNames"
    },
    {
        "name": "scope",
        "baseName": "scope",
        "type": "string"
    },
    {
        "name": "subresources",
        "baseName": "subresources",
        "type": "V1beta1CustomResourceSubresources"
    },
    {
        "name": "validation",
        "baseName": "validation",
        "type": "V1beta1CustomResourceValidation"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    },
    {
        "name": "versions",
        "baseName": "versions",
        "type": "Array<V1beta1CustomResourceDefinitionVersion>"
    }
];
exports.V1beta1CustomResourceDefinitionSpec = V1beta1CustomResourceDefinitionSpec;
/**
* CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
*/
class V1beta1CustomResourceDefinitionStatus {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionStatus.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionStatus.discriminator = undefined;
V1beta1CustomResourceDefinitionStatus.attributeTypeMap = [
    {
        "name": "acceptedNames",
        "baseName": "acceptedNames",
        "type": "V1beta1CustomResourceDefinitionNames"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1CustomResourceDefinitionCondition>"
    },
    {
        "name": "storedVersions",
        "baseName": "storedVersions",
        "type": "Array<string>"
    }
];
exports.V1beta1CustomResourceDefinitionStatus = V1beta1CustomResourceDefinitionStatus;
/**
* CustomResourceDefinitionVersion describes a version for CRD.
*/
class V1beta1CustomResourceDefinitionVersion {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceDefinitionVersion.attributeTypeMap;
    }
}
V1beta1CustomResourceDefinitionVersion.discriminator = undefined;
V1beta1CustomResourceDefinitionVersion.attributeTypeMap = [
    {
        "name": "additionalPrinterColumns",
        "baseName": "additionalPrinterColumns",
        "type": "Array<V1beta1CustomResourceColumnDefinition>"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "schema",
        "baseName": "schema",
        "type": "V1beta1CustomResourceValidation"
    },
    {
        "name": "served",
        "baseName": "served",
        "type": "boolean"
    },
    {
        "name": "storage",
        "baseName": "storage",
        "type": "boolean"
    },
    {
        "name": "subresources",
        "baseName": "subresources",
        "type": "V1beta1CustomResourceSubresources"
    }
];
exports.V1beta1CustomResourceDefinitionVersion = V1beta1CustomResourceDefinitionVersion;
/**
* CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
*/
class V1beta1CustomResourceSubresourceScale {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceSubresourceScale.attributeTypeMap;
    }
}
V1beta1CustomResourceSubresourceScale.discriminator = undefined;
V1beta1CustomResourceSubresourceScale.attributeTypeMap = [
    {
        "name": "labelSelectorPath",
        "baseName": "labelSelectorPath",
        "type": "string"
    },
    {
        "name": "specReplicasPath",
        "baseName": "specReplicasPath",
        "type": "string"
    },
    {
        "name": "statusReplicasPath",
        "baseName": "statusReplicasPath",
        "type": "string"
    }
];
exports.V1beta1CustomResourceSubresourceScale = V1beta1CustomResourceSubresourceScale;
/**
* CustomResourceSubresources defines the status and scale subresources for CustomResources.
*/
class V1beta1CustomResourceSubresources {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceSubresources.attributeTypeMap;
    }
}
V1beta1CustomResourceSubresources.discriminator = undefined;
V1beta1CustomResourceSubresources.attributeTypeMap = [
    {
        "name": "scale",
        "baseName": "scale",
        "type": "V1beta1CustomResourceSubresourceScale"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "any"
    }
];
exports.V1beta1CustomResourceSubresources = V1beta1CustomResourceSubresources;
/**
* CustomResourceValidation is a list of validation methods for CustomResources.
*/
class V1beta1CustomResourceValidation {
    static getAttributeTypeMap() {
        return V1beta1CustomResourceValidation.attributeTypeMap;
    }
}
V1beta1CustomResourceValidation.discriminator = undefined;
V1beta1CustomResourceValidation.attributeTypeMap = [
    {
        "name": "openAPIV3Schema",
        "baseName": "openAPIV3Schema",
        "type": "V1beta1JSONSchemaProps"
    }
];
exports.V1beta1CustomResourceValidation = V1beta1CustomResourceValidation;
/**
* DEPRECATED - This group version of DaemonSet is deprecated by apps/v1beta2/DaemonSet. See the release notes for more information. DaemonSet represents the configuration of a daemon set.
*/
class V1beta1DaemonSet {
    static getAttributeTypeMap() {
        return V1beta1DaemonSet.attributeTypeMap;
    }
}
V1beta1DaemonSet.discriminator = undefined;
V1beta1DaemonSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1DaemonSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1DaemonSetStatus"
    }
];
exports.V1beta1DaemonSet = V1beta1DaemonSet;
/**
* DaemonSetCondition describes the state of a DaemonSet at a certain point.
*/
class V1beta1DaemonSetCondition {
    static getAttributeTypeMap() {
        return V1beta1DaemonSetCondition.attributeTypeMap;
    }
}
V1beta1DaemonSetCondition.discriminator = undefined;
V1beta1DaemonSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1DaemonSetCondition = V1beta1DaemonSetCondition;
/**
* DaemonSetList is a collection of daemon sets.
*/
class V1beta1DaemonSetList {
    static getAttributeTypeMap() {
        return V1beta1DaemonSetList.attributeTypeMap;
    }
}
V1beta1DaemonSetList.discriminator = undefined;
V1beta1DaemonSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1DaemonSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1DaemonSetList = V1beta1DaemonSetList;
/**
* DaemonSetSpec is the specification of a daemon set.
*/
class V1beta1DaemonSetSpec {
    static getAttributeTypeMap() {
        return V1beta1DaemonSetSpec.attributeTypeMap;
    }
}
V1beta1DaemonSetSpec.discriminator = undefined;
V1beta1DaemonSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "templateGeneration",
        "baseName": "templateGeneration",
        "type": "number"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1beta1DaemonSetUpdateStrategy"
    }
];
exports.V1beta1DaemonSetSpec = V1beta1DaemonSetSpec;
/**
* DaemonSetStatus represents the current status of a daemon set.
*/
class V1beta1DaemonSetStatus {
    static getAttributeTypeMap() {
        return V1beta1DaemonSetStatus.attributeTypeMap;
    }
}
V1beta1DaemonSetStatus.discriminator = undefined;
V1beta1DaemonSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1DaemonSetCondition>"
    },
    {
        "name": "currentNumberScheduled",
        "baseName": "currentNumberScheduled",
        "type": "number"
    },
    {
        "name": "desiredNumberScheduled",
        "baseName": "desiredNumberScheduled",
        "type": "number"
    },
    {
        "name": "numberAvailable",
        "baseName": "numberAvailable",
        "type": "number"
    },
    {
        "name": "numberMisscheduled",
        "baseName": "numberMisscheduled",
        "type": "number"
    },
    {
        "name": "numberReady",
        "baseName": "numberReady",
        "type": "number"
    },
    {
        "name": "numberUnavailable",
        "baseName": "numberUnavailable",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "updatedNumberScheduled",
        "baseName": "updatedNumberScheduled",
        "type": "number"
    }
];
exports.V1beta1DaemonSetStatus = V1beta1DaemonSetStatus;
class V1beta1DaemonSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1beta1DaemonSetUpdateStrategy.attributeTypeMap;
    }
}
V1beta1DaemonSetUpdateStrategy.discriminator = undefined;
V1beta1DaemonSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1beta1RollingUpdateDaemonSet"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1DaemonSetUpdateStrategy = V1beta1DaemonSetUpdateStrategy;
/**
* Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.
*/
class V1beta1Event {
    static getAttributeTypeMap() {
        return V1beta1Event.attributeTypeMap;
    }
}
V1beta1Event.discriminator = undefined;
V1beta1Event.attributeTypeMap = [
    {
        "name": "action",
        "baseName": "action",
        "type": "string"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "deprecatedCount",
        "baseName": "deprecatedCount",
        "type": "number"
    },
    {
        "name": "deprecatedFirstTimestamp",
        "baseName": "deprecatedFirstTimestamp",
        "type": "Date"
    },
    {
        "name": "deprecatedLastTimestamp",
        "baseName": "deprecatedLastTimestamp",
        "type": "Date"
    },
    {
        "name": "deprecatedSource",
        "baseName": "deprecatedSource",
        "type": "V1EventSource"
    },
    {
        "name": "eventTime",
        "baseName": "eventTime",
        "type": "Date"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "note",
        "baseName": "note",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "regarding",
        "baseName": "regarding",
        "type": "V1ObjectReference"
    },
    {
        "name": "related",
        "baseName": "related",
        "type": "V1ObjectReference"
    },
    {
        "name": "reportingController",
        "baseName": "reportingController",
        "type": "string"
    },
    {
        "name": "reportingInstance",
        "baseName": "reportingInstance",
        "type": "string"
    },
    {
        "name": "series",
        "baseName": "series",
        "type": "V1beta1EventSeries"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1Event = V1beta1Event;
/**
* EventList is a list of Event objects.
*/
class V1beta1EventList {
    static getAttributeTypeMap() {
        return V1beta1EventList.attributeTypeMap;
    }
}
V1beta1EventList.discriminator = undefined;
V1beta1EventList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1Event>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1EventList = V1beta1EventList;
/**
* EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
*/
class V1beta1EventSeries {
    static getAttributeTypeMap() {
        return V1beta1EventSeries.attributeTypeMap;
    }
}
V1beta1EventSeries.discriminator = undefined;
V1beta1EventSeries.attributeTypeMap = [
    {
        "name": "count",
        "baseName": "count",
        "type": "number"
    },
    {
        "name": "lastObservedTime",
        "baseName": "lastObservedTime",
        "type": "Date"
    },
    {
        "name": "state",
        "baseName": "state",
        "type": "string"
    }
];
exports.V1beta1EventSeries = V1beta1EventSeries;
/**
* Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.
*/
class V1beta1Eviction {
    static getAttributeTypeMap() {
        return V1beta1Eviction.attributeTypeMap;
    }
}
V1beta1Eviction.discriminator = undefined;
V1beta1Eviction.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "deleteOptions",
        "baseName": "deleteOptions",
        "type": "V1DeleteOptions"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    }
];
exports.V1beta1Eviction = V1beta1Eviction;
/**
* ExternalDocumentation allows referencing an external resource for extended documentation.
*/
class V1beta1ExternalDocumentation {
    static getAttributeTypeMap() {
        return V1beta1ExternalDocumentation.attributeTypeMap;
    }
}
V1beta1ExternalDocumentation.discriminator = undefined;
V1beta1ExternalDocumentation.attributeTypeMap = [
    {
        "name": "description",
        "baseName": "description",
        "type": "string"
    },
    {
        "name": "url",
        "baseName": "url",
        "type": "string"
    }
];
exports.V1beta1ExternalDocumentation = V1beta1ExternalDocumentation;
/**
* HTTPIngressPath associates a path regex with a backend. Incoming urls matching the path are forwarded to the backend.
*/
class V1beta1HTTPIngressPath {
    static getAttributeTypeMap() {
        return V1beta1HTTPIngressPath.attributeTypeMap;
    }
}
V1beta1HTTPIngressPath.discriminator = undefined;
V1beta1HTTPIngressPath.attributeTypeMap = [
    {
        "name": "backend",
        "baseName": "backend",
        "type": "V1beta1IngressBackend"
    },
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    }
];
exports.V1beta1HTTPIngressPath = V1beta1HTTPIngressPath;
/**
* HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
*/
class V1beta1HTTPIngressRuleValue {
    static getAttributeTypeMap() {
        return V1beta1HTTPIngressRuleValue.attributeTypeMap;
    }
}
V1beta1HTTPIngressRuleValue.discriminator = undefined;
V1beta1HTTPIngressRuleValue.attributeTypeMap = [
    {
        "name": "paths",
        "baseName": "paths",
        "type": "Array<V1beta1HTTPIngressPath>"
    }
];
exports.V1beta1HTTPIngressRuleValue = V1beta1HTTPIngressRuleValue;
/**
* DEPRECATED 1.9 - This group version of IPBlock is deprecated by networking/v1/IPBlock. IPBlock describes a particular CIDR (Ex. \"192.168.1.1/24\") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
*/
class V1beta1IPBlock {
    static getAttributeTypeMap() {
        return V1beta1IPBlock.attributeTypeMap;
    }
}
V1beta1IPBlock.discriminator = undefined;
V1beta1IPBlock.attributeTypeMap = [
    {
        "name": "cidr",
        "baseName": "cidr",
        "type": "string"
    },
    {
        "name": "except",
        "baseName": "except",
        "type": "Array<string>"
    }
];
exports.V1beta1IPBlock = V1beta1IPBlock;
/**
* Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.
*/
class V1beta1Ingress {
    static getAttributeTypeMap() {
        return V1beta1Ingress.attributeTypeMap;
    }
}
V1beta1Ingress.discriminator = undefined;
V1beta1Ingress.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1IngressSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1IngressStatus"
    }
];
exports.V1beta1Ingress = V1beta1Ingress;
/**
* IngressBackend describes all endpoints for a given service and port.
*/
class V1beta1IngressBackend {
    static getAttributeTypeMap() {
        return V1beta1IngressBackend.attributeTypeMap;
    }
}
V1beta1IngressBackend.discriminator = undefined;
V1beta1IngressBackend.attributeTypeMap = [
    {
        "name": "serviceName",
        "baseName": "serviceName",
        "type": "string"
    },
    {
        "name": "servicePort",
        "baseName": "servicePort",
        "type": "any"
    }
];
exports.V1beta1IngressBackend = V1beta1IngressBackend;
/**
* IngressList is a collection of Ingress.
*/
class V1beta1IngressList {
    static getAttributeTypeMap() {
        return V1beta1IngressList.attributeTypeMap;
    }
}
V1beta1IngressList.discriminator = undefined;
V1beta1IngressList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1Ingress>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1IngressList = V1beta1IngressList;
/**
* IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
*/
class V1beta1IngressRule {
    static getAttributeTypeMap() {
        return V1beta1IngressRule.attributeTypeMap;
    }
}
V1beta1IngressRule.discriminator = undefined;
V1beta1IngressRule.attributeTypeMap = [
    {
        "name": "host",
        "baseName": "host",
        "type": "string"
    },
    {
        "name": "http",
        "baseName": "http",
        "type": "V1beta1HTTPIngressRuleValue"
    }
];
exports.V1beta1IngressRule = V1beta1IngressRule;
/**
* IngressSpec describes the Ingress the user wishes to exist.
*/
class V1beta1IngressSpec {
    static getAttributeTypeMap() {
        return V1beta1IngressSpec.attributeTypeMap;
    }
}
V1beta1IngressSpec.discriminator = undefined;
V1beta1IngressSpec.attributeTypeMap = [
    {
        "name": "backend",
        "baseName": "backend",
        "type": "V1beta1IngressBackend"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1beta1IngressRule>"
    },
    {
        "name": "tls",
        "baseName": "tls",
        "type": "Array<V1beta1IngressTLS>"
    }
];
exports.V1beta1IngressSpec = V1beta1IngressSpec;
/**
* IngressStatus describe the current state of the Ingress.
*/
class V1beta1IngressStatus {
    static getAttributeTypeMap() {
        return V1beta1IngressStatus.attributeTypeMap;
    }
}
V1beta1IngressStatus.discriminator = undefined;
V1beta1IngressStatus.attributeTypeMap = [
    {
        "name": "loadBalancer",
        "baseName": "loadBalancer",
        "type": "V1LoadBalancerStatus"
    }
];
exports.V1beta1IngressStatus = V1beta1IngressStatus;
/**
* IngressTLS describes the transport layer security associated with an Ingress.
*/
class V1beta1IngressTLS {
    static getAttributeTypeMap() {
        return V1beta1IngressTLS.attributeTypeMap;
    }
}
V1beta1IngressTLS.discriminator = undefined;
V1beta1IngressTLS.attributeTypeMap = [
    {
        "name": "hosts",
        "baseName": "hosts",
        "type": "Array<string>"
    },
    {
        "name": "secretName",
        "baseName": "secretName",
        "type": "string"
    }
];
exports.V1beta1IngressTLS = V1beta1IngressTLS;
/**
* JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
*/
class V1beta1JSONSchemaProps {
    static getAttributeTypeMap() {
        return V1beta1JSONSchemaProps.attributeTypeMap;
    }
}
V1beta1JSONSchemaProps.discriminator = undefined;
V1beta1JSONSchemaProps.attributeTypeMap = [
    {
        "name": "ref",
        "baseName": "$ref",
        "type": "string"
    },
    {
        "name": "schema",
        "baseName": "$schema",
        "type": "string"
    },
    {
        "name": "additionalItems",
        "baseName": "additionalItems",
        "type": "any"
    },
    {
        "name": "additionalProperties",
        "baseName": "additionalProperties",
        "type": "any"
    },
    {
        "name": "allOf",
        "baseName": "allOf",
        "type": "Array<V1beta1JSONSchemaProps>"
    },
    {
        "name": "anyOf",
        "baseName": "anyOf",
        "type": "Array<V1beta1JSONSchemaProps>"
    },
    {
        "name": "_default",
        "baseName": "default",
        "type": "any"
    },
    {
        "name": "definitions",
        "baseName": "definitions",
        "type": "{ [key: string]: V1beta1JSONSchemaProps; }"
    },
    {
        "name": "dependencies",
        "baseName": "dependencies",
        "type": "{ [key: string]: any; }"
    },
    {
        "name": "description",
        "baseName": "description",
        "type": "string"
    },
    {
        "name": "_enum",
        "baseName": "enum",
        "type": "Array<any>"
    },
    {
        "name": "example",
        "baseName": "example",
        "type": "any"
    },
    {
        "name": "exclusiveMaximum",
        "baseName": "exclusiveMaximum",
        "type": "boolean"
    },
    {
        "name": "exclusiveMinimum",
        "baseName": "exclusiveMinimum",
        "type": "boolean"
    },
    {
        "name": "externalDocs",
        "baseName": "externalDocs",
        "type": "V1beta1ExternalDocumentation"
    },
    {
        "name": "format",
        "baseName": "format",
        "type": "string"
    },
    {
        "name": "id",
        "baseName": "id",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "any"
    },
    {
        "name": "maxItems",
        "baseName": "maxItems",
        "type": "number"
    },
    {
        "name": "maxLength",
        "baseName": "maxLength",
        "type": "number"
    },
    {
        "name": "maxProperties",
        "baseName": "maxProperties",
        "type": "number"
    },
    {
        "name": "maximum",
        "baseName": "maximum",
        "type": "number"
    },
    {
        "name": "minItems",
        "baseName": "minItems",
        "type": "number"
    },
    {
        "name": "minLength",
        "baseName": "minLength",
        "type": "number"
    },
    {
        "name": "minProperties",
        "baseName": "minProperties",
        "type": "number"
    },
    {
        "name": "minimum",
        "baseName": "minimum",
        "type": "number"
    },
    {
        "name": "multipleOf",
        "baseName": "multipleOf",
        "type": "number"
    },
    {
        "name": "not",
        "baseName": "not",
        "type": "V1beta1JSONSchemaProps"
    },
    {
        "name": "oneOf",
        "baseName": "oneOf",
        "type": "Array<V1beta1JSONSchemaProps>"
    },
    {
        "name": "pattern",
        "baseName": "pattern",
        "type": "string"
    },
    {
        "name": "patternProperties",
        "baseName": "patternProperties",
        "type": "{ [key: string]: V1beta1JSONSchemaProps; }"
    },
    {
        "name": "properties",
        "baseName": "properties",
        "type": "{ [key: string]: V1beta1JSONSchemaProps; }"
    },
    {
        "name": "required",
        "baseName": "required",
        "type": "Array<string>"
    },
    {
        "name": "title",
        "baseName": "title",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    },
    {
        "name": "uniqueItems",
        "baseName": "uniqueItems",
        "type": "boolean"
    }
];
exports.V1beta1JSONSchemaProps = V1beta1JSONSchemaProps;
/**
* JobTemplateSpec describes the data a Job should have when created from a template
*/
class V1beta1JobTemplateSpec {
    static getAttributeTypeMap() {
        return V1beta1JobTemplateSpec.attributeTypeMap;
    }
}
V1beta1JobTemplateSpec.discriminator = undefined;
V1beta1JobTemplateSpec.attributeTypeMap = [
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1JobSpec"
    }
];
exports.V1beta1JobTemplateSpec = V1beta1JobTemplateSpec;
/**
* Lease defines a lease concept.
*/
class V1beta1Lease {
    static getAttributeTypeMap() {
        return V1beta1Lease.attributeTypeMap;
    }
}
V1beta1Lease.discriminator = undefined;
V1beta1Lease.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1LeaseSpec"
    }
];
exports.V1beta1Lease = V1beta1Lease;
/**
* LeaseList is a list of Lease objects.
*/
class V1beta1LeaseList {
    static getAttributeTypeMap() {
        return V1beta1LeaseList.attributeTypeMap;
    }
}
V1beta1LeaseList.discriminator = undefined;
V1beta1LeaseList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1Lease>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1LeaseList = V1beta1LeaseList;
/**
* LeaseSpec is a specification of a Lease.
*/
class V1beta1LeaseSpec {
    static getAttributeTypeMap() {
        return V1beta1LeaseSpec.attributeTypeMap;
    }
}
V1beta1LeaseSpec.discriminator = undefined;
V1beta1LeaseSpec.attributeTypeMap = [
    {
        "name": "acquireTime",
        "baseName": "acquireTime",
        "type": "Date"
    },
    {
        "name": "holderIdentity",
        "baseName": "holderIdentity",
        "type": "string"
    },
    {
        "name": "leaseDurationSeconds",
        "baseName": "leaseDurationSeconds",
        "type": "number"
    },
    {
        "name": "leaseTransitions",
        "baseName": "leaseTransitions",
        "type": "number"
    },
    {
        "name": "renewTime",
        "baseName": "renewTime",
        "type": "Date"
    }
];
exports.V1beta1LeaseSpec = V1beta1LeaseSpec;
/**
* LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.
*/
class V1beta1LocalSubjectAccessReview {
    static getAttributeTypeMap() {
        return V1beta1LocalSubjectAccessReview.attributeTypeMap;
    }
}
V1beta1LocalSubjectAccessReview.discriminator = undefined;
V1beta1LocalSubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1SubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1SubjectAccessReviewStatus"
    }
];
exports.V1beta1LocalSubjectAccessReview = V1beta1LocalSubjectAccessReview;
/**
* MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.
*/
class V1beta1MutatingWebhookConfiguration {
    static getAttributeTypeMap() {
        return V1beta1MutatingWebhookConfiguration.attributeTypeMap;
    }
}
V1beta1MutatingWebhookConfiguration.discriminator = undefined;
V1beta1MutatingWebhookConfiguration.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "webhooks",
        "baseName": "webhooks",
        "type": "Array<V1beta1Webhook>"
    }
];
exports.V1beta1MutatingWebhookConfiguration = V1beta1MutatingWebhookConfiguration;
/**
* MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.
*/
class V1beta1MutatingWebhookConfigurationList {
    static getAttributeTypeMap() {
        return V1beta1MutatingWebhookConfigurationList.attributeTypeMap;
    }
}
V1beta1MutatingWebhookConfigurationList.discriminator = undefined;
V1beta1MutatingWebhookConfigurationList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1MutatingWebhookConfiguration>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1MutatingWebhookConfigurationList = V1beta1MutatingWebhookConfigurationList;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicy is deprecated by networking/v1/NetworkPolicy. NetworkPolicy describes what network traffic is allowed for a set of Pods
*/
class V1beta1NetworkPolicy {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicy.attributeTypeMap;
    }
}
V1beta1NetworkPolicy.discriminator = undefined;
V1beta1NetworkPolicy.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1NetworkPolicySpec"
    }
];
exports.V1beta1NetworkPolicy = V1beta1NetworkPolicy;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicyEgressRule is deprecated by networking/v1/NetworkPolicyEgressRule. NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
*/
class V1beta1NetworkPolicyEgressRule {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicyEgressRule.attributeTypeMap;
    }
}
V1beta1NetworkPolicyEgressRule.discriminator = undefined;
V1beta1NetworkPolicyEgressRule.attributeTypeMap = [
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1beta1NetworkPolicyPort>"
    },
    {
        "name": "to",
        "baseName": "to",
        "type": "Array<V1beta1NetworkPolicyPeer>"
    }
];
exports.V1beta1NetworkPolicyEgressRule = V1beta1NetworkPolicyEgressRule;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicyIngressRule is deprecated by networking/v1/NetworkPolicyIngressRule. This NetworkPolicyIngressRule matches traffic if and only if the traffic matches both ports AND from.
*/
class V1beta1NetworkPolicyIngressRule {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicyIngressRule.attributeTypeMap;
    }
}
V1beta1NetworkPolicyIngressRule.discriminator = undefined;
V1beta1NetworkPolicyIngressRule.attributeTypeMap = [
    {
        "name": "from",
        "baseName": "from",
        "type": "Array<V1beta1NetworkPolicyPeer>"
    },
    {
        "name": "ports",
        "baseName": "ports",
        "type": "Array<V1beta1NetworkPolicyPort>"
    }
];
exports.V1beta1NetworkPolicyIngressRule = V1beta1NetworkPolicyIngressRule;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicyList is deprecated by networking/v1/NetworkPolicyList. Network Policy List is a list of NetworkPolicy objects.
*/
class V1beta1NetworkPolicyList {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicyList.attributeTypeMap;
    }
}
V1beta1NetworkPolicyList.discriminator = undefined;
V1beta1NetworkPolicyList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1NetworkPolicy>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1NetworkPolicyList = V1beta1NetworkPolicyList;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicyPeer is deprecated by networking/v1/NetworkPolicyPeer.
*/
class V1beta1NetworkPolicyPeer {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicyPeer.attributeTypeMap;
    }
}
V1beta1NetworkPolicyPeer.discriminator = undefined;
V1beta1NetworkPolicyPeer.attributeTypeMap = [
    {
        "name": "ipBlock",
        "baseName": "ipBlock",
        "type": "V1beta1IPBlock"
    },
    {
        "name": "namespaceSelector",
        "baseName": "namespaceSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "podSelector",
        "baseName": "podSelector",
        "type": "V1LabelSelector"
    }
];
exports.V1beta1NetworkPolicyPeer = V1beta1NetworkPolicyPeer;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicyPort is deprecated by networking/v1/NetworkPolicyPort.
*/
class V1beta1NetworkPolicyPort {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicyPort.attributeTypeMap;
    }
}
V1beta1NetworkPolicyPort.discriminator = undefined;
V1beta1NetworkPolicyPort.attributeTypeMap = [
    {
        "name": "port",
        "baseName": "port",
        "type": "any"
    },
    {
        "name": "protocol",
        "baseName": "protocol",
        "type": "string"
    }
];
exports.V1beta1NetworkPolicyPort = V1beta1NetworkPolicyPort;
/**
* DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.
*/
class V1beta1NetworkPolicySpec {
    static getAttributeTypeMap() {
        return V1beta1NetworkPolicySpec.attributeTypeMap;
    }
}
V1beta1NetworkPolicySpec.discriminator = undefined;
V1beta1NetworkPolicySpec.attributeTypeMap = [
    {
        "name": "egress",
        "baseName": "egress",
        "type": "Array<V1beta1NetworkPolicyEgressRule>"
    },
    {
        "name": "ingress",
        "baseName": "ingress",
        "type": "Array<V1beta1NetworkPolicyIngressRule>"
    },
    {
        "name": "podSelector",
        "baseName": "podSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "policyTypes",
        "baseName": "policyTypes",
        "type": "Array<string>"
    }
];
exports.V1beta1NetworkPolicySpec = V1beta1NetworkPolicySpec;
/**
* NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface
*/
class V1beta1NonResourceAttributes {
    static getAttributeTypeMap() {
        return V1beta1NonResourceAttributes.attributeTypeMap;
    }
}
V1beta1NonResourceAttributes.discriminator = undefined;
V1beta1NonResourceAttributes.attributeTypeMap = [
    {
        "name": "path",
        "baseName": "path",
        "type": "string"
    },
    {
        "name": "verb",
        "baseName": "verb",
        "type": "string"
    }
];
exports.V1beta1NonResourceAttributes = V1beta1NonResourceAttributes;
/**
* NonResourceRule holds information that describes a rule for the non-resource
*/
class V1beta1NonResourceRule {
    static getAttributeTypeMap() {
        return V1beta1NonResourceRule.attributeTypeMap;
    }
}
V1beta1NonResourceRule.discriminator = undefined;
V1beta1NonResourceRule.attributeTypeMap = [
    {
        "name": "nonResourceURLs",
        "baseName": "nonResourceURLs",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1beta1NonResourceRule = V1beta1NonResourceRule;
/**
* PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods
*/
class V1beta1PodDisruptionBudget {
    static getAttributeTypeMap() {
        return V1beta1PodDisruptionBudget.attributeTypeMap;
    }
}
V1beta1PodDisruptionBudget.discriminator = undefined;
V1beta1PodDisruptionBudget.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1PodDisruptionBudgetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1PodDisruptionBudgetStatus"
    }
];
exports.V1beta1PodDisruptionBudget = V1beta1PodDisruptionBudget;
/**
* PodDisruptionBudgetList is a collection of PodDisruptionBudgets.
*/
class V1beta1PodDisruptionBudgetList {
    static getAttributeTypeMap() {
        return V1beta1PodDisruptionBudgetList.attributeTypeMap;
    }
}
V1beta1PodDisruptionBudgetList.discriminator = undefined;
V1beta1PodDisruptionBudgetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1PodDisruptionBudget>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1PodDisruptionBudgetList = V1beta1PodDisruptionBudgetList;
/**
* PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
*/
class V1beta1PodDisruptionBudgetSpec {
    static getAttributeTypeMap() {
        return V1beta1PodDisruptionBudgetSpec.attributeTypeMap;
    }
}
V1beta1PodDisruptionBudgetSpec.discriminator = undefined;
V1beta1PodDisruptionBudgetSpec.attributeTypeMap = [
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    },
    {
        "name": "minAvailable",
        "baseName": "minAvailable",
        "type": "any"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    }
];
exports.V1beta1PodDisruptionBudgetSpec = V1beta1PodDisruptionBudgetSpec;
/**
* PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
*/
class V1beta1PodDisruptionBudgetStatus {
    static getAttributeTypeMap() {
        return V1beta1PodDisruptionBudgetStatus.attributeTypeMap;
    }
}
V1beta1PodDisruptionBudgetStatus.discriminator = undefined;
V1beta1PodDisruptionBudgetStatus.attributeTypeMap = [
    {
        "name": "currentHealthy",
        "baseName": "currentHealthy",
        "type": "number"
    },
    {
        "name": "desiredHealthy",
        "baseName": "desiredHealthy",
        "type": "number"
    },
    {
        "name": "disruptedPods",
        "baseName": "disruptedPods",
        "type": "{ [key: string]: Date; }"
    },
    {
        "name": "disruptionsAllowed",
        "baseName": "disruptionsAllowed",
        "type": "number"
    },
    {
        "name": "expectedPods",
        "baseName": "expectedPods",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    }
];
exports.V1beta1PodDisruptionBudgetStatus = V1beta1PodDisruptionBudgetStatus;
/**
* PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.
*/
class V1beta1PolicyRule {
    static getAttributeTypeMap() {
        return V1beta1PolicyRule.attributeTypeMap;
    }
}
V1beta1PolicyRule.discriminator = undefined;
V1beta1PolicyRule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "nonResourceURLs",
        "baseName": "nonResourceURLs",
        "type": "Array<string>"
    },
    {
        "name": "resourceNames",
        "baseName": "resourceNames",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1beta1PolicyRule = V1beta1PolicyRule;
/**
* PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.
*/
class V1beta1PriorityClass {
    static getAttributeTypeMap() {
        return V1beta1PriorityClass.attributeTypeMap;
    }
}
V1beta1PriorityClass.discriminator = undefined;
V1beta1PriorityClass.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "description",
        "baseName": "description",
        "type": "string"
    },
    {
        "name": "globalDefault",
        "baseName": "globalDefault",
        "type": "boolean"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "number"
    }
];
exports.V1beta1PriorityClass = V1beta1PriorityClass;
/**
* PriorityClassList is a collection of priority classes.
*/
class V1beta1PriorityClassList {
    static getAttributeTypeMap() {
        return V1beta1PriorityClassList.attributeTypeMap;
    }
}
V1beta1PriorityClassList.discriminator = undefined;
V1beta1PriorityClassList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1PriorityClass>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1PriorityClassList = V1beta1PriorityClassList;
/**
* DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1beta2/ReplicaSet. See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.
*/
class V1beta1ReplicaSet {
    static getAttributeTypeMap() {
        return V1beta1ReplicaSet.attributeTypeMap;
    }
}
V1beta1ReplicaSet.discriminator = undefined;
V1beta1ReplicaSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1ReplicaSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1ReplicaSetStatus"
    }
];
exports.V1beta1ReplicaSet = V1beta1ReplicaSet;
/**
* ReplicaSetCondition describes the state of a replica set at a certain point.
*/
class V1beta1ReplicaSetCondition {
    static getAttributeTypeMap() {
        return V1beta1ReplicaSetCondition.attributeTypeMap;
    }
}
V1beta1ReplicaSetCondition.discriminator = undefined;
V1beta1ReplicaSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1ReplicaSetCondition = V1beta1ReplicaSetCondition;
/**
* ReplicaSetList is a collection of ReplicaSets.
*/
class V1beta1ReplicaSetList {
    static getAttributeTypeMap() {
        return V1beta1ReplicaSetList.attributeTypeMap;
    }
}
V1beta1ReplicaSetList.discriminator = undefined;
V1beta1ReplicaSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1ReplicaSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1ReplicaSetList = V1beta1ReplicaSetList;
/**
* ReplicaSetSpec is the specification of a ReplicaSet.
*/
class V1beta1ReplicaSetSpec {
    static getAttributeTypeMap() {
        return V1beta1ReplicaSetSpec.attributeTypeMap;
    }
}
V1beta1ReplicaSetSpec.discriminator = undefined;
V1beta1ReplicaSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1beta1ReplicaSetSpec = V1beta1ReplicaSetSpec;
/**
* ReplicaSetStatus represents the current status of a ReplicaSet.
*/
class V1beta1ReplicaSetStatus {
    static getAttributeTypeMap() {
        return V1beta1ReplicaSetStatus.attributeTypeMap;
    }
}
V1beta1ReplicaSetStatus.discriminator = undefined;
V1beta1ReplicaSetStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1ReplicaSetCondition>"
    },
    {
        "name": "fullyLabeledReplicas",
        "baseName": "fullyLabeledReplicas",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1beta1ReplicaSetStatus = V1beta1ReplicaSetStatus;
/**
* ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface
*/
class V1beta1ResourceAttributes {
    static getAttributeTypeMap() {
        return V1beta1ResourceAttributes.attributeTypeMap;
    }
}
V1beta1ResourceAttributes.discriminator = undefined;
V1beta1ResourceAttributes.attributeTypeMap = [
    {
        "name": "group",
        "baseName": "group",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "string"
    },
    {
        "name": "subresource",
        "baseName": "subresource",
        "type": "string"
    },
    {
        "name": "verb",
        "baseName": "verb",
        "type": "string"
    },
    {
        "name": "version",
        "baseName": "version",
        "type": "string"
    }
];
exports.V1beta1ResourceAttributes = V1beta1ResourceAttributes;
/**
* ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.
*/
class V1beta1ResourceRule {
    static getAttributeTypeMap() {
        return V1beta1ResourceRule.attributeTypeMap;
    }
}
V1beta1ResourceRule.discriminator = undefined;
V1beta1ResourceRule.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "resourceNames",
        "baseName": "resourceNames",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    },
    {
        "name": "verbs",
        "baseName": "verbs",
        "type": "Array<string>"
    }
];
exports.V1beta1ResourceRule = V1beta1ResourceRule;
/**
* Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
*/
class V1beta1Role {
    static getAttributeTypeMap() {
        return V1beta1Role.attributeTypeMap;
    }
}
V1beta1Role.discriminator = undefined;
V1beta1Role.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1beta1PolicyRule>"
    }
];
exports.V1beta1Role = V1beta1Role;
/**
* RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace.
*/
class V1beta1RoleBinding {
    static getAttributeTypeMap() {
        return V1beta1RoleBinding.attributeTypeMap;
    }
}
V1beta1RoleBinding.discriminator = undefined;
V1beta1RoleBinding.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "roleRef",
        "baseName": "roleRef",
        "type": "V1beta1RoleRef"
    },
    {
        "name": "subjects",
        "baseName": "subjects",
        "type": "Array<V1beta1Subject>"
    }
];
exports.V1beta1RoleBinding = V1beta1RoleBinding;
/**
* RoleBindingList is a collection of RoleBindings
*/
class V1beta1RoleBindingList {
    static getAttributeTypeMap() {
        return V1beta1RoleBindingList.attributeTypeMap;
    }
}
V1beta1RoleBindingList.discriminator = undefined;
V1beta1RoleBindingList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1RoleBinding>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1RoleBindingList = V1beta1RoleBindingList;
/**
* RoleList is a collection of Roles
*/
class V1beta1RoleList {
    static getAttributeTypeMap() {
        return V1beta1RoleList.attributeTypeMap;
    }
}
V1beta1RoleList.discriminator = undefined;
V1beta1RoleList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1Role>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1RoleList = V1beta1RoleList;
/**
* RoleRef contains information that points to the role being used
*/
class V1beta1RoleRef {
    static getAttributeTypeMap() {
        return V1beta1RoleRef.attributeTypeMap;
    }
}
V1beta1RoleRef.discriminator = undefined;
V1beta1RoleRef.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V1beta1RoleRef = V1beta1RoleRef;
/**
* Spec to control the desired behavior of daemon set rolling update.
*/
class V1beta1RollingUpdateDaemonSet {
    static getAttributeTypeMap() {
        return V1beta1RollingUpdateDaemonSet.attributeTypeMap;
    }
}
V1beta1RollingUpdateDaemonSet.discriminator = undefined;
V1beta1RollingUpdateDaemonSet.attributeTypeMap = [
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.V1beta1RollingUpdateDaemonSet = V1beta1RollingUpdateDaemonSet;
/**
* RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
*/
class V1beta1RollingUpdateStatefulSetStrategy {
    static getAttributeTypeMap() {
        return V1beta1RollingUpdateStatefulSetStrategy.attributeTypeMap;
    }
}
V1beta1RollingUpdateStatefulSetStrategy.discriminator = undefined;
V1beta1RollingUpdateStatefulSetStrategy.attributeTypeMap = [
    {
        "name": "partition",
        "baseName": "partition",
        "type": "number"
    }
];
exports.V1beta1RollingUpdateStatefulSetStrategy = V1beta1RollingUpdateStatefulSetStrategy;
/**
* RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.
*/
class V1beta1RuleWithOperations {
    static getAttributeTypeMap() {
        return V1beta1RuleWithOperations.attributeTypeMap;
    }
}
V1beta1RuleWithOperations.discriminator = undefined;
V1beta1RuleWithOperations.attributeTypeMap = [
    {
        "name": "apiGroups",
        "baseName": "apiGroups",
        "type": "Array<string>"
    },
    {
        "name": "apiVersions",
        "baseName": "apiVersions",
        "type": "Array<string>"
    },
    {
        "name": "operations",
        "baseName": "operations",
        "type": "Array<string>"
    },
    {
        "name": "resources",
        "baseName": "resources",
        "type": "Array<string>"
    }
];
exports.V1beta1RuleWithOperations = V1beta1RuleWithOperations;
/**
* SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action
*/
class V1beta1SelfSubjectAccessReview {
    static getAttributeTypeMap() {
        return V1beta1SelfSubjectAccessReview.attributeTypeMap;
    }
}
V1beta1SelfSubjectAccessReview.discriminator = undefined;
V1beta1SelfSubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1SelfSubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1SubjectAccessReviewStatus"
    }
];
exports.V1beta1SelfSubjectAccessReview = V1beta1SelfSubjectAccessReview;
/**
* SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
*/
class V1beta1SelfSubjectAccessReviewSpec {
    static getAttributeTypeMap() {
        return V1beta1SelfSubjectAccessReviewSpec.attributeTypeMap;
    }
}
V1beta1SelfSubjectAccessReviewSpec.discriminator = undefined;
V1beta1SelfSubjectAccessReviewSpec.attributeTypeMap = [
    {
        "name": "nonResourceAttributes",
        "baseName": "nonResourceAttributes",
        "type": "V1beta1NonResourceAttributes"
    },
    {
        "name": "resourceAttributes",
        "baseName": "resourceAttributes",
        "type": "V1beta1ResourceAttributes"
    }
];
exports.V1beta1SelfSubjectAccessReviewSpec = V1beta1SelfSubjectAccessReviewSpec;
/**
* SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.
*/
class V1beta1SelfSubjectRulesReview {
    static getAttributeTypeMap() {
        return V1beta1SelfSubjectRulesReview.attributeTypeMap;
    }
}
V1beta1SelfSubjectRulesReview.discriminator = undefined;
V1beta1SelfSubjectRulesReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1SelfSubjectRulesReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1SubjectRulesReviewStatus"
    }
];
exports.V1beta1SelfSubjectRulesReview = V1beta1SelfSubjectRulesReview;
class V1beta1SelfSubjectRulesReviewSpec {
    static getAttributeTypeMap() {
        return V1beta1SelfSubjectRulesReviewSpec.attributeTypeMap;
    }
}
V1beta1SelfSubjectRulesReviewSpec.discriminator = undefined;
V1beta1SelfSubjectRulesReviewSpec.attributeTypeMap = [
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1beta1SelfSubjectRulesReviewSpec = V1beta1SelfSubjectRulesReviewSpec;
/**
* DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:  - Network: A single stable DNS and hostname.  - Storage: As many VolumeClaims as requested. The StatefulSet guarantees that a given network identity will always map to the same storage identity.
*/
class V1beta1StatefulSet {
    static getAttributeTypeMap() {
        return V1beta1StatefulSet.attributeTypeMap;
    }
}
V1beta1StatefulSet.discriminator = undefined;
V1beta1StatefulSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1StatefulSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1StatefulSetStatus"
    }
];
exports.V1beta1StatefulSet = V1beta1StatefulSet;
/**
* StatefulSetCondition describes the state of a statefulset at a certain point.
*/
class V1beta1StatefulSetCondition {
    static getAttributeTypeMap() {
        return V1beta1StatefulSetCondition.attributeTypeMap;
    }
}
V1beta1StatefulSetCondition.discriminator = undefined;
V1beta1StatefulSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1StatefulSetCondition = V1beta1StatefulSetCondition;
/**
* StatefulSetList is a collection of StatefulSets.
*/
class V1beta1StatefulSetList {
    static getAttributeTypeMap() {
        return V1beta1StatefulSetList.attributeTypeMap;
    }
}
V1beta1StatefulSetList.discriminator = undefined;
V1beta1StatefulSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1StatefulSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1StatefulSetList = V1beta1StatefulSetList;
/**
* A StatefulSetSpec is the specification of a StatefulSet.
*/
class V1beta1StatefulSetSpec {
    static getAttributeTypeMap() {
        return V1beta1StatefulSetSpec.attributeTypeMap;
    }
}
V1beta1StatefulSetSpec.discriminator = undefined;
V1beta1StatefulSetSpec.attributeTypeMap = [
    {
        "name": "podManagementPolicy",
        "baseName": "podManagementPolicy",
        "type": "string"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "serviceName",
        "baseName": "serviceName",
        "type": "string"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1beta1StatefulSetUpdateStrategy"
    },
    {
        "name": "volumeClaimTemplates",
        "baseName": "volumeClaimTemplates",
        "type": "Array<V1PersistentVolumeClaim>"
    }
];
exports.V1beta1StatefulSetSpec = V1beta1StatefulSetSpec;
/**
* StatefulSetStatus represents the current state of a StatefulSet.
*/
class V1beta1StatefulSetStatus {
    static getAttributeTypeMap() {
        return V1beta1StatefulSetStatus.attributeTypeMap;
    }
}
V1beta1StatefulSetStatus.discriminator = undefined;
V1beta1StatefulSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta1StatefulSetCondition>"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "currentRevision",
        "baseName": "currentRevision",
        "type": "string"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "updateRevision",
        "baseName": "updateRevision",
        "type": "string"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.V1beta1StatefulSetStatus = V1beta1StatefulSetStatus;
/**
* StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
*/
class V1beta1StatefulSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1beta1StatefulSetUpdateStrategy.attributeTypeMap;
    }
}
V1beta1StatefulSetUpdateStrategy.discriminator = undefined;
V1beta1StatefulSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1beta1RollingUpdateStatefulSetStrategy"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta1StatefulSetUpdateStrategy = V1beta1StatefulSetUpdateStrategy;
/**
* StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
*/
class V1beta1StorageClass {
    static getAttributeTypeMap() {
        return V1beta1StorageClass.attributeTypeMap;
    }
}
V1beta1StorageClass.discriminator = undefined;
V1beta1StorageClass.attributeTypeMap = [
    {
        "name": "allowVolumeExpansion",
        "baseName": "allowVolumeExpansion",
        "type": "boolean"
    },
    {
        "name": "allowedTopologies",
        "baseName": "allowedTopologies",
        "type": "Array<V1TopologySelectorTerm>"
    },
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "mountOptions",
        "baseName": "mountOptions",
        "type": "Array<string>"
    },
    {
        "name": "parameters",
        "baseName": "parameters",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "provisioner",
        "baseName": "provisioner",
        "type": "string"
    },
    {
        "name": "reclaimPolicy",
        "baseName": "reclaimPolicy",
        "type": "string"
    },
    {
        "name": "volumeBindingMode",
        "baseName": "volumeBindingMode",
        "type": "string"
    }
];
exports.V1beta1StorageClass = V1beta1StorageClass;
/**
* StorageClassList is a collection of storage classes.
*/
class V1beta1StorageClassList {
    static getAttributeTypeMap() {
        return V1beta1StorageClassList.attributeTypeMap;
    }
}
V1beta1StorageClassList.discriminator = undefined;
V1beta1StorageClassList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1StorageClass>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1StorageClassList = V1beta1StorageClassList;
/**
* Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names.
*/
class V1beta1Subject {
    static getAttributeTypeMap() {
        return V1beta1Subject.attributeTypeMap;
    }
}
V1beta1Subject.discriminator = undefined;
V1beta1Subject.attributeTypeMap = [
    {
        "name": "apiGroup",
        "baseName": "apiGroup",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespace",
        "baseName": "namespace",
        "type": "string"
    }
];
exports.V1beta1Subject = V1beta1Subject;
/**
* SubjectAccessReview checks whether or not a user or group can perform an action.
*/
class V1beta1SubjectAccessReview {
    static getAttributeTypeMap() {
        return V1beta1SubjectAccessReview.attributeTypeMap;
    }
}
V1beta1SubjectAccessReview.discriminator = undefined;
V1beta1SubjectAccessReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1SubjectAccessReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1SubjectAccessReviewStatus"
    }
];
exports.V1beta1SubjectAccessReview = V1beta1SubjectAccessReview;
/**
* SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set
*/
class V1beta1SubjectAccessReviewSpec {
    static getAttributeTypeMap() {
        return V1beta1SubjectAccessReviewSpec.attributeTypeMap;
    }
}
V1beta1SubjectAccessReviewSpec.discriminator = undefined;
V1beta1SubjectAccessReviewSpec.attributeTypeMap = [
    {
        "name": "extra",
        "baseName": "extra",
        "type": "{ [key: string]: Array<string>; }"
    },
    {
        "name": "group",
        "baseName": "group",
        "type": "Array<string>"
    },
    {
        "name": "nonResourceAttributes",
        "baseName": "nonResourceAttributes",
        "type": "V1beta1NonResourceAttributes"
    },
    {
        "name": "resourceAttributes",
        "baseName": "resourceAttributes",
        "type": "V1beta1ResourceAttributes"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "string"
    }
];
exports.V1beta1SubjectAccessReviewSpec = V1beta1SubjectAccessReviewSpec;
/**
* SubjectAccessReviewStatus
*/
class V1beta1SubjectAccessReviewStatus {
    static getAttributeTypeMap() {
        return V1beta1SubjectAccessReviewStatus.attributeTypeMap;
    }
}
V1beta1SubjectAccessReviewStatus.discriminator = undefined;
V1beta1SubjectAccessReviewStatus.attributeTypeMap = [
    {
        "name": "allowed",
        "baseName": "allowed",
        "type": "boolean"
    },
    {
        "name": "denied",
        "baseName": "denied",
        "type": "boolean"
    },
    {
        "name": "evaluationError",
        "baseName": "evaluationError",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    }
];
exports.V1beta1SubjectAccessReviewStatus = V1beta1SubjectAccessReviewStatus;
/**
* SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.
*/
class V1beta1SubjectRulesReviewStatus {
    static getAttributeTypeMap() {
        return V1beta1SubjectRulesReviewStatus.attributeTypeMap;
    }
}
V1beta1SubjectRulesReviewStatus.discriminator = undefined;
V1beta1SubjectRulesReviewStatus.attributeTypeMap = [
    {
        "name": "evaluationError",
        "baseName": "evaluationError",
        "type": "string"
    },
    {
        "name": "incomplete",
        "baseName": "incomplete",
        "type": "boolean"
    },
    {
        "name": "nonResourceRules",
        "baseName": "nonResourceRules",
        "type": "Array<V1beta1NonResourceRule>"
    },
    {
        "name": "resourceRules",
        "baseName": "resourceRules",
        "type": "Array<V1beta1ResourceRule>"
    }
];
exports.V1beta1SubjectRulesReviewStatus = V1beta1SubjectRulesReviewStatus;
/**
* TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.
*/
class V1beta1TokenReview {
    static getAttributeTypeMap() {
        return V1beta1TokenReview.attributeTypeMap;
    }
}
V1beta1TokenReview.discriminator = undefined;
V1beta1TokenReview.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1TokenReviewSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1TokenReviewStatus"
    }
];
exports.V1beta1TokenReview = V1beta1TokenReview;
/**
* TokenReviewSpec is a description of the token authentication request.
*/
class V1beta1TokenReviewSpec {
    static getAttributeTypeMap() {
        return V1beta1TokenReviewSpec.attributeTypeMap;
    }
}
V1beta1TokenReviewSpec.discriminator = undefined;
V1beta1TokenReviewSpec.attributeTypeMap = [
    {
        "name": "audiences",
        "baseName": "audiences",
        "type": "Array<string>"
    },
    {
        "name": "token",
        "baseName": "token",
        "type": "string"
    }
];
exports.V1beta1TokenReviewSpec = V1beta1TokenReviewSpec;
/**
* TokenReviewStatus is the result of the token authentication request.
*/
class V1beta1TokenReviewStatus {
    static getAttributeTypeMap() {
        return V1beta1TokenReviewStatus.attributeTypeMap;
    }
}
V1beta1TokenReviewStatus.discriminator = undefined;
V1beta1TokenReviewStatus.attributeTypeMap = [
    {
        "name": "audiences",
        "baseName": "audiences",
        "type": "Array<string>"
    },
    {
        "name": "authenticated",
        "baseName": "authenticated",
        "type": "boolean"
    },
    {
        "name": "error",
        "baseName": "error",
        "type": "string"
    },
    {
        "name": "user",
        "baseName": "user",
        "type": "V1beta1UserInfo"
    }
];
exports.V1beta1TokenReviewStatus = V1beta1TokenReviewStatus;
/**
* UserInfo holds the information about the user needed to implement the user.Info interface.
*/
class V1beta1UserInfo {
    static getAttributeTypeMap() {
        return V1beta1UserInfo.attributeTypeMap;
    }
}
V1beta1UserInfo.discriminator = undefined;
V1beta1UserInfo.attributeTypeMap = [
    {
        "name": "extra",
        "baseName": "extra",
        "type": "{ [key: string]: Array<string>; }"
    },
    {
        "name": "groups",
        "baseName": "groups",
        "type": "Array<string>"
    },
    {
        "name": "uid",
        "baseName": "uid",
        "type": "string"
    },
    {
        "name": "username",
        "baseName": "username",
        "type": "string"
    }
];
exports.V1beta1UserInfo = V1beta1UserInfo;
/**
* ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.
*/
class V1beta1ValidatingWebhookConfiguration {
    static getAttributeTypeMap() {
        return V1beta1ValidatingWebhookConfiguration.attributeTypeMap;
    }
}
V1beta1ValidatingWebhookConfiguration.discriminator = undefined;
V1beta1ValidatingWebhookConfiguration.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "webhooks",
        "baseName": "webhooks",
        "type": "Array<V1beta1Webhook>"
    }
];
exports.V1beta1ValidatingWebhookConfiguration = V1beta1ValidatingWebhookConfiguration;
/**
* ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.
*/
class V1beta1ValidatingWebhookConfigurationList {
    static getAttributeTypeMap() {
        return V1beta1ValidatingWebhookConfigurationList.attributeTypeMap;
    }
}
V1beta1ValidatingWebhookConfigurationList.discriminator = undefined;
V1beta1ValidatingWebhookConfigurationList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1ValidatingWebhookConfiguration>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1ValidatingWebhookConfigurationList = V1beta1ValidatingWebhookConfigurationList;
/**
* VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.  VolumeAttachment objects are non-namespaced.
*/
class V1beta1VolumeAttachment {
    static getAttributeTypeMap() {
        return V1beta1VolumeAttachment.attributeTypeMap;
    }
}
V1beta1VolumeAttachment.discriminator = undefined;
V1beta1VolumeAttachment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta1VolumeAttachmentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta1VolumeAttachmentStatus"
    }
];
exports.V1beta1VolumeAttachment = V1beta1VolumeAttachment;
/**
* VolumeAttachmentList is a collection of VolumeAttachment objects.
*/
class V1beta1VolumeAttachmentList {
    static getAttributeTypeMap() {
        return V1beta1VolumeAttachmentList.attributeTypeMap;
    }
}
V1beta1VolumeAttachmentList.discriminator = undefined;
V1beta1VolumeAttachmentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta1VolumeAttachment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta1VolumeAttachmentList = V1beta1VolumeAttachmentList;
/**
* VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set.
*/
class V1beta1VolumeAttachmentSource {
    static getAttributeTypeMap() {
        return V1beta1VolumeAttachmentSource.attributeTypeMap;
    }
}
V1beta1VolumeAttachmentSource.discriminator = undefined;
V1beta1VolumeAttachmentSource.attributeTypeMap = [
    {
        "name": "persistentVolumeName",
        "baseName": "persistentVolumeName",
        "type": "string"
    }
];
exports.V1beta1VolumeAttachmentSource = V1beta1VolumeAttachmentSource;
/**
* VolumeAttachmentSpec is the specification of a VolumeAttachment request.
*/
class V1beta1VolumeAttachmentSpec {
    static getAttributeTypeMap() {
        return V1beta1VolumeAttachmentSpec.attributeTypeMap;
    }
}
V1beta1VolumeAttachmentSpec.discriminator = undefined;
V1beta1VolumeAttachmentSpec.attributeTypeMap = [
    {
        "name": "attacher",
        "baseName": "attacher",
        "type": "string"
    },
    {
        "name": "nodeName",
        "baseName": "nodeName",
        "type": "string"
    },
    {
        "name": "source",
        "baseName": "source",
        "type": "V1beta1VolumeAttachmentSource"
    }
];
exports.V1beta1VolumeAttachmentSpec = V1beta1VolumeAttachmentSpec;
/**
* VolumeAttachmentStatus is the status of a VolumeAttachment request.
*/
class V1beta1VolumeAttachmentStatus {
    static getAttributeTypeMap() {
        return V1beta1VolumeAttachmentStatus.attributeTypeMap;
    }
}
V1beta1VolumeAttachmentStatus.discriminator = undefined;
V1beta1VolumeAttachmentStatus.attributeTypeMap = [
    {
        "name": "attachError",
        "baseName": "attachError",
        "type": "V1beta1VolumeError"
    },
    {
        "name": "attached",
        "baseName": "attached",
        "type": "boolean"
    },
    {
        "name": "attachmentMetadata",
        "baseName": "attachmentMetadata",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "detachError",
        "baseName": "detachError",
        "type": "V1beta1VolumeError"
    }
];
exports.V1beta1VolumeAttachmentStatus = V1beta1VolumeAttachmentStatus;
/**
* VolumeError captures an error encountered during a volume operation.
*/
class V1beta1VolumeError {
    static getAttributeTypeMap() {
        return V1beta1VolumeError.attributeTypeMap;
    }
}
V1beta1VolumeError.discriminator = undefined;
V1beta1VolumeError.attributeTypeMap = [
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "time",
        "baseName": "time",
        "type": "Date"
    }
];
exports.V1beta1VolumeError = V1beta1VolumeError;
/**
* Webhook describes an admission webhook and the resources and operations it applies to.
*/
class V1beta1Webhook {
    static getAttributeTypeMap() {
        return V1beta1Webhook.attributeTypeMap;
    }
}
V1beta1Webhook.discriminator = undefined;
V1beta1Webhook.attributeTypeMap = [
    {
        "name": "clientConfig",
        "baseName": "clientConfig",
        "type": "AdmissionregistrationV1beta1WebhookClientConfig"
    },
    {
        "name": "failurePolicy",
        "baseName": "failurePolicy",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "namespaceSelector",
        "baseName": "namespaceSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "rules",
        "baseName": "rules",
        "type": "Array<V1beta1RuleWithOperations>"
    },
    {
        "name": "sideEffects",
        "baseName": "sideEffects",
        "type": "string"
    }
];
exports.V1beta1Webhook = V1beta1Webhook;
/**
* DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
*/
class V1beta2ControllerRevision {
    static getAttributeTypeMap() {
        return V1beta2ControllerRevision.attributeTypeMap;
    }
}
V1beta2ControllerRevision.discriminator = undefined;
V1beta2ControllerRevision.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "data",
        "baseName": "data",
        "type": "RuntimeRawExtension"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "revision",
        "baseName": "revision",
        "type": "number"
    }
];
exports.V1beta2ControllerRevision = V1beta2ControllerRevision;
/**
* ControllerRevisionList is a resource containing a list of ControllerRevision objects.
*/
class V1beta2ControllerRevisionList {
    static getAttributeTypeMap() {
        return V1beta2ControllerRevisionList.attributeTypeMap;
    }
}
V1beta2ControllerRevisionList.discriminator = undefined;
V1beta2ControllerRevisionList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta2ControllerRevision>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta2ControllerRevisionList = V1beta2ControllerRevisionList;
/**
* DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet. See the release notes for more information. DaemonSet represents the configuration of a daemon set.
*/
class V1beta2DaemonSet {
    static getAttributeTypeMap() {
        return V1beta2DaemonSet.attributeTypeMap;
    }
}
V1beta2DaemonSet.discriminator = undefined;
V1beta2DaemonSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta2DaemonSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta2DaemonSetStatus"
    }
];
exports.V1beta2DaemonSet = V1beta2DaemonSet;
/**
* DaemonSetCondition describes the state of a DaemonSet at a certain point.
*/
class V1beta2DaemonSetCondition {
    static getAttributeTypeMap() {
        return V1beta2DaemonSetCondition.attributeTypeMap;
    }
}
V1beta2DaemonSetCondition.discriminator = undefined;
V1beta2DaemonSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2DaemonSetCondition = V1beta2DaemonSetCondition;
/**
* DaemonSetList is a collection of daemon sets.
*/
class V1beta2DaemonSetList {
    static getAttributeTypeMap() {
        return V1beta2DaemonSetList.attributeTypeMap;
    }
}
V1beta2DaemonSetList.discriminator = undefined;
V1beta2DaemonSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta2DaemonSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta2DaemonSetList = V1beta2DaemonSetList;
/**
* DaemonSetSpec is the specification of a daemon set.
*/
class V1beta2DaemonSetSpec {
    static getAttributeTypeMap() {
        return V1beta2DaemonSetSpec.attributeTypeMap;
    }
}
V1beta2DaemonSetSpec.discriminator = undefined;
V1beta2DaemonSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1beta2DaemonSetUpdateStrategy"
    }
];
exports.V1beta2DaemonSetSpec = V1beta2DaemonSetSpec;
/**
* DaemonSetStatus represents the current status of a daemon set.
*/
class V1beta2DaemonSetStatus {
    static getAttributeTypeMap() {
        return V1beta2DaemonSetStatus.attributeTypeMap;
    }
}
V1beta2DaemonSetStatus.discriminator = undefined;
V1beta2DaemonSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta2DaemonSetCondition>"
    },
    {
        "name": "currentNumberScheduled",
        "baseName": "currentNumberScheduled",
        "type": "number"
    },
    {
        "name": "desiredNumberScheduled",
        "baseName": "desiredNumberScheduled",
        "type": "number"
    },
    {
        "name": "numberAvailable",
        "baseName": "numberAvailable",
        "type": "number"
    },
    {
        "name": "numberMisscheduled",
        "baseName": "numberMisscheduled",
        "type": "number"
    },
    {
        "name": "numberReady",
        "baseName": "numberReady",
        "type": "number"
    },
    {
        "name": "numberUnavailable",
        "baseName": "numberUnavailable",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "updatedNumberScheduled",
        "baseName": "updatedNumberScheduled",
        "type": "number"
    }
];
exports.V1beta2DaemonSetStatus = V1beta2DaemonSetStatus;
/**
* DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
*/
class V1beta2DaemonSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1beta2DaemonSetUpdateStrategy.attributeTypeMap;
    }
}
V1beta2DaemonSetUpdateStrategy.discriminator = undefined;
V1beta2DaemonSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1beta2RollingUpdateDaemonSet"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2DaemonSetUpdateStrategy = V1beta2DaemonSetUpdateStrategy;
/**
* DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.
*/
class V1beta2Deployment {
    static getAttributeTypeMap() {
        return V1beta2Deployment.attributeTypeMap;
    }
}
V1beta2Deployment.discriminator = undefined;
V1beta2Deployment.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta2DeploymentSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta2DeploymentStatus"
    }
];
exports.V1beta2Deployment = V1beta2Deployment;
/**
* DeploymentCondition describes the state of a deployment at a certain point.
*/
class V1beta2DeploymentCondition {
    static getAttributeTypeMap() {
        return V1beta2DeploymentCondition.attributeTypeMap;
    }
}
V1beta2DeploymentCondition.discriminator = undefined;
V1beta2DeploymentCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "lastUpdateTime",
        "baseName": "lastUpdateTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2DeploymentCondition = V1beta2DeploymentCondition;
/**
* DeploymentList is a list of Deployments.
*/
class V1beta2DeploymentList {
    static getAttributeTypeMap() {
        return V1beta2DeploymentList.attributeTypeMap;
    }
}
V1beta2DeploymentList.discriminator = undefined;
V1beta2DeploymentList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta2Deployment>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta2DeploymentList = V1beta2DeploymentList;
/**
* DeploymentSpec is the specification of the desired behavior of the Deployment.
*/
class V1beta2DeploymentSpec {
    static getAttributeTypeMap() {
        return V1beta2DeploymentSpec.attributeTypeMap;
    }
}
V1beta2DeploymentSpec.discriminator = undefined;
V1beta2DeploymentSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "paused",
        "baseName": "paused",
        "type": "boolean"
    },
    {
        "name": "progressDeadlineSeconds",
        "baseName": "progressDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "strategy",
        "baseName": "strategy",
        "type": "V1beta2DeploymentStrategy"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1beta2DeploymentSpec = V1beta2DeploymentSpec;
/**
* DeploymentStatus is the most recently observed status of the Deployment.
*/
class V1beta2DeploymentStatus {
    static getAttributeTypeMap() {
        return V1beta2DeploymentStatus.attributeTypeMap;
    }
}
V1beta2DeploymentStatus.discriminator = undefined;
V1beta2DeploymentStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta2DeploymentCondition>"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "unavailableReplicas",
        "baseName": "unavailableReplicas",
        "type": "number"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.V1beta2DeploymentStatus = V1beta2DeploymentStatus;
/**
* DeploymentStrategy describes how to replace existing pods with new ones.
*/
class V1beta2DeploymentStrategy {
    static getAttributeTypeMap() {
        return V1beta2DeploymentStrategy.attributeTypeMap;
    }
}
V1beta2DeploymentStrategy.discriminator = undefined;
V1beta2DeploymentStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1beta2RollingUpdateDeployment"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2DeploymentStrategy = V1beta2DeploymentStrategy;
/**
* DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet. See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.
*/
class V1beta2ReplicaSet {
    static getAttributeTypeMap() {
        return V1beta2ReplicaSet.attributeTypeMap;
    }
}
V1beta2ReplicaSet.discriminator = undefined;
V1beta2ReplicaSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta2ReplicaSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta2ReplicaSetStatus"
    }
];
exports.V1beta2ReplicaSet = V1beta2ReplicaSet;
/**
* ReplicaSetCondition describes the state of a replica set at a certain point.
*/
class V1beta2ReplicaSetCondition {
    static getAttributeTypeMap() {
        return V1beta2ReplicaSetCondition.attributeTypeMap;
    }
}
V1beta2ReplicaSetCondition.discriminator = undefined;
V1beta2ReplicaSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2ReplicaSetCondition = V1beta2ReplicaSetCondition;
/**
* ReplicaSetList is a collection of ReplicaSets.
*/
class V1beta2ReplicaSetList {
    static getAttributeTypeMap() {
        return V1beta2ReplicaSetList.attributeTypeMap;
    }
}
V1beta2ReplicaSetList.discriminator = undefined;
V1beta2ReplicaSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta2ReplicaSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta2ReplicaSetList = V1beta2ReplicaSetList;
/**
* ReplicaSetSpec is the specification of a ReplicaSet.
*/
class V1beta2ReplicaSetSpec {
    static getAttributeTypeMap() {
        return V1beta2ReplicaSetSpec.attributeTypeMap;
    }
}
V1beta2ReplicaSetSpec.discriminator = undefined;
V1beta2ReplicaSetSpec.attributeTypeMap = [
    {
        "name": "minReadySeconds",
        "baseName": "minReadySeconds",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    }
];
exports.V1beta2ReplicaSetSpec = V1beta2ReplicaSetSpec;
/**
* ReplicaSetStatus represents the current status of a ReplicaSet.
*/
class V1beta2ReplicaSetStatus {
    static getAttributeTypeMap() {
        return V1beta2ReplicaSetStatus.attributeTypeMap;
    }
}
V1beta2ReplicaSetStatus.discriminator = undefined;
V1beta2ReplicaSetStatus.attributeTypeMap = [
    {
        "name": "availableReplicas",
        "baseName": "availableReplicas",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta2ReplicaSetCondition>"
    },
    {
        "name": "fullyLabeledReplicas",
        "baseName": "fullyLabeledReplicas",
        "type": "number"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1beta2ReplicaSetStatus = V1beta2ReplicaSetStatus;
/**
* Spec to control the desired behavior of daemon set rolling update.
*/
class V1beta2RollingUpdateDaemonSet {
    static getAttributeTypeMap() {
        return V1beta2RollingUpdateDaemonSet.attributeTypeMap;
    }
}
V1beta2RollingUpdateDaemonSet.discriminator = undefined;
V1beta2RollingUpdateDaemonSet.attributeTypeMap = [
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.V1beta2RollingUpdateDaemonSet = V1beta2RollingUpdateDaemonSet;
/**
* Spec to control the desired behavior of rolling update.
*/
class V1beta2RollingUpdateDeployment {
    static getAttributeTypeMap() {
        return V1beta2RollingUpdateDeployment.attributeTypeMap;
    }
}
V1beta2RollingUpdateDeployment.discriminator = undefined;
V1beta2RollingUpdateDeployment.attributeTypeMap = [
    {
        "name": "maxSurge",
        "baseName": "maxSurge",
        "type": "any"
    },
    {
        "name": "maxUnavailable",
        "baseName": "maxUnavailable",
        "type": "any"
    }
];
exports.V1beta2RollingUpdateDeployment = V1beta2RollingUpdateDeployment;
/**
* RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
*/
class V1beta2RollingUpdateStatefulSetStrategy {
    static getAttributeTypeMap() {
        return V1beta2RollingUpdateStatefulSetStrategy.attributeTypeMap;
    }
}
V1beta2RollingUpdateStatefulSetStrategy.discriminator = undefined;
V1beta2RollingUpdateStatefulSetStrategy.attributeTypeMap = [
    {
        "name": "partition",
        "baseName": "partition",
        "type": "number"
    }
];
exports.V1beta2RollingUpdateStatefulSetStrategy = V1beta2RollingUpdateStatefulSetStrategy;
/**
* Scale represents a scaling request for a resource.
*/
class V1beta2Scale {
    static getAttributeTypeMap() {
        return V1beta2Scale.attributeTypeMap;
    }
}
V1beta2Scale.discriminator = undefined;
V1beta2Scale.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta2ScaleSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta2ScaleStatus"
    }
];
exports.V1beta2Scale = V1beta2Scale;
/**
* ScaleSpec describes the attributes of a scale subresource
*/
class V1beta2ScaleSpec {
    static getAttributeTypeMap() {
        return V1beta2ScaleSpec.attributeTypeMap;
    }
}
V1beta2ScaleSpec.discriminator = undefined;
V1beta2ScaleSpec.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    }
];
exports.V1beta2ScaleSpec = V1beta2ScaleSpec;
/**
* ScaleStatus represents the current status of a scale subresource.
*/
class V1beta2ScaleStatus {
    static getAttributeTypeMap() {
        return V1beta2ScaleStatus.attributeTypeMap;
    }
}
V1beta2ScaleStatus.discriminator = undefined;
V1beta2ScaleStatus.attributeTypeMap = [
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "{ [key: string]: string; }"
    },
    {
        "name": "targetSelector",
        "baseName": "targetSelector",
        "type": "string"
    }
];
exports.V1beta2ScaleStatus = V1beta2ScaleStatus;
/**
* DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:  - Network: A single stable DNS and hostname.  - Storage: As many VolumeClaims as requested. The StatefulSet guarantees that a given network identity will always map to the same storage identity.
*/
class V1beta2StatefulSet {
    static getAttributeTypeMap() {
        return V1beta2StatefulSet.attributeTypeMap;
    }
}
V1beta2StatefulSet.discriminator = undefined;
V1beta2StatefulSet.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1beta2StatefulSetSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V1beta2StatefulSetStatus"
    }
];
exports.V1beta2StatefulSet = V1beta2StatefulSet;
/**
* StatefulSetCondition describes the state of a statefulset at a certain point.
*/
class V1beta2StatefulSetCondition {
    static getAttributeTypeMap() {
        return V1beta2StatefulSetCondition.attributeTypeMap;
    }
}
V1beta2StatefulSetCondition.discriminator = undefined;
V1beta2StatefulSetCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2StatefulSetCondition = V1beta2StatefulSetCondition;
/**
* StatefulSetList is a collection of StatefulSets.
*/
class V1beta2StatefulSetList {
    static getAttributeTypeMap() {
        return V1beta2StatefulSetList.attributeTypeMap;
    }
}
V1beta2StatefulSetList.discriminator = undefined;
V1beta2StatefulSetList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V1beta2StatefulSet>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V1beta2StatefulSetList = V1beta2StatefulSetList;
/**
* A StatefulSetSpec is the specification of a StatefulSet.
*/
class V1beta2StatefulSetSpec {
    static getAttributeTypeMap() {
        return V1beta2StatefulSetSpec.attributeTypeMap;
    }
}
V1beta2StatefulSetSpec.discriminator = undefined;
V1beta2StatefulSetSpec.attributeTypeMap = [
    {
        "name": "podManagementPolicy",
        "baseName": "podManagementPolicy",
        "type": "string"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "revisionHistoryLimit",
        "baseName": "revisionHistoryLimit",
        "type": "number"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "serviceName",
        "baseName": "serviceName",
        "type": "string"
    },
    {
        "name": "template",
        "baseName": "template",
        "type": "V1PodTemplateSpec"
    },
    {
        "name": "updateStrategy",
        "baseName": "updateStrategy",
        "type": "V1beta2StatefulSetUpdateStrategy"
    },
    {
        "name": "volumeClaimTemplates",
        "baseName": "volumeClaimTemplates",
        "type": "Array<V1PersistentVolumeClaim>"
    }
];
exports.V1beta2StatefulSetSpec = V1beta2StatefulSetSpec;
/**
* StatefulSetStatus represents the current state of a StatefulSet.
*/
class V1beta2StatefulSetStatus {
    static getAttributeTypeMap() {
        return V1beta2StatefulSetStatus.attributeTypeMap;
    }
}
V1beta2StatefulSetStatus.discriminator = undefined;
V1beta2StatefulSetStatus.attributeTypeMap = [
    {
        "name": "collisionCount",
        "baseName": "collisionCount",
        "type": "number"
    },
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V1beta2StatefulSetCondition>"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "currentRevision",
        "baseName": "currentRevision",
        "type": "string"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    },
    {
        "name": "readyReplicas",
        "baseName": "readyReplicas",
        "type": "number"
    },
    {
        "name": "replicas",
        "baseName": "replicas",
        "type": "number"
    },
    {
        "name": "updateRevision",
        "baseName": "updateRevision",
        "type": "string"
    },
    {
        "name": "updatedReplicas",
        "baseName": "updatedReplicas",
        "type": "number"
    }
];
exports.V1beta2StatefulSetStatus = V1beta2StatefulSetStatus;
/**
* StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
*/
class V1beta2StatefulSetUpdateStrategy {
    static getAttributeTypeMap() {
        return V1beta2StatefulSetUpdateStrategy.attributeTypeMap;
    }
}
V1beta2StatefulSetUpdateStrategy.discriminator = undefined;
V1beta2StatefulSetUpdateStrategy.attributeTypeMap = [
    {
        "name": "rollingUpdate",
        "baseName": "rollingUpdate",
        "type": "V1beta2RollingUpdateStatefulSetStrategy"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V1beta2StatefulSetUpdateStrategy = V1beta2StatefulSetUpdateStrategy;
/**
* CronJob represents the configuration of a single cron job.
*/
class V2alpha1CronJob {
    static getAttributeTypeMap() {
        return V2alpha1CronJob.attributeTypeMap;
    }
}
V2alpha1CronJob.discriminator = undefined;
V2alpha1CronJob.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V2alpha1CronJobSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V2alpha1CronJobStatus"
    }
];
exports.V2alpha1CronJob = V2alpha1CronJob;
/**
* CronJobList is a collection of cron jobs.
*/
class V2alpha1CronJobList {
    static getAttributeTypeMap() {
        return V2alpha1CronJobList.attributeTypeMap;
    }
}
V2alpha1CronJobList.discriminator = undefined;
V2alpha1CronJobList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V2alpha1CronJob>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V2alpha1CronJobList = V2alpha1CronJobList;
/**
* CronJobSpec describes how the job execution will look like and when it will actually run.
*/
class V2alpha1CronJobSpec {
    static getAttributeTypeMap() {
        return V2alpha1CronJobSpec.attributeTypeMap;
    }
}
V2alpha1CronJobSpec.discriminator = undefined;
V2alpha1CronJobSpec.attributeTypeMap = [
    {
        "name": "concurrencyPolicy",
        "baseName": "concurrencyPolicy",
        "type": "string"
    },
    {
        "name": "failedJobsHistoryLimit",
        "baseName": "failedJobsHistoryLimit",
        "type": "number"
    },
    {
        "name": "jobTemplate",
        "baseName": "jobTemplate",
        "type": "V2alpha1JobTemplateSpec"
    },
    {
        "name": "schedule",
        "baseName": "schedule",
        "type": "string"
    },
    {
        "name": "startingDeadlineSeconds",
        "baseName": "startingDeadlineSeconds",
        "type": "number"
    },
    {
        "name": "successfulJobsHistoryLimit",
        "baseName": "successfulJobsHistoryLimit",
        "type": "number"
    },
    {
        "name": "suspend",
        "baseName": "suspend",
        "type": "boolean"
    }
];
exports.V2alpha1CronJobSpec = V2alpha1CronJobSpec;
/**
* CronJobStatus represents the current state of a cron job.
*/
class V2alpha1CronJobStatus {
    static getAttributeTypeMap() {
        return V2alpha1CronJobStatus.attributeTypeMap;
    }
}
V2alpha1CronJobStatus.discriminator = undefined;
V2alpha1CronJobStatus.attributeTypeMap = [
    {
        "name": "active",
        "baseName": "active",
        "type": "Array<V1ObjectReference>"
    },
    {
        "name": "lastScheduleTime",
        "baseName": "lastScheduleTime",
        "type": "Date"
    }
];
exports.V2alpha1CronJobStatus = V2alpha1CronJobStatus;
/**
* JobTemplateSpec describes the data a Job should have when created from a template
*/
class V2alpha1JobTemplateSpec {
    static getAttributeTypeMap() {
        return V2alpha1JobTemplateSpec.attributeTypeMap;
    }
}
V2alpha1JobTemplateSpec.discriminator = undefined;
V2alpha1JobTemplateSpec.attributeTypeMap = [
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V1JobSpec"
    }
];
exports.V2alpha1JobTemplateSpec = V2alpha1JobTemplateSpec;
/**
* CrossVersionObjectReference contains enough information to let you identify the referred resource.
*/
class V2beta1CrossVersionObjectReference {
    static getAttributeTypeMap() {
        return V2beta1CrossVersionObjectReference.attributeTypeMap;
    }
}
V2beta1CrossVersionObjectReference.discriminator = undefined;
V2beta1CrossVersionObjectReference.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V2beta1CrossVersionObjectReference = V2beta1CrossVersionObjectReference;
/**
* ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one \"target\" type should be set.
*/
class V2beta1ExternalMetricSource {
    static getAttributeTypeMap() {
        return V2beta1ExternalMetricSource.attributeTypeMap;
    }
}
V2beta1ExternalMetricSource.discriminator = undefined;
V2beta1ExternalMetricSource.attributeTypeMap = [
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "metricSelector",
        "baseName": "metricSelector",
        "type": "V1LabelSelector"
    },
    {
        "name": "targetAverageValue",
        "baseName": "targetAverageValue",
        "type": "string"
    },
    {
        "name": "targetValue",
        "baseName": "targetValue",
        "type": "string"
    }
];
exports.V2beta1ExternalMetricSource = V2beta1ExternalMetricSource;
/**
* ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
*/
class V2beta1ExternalMetricStatus {
    static getAttributeTypeMap() {
        return V2beta1ExternalMetricStatus.attributeTypeMap;
    }
}
V2beta1ExternalMetricStatus.discriminator = undefined;
V2beta1ExternalMetricStatus.attributeTypeMap = [
    {
        "name": "currentAverageValue",
        "baseName": "currentAverageValue",
        "type": "string"
    },
    {
        "name": "currentValue",
        "baseName": "currentValue",
        "type": "string"
    },
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "metricSelector",
        "baseName": "metricSelector",
        "type": "V1LabelSelector"
    }
];
exports.V2beta1ExternalMetricStatus = V2beta1ExternalMetricStatus;
/**
* HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
*/
class V2beta1HorizontalPodAutoscaler {
    static getAttributeTypeMap() {
        return V2beta1HorizontalPodAutoscaler.attributeTypeMap;
    }
}
V2beta1HorizontalPodAutoscaler.discriminator = undefined;
V2beta1HorizontalPodAutoscaler.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V2beta1HorizontalPodAutoscalerSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V2beta1HorizontalPodAutoscalerStatus"
    }
];
exports.V2beta1HorizontalPodAutoscaler = V2beta1HorizontalPodAutoscaler;
/**
* HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
*/
class V2beta1HorizontalPodAutoscalerCondition {
    static getAttributeTypeMap() {
        return V2beta1HorizontalPodAutoscalerCondition.attributeTypeMap;
    }
}
V2beta1HorizontalPodAutoscalerCondition.discriminator = undefined;
V2beta1HorizontalPodAutoscalerCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta1HorizontalPodAutoscalerCondition = V2beta1HorizontalPodAutoscalerCondition;
/**
* HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.
*/
class V2beta1HorizontalPodAutoscalerList {
    static getAttributeTypeMap() {
        return V2beta1HorizontalPodAutoscalerList.attributeTypeMap;
    }
}
V2beta1HorizontalPodAutoscalerList.discriminator = undefined;
V2beta1HorizontalPodAutoscalerList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V2beta1HorizontalPodAutoscaler>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V2beta1HorizontalPodAutoscalerList = V2beta1HorizontalPodAutoscalerList;
/**
* HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
*/
class V2beta1HorizontalPodAutoscalerSpec {
    static getAttributeTypeMap() {
        return V2beta1HorizontalPodAutoscalerSpec.attributeTypeMap;
    }
}
V2beta1HorizontalPodAutoscalerSpec.discriminator = undefined;
V2beta1HorizontalPodAutoscalerSpec.attributeTypeMap = [
    {
        "name": "maxReplicas",
        "baseName": "maxReplicas",
        "type": "number"
    },
    {
        "name": "metrics",
        "baseName": "metrics",
        "type": "Array<V2beta1MetricSpec>"
    },
    {
        "name": "minReplicas",
        "baseName": "minReplicas",
        "type": "number"
    },
    {
        "name": "scaleTargetRef",
        "baseName": "scaleTargetRef",
        "type": "V2beta1CrossVersionObjectReference"
    }
];
exports.V2beta1HorizontalPodAutoscalerSpec = V2beta1HorizontalPodAutoscalerSpec;
/**
* HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
*/
class V2beta1HorizontalPodAutoscalerStatus {
    static getAttributeTypeMap() {
        return V2beta1HorizontalPodAutoscalerStatus.attributeTypeMap;
    }
}
V2beta1HorizontalPodAutoscalerStatus.discriminator = undefined;
V2beta1HorizontalPodAutoscalerStatus.attributeTypeMap = [
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V2beta1HorizontalPodAutoscalerCondition>"
    },
    {
        "name": "currentMetrics",
        "baseName": "currentMetrics",
        "type": "Array<V2beta1MetricStatus>"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "desiredReplicas",
        "baseName": "desiredReplicas",
        "type": "number"
    },
    {
        "name": "lastScaleTime",
        "baseName": "lastScaleTime",
        "type": "Date"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    }
];
exports.V2beta1HorizontalPodAutoscalerStatus = V2beta1HorizontalPodAutoscalerStatus;
/**
* MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
*/
class V2beta1MetricSpec {
    static getAttributeTypeMap() {
        return V2beta1MetricSpec.attributeTypeMap;
    }
}
V2beta1MetricSpec.discriminator = undefined;
V2beta1MetricSpec.attributeTypeMap = [
    {
        "name": "external",
        "baseName": "external",
        "type": "V2beta1ExternalMetricSource"
    },
    {
        "name": "object",
        "baseName": "object",
        "type": "V2beta1ObjectMetricSource"
    },
    {
        "name": "pods",
        "baseName": "pods",
        "type": "V2beta1PodsMetricSource"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "V2beta1ResourceMetricSource"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta1MetricSpec = V2beta1MetricSpec;
/**
* MetricStatus describes the last-read state of a single metric.
*/
class V2beta1MetricStatus {
    static getAttributeTypeMap() {
        return V2beta1MetricStatus.attributeTypeMap;
    }
}
V2beta1MetricStatus.discriminator = undefined;
V2beta1MetricStatus.attributeTypeMap = [
    {
        "name": "external",
        "baseName": "external",
        "type": "V2beta1ExternalMetricStatus"
    },
    {
        "name": "object",
        "baseName": "object",
        "type": "V2beta1ObjectMetricStatus"
    },
    {
        "name": "pods",
        "baseName": "pods",
        "type": "V2beta1PodsMetricStatus"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "V2beta1ResourceMetricStatus"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta1MetricStatus = V2beta1MetricStatus;
/**
* ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
*/
class V2beta1ObjectMetricSource {
    static getAttributeTypeMap() {
        return V2beta1ObjectMetricSource.attributeTypeMap;
    }
}
V2beta1ObjectMetricSource.discriminator = undefined;
V2beta1ObjectMetricSource.attributeTypeMap = [
    {
        "name": "averageValue",
        "baseName": "averageValue",
        "type": "string"
    },
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta1CrossVersionObjectReference"
    },
    {
        "name": "targetValue",
        "baseName": "targetValue",
        "type": "string"
    }
];
exports.V2beta1ObjectMetricSource = V2beta1ObjectMetricSource;
/**
* ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
*/
class V2beta1ObjectMetricStatus {
    static getAttributeTypeMap() {
        return V2beta1ObjectMetricStatus.attributeTypeMap;
    }
}
V2beta1ObjectMetricStatus.discriminator = undefined;
V2beta1ObjectMetricStatus.attributeTypeMap = [
    {
        "name": "averageValue",
        "baseName": "averageValue",
        "type": "string"
    },
    {
        "name": "currentValue",
        "baseName": "currentValue",
        "type": "string"
    },
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta1CrossVersionObjectReference"
    }
];
exports.V2beta1ObjectMetricStatus = V2beta1ObjectMetricStatus;
/**
* PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
*/
class V2beta1PodsMetricSource {
    static getAttributeTypeMap() {
        return V2beta1PodsMetricSource.attributeTypeMap;
    }
}
V2beta1PodsMetricSource.discriminator = undefined;
V2beta1PodsMetricSource.attributeTypeMap = [
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    },
    {
        "name": "targetAverageValue",
        "baseName": "targetAverageValue",
        "type": "string"
    }
];
exports.V2beta1PodsMetricSource = V2beta1PodsMetricSource;
/**
* PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
*/
class V2beta1PodsMetricStatus {
    static getAttributeTypeMap() {
        return V2beta1PodsMetricStatus.attributeTypeMap;
    }
}
V2beta1PodsMetricStatus.discriminator = undefined;
V2beta1PodsMetricStatus.attributeTypeMap = [
    {
        "name": "currentAverageValue",
        "baseName": "currentAverageValue",
        "type": "string"
    },
    {
        "name": "metricName",
        "baseName": "metricName",
        "type": "string"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    }
];
exports.V2beta1PodsMetricStatus = V2beta1PodsMetricStatus;
/**
* ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.
*/
class V2beta1ResourceMetricSource {
    static getAttributeTypeMap() {
        return V2beta1ResourceMetricSource.attributeTypeMap;
    }
}
V2beta1ResourceMetricSource.discriminator = undefined;
V2beta1ResourceMetricSource.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "targetAverageUtilization",
        "baseName": "targetAverageUtilization",
        "type": "number"
    },
    {
        "name": "targetAverageValue",
        "baseName": "targetAverageValue",
        "type": "string"
    }
];
exports.V2beta1ResourceMetricSource = V2beta1ResourceMetricSource;
/**
* ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.
*/
class V2beta1ResourceMetricStatus {
    static getAttributeTypeMap() {
        return V2beta1ResourceMetricStatus.attributeTypeMap;
    }
}
V2beta1ResourceMetricStatus.discriminator = undefined;
V2beta1ResourceMetricStatus.attributeTypeMap = [
    {
        "name": "currentAverageUtilization",
        "baseName": "currentAverageUtilization",
        "type": "number"
    },
    {
        "name": "currentAverageValue",
        "baseName": "currentAverageValue",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V2beta1ResourceMetricStatus = V2beta1ResourceMetricStatus;
/**
* CrossVersionObjectReference contains enough information to let you identify the referred resource.
*/
class V2beta2CrossVersionObjectReference {
    static getAttributeTypeMap() {
        return V2beta2CrossVersionObjectReference.attributeTypeMap;
    }
}
V2beta2CrossVersionObjectReference.discriminator = undefined;
V2beta2CrossVersionObjectReference.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V2beta2CrossVersionObjectReference = V2beta2CrossVersionObjectReference;
/**
* ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
*/
class V2beta2ExternalMetricSource {
    static getAttributeTypeMap() {
        return V2beta2ExternalMetricSource.attributeTypeMap;
    }
}
V2beta2ExternalMetricSource.discriminator = undefined;
V2beta2ExternalMetricSource.attributeTypeMap = [
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta2MetricTarget"
    }
];
exports.V2beta2ExternalMetricSource = V2beta2ExternalMetricSource;
/**
* ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
*/
class V2beta2ExternalMetricStatus {
    static getAttributeTypeMap() {
        return V2beta2ExternalMetricStatus.attributeTypeMap;
    }
}
V2beta2ExternalMetricStatus.discriminator = undefined;
V2beta2ExternalMetricStatus.attributeTypeMap = [
    {
        "name": "current",
        "baseName": "current",
        "type": "V2beta2MetricValueStatus"
    },
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    }
];
exports.V2beta2ExternalMetricStatus = V2beta2ExternalMetricStatus;
/**
* HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
*/
class V2beta2HorizontalPodAutoscaler {
    static getAttributeTypeMap() {
        return V2beta2HorizontalPodAutoscaler.attributeTypeMap;
    }
}
V2beta2HorizontalPodAutoscaler.discriminator = undefined;
V2beta2HorizontalPodAutoscaler.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ObjectMeta"
    },
    {
        "name": "spec",
        "baseName": "spec",
        "type": "V2beta2HorizontalPodAutoscalerSpec"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "V2beta2HorizontalPodAutoscalerStatus"
    }
];
exports.V2beta2HorizontalPodAutoscaler = V2beta2HorizontalPodAutoscaler;
/**
* HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
*/
class V2beta2HorizontalPodAutoscalerCondition {
    static getAttributeTypeMap() {
        return V2beta2HorizontalPodAutoscalerCondition.attributeTypeMap;
    }
}
V2beta2HorizontalPodAutoscalerCondition.discriminator = undefined;
V2beta2HorizontalPodAutoscalerCondition.attributeTypeMap = [
    {
        "name": "lastTransitionTime",
        "baseName": "lastTransitionTime",
        "type": "Date"
    },
    {
        "name": "message",
        "baseName": "message",
        "type": "string"
    },
    {
        "name": "reason",
        "baseName": "reason",
        "type": "string"
    },
    {
        "name": "status",
        "baseName": "status",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta2HorizontalPodAutoscalerCondition = V2beta2HorizontalPodAutoscalerCondition;
/**
* HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.
*/
class V2beta2HorizontalPodAutoscalerList {
    static getAttributeTypeMap() {
        return V2beta2HorizontalPodAutoscalerList.attributeTypeMap;
    }
}
V2beta2HorizontalPodAutoscalerList.discriminator = undefined;
V2beta2HorizontalPodAutoscalerList.attributeTypeMap = [
    {
        "name": "apiVersion",
        "baseName": "apiVersion",
        "type": "string"
    },
    {
        "name": "items",
        "baseName": "items",
        "type": "Array<V2beta2HorizontalPodAutoscaler>"
    },
    {
        "name": "kind",
        "baseName": "kind",
        "type": "string"
    },
    {
        "name": "metadata",
        "baseName": "metadata",
        "type": "V1ListMeta"
    }
];
exports.V2beta2HorizontalPodAutoscalerList = V2beta2HorizontalPodAutoscalerList;
/**
* HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
*/
class V2beta2HorizontalPodAutoscalerSpec {
    static getAttributeTypeMap() {
        return V2beta2HorizontalPodAutoscalerSpec.attributeTypeMap;
    }
}
V2beta2HorizontalPodAutoscalerSpec.discriminator = undefined;
V2beta2HorizontalPodAutoscalerSpec.attributeTypeMap = [
    {
        "name": "maxReplicas",
        "baseName": "maxReplicas",
        "type": "number"
    },
    {
        "name": "metrics",
        "baseName": "metrics",
        "type": "Array<V2beta2MetricSpec>"
    },
    {
        "name": "minReplicas",
        "baseName": "minReplicas",
        "type": "number"
    },
    {
        "name": "scaleTargetRef",
        "baseName": "scaleTargetRef",
        "type": "V2beta2CrossVersionObjectReference"
    }
];
exports.V2beta2HorizontalPodAutoscalerSpec = V2beta2HorizontalPodAutoscalerSpec;
/**
* HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
*/
class V2beta2HorizontalPodAutoscalerStatus {
    static getAttributeTypeMap() {
        return V2beta2HorizontalPodAutoscalerStatus.attributeTypeMap;
    }
}
V2beta2HorizontalPodAutoscalerStatus.discriminator = undefined;
V2beta2HorizontalPodAutoscalerStatus.attributeTypeMap = [
    {
        "name": "conditions",
        "baseName": "conditions",
        "type": "Array<V2beta2HorizontalPodAutoscalerCondition>"
    },
    {
        "name": "currentMetrics",
        "baseName": "currentMetrics",
        "type": "Array<V2beta2MetricStatus>"
    },
    {
        "name": "currentReplicas",
        "baseName": "currentReplicas",
        "type": "number"
    },
    {
        "name": "desiredReplicas",
        "baseName": "desiredReplicas",
        "type": "number"
    },
    {
        "name": "lastScaleTime",
        "baseName": "lastScaleTime",
        "type": "Date"
    },
    {
        "name": "observedGeneration",
        "baseName": "observedGeneration",
        "type": "number"
    }
];
exports.V2beta2HorizontalPodAutoscalerStatus = V2beta2HorizontalPodAutoscalerStatus;
/**
* MetricIdentifier defines the name and optionally selector for a metric
*/
class V2beta2MetricIdentifier {
    static getAttributeTypeMap() {
        return V2beta2MetricIdentifier.attributeTypeMap;
    }
}
V2beta2MetricIdentifier.discriminator = undefined;
V2beta2MetricIdentifier.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "selector",
        "baseName": "selector",
        "type": "V1LabelSelector"
    }
];
exports.V2beta2MetricIdentifier = V2beta2MetricIdentifier;
/**
* MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
*/
class V2beta2MetricSpec {
    static getAttributeTypeMap() {
        return V2beta2MetricSpec.attributeTypeMap;
    }
}
V2beta2MetricSpec.discriminator = undefined;
V2beta2MetricSpec.attributeTypeMap = [
    {
        "name": "external",
        "baseName": "external",
        "type": "V2beta2ExternalMetricSource"
    },
    {
        "name": "object",
        "baseName": "object",
        "type": "V2beta2ObjectMetricSource"
    },
    {
        "name": "pods",
        "baseName": "pods",
        "type": "V2beta2PodsMetricSource"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "V2beta2ResourceMetricSource"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta2MetricSpec = V2beta2MetricSpec;
/**
* MetricStatus describes the last-read state of a single metric.
*/
class V2beta2MetricStatus {
    static getAttributeTypeMap() {
        return V2beta2MetricStatus.attributeTypeMap;
    }
}
V2beta2MetricStatus.discriminator = undefined;
V2beta2MetricStatus.attributeTypeMap = [
    {
        "name": "external",
        "baseName": "external",
        "type": "V2beta2ExternalMetricStatus"
    },
    {
        "name": "object",
        "baseName": "object",
        "type": "V2beta2ObjectMetricStatus"
    },
    {
        "name": "pods",
        "baseName": "pods",
        "type": "V2beta2PodsMetricStatus"
    },
    {
        "name": "resource",
        "baseName": "resource",
        "type": "V2beta2ResourceMetricStatus"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    }
];
exports.V2beta2MetricStatus = V2beta2MetricStatus;
/**
* MetricTarget defines the target value, average value, or average utilization of a specific metric
*/
class V2beta2MetricTarget {
    static getAttributeTypeMap() {
        return V2beta2MetricTarget.attributeTypeMap;
    }
}
V2beta2MetricTarget.discriminator = undefined;
V2beta2MetricTarget.attributeTypeMap = [
    {
        "name": "averageUtilization",
        "baseName": "averageUtilization",
        "type": "number"
    },
    {
        "name": "averageValue",
        "baseName": "averageValue",
        "type": "string"
    },
    {
        "name": "type",
        "baseName": "type",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V2beta2MetricTarget = V2beta2MetricTarget;
/**
* MetricValueStatus holds the current value for a metric
*/
class V2beta2MetricValueStatus {
    static getAttributeTypeMap() {
        return V2beta2MetricValueStatus.attributeTypeMap;
    }
}
V2beta2MetricValueStatus.discriminator = undefined;
V2beta2MetricValueStatus.attributeTypeMap = [
    {
        "name": "averageUtilization",
        "baseName": "averageUtilization",
        "type": "number"
    },
    {
        "name": "averageValue",
        "baseName": "averageValue",
        "type": "string"
    },
    {
        "name": "value",
        "baseName": "value",
        "type": "string"
    }
];
exports.V2beta2MetricValueStatus = V2beta2MetricValueStatus;
/**
* ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
*/
class V2beta2ObjectMetricSource {
    static getAttributeTypeMap() {
        return V2beta2ObjectMetricSource.attributeTypeMap;
    }
}
V2beta2ObjectMetricSource.discriminator = undefined;
V2beta2ObjectMetricSource.attributeTypeMap = [
    {
        "name": "describedObject",
        "baseName": "describedObject",
        "type": "V2beta2CrossVersionObjectReference"
    },
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta2MetricTarget"
    }
];
exports.V2beta2ObjectMetricSource = V2beta2ObjectMetricSource;
/**
* ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
*/
class V2beta2ObjectMetricStatus {
    static getAttributeTypeMap() {
        return V2beta2ObjectMetricStatus.attributeTypeMap;
    }
}
V2beta2ObjectMetricStatus.discriminator = undefined;
V2beta2ObjectMetricStatus.attributeTypeMap = [
    {
        "name": "current",
        "baseName": "current",
        "type": "V2beta2MetricValueStatus"
    },
    {
        "name": "describedObject",
        "baseName": "describedObject",
        "type": "V2beta2CrossVersionObjectReference"
    },
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    }
];
exports.V2beta2ObjectMetricStatus = V2beta2ObjectMetricStatus;
/**
* PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
*/
class V2beta2PodsMetricSource {
    static getAttributeTypeMap() {
        return V2beta2PodsMetricSource.attributeTypeMap;
    }
}
V2beta2PodsMetricSource.discriminator = undefined;
V2beta2PodsMetricSource.attributeTypeMap = [
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta2MetricTarget"
    }
];
exports.V2beta2PodsMetricSource = V2beta2PodsMetricSource;
/**
* PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
*/
class V2beta2PodsMetricStatus {
    static getAttributeTypeMap() {
        return V2beta2PodsMetricStatus.attributeTypeMap;
    }
}
V2beta2PodsMetricStatus.discriminator = undefined;
V2beta2PodsMetricStatus.attributeTypeMap = [
    {
        "name": "current",
        "baseName": "current",
        "type": "V2beta2MetricValueStatus"
    },
    {
        "name": "metric",
        "baseName": "metric",
        "type": "V2beta2MetricIdentifier"
    }
];
exports.V2beta2PodsMetricStatus = V2beta2PodsMetricStatus;
/**
* ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.
*/
class V2beta2ResourceMetricSource {
    static getAttributeTypeMap() {
        return V2beta2ResourceMetricSource.attributeTypeMap;
    }
}
V2beta2ResourceMetricSource.discriminator = undefined;
V2beta2ResourceMetricSource.attributeTypeMap = [
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    },
    {
        "name": "target",
        "baseName": "target",
        "type": "V2beta2MetricTarget"
    }
];
exports.V2beta2ResourceMetricSource = V2beta2ResourceMetricSource;
/**
* ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.
*/
class V2beta2ResourceMetricStatus {
    static getAttributeTypeMap() {
        return V2beta2ResourceMetricStatus.attributeTypeMap;
    }
}
V2beta2ResourceMetricStatus.discriminator = undefined;
V2beta2ResourceMetricStatus.attributeTypeMap = [
    {
        "name": "current",
        "baseName": "current",
        "type": "V2beta2MetricValueStatus"
    },
    {
        "name": "name",
        "baseName": "name",
        "type": "string"
    }
];
exports.V2beta2ResourceMetricStatus = V2beta2ResourceMetricStatus;
/**
* Info contains versioning information. how we'll want to distribute that information.
*/
class VersionInfo {
    static getAttributeTypeMap() {
        return VersionInfo.attributeTypeMap;
    }
}
VersionInfo.discriminator = undefined;
VersionInfo.attributeTypeMap = [
    {
        "name": "buildDate",
        "baseName": "buildDate",
        "type": "string"
    },
    {
        "name": "compiler",
        "baseName": "compiler",
        "type": "string"
    },
    {
        "name": "gitCommit",
        "baseName": "gitCommit",
        "type": "string"
    },
    {
        "name": "gitTreeState",
        "baseName": "gitTreeState",
        "type": "string"
    },
    {
        "name": "gitVersion",
        "baseName": "gitVersion",
        "type": "string"
    },
    {
        "name": "goVersion",
        "baseName": "goVersion",
        "type": "string"
    },
    {
        "name": "major",
        "baseName": "major",
        "type": "string"
    },
    {
        "name": "minor",
        "baseName": "minor",
        "type": "string"
    },
    {
        "name": "platform",
        "baseName": "platform",
        "type": "string"
    }
];
exports.VersionInfo = VersionInfo;
let enumsMap = {};
let typeMap = {
    "AdmissionregistrationV1beta1ServiceReference": AdmissionregistrationV1beta1ServiceReference,
    "AdmissionregistrationV1beta1WebhookClientConfig": AdmissionregistrationV1beta1WebhookClientConfig,
    "ApiextensionsV1beta1ServiceReference": ApiextensionsV1beta1ServiceReference,
    "ApiextensionsV1beta1WebhookClientConfig": ApiextensionsV1beta1WebhookClientConfig,
    "ApiregistrationV1beta1ServiceReference": ApiregistrationV1beta1ServiceReference,
    "AppsV1beta1Deployment": AppsV1beta1Deployment,
    "AppsV1beta1DeploymentCondition": AppsV1beta1DeploymentCondition,
    "AppsV1beta1DeploymentList": AppsV1beta1DeploymentList,
    "AppsV1beta1DeploymentRollback": AppsV1beta1DeploymentRollback,
    "AppsV1beta1DeploymentSpec": AppsV1beta1DeploymentSpec,
    "AppsV1beta1DeploymentStatus": AppsV1beta1DeploymentStatus,
    "AppsV1beta1DeploymentStrategy": AppsV1beta1DeploymentStrategy,
    "AppsV1beta1RollbackConfig": AppsV1beta1RollbackConfig,
    "AppsV1beta1RollingUpdateDeployment": AppsV1beta1RollingUpdateDeployment,
    "AppsV1beta1Scale": AppsV1beta1Scale,
    "AppsV1beta1ScaleSpec": AppsV1beta1ScaleSpec,
    "AppsV1beta1ScaleStatus": AppsV1beta1ScaleStatus,
    "ExtensionsV1beta1AllowedFlexVolume": ExtensionsV1beta1AllowedFlexVolume,
    "ExtensionsV1beta1AllowedHostPath": ExtensionsV1beta1AllowedHostPath,
    "ExtensionsV1beta1Deployment": ExtensionsV1beta1Deployment,
    "ExtensionsV1beta1DeploymentCondition": ExtensionsV1beta1DeploymentCondition,
    "ExtensionsV1beta1DeploymentList": ExtensionsV1beta1DeploymentList,
    "ExtensionsV1beta1DeploymentRollback": ExtensionsV1beta1DeploymentRollback,
    "ExtensionsV1beta1DeploymentSpec": ExtensionsV1beta1DeploymentSpec,
    "ExtensionsV1beta1DeploymentStatus": ExtensionsV1beta1DeploymentStatus,
    "ExtensionsV1beta1DeploymentStrategy": ExtensionsV1beta1DeploymentStrategy,
    "ExtensionsV1beta1FSGroupStrategyOptions": ExtensionsV1beta1FSGroupStrategyOptions,
    "ExtensionsV1beta1HostPortRange": ExtensionsV1beta1HostPortRange,
    "ExtensionsV1beta1IDRange": ExtensionsV1beta1IDRange,
    "ExtensionsV1beta1PodSecurityPolicy": ExtensionsV1beta1PodSecurityPolicy,
    "ExtensionsV1beta1PodSecurityPolicyList": ExtensionsV1beta1PodSecurityPolicyList,
    "ExtensionsV1beta1PodSecurityPolicySpec": ExtensionsV1beta1PodSecurityPolicySpec,
    "ExtensionsV1beta1RollbackConfig": ExtensionsV1beta1RollbackConfig,
    "ExtensionsV1beta1RollingUpdateDeployment": ExtensionsV1beta1RollingUpdateDeployment,
    "ExtensionsV1beta1RunAsGroupStrategyOptions": ExtensionsV1beta1RunAsGroupStrategyOptions,
    "ExtensionsV1beta1RunAsUserStrategyOptions": ExtensionsV1beta1RunAsUserStrategyOptions,
    "ExtensionsV1beta1SELinuxStrategyOptions": ExtensionsV1beta1SELinuxStrategyOptions,
    "ExtensionsV1beta1Scale": ExtensionsV1beta1Scale,
    "ExtensionsV1beta1ScaleSpec": ExtensionsV1beta1ScaleSpec,
    "ExtensionsV1beta1ScaleStatus": ExtensionsV1beta1ScaleStatus,
    "ExtensionsV1beta1SupplementalGroupsStrategyOptions": ExtensionsV1beta1SupplementalGroupsStrategyOptions,
    "PolicyV1beta1AllowedFlexVolume": PolicyV1beta1AllowedFlexVolume,
    "PolicyV1beta1AllowedHostPath": PolicyV1beta1AllowedHostPath,
    "PolicyV1beta1FSGroupStrategyOptions": PolicyV1beta1FSGroupStrategyOptions,
    "PolicyV1beta1HostPortRange": PolicyV1beta1HostPortRange,
    "PolicyV1beta1IDRange": PolicyV1beta1IDRange,
    "PolicyV1beta1PodSecurityPolicy": PolicyV1beta1PodSecurityPolicy,
    "PolicyV1beta1PodSecurityPolicyList": PolicyV1beta1PodSecurityPolicyList,
    "PolicyV1beta1PodSecurityPolicySpec": PolicyV1beta1PodSecurityPolicySpec,
    "PolicyV1beta1RunAsGroupStrategyOptions": PolicyV1beta1RunAsGroupStrategyOptions,
    "PolicyV1beta1RunAsUserStrategyOptions": PolicyV1beta1RunAsUserStrategyOptions,
    "PolicyV1beta1SELinuxStrategyOptions": PolicyV1beta1SELinuxStrategyOptions,
    "PolicyV1beta1SupplementalGroupsStrategyOptions": PolicyV1beta1SupplementalGroupsStrategyOptions,
    "RuntimeRawExtension": RuntimeRawExtension,
    "V1APIGroup": V1APIGroup,
    "V1APIGroupList": V1APIGroupList,
    "V1APIResource": V1APIResource,
    "V1APIResourceList": V1APIResourceList,
    "V1APIService": V1APIService,
    "V1APIServiceCondition": V1APIServiceCondition,
    "V1APIServiceList": V1APIServiceList,
    "V1APIServiceSpec": V1APIServiceSpec,
    "V1APIServiceStatus": V1APIServiceStatus,
    "V1APIVersions": V1APIVersions,
    "V1AWSElasticBlockStoreVolumeSource": V1AWSElasticBlockStoreVolumeSource,
    "V1Affinity": V1Affinity,
    "V1AggregationRule": V1AggregationRule,
    "V1AttachedVolume": V1AttachedVolume,
    "V1AzureDiskVolumeSource": V1AzureDiskVolumeSource,
    "V1AzureFilePersistentVolumeSource": V1AzureFilePersistentVolumeSource,
    "V1AzureFileVolumeSource": V1AzureFileVolumeSource,
    "V1Binding": V1Binding,
    "V1CSIPersistentVolumeSource": V1CSIPersistentVolumeSource,
    "V1Capabilities": V1Capabilities,
    "V1CephFSPersistentVolumeSource": V1CephFSPersistentVolumeSource,
    "V1CephFSVolumeSource": V1CephFSVolumeSource,
    "V1CinderPersistentVolumeSource": V1CinderPersistentVolumeSource,
    "V1CinderVolumeSource": V1CinderVolumeSource,
    "V1ClientIPConfig": V1ClientIPConfig,
    "V1ClusterRole": V1ClusterRole,
    "V1ClusterRoleBinding": V1ClusterRoleBinding,
    "V1ClusterRoleBindingList": V1ClusterRoleBindingList,
    "V1ClusterRoleList": V1ClusterRoleList,
    "V1ComponentCondition": V1ComponentCondition,
    "V1ComponentStatus": V1ComponentStatus,
    "V1ComponentStatusList": V1ComponentStatusList,
    "V1ConfigMap": V1ConfigMap,
    "V1ConfigMapEnvSource": V1ConfigMapEnvSource,
    "V1ConfigMapKeySelector": V1ConfigMapKeySelector,
    "V1ConfigMapList": V1ConfigMapList,
    "V1ConfigMapNodeConfigSource": V1ConfigMapNodeConfigSource,
    "V1ConfigMapProjection": V1ConfigMapProjection,
    "V1ConfigMapVolumeSource": V1ConfigMapVolumeSource,
    "V1Container": V1Container,
    "V1ContainerImage": V1ContainerImage,
    "V1ContainerPort": V1ContainerPort,
    "V1ContainerState": V1ContainerState,
    "V1ContainerStateRunning": V1ContainerStateRunning,
    "V1ContainerStateTerminated": V1ContainerStateTerminated,
    "V1ContainerStateWaiting": V1ContainerStateWaiting,
    "V1ContainerStatus": V1ContainerStatus,
    "V1ControllerRevision": V1ControllerRevision,
    "V1ControllerRevisionList": V1ControllerRevisionList,
    "V1CrossVersionObjectReference": V1CrossVersionObjectReference,
    "V1DaemonEndpoint": V1DaemonEndpoint,
    "V1DaemonSet": V1DaemonSet,
    "V1DaemonSetCondition": V1DaemonSetCondition,
    "V1DaemonSetList": V1DaemonSetList,
    "V1DaemonSetSpec": V1DaemonSetSpec,
    "V1DaemonSetStatus": V1DaemonSetStatus,
    "V1DaemonSetUpdateStrategy": V1DaemonSetUpdateStrategy,
    "V1DeleteOptions": V1DeleteOptions,
    "V1Deployment": V1Deployment,
    "V1DeploymentCondition": V1DeploymentCondition,
    "V1DeploymentList": V1DeploymentList,
    "V1DeploymentSpec": V1DeploymentSpec,
    "V1DeploymentStatus": V1DeploymentStatus,
    "V1DeploymentStrategy": V1DeploymentStrategy,
    "V1DownwardAPIProjection": V1DownwardAPIProjection,
    "V1DownwardAPIVolumeFile": V1DownwardAPIVolumeFile,
    "V1DownwardAPIVolumeSource": V1DownwardAPIVolumeSource,
    "V1EmptyDirVolumeSource": V1EmptyDirVolumeSource,
    "V1EndpointAddress": V1EndpointAddress,
    "V1EndpointPort": V1EndpointPort,
    "V1EndpointSubset": V1EndpointSubset,
    "V1Endpoints": V1Endpoints,
    "V1EndpointsList": V1EndpointsList,
    "V1EnvFromSource": V1EnvFromSource,
    "V1EnvVar": V1EnvVar,
    "V1EnvVarSource": V1EnvVarSource,
    "V1Event": V1Event,
    "V1EventList": V1EventList,
    "V1EventSeries": V1EventSeries,
    "V1EventSource": V1EventSource,
    "V1ExecAction": V1ExecAction,
    "V1FCVolumeSource": V1FCVolumeSource,
    "V1FlexPersistentVolumeSource": V1FlexPersistentVolumeSource,
    "V1FlexVolumeSource": V1FlexVolumeSource,
    "V1FlockerVolumeSource": V1FlockerVolumeSource,
    "V1GCEPersistentDiskVolumeSource": V1GCEPersistentDiskVolumeSource,
    "V1GitRepoVolumeSource": V1GitRepoVolumeSource,
    "V1GlusterfsPersistentVolumeSource": V1GlusterfsPersistentVolumeSource,
    "V1GlusterfsVolumeSource": V1GlusterfsVolumeSource,
    "V1GroupVersionForDiscovery": V1GroupVersionForDiscovery,
    "V1HTTPGetAction": V1HTTPGetAction,
    "V1HTTPHeader": V1HTTPHeader,
    "V1Handler": V1Handler,
    "V1HorizontalPodAutoscaler": V1HorizontalPodAutoscaler,
    "V1HorizontalPodAutoscalerList": V1HorizontalPodAutoscalerList,
    "V1HorizontalPodAutoscalerSpec": V1HorizontalPodAutoscalerSpec,
    "V1HorizontalPodAutoscalerStatus": V1HorizontalPodAutoscalerStatus,
    "V1HostAlias": V1HostAlias,
    "V1HostPathVolumeSource": V1HostPathVolumeSource,
    "V1IPBlock": V1IPBlock,
    "V1ISCSIPersistentVolumeSource": V1ISCSIPersistentVolumeSource,
    "V1ISCSIVolumeSource": V1ISCSIVolumeSource,
    "V1Initializer": V1Initializer,
    "V1Initializers": V1Initializers,
    "V1Job": V1Job,
    "V1JobCondition": V1JobCondition,
    "V1JobList": V1JobList,
    "V1JobSpec": V1JobSpec,
    "V1JobStatus": V1JobStatus,
    "V1KeyToPath": V1KeyToPath,
    "V1LabelSelector": V1LabelSelector,
    "V1LabelSelectorRequirement": V1LabelSelectorRequirement,
    "V1Lifecycle": V1Lifecycle,
    "V1LimitRange": V1LimitRange,
    "V1LimitRangeItem": V1LimitRangeItem,
    "V1LimitRangeList": V1LimitRangeList,
    "V1LimitRangeSpec": V1LimitRangeSpec,
    "V1ListMeta": V1ListMeta,
    "V1LoadBalancerIngress": V1LoadBalancerIngress,
    "V1LoadBalancerStatus": V1LoadBalancerStatus,
    "V1LocalObjectReference": V1LocalObjectReference,
    "V1LocalSubjectAccessReview": V1LocalSubjectAccessReview,
    "V1LocalVolumeSource": V1LocalVolumeSource,
    "V1NFSVolumeSource": V1NFSVolumeSource,
    "V1Namespace": V1Namespace,
    "V1NamespaceList": V1NamespaceList,
    "V1NamespaceSpec": V1NamespaceSpec,
    "V1NamespaceStatus": V1NamespaceStatus,
    "V1NetworkPolicy": V1NetworkPolicy,
    "V1NetworkPolicyEgressRule": V1NetworkPolicyEgressRule,
    "V1NetworkPolicyIngressRule": V1NetworkPolicyIngressRule,
    "V1NetworkPolicyList": V1NetworkPolicyList,
    "V1NetworkPolicyPeer": V1NetworkPolicyPeer,
    "V1NetworkPolicyPort": V1NetworkPolicyPort,
    "V1NetworkPolicySpec": V1NetworkPolicySpec,
    "V1Node": V1Node,
    "V1NodeAddress": V1NodeAddress,
    "V1NodeAffinity": V1NodeAffinity,
    "V1NodeCondition": V1NodeCondition,
    "V1NodeConfigSource": V1NodeConfigSource,
    "V1NodeConfigStatus": V1NodeConfigStatus,
    "V1NodeDaemonEndpoints": V1NodeDaemonEndpoints,
    "V1NodeList": V1NodeList,
    "V1NodeSelector": V1NodeSelector,
    "V1NodeSelectorRequirement": V1NodeSelectorRequirement,
    "V1NodeSelectorTerm": V1NodeSelectorTerm,
    "V1NodeSpec": V1NodeSpec,
    "V1NodeStatus": V1NodeStatus,
    "V1NodeSystemInfo": V1NodeSystemInfo,
    "V1NonResourceAttributes": V1NonResourceAttributes,
    "V1NonResourceRule": V1NonResourceRule,
    "V1ObjectFieldSelector": V1ObjectFieldSelector,
    "V1ObjectMeta": V1ObjectMeta,
    "V1ObjectReference": V1ObjectReference,
    "V1OwnerReference": V1OwnerReference,
    "V1PersistentVolume": V1PersistentVolume,
    "V1PersistentVolumeClaim": V1PersistentVolumeClaim,
    "V1PersistentVolumeClaimCondition": V1PersistentVolumeClaimCondition,
    "V1PersistentVolumeClaimList": V1PersistentVolumeClaimList,
    "V1PersistentVolumeClaimSpec": V1PersistentVolumeClaimSpec,
    "V1PersistentVolumeClaimStatus": V1PersistentVolumeClaimStatus,
    "V1PersistentVolumeClaimVolumeSource": V1PersistentVolumeClaimVolumeSource,
    "V1PersistentVolumeList": V1PersistentVolumeList,
    "V1PersistentVolumeSpec": V1PersistentVolumeSpec,
    "V1PersistentVolumeStatus": V1PersistentVolumeStatus,
    "V1PhotonPersistentDiskVolumeSource": V1PhotonPersistentDiskVolumeSource,
    "V1Pod": V1Pod,
    "V1PodAffinity": V1PodAffinity,
    "V1PodAffinityTerm": V1PodAffinityTerm,
    "V1PodAntiAffinity": V1PodAntiAffinity,
    "V1PodCondition": V1PodCondition,
    "V1PodDNSConfig": V1PodDNSConfig,
    "V1PodDNSConfigOption": V1PodDNSConfigOption,
    "V1PodList": V1PodList,
    "V1PodReadinessGate": V1PodReadinessGate,
    "V1PodSecurityContext": V1PodSecurityContext,
    "V1PodSpec": V1PodSpec,
    "V1PodStatus": V1PodStatus,
    "V1PodTemplate": V1PodTemplate,
    "V1PodTemplateList": V1PodTemplateList,
    "V1PodTemplateSpec": V1PodTemplateSpec,
    "V1PolicyRule": V1PolicyRule,
    "V1PortworxVolumeSource": V1PortworxVolumeSource,
    "V1Preconditions": V1Preconditions,
    "V1PreferredSchedulingTerm": V1PreferredSchedulingTerm,
    "V1Probe": V1Probe,
    "V1ProjectedVolumeSource": V1ProjectedVolumeSource,
    "V1QuobyteVolumeSource": V1QuobyteVolumeSource,
    "V1RBDPersistentVolumeSource": V1RBDPersistentVolumeSource,
    "V1RBDVolumeSource": V1RBDVolumeSource,
    "V1ReplicaSet": V1ReplicaSet,
    "V1ReplicaSetCondition": V1ReplicaSetCondition,
    "V1ReplicaSetList": V1ReplicaSetList,
    "V1ReplicaSetSpec": V1ReplicaSetSpec,
    "V1ReplicaSetStatus": V1ReplicaSetStatus,
    "V1ReplicationController": V1ReplicationController,
    "V1ReplicationControllerCondition": V1ReplicationControllerCondition,
    "V1ReplicationControllerList": V1ReplicationControllerList,
    "V1ReplicationControllerSpec": V1ReplicationControllerSpec,
    "V1ReplicationControllerStatus": V1ReplicationControllerStatus,
    "V1ResourceAttributes": V1ResourceAttributes,
    "V1ResourceFieldSelector": V1ResourceFieldSelector,
    "V1ResourceQuota": V1ResourceQuota,
    "V1ResourceQuotaList": V1ResourceQuotaList,
    "V1ResourceQuotaSpec": V1ResourceQuotaSpec,
    "V1ResourceQuotaStatus": V1ResourceQuotaStatus,
    "V1ResourceRequirements": V1ResourceRequirements,
    "V1ResourceRule": V1ResourceRule,
    "V1Role": V1Role,
    "V1RoleBinding": V1RoleBinding,
    "V1RoleBindingList": V1RoleBindingList,
    "V1RoleList": V1RoleList,
    "V1RoleRef": V1RoleRef,
    "V1RollingUpdateDaemonSet": V1RollingUpdateDaemonSet,
    "V1RollingUpdateDeployment": V1RollingUpdateDeployment,
    "V1RollingUpdateStatefulSetStrategy": V1RollingUpdateStatefulSetStrategy,
    "V1SELinuxOptions": V1SELinuxOptions,
    "V1Scale": V1Scale,
    "V1ScaleIOPersistentVolumeSource": V1ScaleIOPersistentVolumeSource,
    "V1ScaleIOVolumeSource": V1ScaleIOVolumeSource,
    "V1ScaleSpec": V1ScaleSpec,
    "V1ScaleStatus": V1ScaleStatus,
    "V1ScopeSelector": V1ScopeSelector,
    "V1ScopedResourceSelectorRequirement": V1ScopedResourceSelectorRequirement,
    "V1Secret": V1Secret,
    "V1SecretEnvSource": V1SecretEnvSource,
    "V1SecretKeySelector": V1SecretKeySelector,
    "V1SecretList": V1SecretList,
    "V1SecretProjection": V1SecretProjection,
    "V1SecretReference": V1SecretReference,
    "V1SecretVolumeSource": V1SecretVolumeSource,
    "V1SecurityContext": V1SecurityContext,
    "V1SelfSubjectAccessReview": V1SelfSubjectAccessReview,
    "V1SelfSubjectAccessReviewSpec": V1SelfSubjectAccessReviewSpec,
    "V1SelfSubjectRulesReview": V1SelfSubjectRulesReview,
    "V1SelfSubjectRulesReviewSpec": V1SelfSubjectRulesReviewSpec,
    "V1ServerAddressByClientCIDR": V1ServerAddressByClientCIDR,
    "V1Service": V1Service,
    "V1ServiceAccount": V1ServiceAccount,
    "V1ServiceAccountList": V1ServiceAccountList,
    "V1ServiceAccountTokenProjection": V1ServiceAccountTokenProjection,
    "V1ServiceList": V1ServiceList,
    "V1ServicePort": V1ServicePort,
    "V1ServiceReference": V1ServiceReference,
    "V1ServiceSpec": V1ServiceSpec,
    "V1ServiceStatus": V1ServiceStatus,
    "V1SessionAffinityConfig": V1SessionAffinityConfig,
    "V1StatefulSet": V1StatefulSet,
    "V1StatefulSetCondition": V1StatefulSetCondition,
    "V1StatefulSetList": V1StatefulSetList,
    "V1StatefulSetSpec": V1StatefulSetSpec,
    "V1StatefulSetStatus": V1StatefulSetStatus,
    "V1StatefulSetUpdateStrategy": V1StatefulSetUpdateStrategy,
    "V1Status": V1Status,
    "V1StatusCause": V1StatusCause,
    "V1StatusDetails": V1StatusDetails,
    "V1StorageClass": V1StorageClass,
    "V1StorageClassList": V1StorageClassList,
    "V1StorageOSPersistentVolumeSource": V1StorageOSPersistentVolumeSource,
    "V1StorageOSVolumeSource": V1StorageOSVolumeSource,
    "V1Subject": V1Subject,
    "V1SubjectAccessReview": V1SubjectAccessReview,
    "V1SubjectAccessReviewSpec": V1SubjectAccessReviewSpec,
    "V1SubjectAccessReviewStatus": V1SubjectAccessReviewStatus,
    "V1SubjectRulesReviewStatus": V1SubjectRulesReviewStatus,
    "V1Sysctl": V1Sysctl,
    "V1TCPSocketAction": V1TCPSocketAction,
    "V1Taint": V1Taint,
    "V1TokenReview": V1TokenReview,
    "V1TokenReviewSpec": V1TokenReviewSpec,
    "V1TokenReviewStatus": V1TokenReviewStatus,
    "V1Toleration": V1Toleration,
    "V1TopologySelectorLabelRequirement": V1TopologySelectorLabelRequirement,
    "V1TopologySelectorTerm": V1TopologySelectorTerm,
    "V1TypedLocalObjectReference": V1TypedLocalObjectReference,
    "V1UserInfo": V1UserInfo,
    "V1Volume": V1Volume,
    "V1VolumeAttachment": V1VolumeAttachment,
    "V1VolumeAttachmentList": V1VolumeAttachmentList,
    "V1VolumeAttachmentSource": V1VolumeAttachmentSource,
    "V1VolumeAttachmentSpec": V1VolumeAttachmentSpec,
    "V1VolumeAttachmentStatus": V1VolumeAttachmentStatus,
    "V1VolumeDevice": V1VolumeDevice,
    "V1VolumeError": V1VolumeError,
    "V1VolumeMount": V1VolumeMount,
    "V1VolumeNodeAffinity": V1VolumeNodeAffinity,
    "V1VolumeProjection": V1VolumeProjection,
    "V1VsphereVirtualDiskVolumeSource": V1VsphereVirtualDiskVolumeSource,
    "V1WatchEvent": V1WatchEvent,
    "V1WeightedPodAffinityTerm": V1WeightedPodAffinityTerm,
    "V1alpha1AggregationRule": V1alpha1AggregationRule,
    "V1alpha1AuditSink": V1alpha1AuditSink,
    "V1alpha1AuditSinkList": V1alpha1AuditSinkList,
    "V1alpha1AuditSinkSpec": V1alpha1AuditSinkSpec,
    "V1alpha1ClusterRole": V1alpha1ClusterRole,
    "V1alpha1ClusterRoleBinding": V1alpha1ClusterRoleBinding,
    "V1alpha1ClusterRoleBindingList": V1alpha1ClusterRoleBindingList,
    "V1alpha1ClusterRoleList": V1alpha1ClusterRoleList,
    "V1alpha1Initializer": V1alpha1Initializer,
    "V1alpha1InitializerConfiguration": V1alpha1InitializerConfiguration,
    "V1alpha1InitializerConfigurationList": V1alpha1InitializerConfigurationList,
    "V1alpha1PodPreset": V1alpha1PodPreset,
    "V1alpha1PodPresetList": V1alpha1PodPresetList,
    "V1alpha1PodPresetSpec": V1alpha1PodPresetSpec,
    "V1alpha1Policy": V1alpha1Policy,
    "V1alpha1PolicyRule": V1alpha1PolicyRule,
    "V1alpha1PriorityClass": V1alpha1PriorityClass,
    "V1alpha1PriorityClassList": V1alpha1PriorityClassList,
    "V1alpha1Role": V1alpha1Role,
    "V1alpha1RoleBinding": V1alpha1RoleBinding,
    "V1alpha1RoleBindingList": V1alpha1RoleBindingList,
    "V1alpha1RoleList": V1alpha1RoleList,
    "V1alpha1RoleRef": V1alpha1RoleRef,
    "V1alpha1Rule": V1alpha1Rule,
    "V1alpha1ServiceReference": V1alpha1ServiceReference,
    "V1alpha1Subject": V1alpha1Subject,
    "V1alpha1VolumeAttachment": V1alpha1VolumeAttachment,
    "V1alpha1VolumeAttachmentList": V1alpha1VolumeAttachmentList,
    "V1alpha1VolumeAttachmentSource": V1alpha1VolumeAttachmentSource,
    "V1alpha1VolumeAttachmentSpec": V1alpha1VolumeAttachmentSpec,
    "V1alpha1VolumeAttachmentStatus": V1alpha1VolumeAttachmentStatus,
    "V1alpha1VolumeError": V1alpha1VolumeError,
    "V1alpha1Webhook": V1alpha1Webhook,
    "V1alpha1WebhookClientConfig": V1alpha1WebhookClientConfig,
    "V1alpha1WebhookThrottleConfig": V1alpha1WebhookThrottleConfig,
    "V1beta1APIService": V1beta1APIService,
    "V1beta1APIServiceCondition": V1beta1APIServiceCondition,
    "V1beta1APIServiceList": V1beta1APIServiceList,
    "V1beta1APIServiceSpec": V1beta1APIServiceSpec,
    "V1beta1APIServiceStatus": V1beta1APIServiceStatus,
    "V1beta1AggregationRule": V1beta1AggregationRule,
    "V1beta1CertificateSigningRequest": V1beta1CertificateSigningRequest,
    "V1beta1CertificateSigningRequestCondition": V1beta1CertificateSigningRequestCondition,
    "V1beta1CertificateSigningRequestList": V1beta1CertificateSigningRequestList,
    "V1beta1CertificateSigningRequestSpec": V1beta1CertificateSigningRequestSpec,
    "V1beta1CertificateSigningRequestStatus": V1beta1CertificateSigningRequestStatus,
    "V1beta1ClusterRole": V1beta1ClusterRole,
    "V1beta1ClusterRoleBinding": V1beta1ClusterRoleBinding,
    "V1beta1ClusterRoleBindingList": V1beta1ClusterRoleBindingList,
    "V1beta1ClusterRoleList": V1beta1ClusterRoleList,
    "V1beta1ControllerRevision": V1beta1ControllerRevision,
    "V1beta1ControllerRevisionList": V1beta1ControllerRevisionList,
    "V1beta1CronJob": V1beta1CronJob,
    "V1beta1CronJobList": V1beta1CronJobList,
    "V1beta1CronJobSpec": V1beta1CronJobSpec,
    "V1beta1CronJobStatus": V1beta1CronJobStatus,
    "V1beta1CustomResourceColumnDefinition": V1beta1CustomResourceColumnDefinition,
    "V1beta1CustomResourceConversion": V1beta1CustomResourceConversion,
    "V1beta1CustomResourceDefinition": V1beta1CustomResourceDefinition,
    "V1beta1CustomResourceDefinitionCondition": V1beta1CustomResourceDefinitionCondition,
    "V1beta1CustomResourceDefinitionList": V1beta1CustomResourceDefinitionList,
    "V1beta1CustomResourceDefinitionNames": V1beta1CustomResourceDefinitionNames,
    "V1beta1CustomResourceDefinitionSpec": V1beta1CustomResourceDefinitionSpec,
    "V1beta1CustomResourceDefinitionStatus": V1beta1CustomResourceDefinitionStatus,
    "V1beta1CustomResourceDefinitionVersion": V1beta1CustomResourceDefinitionVersion,
    "V1beta1CustomResourceSubresourceScale": V1beta1CustomResourceSubresourceScale,
    "V1beta1CustomResourceSubresources": V1beta1CustomResourceSubresources,
    "V1beta1CustomResourceValidation": V1beta1CustomResourceValidation,
    "V1beta1DaemonSet": V1beta1DaemonSet,
    "V1beta1DaemonSetCondition": V1beta1DaemonSetCondition,
    "V1beta1DaemonSetList": V1beta1DaemonSetList,
    "V1beta1DaemonSetSpec": V1beta1DaemonSetSpec,
    "V1beta1DaemonSetStatus": V1beta1DaemonSetStatus,
    "V1beta1DaemonSetUpdateStrategy": V1beta1DaemonSetUpdateStrategy,
    "V1beta1Event": V1beta1Event,
    "V1beta1EventList": V1beta1EventList,
    "V1beta1EventSeries": V1beta1EventSeries,
    "V1beta1Eviction": V1beta1Eviction,
    "V1beta1ExternalDocumentation": V1beta1ExternalDocumentation,
    "V1beta1HTTPIngressPath": V1beta1HTTPIngressPath,
    "V1beta1HTTPIngressRuleValue": V1beta1HTTPIngressRuleValue,
    "V1beta1IPBlock": V1beta1IPBlock,
    "V1beta1Ingress": V1beta1Ingress,
    "V1beta1IngressBackend": V1beta1IngressBackend,
    "V1beta1IngressList": V1beta1IngressList,
    "V1beta1IngressRule": V1beta1IngressRule,
    "V1beta1IngressSpec": V1beta1IngressSpec,
    "V1beta1IngressStatus": V1beta1IngressStatus,
    "V1beta1IngressTLS": V1beta1IngressTLS,
    "V1beta1JSONSchemaProps": V1beta1JSONSchemaProps,
    "V1beta1JobTemplateSpec": V1beta1JobTemplateSpec,
    "V1beta1Lease": V1beta1Lease,
    "V1beta1LeaseList": V1beta1LeaseList,
    "V1beta1LeaseSpec": V1beta1LeaseSpec,
    "V1beta1LocalSubjectAccessReview": V1beta1LocalSubjectAccessReview,
    "V1beta1MutatingWebhookConfiguration": V1beta1MutatingWebhookConfiguration,
    "V1beta1MutatingWebhookConfigurationList": V1beta1MutatingWebhookConfigurationList,
    "V1beta1NetworkPolicy": V1beta1NetworkPolicy,
    "V1beta1NetworkPolicyEgressRule": V1beta1NetworkPolicyEgressRule,
    "V1beta1NetworkPolicyIngressRule": V1beta1NetworkPolicyIngressRule,
    "V1beta1NetworkPolicyList": V1beta1NetworkPolicyList,
    "V1beta1NetworkPolicyPeer": V1beta1NetworkPolicyPeer,
    "V1beta1NetworkPolicyPort": V1beta1NetworkPolicyPort,
    "V1beta1NetworkPolicySpec": V1beta1NetworkPolicySpec,
    "V1beta1NonResourceAttributes": V1beta1NonResourceAttributes,
    "V1beta1NonResourceRule": V1beta1NonResourceRule,
    "V1beta1PodDisruptionBudget": V1beta1PodDisruptionBudget,
    "V1beta1PodDisruptionBudgetList": V1beta1PodDisruptionBudgetList,
    "V1beta1PodDisruptionBudgetSpec": V1beta1PodDisruptionBudgetSpec,
    "V1beta1PodDisruptionBudgetStatus": V1beta1PodDisruptionBudgetStatus,
    "V1beta1PolicyRule": V1beta1PolicyRule,
    "V1beta1PriorityClass": V1beta1PriorityClass,
    "V1beta1PriorityClassList": V1beta1PriorityClassList,
    "V1beta1ReplicaSet": V1beta1ReplicaSet,
    "V1beta1ReplicaSetCondition": V1beta1ReplicaSetCondition,
    "V1beta1ReplicaSetList": V1beta1ReplicaSetList,
    "V1beta1ReplicaSetSpec": V1beta1ReplicaSetSpec,
    "V1beta1ReplicaSetStatus": V1beta1ReplicaSetStatus,
    "V1beta1ResourceAttributes": V1beta1ResourceAttributes,
    "V1beta1ResourceRule": V1beta1ResourceRule,
    "V1beta1Role": V1beta1Role,
    "V1beta1RoleBinding": V1beta1RoleBinding,
    "V1beta1RoleBindingList": V1beta1RoleBindingList,
    "V1beta1RoleList": V1beta1RoleList,
    "V1beta1RoleRef": V1beta1RoleRef,
    "V1beta1RollingUpdateDaemonSet": V1beta1RollingUpdateDaemonSet,
    "V1beta1RollingUpdateStatefulSetStrategy": V1beta1RollingUpdateStatefulSetStrategy,
    "V1beta1RuleWithOperations": V1beta1RuleWithOperations,
    "V1beta1SelfSubjectAccessReview": V1beta1SelfSubjectAccessReview,
    "V1beta1SelfSubjectAccessReviewSpec": V1beta1SelfSubjectAccessReviewSpec,
    "V1beta1SelfSubjectRulesReview": V1beta1SelfSubjectRulesReview,
    "V1beta1SelfSubjectRulesReviewSpec": V1beta1SelfSubjectRulesReviewSpec,
    "V1beta1StatefulSet": V1beta1StatefulSet,
    "V1beta1StatefulSetCondition": V1beta1StatefulSetCondition,
    "V1beta1StatefulSetList": V1beta1StatefulSetList,
    "V1beta1StatefulSetSpec": V1beta1StatefulSetSpec,
    "V1beta1StatefulSetStatus": V1beta1StatefulSetStatus,
    "V1beta1StatefulSetUpdateStrategy": V1beta1StatefulSetUpdateStrategy,
    "V1beta1StorageClass": V1beta1StorageClass,
    "V1beta1StorageClassList": V1beta1StorageClassList,
    "V1beta1Subject": V1beta1Subject,
    "V1beta1SubjectAccessReview": V1beta1SubjectAccessReview,
    "V1beta1SubjectAccessReviewSpec": V1beta1SubjectAccessReviewSpec,
    "V1beta1SubjectAccessReviewStatus": V1beta1SubjectAccessReviewStatus,
    "V1beta1SubjectRulesReviewStatus": V1beta1SubjectRulesReviewStatus,
    "V1beta1TokenReview": V1beta1TokenReview,
    "V1beta1TokenReviewSpec": V1beta1TokenReviewSpec,
    "V1beta1TokenReviewStatus": V1beta1TokenReviewStatus,
    "V1beta1UserInfo": V1beta1UserInfo,
    "V1beta1ValidatingWebhookConfiguration": V1beta1ValidatingWebhookConfiguration,
    "V1beta1ValidatingWebhookConfigurationList": V1beta1ValidatingWebhookConfigurationList,
    "V1beta1VolumeAttachment": V1beta1VolumeAttachment,
    "V1beta1VolumeAttachmentList": V1beta1VolumeAttachmentList,
    "V1beta1VolumeAttachmentSource": V1beta1VolumeAttachmentSource,
    "V1beta1VolumeAttachmentSpec": V1beta1VolumeAttachmentSpec,
    "V1beta1VolumeAttachmentStatus": V1beta1VolumeAttachmentStatus,
    "V1beta1VolumeError": V1beta1VolumeError,
    "V1beta1Webhook": V1beta1Webhook,
    "V1beta2ControllerRevision": V1beta2ControllerRevision,
    "V1beta2ControllerRevisionList": V1beta2ControllerRevisionList,
    "V1beta2DaemonSet": V1beta2DaemonSet,
    "V1beta2DaemonSetCondition": V1beta2DaemonSetCondition,
    "V1beta2DaemonSetList": V1beta2DaemonSetList,
    "V1beta2DaemonSetSpec": V1beta2DaemonSetSpec,
    "V1beta2DaemonSetStatus": V1beta2DaemonSetStatus,
    "V1beta2DaemonSetUpdateStrategy": V1beta2DaemonSetUpdateStrategy,
    "V1beta2Deployment": V1beta2Deployment,
    "V1beta2DeploymentCondition": V1beta2DeploymentCondition,
    "V1beta2DeploymentList": V1beta2DeploymentList,
    "V1beta2DeploymentSpec": V1beta2DeploymentSpec,
    "V1beta2DeploymentStatus": V1beta2DeploymentStatus,
    "V1beta2DeploymentStrategy": V1beta2DeploymentStrategy,
    "V1beta2ReplicaSet": V1beta2ReplicaSet,
    "V1beta2ReplicaSetCondition": V1beta2ReplicaSetCondition,
    "V1beta2ReplicaSetList": V1beta2ReplicaSetList,
    "V1beta2ReplicaSetSpec": V1beta2ReplicaSetSpec,
    "V1beta2ReplicaSetStatus": V1beta2ReplicaSetStatus,
    "V1beta2RollingUpdateDaemonSet": V1beta2RollingUpdateDaemonSet,
    "V1beta2RollingUpdateDeployment": V1beta2RollingUpdateDeployment,
    "V1beta2RollingUpdateStatefulSetStrategy": V1beta2RollingUpdateStatefulSetStrategy,
    "V1beta2Scale": V1beta2Scale,
    "V1beta2ScaleSpec": V1beta2ScaleSpec,
    "V1beta2ScaleStatus": V1beta2ScaleStatus,
    "V1beta2StatefulSet": V1beta2StatefulSet,
    "V1beta2StatefulSetCondition": V1beta2StatefulSetCondition,
    "V1beta2StatefulSetList": V1beta2StatefulSetList,
    "V1beta2StatefulSetSpec": V1beta2StatefulSetSpec,
    "V1beta2StatefulSetStatus": V1beta2StatefulSetStatus,
    "V1beta2StatefulSetUpdateStrategy": V1beta2StatefulSetUpdateStrategy,
    "V2alpha1CronJob": V2alpha1CronJob,
    "V2alpha1CronJobList": V2alpha1CronJobList,
    "V2alpha1CronJobSpec": V2alpha1CronJobSpec,
    "V2alpha1CronJobStatus": V2alpha1CronJobStatus,
    "V2alpha1JobTemplateSpec": V2alpha1JobTemplateSpec,
    "V2beta1CrossVersionObjectReference": V2beta1CrossVersionObjectReference,
    "V2beta1ExternalMetricSource": V2beta1ExternalMetricSource,
    "V2beta1ExternalMetricStatus": V2beta1ExternalMetricStatus,
    "V2beta1HorizontalPodAutoscaler": V2beta1HorizontalPodAutoscaler,
    "V2beta1HorizontalPodAutoscalerCondition": V2beta1HorizontalPodAutoscalerCondition,
    "V2beta1HorizontalPodAutoscalerList": V2beta1HorizontalPodAutoscalerList,
    "V2beta1HorizontalPodAutoscalerSpec": V2beta1HorizontalPodAutoscalerSpec,
    "V2beta1HorizontalPodAutoscalerStatus": V2beta1HorizontalPodAutoscalerStatus,
    "V2beta1MetricSpec": V2beta1MetricSpec,
    "V2beta1MetricStatus": V2beta1MetricStatus,
    "V2beta1ObjectMetricSource": V2beta1ObjectMetricSource,
    "V2beta1ObjectMetricStatus": V2beta1ObjectMetricStatus,
    "V2beta1PodsMetricSource": V2beta1PodsMetricSource,
    "V2beta1PodsMetricStatus": V2beta1PodsMetricStatus,
    "V2beta1ResourceMetricSource": V2beta1ResourceMetricSource,
    "V2beta1ResourceMetricStatus": V2beta1ResourceMetricStatus,
    "V2beta2CrossVersionObjectReference": V2beta2CrossVersionObjectReference,
    "V2beta2ExternalMetricSource": V2beta2ExternalMetricSource,
    "V2beta2ExternalMetricStatus": V2beta2ExternalMetricStatus,
    "V2beta2HorizontalPodAutoscaler": V2beta2HorizontalPodAutoscaler,
    "V2beta2HorizontalPodAutoscalerCondition": V2beta2HorizontalPodAutoscalerCondition,
    "V2beta2HorizontalPodAutoscalerList": V2beta2HorizontalPodAutoscalerList,
    "V2beta2HorizontalPodAutoscalerSpec": V2beta2HorizontalPodAutoscalerSpec,
    "V2beta2HorizontalPodAutoscalerStatus": V2beta2HorizontalPodAutoscalerStatus,
    "V2beta2MetricIdentifier": V2beta2MetricIdentifier,
    "V2beta2MetricSpec": V2beta2MetricSpec,
    "V2beta2MetricStatus": V2beta2MetricStatus,
    "V2beta2MetricTarget": V2beta2MetricTarget,
    "V2beta2MetricValueStatus": V2beta2MetricValueStatus,
    "V2beta2ObjectMetricSource": V2beta2ObjectMetricSource,
    "V2beta2ObjectMetricStatus": V2beta2ObjectMetricStatus,
    "V2beta2PodsMetricSource": V2beta2PodsMetricSource,
    "V2beta2PodsMetricStatus": V2beta2PodsMetricStatus,
    "V2beta2ResourceMetricSource": V2beta2ResourceMetricSource,
    "V2beta2ResourceMetricStatus": V2beta2ResourceMetricStatus,
    "VersionInfo": VersionInfo,
};
class HttpBasicAuth {
    constructor() {
        this.username = '';
        this.password = '';
    }
    applyToRequest(requestOptions) {
        requestOptions.auth = {
            username: this.username, password: this.password
        };
    }
}
exports.HttpBasicAuth = HttpBasicAuth;
class ApiKeyAuth {
    constructor(location, paramName) {
        this.location = location;
        this.paramName = paramName;
        this.apiKey = '';
    }
    applyToRequest(requestOptions) {
        if (this.location == "query") {
            requestOptions.qs[this.paramName] = this.apiKey;
        }
        else if (this.location == "header" && requestOptions && requestOptions.headers) {
            requestOptions.headers[this.paramName] = this.apiKey;
        }
    }
}
exports.ApiKeyAuth = ApiKeyAuth;
class OAuth {
    constructor() {
        this.accessToken = '';
    }
    applyToRequest(requestOptions) {
        if (requestOptions && requestOptions.headers) {
            requestOptions.headers["Authorization"] = "Bearer " + this.accessToken;
        }
    }
}
exports.OAuth = OAuth;
class VoidAuth {
    constructor() {
        this.username = '';
        this.password = '';
    }
    applyToRequest(_) {
        // Do nothing
    }
}
exports.VoidAuth = VoidAuth;
var AdmissionregistrationApiApiKeys;
(function (AdmissionregistrationApiApiKeys) {
    AdmissionregistrationApiApiKeys[AdmissionregistrationApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(AdmissionregistrationApiApiKeys = exports.AdmissionregistrationApiApiKeys || (exports.AdmissionregistrationApiApiKeys = {}));
class AdmissionregistrationApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[AdmissionregistrationApiApiKeys[key]].apiKey = value;
    }
    /**
     * get information of a group
     * @param {*} [options] Override http request options.
     */
    getAPIGroup(options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIGroup");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.AdmissionregistrationApi = AdmissionregistrationApi;
var AdmissionregistrationV1alpha1ApiApiKeys;
(function (AdmissionregistrationV1alpha1ApiApiKeys) {
    AdmissionregistrationV1alpha1ApiApiKeys[AdmissionregistrationV1alpha1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(AdmissionregistrationV1alpha1ApiApiKeys = exports.AdmissionregistrationV1alpha1ApiApiKeys || (exports.AdmissionregistrationV1alpha1ApiApiKeys = {}));
class AdmissionregistrationV1alpha1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[AdmissionregistrationV1alpha1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create an InitializerConfiguration
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createInitializerConfiguration(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createInitializerConfiguration.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1alpha1InitializerConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1alpha1InitializerConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of InitializerConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionInitializerConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete an InitializerConfiguration
     * @param name name of the InitializerConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteInitializerConfiguration(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteInitializerConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind InitializerConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listInitializerConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1alpha1InitializerConfigurationList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified InitializerConfiguration
     * @param name name of the InitializerConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchInitializerConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchInitializerConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchInitializerConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1alpha1InitializerConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified InitializerConfiguration
     * @param name name of the InitializerConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readInitializerConfiguration(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readInitializerConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1alpha1InitializerConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified InitializerConfiguration
     * @param name name of the InitializerConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceInitializerConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1alpha1/initializerconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceInitializerConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceInitializerConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1alpha1InitializerConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1alpha1InitializerConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.AdmissionregistrationV1alpha1Api = AdmissionregistrationV1alpha1Api;
var AdmissionregistrationV1beta1ApiApiKeys;
(function (AdmissionregistrationV1beta1ApiApiKeys) {
    AdmissionregistrationV1beta1ApiApiKeys[AdmissionregistrationV1beta1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(AdmissionregistrationV1beta1ApiApiKeys = exports.AdmissionregistrationV1beta1ApiApiKeys || (exports.AdmissionregistrationV1beta1ApiApiKeys = {}));
class AdmissionregistrationV1beta1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[AdmissionregistrationV1beta1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create a MutatingWebhookConfiguration
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createMutatingWebhookConfiguration(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createMutatingWebhookConfiguration.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1MutatingWebhookConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1MutatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * create a ValidatingWebhookConfiguration
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createValidatingWebhookConfiguration(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createValidatingWebhookConfiguration.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1ValidatingWebhookConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1ValidatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of MutatingWebhookConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionMutatingWebhookConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of ValidatingWebhookConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionValidatingWebhookConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a MutatingWebhookConfiguration
     * @param name name of the MutatingWebhookConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteMutatingWebhookConfiguration(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteMutatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a ValidatingWebhookConfiguration
     * @param name name of the ValidatingWebhookConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteValidatingWebhookConfiguration(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteValidatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind MutatingWebhookConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listMutatingWebhookConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1MutatingWebhookConfigurationList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind ValidatingWebhookConfiguration
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listValidatingWebhookConfiguration(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1ValidatingWebhookConfigurationList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified MutatingWebhookConfiguration
     * @param name name of the MutatingWebhookConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchMutatingWebhookConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchMutatingWebhookConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchMutatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1MutatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified ValidatingWebhookConfiguration
     * @param name name of the ValidatingWebhookConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchValidatingWebhookConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchValidatingWebhookConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchValidatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1ValidatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified MutatingWebhookConfiguration
     * @param name name of the MutatingWebhookConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readMutatingWebhookConfiguration(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readMutatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1MutatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified ValidatingWebhookConfiguration
     * @param name name of the ValidatingWebhookConfiguration
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readValidatingWebhookConfiguration(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readValidatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1ValidatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified MutatingWebhookConfiguration
     * @param name name of the MutatingWebhookConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceMutatingWebhookConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/mutatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceMutatingWebhookConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceMutatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1MutatingWebhookConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1MutatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified ValidatingWebhookConfiguration
     * @param name name of the ValidatingWebhookConfiguration
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceValidatingWebhookConfiguration(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/admissionregistration.k8s.io/v1beta1/validatingwebhookconfigurations/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceValidatingWebhookConfiguration.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceValidatingWebhookConfiguration.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1ValidatingWebhookConfiguration")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1ValidatingWebhookConfiguration");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.AdmissionregistrationV1beta1Api = AdmissionregistrationV1beta1Api;
var ApiextensionsApiApiKeys;
(function (ApiextensionsApiApiKeys) {
    ApiextensionsApiApiKeys[ApiextensionsApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApiextensionsApiApiKeys = exports.ApiextensionsApiApiKeys || (exports.ApiextensionsApiApiKeys = {}));
class ApiextensionsApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApiextensionsApiApiKeys[key]].apiKey = value;
    }
    /**
     * get information of a group
     * @param {*} [options] Override http request options.
     */
    getAPIGroup(options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIGroup");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApiextensionsApi = ApiextensionsApi;
var ApiextensionsV1beta1ApiApiKeys;
(function (ApiextensionsV1beta1ApiApiKeys) {
    ApiextensionsV1beta1ApiApiKeys[ApiextensionsV1beta1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApiextensionsV1beta1ApiApiKeys = exports.ApiextensionsV1beta1ApiApiKeys || (exports.ApiextensionsV1beta1ApiApiKeys = {}));
class ApiextensionsV1beta1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApiextensionsV1beta1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create a CustomResourceDefinition
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createCustomResourceDefinition(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createCustomResourceDefinition.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1CustomResourceDefinition")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of CustomResourceDefinition
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionCustomResourceDefinition(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteCustomResourceDefinition(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteCustomResourceDefinition.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind CustomResourceDefinition
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listCustomResourceDefinition(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinitionList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchCustomResourceDefinition(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchCustomResourceDefinition.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchCustomResourceDefinition.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchCustomResourceDefinitionStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchCustomResourceDefinitionStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchCustomResourceDefinitionStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readCustomResourceDefinition(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readCustomResourceDefinition.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read status of the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param {*} [options] Override http request options.
     */
    readCustomResourceDefinitionStatus(name, pretty, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readCustomResourceDefinitionStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceCustomResourceDefinition(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceCustomResourceDefinition.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceCustomResourceDefinition.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1CustomResourceDefinition")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace status of the specified CustomResourceDefinition
     * @param name name of the CustomResourceDefinition
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceCustomResourceDefinitionStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiextensions.k8s.io/v1beta1/customresourcedefinitions/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceCustomResourceDefinitionStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceCustomResourceDefinitionStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1CustomResourceDefinition")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1CustomResourceDefinition");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApiextensionsV1beta1Api = ApiextensionsV1beta1Api;
var ApiregistrationApiApiKeys;
(function (ApiregistrationApiApiKeys) {
    ApiregistrationApiApiKeys[ApiregistrationApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApiregistrationApiApiKeys = exports.ApiregistrationApiApiKeys || (exports.ApiregistrationApiApiKeys = {}));
class ApiregistrationApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApiregistrationApiApiKeys[key]].apiKey = value;
    }
    /**
     * get information of a group
     * @param {*} [options] Override http request options.
     */
    getAPIGroup(options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIGroup");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApiregistrationApi = ApiregistrationApi;
var ApiregistrationV1ApiApiKeys;
(function (ApiregistrationV1ApiApiKeys) {
    ApiregistrationV1ApiApiKeys[ApiregistrationV1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApiregistrationV1ApiApiKeys = exports.ApiregistrationV1ApiApiKeys || (exports.ApiregistrationV1ApiApiKeys = {}));
class ApiregistrationV1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApiregistrationV1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create an APIService
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createAPIService(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createAPIService.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete an APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteAPIService(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of APIService
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionAPIService(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind APIService
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listAPIService(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIServiceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchAPIService(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchAPIService.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchAPIServiceStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchAPIServiceStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readAPIService(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read status of the specified APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param {*} [options] Override http request options.
     */
    readAPIServiceStatus(name, pretty, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceAPIService(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceAPIService.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace status of the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceAPIServiceStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceAPIServiceStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApiregistrationV1Api = ApiregistrationV1Api;
var ApiregistrationV1beta1ApiApiKeys;
(function (ApiregistrationV1beta1ApiApiKeys) {
    ApiregistrationV1beta1ApiApiKeys[ApiregistrationV1beta1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApiregistrationV1beta1ApiApiKeys = exports.ApiregistrationV1beta1ApiApiKeys || (exports.ApiregistrationV1beta1ApiApiKeys = {}));
class ApiregistrationV1beta1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApiregistrationV1beta1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create an APIService
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createAPIService(body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createAPIService.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete an APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteAPIService(name, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of APIService
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionAPIService(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind APIService
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listAPIService(includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIServiceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchAPIService(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchAPIService.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchAPIServiceStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchAPIServiceStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readAPIService(name, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read status of the specified APIService
     * @param name name of the APIService
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param {*} [options] Override http request options.
     */
    readAPIServiceStatus(name, pretty, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceAPIService(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceAPIService.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceAPIService.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * replace status of the specified APIService
     * @param name name of the APIService
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    replaceAPIServiceStatus(name, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apiregistration.k8s.io/v1beta1/apiservices/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling replaceAPIServiceStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling replaceAPIServiceStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PUT',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1beta1APIService")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1beta1APIService");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApiregistrationV1beta1Api = ApiregistrationV1beta1Api;
var ApisApiApiKeys;
(function (ApisApiApiKeys) {
    ApisApiApiKeys[ApisApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(ApisApiApiKeys = exports.ApisApiApiKeys || (exports.ApisApiApiKeys = {}));
class ApisApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[ApisApiApiKeys[key]].apiKey = value;
    }
    /**
     * get available API versions
     * @param {*} [options] Override http request options.
     */
    getAPIVersions(options = {}) {
        const localVarPath = this.basePath + '/apis/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIGroupList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.ApisApi = ApisApi;
var AppsApiApiKeys;
(function (AppsApiApiKeys) {
    AppsApiApiKeys[AppsApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(AppsApiApiKeys = exports.AppsApiApiKeys || (exports.AppsApiApiKeys = {}));
class AppsApi {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[AppsApiApiKeys[key]].apiKey = value;
    }
    /**
     * get information of a group
     * @param {*} [options] Override http request options.
     */
    getAPIGroup(options = {}) {
        const localVarPath = this.basePath + '/apis/apps/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIGroup");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
}
exports.AppsApi = AppsApi;
var AppsV1ApiApiKeys;
(function (AppsV1ApiApiKeys) {
    AppsV1ApiApiKeys[AppsV1ApiApiKeys["BearerToken"] = 0] = "BearerToken";
})(AppsV1ApiApiKeys = exports.AppsV1ApiApiKeys || (exports.AppsV1ApiApiKeys = {}));
class AppsV1Api {
    constructor(basePathOrUsername, password, basePath) {
        this._basePath = defaultBasePath;
        this.defaultHeaders = {};
        this._useQuerystring = false;
        this.authentications = {
            'default': new VoidAuth(),
            'BearerToken': new ApiKeyAuth('header', 'authorization'),
        };
        if (password) {
            if (basePath) {
                this.basePath = basePath;
            }
        }
        else {
            if (basePathOrUsername) {
                this.basePath = basePathOrUsername;
            }
        }
    }
    set useQuerystring(value) {
        this._useQuerystring = value;
    }
    set basePath(basePath) {
        this._basePath = basePath;
    }
    get basePath() {
        return this._basePath;
    }
    setDefaultAuthentication(auth) {
        this.authentications.default = auth;
    }
    setApiKey(key, value) {
        this.authentications[AppsV1ApiApiKeys[key]].apiKey = value;
    }
    /**
     * create a ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createNamespacedControllerRevision(namespace, body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedControllerRevision.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedControllerRevision.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1ControllerRevision")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ControllerRevision");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * create a DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createNamespacedDaemonSet(namespace, body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedDaemonSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedDaemonSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DaemonSet")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * create a Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createNamespacedDeployment(namespace, body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedDeployment.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedDeployment.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1Deployment")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Deployment");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * create a ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createNamespacedReplicaSet(namespace, body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedReplicaSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedReplicaSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1ReplicaSet")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ReplicaSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * create a StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    createNamespacedStatefulSet(namespace, body, includeUninitialized, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling createNamespacedStatefulSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling createNamespacedStatefulSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'POST',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1StatefulSet")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1StatefulSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionNamespacedControllerRevision(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedControllerRevision.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionNamespacedDaemonSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedDaemonSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionNamespacedDeployment(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedDeployment.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionNamespacedReplicaSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedReplicaSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete collection of StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    deleteCollectionNamespacedStatefulSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteCollectionNamespacedStatefulSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a ControllerRevision
     * @param name name of the ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteNamespacedControllerRevision(name, namespace, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedControllerRevision.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedControllerRevision.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a DaemonSet
     * @param name name of the DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteNamespacedDaemonSet(name, namespace, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedDaemonSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedDaemonSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a Deployment
     * @param name name of the Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteNamespacedDeployment(name, namespace, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedDeployment.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedDeployment.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a ReplicaSet
     * @param name name of the ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteNamespacedReplicaSet(name, namespace, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedReplicaSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedReplicaSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * delete a StatefulSet
     * @param name name of the StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param body
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param gracePeriodSeconds The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
     * @param orphanDependents Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \&quot;orphan\&quot; finalizer will be added to/removed from the object&#39;s finalizers list. Either this field or PropagationPolicy may be set, but not both.
     * @param propagationPolicy Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy. Acceptable values are: &#39;Orphan&#39; - orphan the dependents; &#39;Background&#39; - allow the garbage collector to delete the dependents in the background; &#39;Foreground&#39; - a cascading policy that deletes all dependents in the foreground.
     * @param {*} [options] Override http request options.
     */
    deleteNamespacedStatefulSet(name, namespace, pretty, body, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling deleteNamespacedStatefulSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling deleteNamespacedStatefulSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        if (gracePeriodSeconds !== undefined) {
            localVarQueryParameters['gracePeriodSeconds'] = ObjectSerializer.serialize(gracePeriodSeconds, "number");
        }
        if (orphanDependents !== undefined) {
            localVarQueryParameters['orphanDependents'] = ObjectSerializer.serialize(orphanDependents, "boolean");
        }
        if (propagationPolicy !== undefined) {
            localVarQueryParameters['propagationPolicy'] = ObjectSerializer.serialize(propagationPolicy, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'DELETE',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "V1DeleteOptions")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Status");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * get available resources
     * @param {*} [options] Override http request options.
     */
    getAPIResources(options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1APIResourceList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind ControllerRevision
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listControllerRevisionForAllNamespaces(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/controllerrevisions';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ControllerRevisionList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind DaemonSet
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listDaemonSetForAllNamespaces(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/daemonsets';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind Deployment
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listDeploymentForAllNamespaces(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/deployments';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DeploymentList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listNamespacedControllerRevision(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedControllerRevision.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ControllerRevisionList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listNamespacedDaemonSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedDaemonSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listNamespacedDeployment(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedDeployment.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DeploymentList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listNamespacedReplicaSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedReplicaSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ReplicaSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listNamespacedStatefulSet(namespace, includeUninitialized, pretty, _continue, fieldSelector, labelSelector, limit, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets'
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling listNamespacedStatefulSet.');
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1StatefulSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind ReplicaSet
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listReplicaSetForAllNamespaces(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/replicasets';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ReplicaSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * list or watch objects of kind StatefulSet
     * @param _continue The continue option should be set when retrieving more results from the server. Since this value is server defined, clients may only use the continue value from a previous query result with identical query parameters (except for the value of continue) and the server may reject a continue value it does not recognize. If the specified continue value is no longer valid whether due to expiration (generally five to fifteen minutes) or a configuration change on the server, the server will respond with a 410 ResourceExpired error together with a continue token. If the client needs a consistent list, it must restart their list without the continue field. Otherwise, the client may send another list request with the token received with the 410 error, the server will respond with a list starting from the next key, but from the latest snapshot, which is inconsistent from the previous list results - objects that are created, modified, or deleted after the first list request will be included in the response, as long as their keys are after the \&quot;next key\&quot;.  This field is not supported when watch is true. Clients may start a watch from the last resourceVersion value returned by the server and not miss any modifications.
     * @param fieldSelector A selector to restrict the list of returned objects by their fields. Defaults to everything.
     * @param includeUninitialized If true, partially initialized resources are included in the response.
     * @param labelSelector A selector to restrict the list of returned objects by their labels. Defaults to everything.
     * @param limit limit is a maximum number of responses to return for a list call. If more items exist, the server will set the &#x60;continue&#x60; field on the list metadata to a value that can be used with the same initial query to retrieve the next set of results. Setting a limit may return fewer than the requested amount of items (up to zero items) in the event all requested objects are filtered out and clients should only use the presence of the continue field to determine whether more results are available. Servers may choose not to support the limit argument and will return all of the available results. If limit is specified and the continue field is empty, clients may assume that no more results are available. This field is not supported if watch is true.  The server guarantees that the objects returned when using continue will be identical to issuing a single list call without a limit - that is, no objects created, modified, or deleted after the first request is issued will be included in any subsequent continued requests. This is sometimes referred to as a consistent snapshot, and ensures that a client that is using limit to receive smaller chunks of a very large result can ensure they see all possible objects. If objects are updated during a chunked list the version of the object that was present at the time the first list result was calculated is returned.
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param resourceVersion When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it&#39;s 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
     * @param timeoutSeconds Timeout for the list/watch call. This limits the duration of the call, regardless of any activity or inactivity.
     * @param watch Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
     * @param {*} [options] Override http request options.
     */
    listStatefulSetForAllNamespaces(_continue, fieldSelector, includeUninitialized, labelSelector, limit, pretty, resourceVersion, timeoutSeconds, watch, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/statefulsets';
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        if (_continue !== undefined) {
            localVarQueryParameters['continue'] = ObjectSerializer.serialize(_continue, "string");
        }
        if (fieldSelector !== undefined) {
            localVarQueryParameters['fieldSelector'] = ObjectSerializer.serialize(fieldSelector, "string");
        }
        if (includeUninitialized !== undefined) {
            localVarQueryParameters['includeUninitialized'] = ObjectSerializer.serialize(includeUninitialized, "boolean");
        }
        if (labelSelector !== undefined) {
            localVarQueryParameters['labelSelector'] = ObjectSerializer.serialize(labelSelector, "string");
        }
        if (limit !== undefined) {
            localVarQueryParameters['limit'] = ObjectSerializer.serialize(limit, "number");
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (resourceVersion !== undefined) {
            localVarQueryParameters['resourceVersion'] = ObjectSerializer.serialize(resourceVersion, "string");
        }
        if (timeoutSeconds !== undefined) {
            localVarQueryParameters['timeoutSeconds'] = ObjectSerializer.serialize(timeoutSeconds, "number");
        }
        if (watch !== undefined) {
            localVarQueryParameters['watch'] = ObjectSerializer.serialize(watch, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1StatefulSetList");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified ControllerRevision
     * @param name name of the ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedControllerRevision(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedControllerRevision.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedControllerRevision.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedControllerRevision.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ControllerRevision");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified DaemonSet
     * @param name name of the DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedDaemonSet(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedDaemonSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedDaemonSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedDaemonSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified DaemonSet
     * @param name name of the DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedDaemonSetStatus(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedDaemonSetStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedDaemonSetStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedDaemonSetStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified Deployment
     * @param name name of the Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedDeployment(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedDeployment.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedDeployment.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedDeployment.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Deployment");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update scale of the specified Deployment
     * @param name name of the Scale
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedDeploymentScale(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedDeploymentScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedDeploymentScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedDeploymentScale.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Scale");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified Deployment
     * @param name name of the Deployment
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedDeploymentStatus(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/deployments/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedDeploymentStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedDeploymentStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedDeploymentStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Deployment");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified ReplicaSet
     * @param name name of the ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedReplicaSet(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedReplicaSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedReplicaSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedReplicaSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ReplicaSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update scale of the specified ReplicaSet
     * @param name name of the Scale
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedReplicaSetScale(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedReplicaSetScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedReplicaSetScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedReplicaSetScale.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Scale");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified ReplicaSet
     * @param name name of the ReplicaSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedReplicaSetStatus(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedReplicaSetStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedReplicaSetStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedReplicaSetStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ReplicaSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update the specified StatefulSet
     * @param name name of the StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedStatefulSet(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedStatefulSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedStatefulSet.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedStatefulSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1StatefulSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update scale of the specified StatefulSet
     * @param name name of the Scale
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedStatefulSetScale(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedStatefulSetScale.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedStatefulSetScale.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedStatefulSetScale.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1Scale");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * partially update status of the specified StatefulSet
     * @param name name of the StatefulSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param body
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param dryRun When present, indicates that modifications should not be persisted. An invalid or unrecognized dryRun directive will result in an error response and no further processing of the request. Valid values are: - All: all dry run stages will be processed
     * @param {*} [options] Override http request options.
     */
    patchNamespacedStatefulSetStatus(name, namespace, body, pretty, dryRun, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling patchNamespacedStatefulSetStatus.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling patchNamespacedStatefulSetStatus.');
        }
        // verify required parameter 'body' is not null or undefined
        if (body === null || body === undefined) {
            throw new Error('Required parameter body was null or undefined when calling patchNamespacedStatefulSetStatus.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (dryRun !== undefined) {
            localVarQueryParameters['dryRun'] = ObjectSerializer.serialize(dryRun, "string");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'PATCH',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
            body: ObjectSerializer.serialize(body, "any")
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1StatefulSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified ControllerRevision
     * @param name name of the ControllerRevision
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readNamespacedControllerRevision(name, namespace, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readNamespacedControllerRevision.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling readNamespacedControllerRevision.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1ControllerRevision");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read the specified DaemonSet
     * @param name name of the DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param exact Should the export be exact.  Exact export maintains cluster-specific fields like &#39;Namespace&#39;.
     * @param _export Should this value be exported.  Export strips fields that a user can not specify.
     * @param {*} [options] Override http request options.
     */
    readNamespacedDaemonSet(name, namespace, pretty, exact, _export, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readNamespacedDaemonSet.');
        }
        // verify required parameter 'namespace' is not null or undefined
        if (namespace === null || namespace === undefined) {
            throw new Error('Required parameter namespace was null or undefined when calling readNamespacedDaemonSet.');
        }
        if (pretty !== undefined) {
            localVarQueryParameters['pretty'] = ObjectSerializer.serialize(pretty, "string");
        }
        if (exact !== undefined) {
            localVarQueryParameters['exact'] = ObjectSerializer.serialize(exact, "boolean");
        }
        if (_export !== undefined) {
            localVarQueryParameters['export'] = ObjectSerializer.serialize(_export, "boolean");
        }
        Object.assign(localVarHeaderParams, options.headers);
        let localVarUseFormData = false;
        let localVarRequestOptions = {
            method: 'GET',
            qs: localVarQueryParameters,
            headers: localVarHeaderParams,
            uri: localVarPath,
            useQuerystring: this._useQuerystring,
            json: true,
        };
        this.authentications.BearerToken.applyToRequest(localVarRequestOptions);
        this.authentications.default.applyToRequest(localVarRequestOptions);
        if (Object.keys(localVarFormParams).length) {
            if (localVarUseFormData) {
                localVarRequestOptions.formData = localVarFormParams;
            }
            else {
                localVarRequestOptions.form = localVarFormParams;
            }
        }
        return new Promise((resolve, reject) => {
            localVarRequest(localVarRequestOptions, (error, response, body) => {
                if (error) {
                    reject(error);
                }
                else {
                    body = ObjectSerializer.deserialize(body, "V1DaemonSet");
                    if (response.statusCode && response.statusCode >= 200 && response.statusCode <= 299) {
                        resolve({ response: response, body: body });
                    }
                    else {
                        reject({ response: response, body: body });
                    }
                }
            });
        });
    }
    /**
     * read status of the specified DaemonSet
     * @param name name of the DaemonSet
     * @param namespace object name and auth scope, such as for teams and projects
     * @param pretty If &#39;true&#39;, then the output is pretty printed.
     * @param {*} [options] Override http request options.
     */
    readNamespacedDaemonSetStatus(name, namespace, pretty, options = {}) {
        const localVarPath = this.basePath + '/apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status'
            .replace('{' + 'name' + '}', encodeURIComponent(String(name)))
            .replace('{' + 'namespace' + '}', encodeURIComponent(String(namespace)));
        let localVarQueryParameters = {};
        let localVarHeaderParams = Object.assign({}, this.defaultHeaders);
        let localVarFormParams = {};
        // verify required parameter 'name' is not null or undefined
        if (name === null || name === undefined) {
            throw new Error('Required parameter name was null or undefined when calling readNamespacedDaemonSetStatus.');
        }
        // verify required parameter 'namespace' is not 