"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const notifier = require("node-notifier");
const che_1 = require("../../api/che");
const common_flags_1 = require("../../common-flags");
class Open extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Open);
            try {
                const cheHelper = new che_1.CheHelper(flags);
                const cheURL = yield cheHelper.cheURL(flags.chenamespace);
                const dashboardUrl = `${cheURL}/dashboard/`;
                cli_ux_1.cli.info(`Opening ... ${dashboardUrl}`);
                yield cli_ux_1.cli.open(dashboardUrl);
            }
            catch (error) {
                this.error(error);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command dashboard:open has completed successfully.'
            });
            this.exit(0);
        });
    }
}
exports.default = Open;
Open.description = 'Open CodeReady Workspaces dashboard';
Open.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
};
//# sourceMappingURL=open.js.map