"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const Listr = require("listr");
const notifier = require("node-notifier");
const common_flags_1 = require("../../common-flags");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
const workspace_tasks_1 = require("../../tasks/workspace-tasks");
class Stop extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Stop);
            const { args } = this.parse(Stop);
            const ctx = {};
            const tasks = new Listr([], { renderer: 'silent' });
            const apiTasks = new api_1.ApiTasks();
            const cheTasks = new che_1.CheTasks(flags);
            const workspaceTasks = new workspace_tasks_1.WorkspaceTasks(flags);
            ctx.workspaceId = args.workspace;
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.retrieveEclipseCheUrl(flags));
            tasks.add(cheTasks.checkEclipseCheStatus());
            tasks.add(workspaceTasks.getWorkspaceStopTask());
            try {
                yield tasks.run(ctx);
                cli_ux_1.cli.log('Workspace successfully stopped.');
            }
            catch (err) {
                this.error(err);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:stop has completed successfully.'
            });
            this.exit(0);
        });
    }
}
exports.default = Stop;
Stop.description = 'Stop a running workspace';
Stop.flags = {
    help: command_1.flags.help({ char: 'h' }),
    'access-token': common_flags_1.accessToken,
    chenamespace: common_flags_1.cheNamespace,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
Stop.args = [
    {
        name: 'workspace',
        description: 'The workspace id to stop',
        required: true
    }
];
//# sourceMappingURL=stop.js.map