"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
/**
 * Update command to display download instructions to the user
 */
class Update extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.log('To update crwctl, download the latest from https://developers.redhat.com/products/codeready-workspaces/download and install that instead of your current version.');
        });
    }
}
exports.default = Update;
Update.description = 'instructions for updating crwctl';
//# sourceMappingURL=update.js.map