"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const common_flags_1 = require("../../common-flags");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
class Stop extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Stop);
            const Listr = require('listr');
            const notifier = require('node-notifier');
            const cheTasks = new che_1.CheTasks(flags);
            const apiTasks = new api_1.ApiTasks();
            let tasks = new Listr(undefined, {
                renderer: flags['listr-renderer'],
                collapse: false
            });
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.checkIfCheIsInstalledTasks(flags, this));
            tasks.add([
                {
                    title: 'Deployment doesn\'t exist',
                    enabled: (ctx) => !ctx.isCheDeployed,
                    task: () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        yield this.error(`E_BAD_DEPLOY - Deployment do not exist.\nA Deployment named "${flags['deployment-name']}" exist in namespace \"${flags.chenamespace}\", CodeReady Workspaces server cannot be stopped.\nFix with: verify the namespace where CodeReady Workspaces is running (oc get projects)\nhttps://github.com/eclipse/che`, { code: 'E_BAD_DEPLOY' });
                    })
                }
            ], { renderer: flags['listr-renderer'] });
            tasks.add(cheTasks.scaleCheDownTasks(this));
            tasks.add(cheTasks.waitPodsDeletedTasks());
            try {
                yield tasks.run();
            }
            catch (err) {
                this.error(err);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command server:stop has completed.'
            });
            this.exit(0);
        });
    }
}
exports.default = Stop;
Stop.description = 'stop CodeReady Workspaces server';
Stop.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'deployment-name': common_flags_1.cheDeployment,
    'che-selector': flags_1.string({
        description: 'Selector for CodeReady Workspaces server resources',
        default: 'app=codeready,component=codeready',
        env: 'CHE_SELECTOR'
    }),
    'access-token': common_flags_1.accessToken,
    'listr-renderer': common_flags_1.listrRenderer,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
//# sourceMappingURL=stop.js.map