"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const Listr = require("listr");
const notifier = require("node-notifier");
const os = require("os");
const path = require("path");
const common_flags_1 = require("../../common-flags");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
class Logs extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Logs);
            const ctx = {};
            ctx.directory = path.resolve(flags.directory ? flags.directory : path.resolve(os.tmpdir(), 'crwctl-logs', Date.now().toString()));
            const cheTasks = new che_1.CheTasks(flags);
            const apiTasks = new api_1.ApiTasks();
            const tasks = new Listr([], { renderer: flags['listr-renderer'] });
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.serverLogsTasks(flags, false));
            tasks.add(cheTasks.namespaceEventsTask(flags.chenamespace, this, false));
            try {
                this.log(`CodeReady Workspaces logs will be available in '${ctx.directory}'`);
                yield tasks.run(ctx);
                this.log('Command server:logs has completed successfully.');
            }
            catch (error) {
                this.error(error);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command server:logs has completed successfully.'
            });
            this.exit(0);
        });
    }
}
exports.default = Logs;
Logs.description = 'Collect CodeReady Workspaces logs';
Logs.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'listr-renderer': common_flags_1.listrRenderer,
    'deployment-name': common_flags_1.cheDeployment,
    directory: flags_1.string({
        char: 'd',
        description: 'Directory to store logs into',
        env: 'CHE_LOGS'
    }),
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
//# sourceMappingURL=logs.js.map