/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
export default class Export extends Command {
    static description: string;
    static flags: {
        help: import("@oclif/parser/lib/flags").IBooleanFlag<void>;
        chenamespace: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        destination: import("@oclif/parser/lib/flags").IOptionFlag<string>;
        'skip-kubernetes-health-check': import("@oclif/parser/lib/flags").IBooleanFlag<boolean>;
    };
    run(): Promise<void>;
    /**
     * Handles certificate target location and returns string which points to the target file.
     */
    private getTargetFile;
}
