if (!window.DW) {
	window.DW = {};
}

if (!window.Richfaces) {
	window.Richfaces = {};
}

function discardElement(element) {
    var garbageBin = document.getElementById('IELeakGarbageBin');
    if (!garbageBin) {
        garbageBin = document.createElement('DIV');
        garbageBin.id = 'IELeakGarbageBin';
        garbageBin.style.display = 'none';
        document.body.appendChild(garbageBin);
    }

	window.RichFaces.Memory.clean(element);
    // move the element to the garbage bin
    garbageBin.appendChild(element);
    garbageBin.innerHTML = '';
}

ModalPanel = Class.create();

{
	var searchString = "MSIE";
	var agent = navigator.userAgent;
	var idx = agent.indexOf(searchString);
	if (idx != -1) {
		var versIdx = agent.indexOf(";", idx);
		var versString;

		if (versIdx != -1) {
			versString = agent.substring(idx + searchString.length, versIdx);
		} else {
			versString = agent.substring(idx + searchString.length);
		}

		if (parseFloat(versString) < 7) {
			ModalPanel.disableSelects = true;
		}
	}
}

ModalPanel.panels = new Array();

function getSizeElement() {
	var element;
	if (RichFaces.navigatorType() != "OPERA" && document.compatMode=='CSS1Compat') {
		element = document.documentElement;
	} else {
		element = document.body;
	}

	return element;
}


ModalPanel.prototype = {
	initialize: function(id, options) {
		this["rich:destructor"] = "destroy";
	
		this.markerId = $(id);

		this.id = $(id + "Container");

		this.options = options;

		this.baseZIndex = this.options.zindex ? this.options.zindex : 100;

		this.minWidth = Math.max(this.options.minWidth, 2*ModalPanel.Sizer.INITIAL_MIN + 2);
		this.minHeight = Math.max(this.options.minHeight, 2*ModalPanel.Sizer.INITIAL_MIN + 2);

		this.div = id + "Div";
		this.cursorDiv = id + "CursorDiv";
		this.cdiv = id + "CDiv";
		this.contentDiv = id + "ContentDiv";
		this.contentTable = id + "ContentTable";
		this.shadowDiv = id + "ShadowDiv";

		this.borders = new Array();

		if (this.options.resizeable) {
			this.borders.push(new ModalPanel.Border(id + "ResizerNWU", this, "NW-resize", ModalPanel.Sizer.NWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerN", this, "N-resize", ModalPanel.Sizer.N));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEU", this, "NE-resize", ModalPanel.Sizer.NEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEL", this, "NE-resize", ModalPanel.Sizer.NEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerE", this, "E-resize", ModalPanel.Sizer.E));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEU", this, "SE-resize", ModalPanel.Sizer.SEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEL", this, "SE-resize", ModalPanel.Sizer.SEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerS", this, "S-resize", ModalPanel.Sizer.S));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWL", this, "SW-resize", ModalPanel.Sizer.SWL));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWU", this, "SW-resize", ModalPanel.Sizer.SWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerW", this, "W-resize", ModalPanel.Sizer.W));
			this.borders.push(new ModalPanel.Border(id + "ResizerNWL", this, "NW-resize", ModalPanel.Sizer.NWL));
		}

		if (this.options.moveable && $(id + "Header")) {
			this.header = new ModalPanel.Border(id + "Header", this, "move", ModalPanel.Header);
		}

		this.markerId.component = this;
		
		var eDiv = $(this.div);
		if (eDiv.style.setExpression)
			if (ModalPanel.disableSelects /* IE 6 */ || Richfaces.getComputedStyle(eDiv, "position") != "fixed" /* IE again, not in strict mode*/)

		{
			eDiv.style.position = "absolute";
			
			var eCursorDiv = $(this.cursorDiv);
			eCursorDiv.style.position = "absolute";

			//that is to apply filter
			eDiv.style.width = "1px";
			eDiv.style.height = "1px";
			eCursorDiv.style.width = "1px";
			eCursorDiv.style.height = "1px";

			var eCdiv = $(this.cdiv);
			eCdiv.style.position = "absolute";

			eCdiv.mpUseExpr = true;
		}

		if (this.options.onshow && this.options.onshow != ""){
			this.eventOnShow = new Function("event",this.options.onshow).bindAsEventListener(this);
		}
		if (this.options.onhide && this.options.onhide != ""){
			this.eventOnHide = new Function("event",this.options.onhide).bindAsEventListener(this);
		}

		ModalPanel.panels.push(this);

		this.eventFirstOnfocus = this.firstOnfocus.bindAsEventListener(this);
		this.eventLastOnfocus = this.lastOnfocus.bindAsEventListener(this);

		this.firstHref = id + "FirstHref";
		this.lastHref = id + "LastHref";
		
		this.selectBehavior = options.selectBehavior;
	},

	width: function() {
		return this.getContentElement().offsetWidth;
	},

	height: function() {
		return this.getContentElement().offsetHeight;
	},
	
	getContentElement: function() {
		if (!this._sizedElement) {
			this._sizedElement = this.options.autosized ? $(this.contentTable) : $(this.contentDiv);
		}

		return this._sizedElement;
	},
	
	destroy: function() {
		this._sizedElement = null;

		ModalPanel.panels = ModalPanel.panels.without(this);
		
        this.traverseSelects(true);
        
        this.parent = null;
        this.firstOutside = null;
        this.lastOutside = null;
        if (this.header) {
        	this.header.destroy();
			this.header=null;        	
        }

		for (var k = 0; k < this.borders.length; k++ ) {
			this.borders[k].destroy();
		}
		this.borders = null;

		setTimeout(function() {
			if (this.floatedToBody) {
				var element = this.id;
				var parent = element.parentNode;
				if (parent) {
					parent.removeChild(element);
					discardElement(element);
				}
			}
		}.bind(this), 0);
        this.markerId.component = null;
        this.markerId = null;
	},

	initIframe : function() {
        if (this.contentWindow) {
			Element.setStyle(this.contentWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		} else {
			//TODO opera etc.

		}

		if("transparent" == Element.getStyle(document.body, "background-color")) {
			this.style.filter = "alpha(opacity=0)";
			this.style.opacity = "0";
		}

		//this.style.opacity = "0.5";
		//this.style.filter='progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=50)';
		//var iframeBodyStyle = this.contentWindow.document.body.style;
		//iframeBodyStyle.backgroundColor = "#d0d0d0";
		//iframeBodyStyle.filter = "alpha(opacity=50)";
		//iframeBodyStyle.opacity = "0.5";
		//iframeBodyStyle.zIndex = "99";
	},

	traverseSelects: function(enable) {
		if (!ModalPanel.disableSelects) {
			return ;
		}

		var children = document.body.childNodes;
		for (var k = 0; k < children.length; k++) {
			var child = children[k];
			if (child != this.id && child.getElementsByTagName) {

				var selects = child.getElementsByTagName("SELECT");

				for (var i = 0; i < selects.length; i++) {
					var elt = selects[i];
					
					if (this.selectBehavior && "hide" == this.selectBehavior) {
						if (enable) {
							if (elt._mdwCount) {
								elt._mdwCount -= 1;
	
								if (elt._mdwCount == 0) {
									if (elt._mdwHidden) {
										Element.setStyle(elt, { "visibility" : elt._mdwHidden });
										elt._mdwHidden = undefined;
									} else {
										Element.setStyle(elt, { "visibility" : "" });
									}
	
									elt._mdwCount = undefined;
								}
							}
						} else {
							if (elt._mdwCount) {
								elt._mdwCount += 1;
							} else {
								if (elt.style.visibility && "" != elt.style.visibility) {
									elt._mdwHidden = elt.style.visibility;
								}
								Element.setStyle(elt, { "visibility" : "hidden" });
	
								elt._mdwCount = 1;
							}
						}
					} else {
						if (enable) {
							if (elt._mdwCount) {
								elt._mdwCount -= 1;
	
								if (elt._mdwCount == 0) {
									if (elt._mdwDisabled) {
										elt._mdwDisabled = undefined;
									} else {
										elt.disabled = false;
									}
	
									elt._mdwCount = undefined;
								}
							}
						} else {
							if (elt._mdwCount) {
								elt._mdwCount += 1;
							} else {
								if (elt.disabled) {
									elt._mdwDisabled = true;
								} else {
									elt.disabled = true;
								}
	
								elt._mdwCount = 1;
							}
						}
					}
				}
			}
		}
	},

	setLeft: function(pos) {
		var eCdiv = $(this.cdiv);
		if (eCdiv.mpUseExpr) {
			eCdiv.mpLeft = pos;
		} else {
			eCdiv.style.left = pos + "px";
		}
	},

	setTop: function(pos) {
		var eCdiv = $(this.cdiv);
		if (eCdiv.mpUseExpr) {
			eCdiv.mpTop = pos;
		} else {
			eCdiv.style.top = pos + "px";
		}
	},

	firstOnfocus: function(event) {
		var e = $(this.firstHref)
		if (e) {
			e.focus();
		}
	},

	lastOnfocus: function(event) {
		var e = $(this.lastHref);
		if (e) {
			e.focus();
		}
	},

	processAllFocusElements: function(root, callback) {
		if (root.focus && 
			// Many not visible elements have focus method, we is had to avoid processing them.
			/^(?:a|input|select|button|textarea)$/i.test(root.tagName) &&
			!root.disabled && !/^hidden$/.test(root.type) &&
			Element.visible(root)) {

				callback.call(this, root);
		} else {
			if (root != this.id) {
				var child = root.firstChild;
				while (child) {
					if (!child.style || Element.visible(child)) {
						this.processAllFocusElements(child, callback);
					}
					child = child.nextSibling;
				}
			}
		}
	},

	processTabindexes:	function(input) {
		if (!this.firstOutside && !(/^select$/i.test(input.tagName) && ModalPanel.disableSelects)) {
			this.firstOutside = input;
		}
		this.lastOutside = input;
		if (input.tabIndex) {
			input.prevTabIndex = input.tabIndex;
		}
		input.tabIndex = undefined;
		if (input.accesskey) {
			input.prevAccesskey = input.accesskey;
		}
		input.accesskey = undefined;
	},

	restoreTabindexes:	function(input) {
		if (input.prevTabIndex)
			input.tabIndex = input.prevTabIndex;
		if (input.prevAccesskey)
			input.accesskey = input.prevAccesskey;
	},

	preventFocus:	function() {
		this.processAllFocusElements(document, this.processTabindexes);
		
		if (this.firstOutside) {
			Event.observe(this.firstOutside, "focus", this.eventFirstOnfocus); 
		}
		if (this.lastOutside && this.lastOutside != this.firstOutside) {
			Event.observe(this.lastOutside, "focus", this.eventLastOnfocus); 
		}
	},

	restoreFocus: function() {
		this.processAllFocusElements(document, this.restoreTabindexes);
		
		if (this.firstOutside) {
			Event.stopObserving(this.firstOutside, "focus", this.eventFirstOnfocus);
			this.firstOutside = null;
		}
		if (this.lastOutside) {
			Event.stopObserving(this.lastOutside, "focus", this.eventLastOnfocus);
			this.lastOutside = null;
		}
	},

	show: function(event, opts) {
		this.preventFocus();

		var element = this.id;
        if (!this.floatedToBody) {
			this.parent = element.parentNode;
			document.body.insertBefore(this.parent.removeChild(element), null);
			this.floatedToBody = true;
		}

		var eCdiv = $(this.cdiv);
		var forms = eCdiv.getElementsByTagName("form");

		if (this.options.keepVisualState && forms) {
			this.formOnsubmit = this.setStateInput.bindAsEventListener(this); 
			for (var i = 0; i < forms.length; i++) {
				Event.observe(forms[i], "submit", this.formOnsubmit); 
			}
		}

		var eIframe;
		if (ModalPanel.disableSelects && !this.iframe) {
			this.iframe = this.id.id + "IFrame";

			new Insertion.Top(eCdiv,
			"<iframe src=\"javascript:''\" frameborder=\"0\" scrolling=\"no\" id=\"" + this.iframe + "\" " +
				"style=\"position: absolute; width: 1px; height: 1px; background-color: white; overflow-y: hidden; z-index: 1;\">" +
			"</iframe>");
			
			eIframe = $(this.iframe); 

			//alert("IFrame:" + eIframe + "created!");

			//eIframe.onload = this.initIframe.bind(eIframe);
			Event.observe(eIframe, 'load', this.initIframe.bindAsEventListener(eIframe));
		}

		var options = {};
		this.userOptions = {};

		if (!eCdiv.mpSet) {
			Object.extend(options, this.options);
		}

		if (opts) {
			Object.extend(options, opts);
			Object.extend(this.userOptions, opts);
		}
		
		var eContentElt = this.getContentElement();
		var eShadowDiv = $(this.shadowDiv);

		if (!this.options.autosized) {
			if (options.width && options.width == -1) 
				options.width = 300;
			if (options.height && options.height == -1) 
				options.height = 200;
		}
			
		if (options.width && options.width != -1) {
			if (this.minWidth > options.width) {
				options.width = this.minWidth;
			}

			if (eIframe) {
				eIframe.style.width = options.width + (/px/.test(options.width) ? '' : 'px');
			}
			eContentElt.style.width = options.width + (/px/.test(options.width) ? '' : 'px');
			eShadowDiv.style.width = options.width + (/px/.test(options.width) ? '' : 'px');
		}

		if (options.height && options.height != -1) {
			if (this.minHeight > options.height) {
				options.height = this.minHeight;
			}

			if (eIframe) {
				eIframe.style.height = options.height + (/px/.test(options.height) ? '' : 'px');
			}
			eContentElt.style.height = options.height + (/px/.test(options.height) ? '' : 'px');
			eShadowDiv.style.height = options.height + (/px/.test(options.height) ? '' : 'px');
		}

		eCdiv.mpSet = true;

		//Element.setStyle(this.dialogWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		//if("transparent" == Element.getStyle(document.body, "background-color")) {
		//	eIframe.allowTransparency = true;
		//}


		this.traverseSelects();

		//this.shape.init(eCdiv, this.options);

		var eDiv = $(this.div);
		if (eDiv.style.position == "absolute")
		{
			var we = "getSizeElement().clientWidth + \"px\"";
			var he = "getSizeElement().clientHeight + \"px\"";
			eDiv.style.setExpression("width", we);
			eDiv.style.setExpression("height", he);

			var eCursorDiv = $(this.cursorDiv);
			eCursorDiv.style.setExpression("width", we);
			eCursorDiv.style.setExpression("height", he);

			var le = "-Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
			var te = "-Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";

			eDiv.style.setExpression("left", le);
			eDiv.style.setExpression("top", te);

			eCursorDiv.style.setExpression("left", le);
			eCursorDiv.style.setExpression("top", te);


			var leftExpr = "(this.mpLeft || 0) + -Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
			var topExpr = "(this.mpTop || 0) + -Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";

			eCdiv.style.setExpression("left", leftExpr);
			eCdiv.style.setExpression("top", topExpr);


			/* That's how we output debug info - DOM inspector rulez */
			/*
			document.body.setExpression("_clientLeft", "getSizeElement().clientLeft");
			document.body.setExpression("_clientTop", "getSizeElement().clientTop");
			document.body.setExpression("_scrollLeft", "getSizeElement().scrollLeft");
			document.body.setExpression("_scrollTop", "getSizeElement().scrollTop");
			*/
			/* */
		}

		element.style.visibility = "hidden";

		Element.show(element);

		if (options.left) {
			var _left;
			if (options.left != "auto") {
				_left = parseInt(options.left, 10);
			} else {
				var cw = getSizeElement().clientWidth;
			 	var _width = this.width(); //Richfaces.getComputedStyleSize(eContentElt, "width");
				if (cw >= _width) {
				 	_left = (cw - _width) / 2;
				} else {
					_left = 0;
				}
			}

			this.setLeft(_left);
		}

		if (options.top) {
			var _top;
			if (options.top != "auto") {
				_top = parseInt(options.top, 10);
			} else {
				var cw = getSizeElement().clientHeight;
				var _height = this.height(); //Richfaces.getComputedStyleSize(eContentElt, "height");
				if (cw >= _height) {
					_top = (cw - _height) / 2;
				} else {
					_top = 0;
				}
			}

			this.setTop(_top);
		}

		if (this.options.autosized) {
			this.observerSize =
		        window.setInterval(this.correctShadowSize.bindAsEventListener(this), 500);
		}

		this.doResizeOrMove(ModalPanel.Sizer.Diff.EMPTY);

		for (var k = 0; k < this.borders.length; k++ ) {
			this.borders[k].doPosition();
		}

		if (this.header) {
			this.header.doPosition();
		}

		Element.hide(eCdiv);
		element.style.visibility = "";

		Element.show(eCdiv);
		
		this.lastOnfocus();

		var event = {};
		event.parameters = opts || {};
		if (this.eventOnShow) this.eventOnShow(event);

		this.shown = true;
	},
	
	startDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].hide();
		}
	},

	endDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].show();
			this.borders[k].doPosition();
		}
	},

	hide: function(event, opts) {
		this.restoreFocus();

        this.traverseSelects(true);

		var eDiv = $(this.div);
		var eCdiv = $(this.cdiv);

		if (eDiv.style.removeExpression) {
			eDiv.style.removeExpression("width");
			eDiv.style.removeExpression("height");

			eDiv.style.removeExpression("left");
			eDiv.style.removeExpression("top");

			var eCursorDiv = $(this.cursorDiv);
			eCursorDiv.style.removeExpression("width");
			eCursorDiv.style.removeExpression("height");

			eCursorDiv.style.removeExpression("left");
			eCursorDiv.style.removeExpression("top");

			eCdiv.style.removeExpression("left");
			eCdiv.style.removeExpression("top");
		}

		var element = this.id;
		Element.hide(element);

		if (this.floatedToBody && this.parent) {
			
			document.body.removeChild(element);
			this.parent.appendChild(element);
			this.floatedToBody = false;
		}
		
		var event = {};
		event.parameters = opts || {};
		if (this.eventOnHide) this.eventOnHide(event);
		
		var forms = eCdiv.getElementsByTagName("form");
		if (this.options.keepVisualState && forms) {
			for (var i = 0; i < forms.length; i++) {
				Event.stopObserving(forms[i], "submit", this.formOnsubmit);
			}
		}

		this.shown = false;
		
		if (this.options.autosized) {
			window.clearInterval(this.observerSize);
		}
	},

    _getStyle: function(elt, name) { 
		return parseInt(elt.style[name].replace("px", ""), 10); 
	}, 

	doResizeOrMove: function(diff) {
		var vetoes = {};
		var cssHash = {};
		var cssHashWH = {};

		var vetoeChange = false;
		var newSize;
		
		var eContentElt = this.getContentElement();
		var eShadowDiv = $(this.shadowDiv);
		
		// Avoid currentStyle bug in opera
		if (RichFaces.navigatorType() != "OPERA")
			newSize = Richfaces.getComputedStyleSize(eContentElt, "width");
		else
			newSize = this._getStyle(eContentElt, "width");

		var oldSize = newSize;
		newSize += diff.deltaWidth || 0;

		if (newSize >= this.minWidth || this.options.autosized) {
			if (diff.deltaWidth) {
				cssHashWH.width = newSize + 'px';
			}
		} else {
			if (diff.deltaWidth) {
				cssHashWH.width = this.minWidth + 'px';

				vetoes.vx = oldSize - this.minWidth;
			}

			vetoes.x = true;
		}

		if (vetoes.vx && diff.deltaX) {
			diff.deltaX = -vetoes.vx;
		}
		
		var eCdiv = $(this.cdiv); 

		if (diff.deltaX && (vetoes.vx || !vetoes.x)) {
			if (vetoes.vx) {
				diff.deltaX = vetoes.vx;
			}
			var newPos;
			
			newPos = this._getStyle(eCdiv, "left");//Richfaces.getComputedStyleSize(eCdiv, "left");
			newPos += diff.deltaX;
			cssHash.left = newPos + 'px';
		}

		// Avoid currentStyle bug in opera
		if (RichFaces.navigatorType() != "OPERA")
			newSize = Richfaces.getComputedStyleSize(eContentElt, "height");
		else
			newSize = this._getStyle(eContentElt, "height")//;Richfaces.getComputedStyleSize(eContentDiv, "height");

		var oldSize = newSize;
		newSize += diff.deltaHeight || 0;

		if (newSize >= this.minHeight || this.options.autosized) {
			if (diff.deltaHeight) {
				cssHashWH.height = newSize + 'px';
			}
		} else {
			if (diff.deltaHeight) {
				cssHashWH.height = this.minHeight + 'px';

				vetoes.vy = oldSize - this.minHeight;
			}

			vetoes.y = true;
		}

		if (vetoes.vy && diff.deltaY) {
			diff.deltaY = -vetoes.vy;
		}

		if (diff.deltaY && (vetoes.vy || !vetoes.y)) {
			if (vetoes.vy) {
				diff.deltaY = vetoes.vy;
			}

			var newPos;
			if (eCdiv.mpUseExpr) {
				newPos = eCdiv.mpTop || 0;
				newPos += diff.deltaY;

				eCdiv.mpTop = newPos;
				cssHash.top = newPos + 'px';
			} else {
				newPos = this._getStyle(eCdiv, "top");//Richfaces.getComputedStyleSize(eCdiv, "top");
				newPos += diff.deltaY;
				cssHash.top = newPos + 'px';
			}
		}

		Element.setStyle(eCdiv, cssHash);

		Element.setStyle(eContentElt, cssHashWH);
		this.correctShadowSize();
		if (this.iframe) {
			Element.setStyle($(this.iframe), cssHashWH);
		}
		
		Object.extend(this.userOptions, cssHash);
		Object.extend(this.userOptions, cssHashWH);

		var w = this.width();
		var h = this.height();

		this.reductionData = null;

		if (w <= 2*ModalPanel.Sizer.INITIAL_MAX) {
			this.reductionData = {};
			this.reductionData.w = w;
		}

		if (h <= 2*ModalPanel.Sizer.INITIAL_MAX) {
			if (!this.reductionData) {
				this.reductionData = {};
			}

			this.reductionData.h = h;
		}

		if (this.header) {
			this.header.doPosition();
		}

		return vetoes;
	},

	setStateInput: function(e) {
		var target = Event.element(e);
		if (e && target) {
			var input = document.createElement("input");
			input.type = "hidden";
			input.id = this.id.id + "OpenedState";
			input.name = this.id.id + "OpenedState";
			input.value = this.shown ? "true" : "false";
			target.appendChild(input);

			var keys = $H(this.userOptions).keys();
			if (keys) {
				for (var i = 0; i < keys.length; i++) {
					input = document.createElement("input");
					input.type = "hidden";
					input.id = this.id.id + "StateOption_" + keys[i];
					input.name = this.id.id + "StateOption_" + keys[i];
					input.value = this.userOptions[keys[i]];
					target.appendChild(input);

				}
			}
			
			return true;
		}
	},
	
	correctShadowSize: function(event) {
		var eShadowDiv = $(this.shadowDiv);
		if (!eShadowDiv) {
			return;
		}
		var eIframe = $(this.iframe);
		
		var dx = 0;
		var dy = 0;
		if (!Richfaces.browser.isIE)
		{
			dx = eShadowDiv.offsetWidth-eShadowDiv.clientWidth;
			dy = eShadowDiv.offsetHeight-eShadowDiv.clientHeight;
		}
		var w = this.width();
		var h = this.height();
		eShadowDiv.style.width = (w-dx)+"px";
		eShadowDiv.style.height = (h-dy)+"px";
		
		if (eIframe) {
			eIframe.style.width = w+"px";
			eIframe.style.height = h+"px";
		}
	}
}

Richfaces.findModalPanel = function (id) {
	if (id) {
		var prefId = (id.charAt(0) == ':' ? id : ':' + id);

		for (var i = 0; i < ModalPanel.panels.length; i++ ) {
			var pnl = ModalPanel.panels[i];
			if (pnl && pnl.markerId) {
				var pnlId = pnl.markerId.id;

				if (pnlId) {
					//try to match ids
					if (pnlId.length >= prefId.length) {
						var substr = pnlId.substring(pnlId.length - prefId.length, pnlId.length);
						if (substr == prefId) {
							return pnl.markerId;
						}
					}
				}
			}
		}
	}
}

Richfaces.showModalPanel = function (id, opts, event) {
	
	var invoke = 
		("MSIE" == RichFaces.navigatorType()) ?
		function(f) {
				if (document.readyState != "complete") {
					var args = arguments;
					var dis = this;
				window.setTimeout(
					function() {
						args.callee.apply(dis,args );
					}, 50);
			} else {
				f();
			}
		} : 
		function(f) {
			f();
		}; 
	
	var panel = $(id);
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	invoke(function() {
	panel.component.show(event, opts);
	});
	
	
};

Richfaces.hideModalPanel = function (id, opts, event) {
	var panel = $(id);
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	panel.component.hide(event, opts);
};
