/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Exadel, Inc.
 *     Red Hat, Inc.
 *******************************************************************************/
package org.jboss.tools.jst.jsp.text.xpl;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.sse.ui.StructuredTextEditor;


/**
 * @author Jeremy
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
/**
 * Contributors to the
 * <code>org.eclipse.jdt.ui.foldingStructureProvider</code> extension
 * point must specify an implementation of this interface which will create and
 * maintain {@link org.eclipse.jface.text.source.projection.ProjectionAnnotation} objects
 * that define folded regions in the the {@link org.eclipse.jface.text.source.projection.ProjectionViewer}.
 * <p>
 * Clients may implement this interface.
 * </p>
 * 
 * @since 3.0
 */

public interface IStructuredTextOccurrenceStructureProvider {

	/**
	 * Installs this structure provider on the given editor and viewer.
	 * Implementations should listen to the projection events generated by
	 * <code>viewer</code> and enable / disable generation of projection
	 * structure accordingly.
	 * 
	 * @param editor the editor that this provider works on
	 * @param viewer the projection viewer that displays the annotations created
	 *        by this structure provider
	 */
	public abstract void install(StructuredTextEditor editor, ProjectionViewer viewer);

	/**
	 * Uninstalls this structure provider. Any references to editors or viewers
	 * should be cleared.
	 */
	public abstract void uninstall();

	/**
	 * (Re-)initializes the structure provided by the receiver.
	 */
	public abstract void initialize();
	
	public abstract boolean affectsPreferences(String property);
	
	public abstract void handlePreferenceStoreChanged(PropertyChangeEvent event);
	
	public IPreferenceStore getPreferenceStore();
	
	public String getEditorId();
}
