/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajax4jsf.webapp.HtmlParser;

abstract class ParserConfig {
    private static final Pattern[] ALL_VIEWS_PATTERN = new Pattern[]{Pattern.compile(".*")};
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");
    private Pattern[] patterns = ALL_VIEWS_PATTERN;
    private ParserConfig next;

    ParserConfig() {
    }

    protected abstract HtmlParser createParser(String var1);

    boolean storeParser(HtmlParser parser) {
        return false;
    }

    HtmlParser getParser(String viewId, String mimetype) {
        HtmlParser result = null;
        for (int i = 0; i < this.patterns.length && null == result; ++i) {
            Matcher matcher = this.patterns[i].matcher(viewId);
            if (!matcher.matches()) continue;
            result = this.createParser(mimetype);
        }
        if (null == result && null != this.next) {
            result = this.next.getParser(viewId, mimetype);
        }
        return result;
    }

    public void reuseParser(HtmlParser parser) {
        if (!this.storeParser(parser) && null != this.next) {
            this.next.reuseParser(parser);
        }
    }

    public ParserConfig getNext() {
        return this.next;
    }

    public void setNext(ParserConfig next) {
        this.next = next;
    }

    public void setPatterns(String patternsString) {
        if (null != patternsString) {
            String[] split = SEPARATOR_PATTERN.split(patternsString);
            this.patterns = new Pattern[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.patterns[i] = Pattern.compile(split[i].trim());
            }
        }
    }

    public Pattern[] getPatterns() {
        return this.patterns;
    }
}

