/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.awt.Color;
import java.nio.ByteBuffer;

public class Zipper2 {
    private byte[] buffer;
    int offset = 0;

    public Zipper2(byte[] buffer) {
        this.buffer = buffer;
    }

    public Zipper2 addByte(byte b) {
        this.buffer[this.offset++] = b;
        return this;
    }

    public Zipper2 addShort(short s) {
        ByteBuffer.wrap(this.buffer, this.offset, 2).asShortBuffer().put(s);
        this.offset += 2;
        return this;
    }

    public Zipper2 addColor(Color color) {
        this.addColor(color.getRGB());
        return this;
    }

    public Zipper2 addColor(int i) {
        this.buffer[this.offset] = (byte)(i >> 0 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(i >> 8 & 0xFF);
        this.buffer[this.offset + 2] = (byte)(i >> 16 & 0xFF);
        this.offset += 3;
        return this;
    }

    public Zipper2 addInt(int i) {
        ByteBuffer.wrap(this.buffer, this.offset, 4).asIntBuffer().put(i);
        this.offset += 4;
        return this;
    }

    public byte nextByte() {
        return this.buffer[this.offset++];
    }

    public short nextShort() {
        short s = ByteBuffer.wrap(this.buffer, this.offset, 2).asShortBuffer().get();
        this.offset += 2;
        return s;
    }

    public Color nextColor() {
        return new Color(this.nextIntColor());
    }

    public int nextIntColor() {
        int r0 = this.buffer[this.offset] & 0xFF;
        int r1 = this.buffer[this.offset + 1] << 8 & 0xFF00;
        int r2 = this.buffer[this.offset + 2] << 16 & 0xFF0000;
        int ret = r0 | r1 | r2;
        this.offset += 3;
        return ret;
    }

    public int nextInt() {
        int i = ByteBuffer.wrap(this.buffer, this.offset, 4).asIntBuffer().get();
        this.offset += 4;
        return i;
    }
}

