/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.compiler;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Instruction;
import com.sun.facelets.compiler.UIInstructions;
import com.sun.facelets.el.ELText;
import com.sun.facelets.tag.TextHandler;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.FastWriter;
import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

final class UIInstructionHandler
implements FaceletHandler,
TextHandler {
    private final String alias;
    private final ELText txt;
    private final Instruction[] instructions;
    private final int length;
    private final boolean literal;

    public UIInstructionHandler(String alias, Instruction[] instructions, ELText txt) {
        this.alias = alias;
        this.instructions = instructions;
        this.txt = txt;
        this.length = txt.toString().length();
        boolean literal = true;
        int size = instructions.length;
        for (int i = 0; i < size; ++i) {
            Instruction ins = this.instructions[i];
            if (ins.isLiteral()) continue;
            literal = false;
            break;
        }
        this.literal = literal;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent != null) {
            Instruction[] applied;
            if (this.literal) {
                applied = this.instructions;
            } else {
                int size = this.instructions.length;
                applied = new Instruction[size];
                for (int i = 0; i < size; ++i) {
                    Instruction ins = this.instructions[i];
                    applied[i] = ins.apply(ctx.getExpressionFactory(), ctx);
                }
            }
            UIInstructions c = new UIInstructions(this.txt, applied);
            c.setId(ComponentSupport.getViewRoot(ctx, parent).createUniqueId());
            parent.getChildren().add(c);
        }
    }

    public String toString() {
        return this.txt.toString();
    }

    public String getText() {
        return this.txt.toString();
    }

    public String getText(FaceletContext ctx) {
        FastWriter writer = new FastWriter(this.length);
        try {
            this.txt.apply(ctx.getExpressionFactory(), ctx).write(writer, ctx);
        }
        catch (IOException e) {
            throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
        }
        return ((Object)writer).toString();
    }
}

