/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public class StandardQueryCache
implements QueryCache {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)StandardQueryCache.class.getName());
    private QueryResultsRegion cacheRegion;
    private UpdateTimestampsCache updateTimestampsCache;

    @Override
    public void clear() throws CacheException {
        this.cacheRegion.evictAll();
    }

    public StandardQueryCache(Settings settings, Properties props, UpdateTimestampsCache updateTimestampsCache, String regionName) throws HibernateException {
        String prefix;
        if (regionName == null) {
            regionName = StandardQueryCache.class.getName();
        }
        if ((prefix = settings.getCacheRegionPrefix()) != null) {
            regionName = prefix + '.' + regionName;
        }
        LOG.startingQueryCache(regionName);
        this.cacheRegion = settings.getRegionFactory().buildQueryResultsRegion(regionName, props);
        this.updateTimestampsCache = updateTimestampsCache;
    }

    @Override
    public boolean put(QueryKey key, Type[] returnTypes, List result, boolean isNaturalKeyLookup, SessionImplementor session) throws HibernateException {
        if (isNaturalKeyLookup && result.size() == 0) {
            return false;
        }
        Long ts = session.getFactory().getSettings().getRegionFactory().nextTimestamp();
        LOG.debugf("Caching query results in region: %s; timestamp=%s", this.cacheRegion.getName(), ts);
        ArrayList<Object> cacheable = new ArrayList<Object>(result.size() + 1);
        StandardQueryCache.logCachedResultDetails(key, null, returnTypes, cacheable);
        cacheable.add(ts);
        for (Object aResult : result) {
            if (returnTypes.length == 1) {
                cacheable.add(returnTypes[0].disassemble(aResult, session, null));
            } else {
                cacheable.add(TypeHelper.disassemble((Object[])aResult, returnTypes, null, session, null));
            }
            StandardQueryCache.logCachedResultRowDetails(returnTypes, aResult);
        }
        this.cacheRegion.put(key, cacheable);
        return true;
    }

    @Override
    public List get(QueryKey key, Type[] returnTypes, boolean isNaturalKeyLookup, Set spaces, SessionImplementor session) throws HibernateException {
        LOG.debugf("Checking cached query results in region: %s", this.cacheRegion.getName());
        List cacheable = (List)this.cacheRegion.get(key);
        StandardQueryCache.logCachedResultDetails(key, spaces, returnTypes, cacheable);
        if (cacheable == null) {
            LOG.debugf("Query results were not found in cache", new Object[0]);
            return null;
        }
        Long timestamp = (Long)cacheable.get(0);
        if (!isNaturalKeyLookup && !this.isUpToDate(spaces, timestamp)) {
            LOG.debugf("Cached query results were not up-to-date", new Object[0]);
            return null;
        }
        LOG.debugf("Returning cached query results", new Object[0]);
        for (int i = 1; i < cacheable.size(); ++i) {
            if (returnTypes.length == 1) {
                returnTypes[0].beforeAssemble((Serializable)cacheable.get(i), session);
                continue;
            }
            TypeHelper.beforeAssemble((Serializable[])cacheable.get(i), returnTypes, session);
        }
        ArrayList<Object> result = new ArrayList<Object>(cacheable.size() - 1);
        for (int i = 1; i < cacheable.size(); ++i) {
            try {
                if (returnTypes.length == 1) {
                    result.add(returnTypes[0].assemble((Serializable)cacheable.get(i), session, null));
                } else {
                    result.add(TypeHelper.assemble((Serializable[])cacheable.get(i), returnTypes, session, null));
                }
                StandardQueryCache.logCachedResultRowDetails(returnTypes, result.get(i - 1));
                continue;
            }
            catch (RuntimeException ex) {
                if (isNaturalKeyLookup && (UnresolvableObjectException.class.isInstance(ex) || EntityNotFoundException.class.isInstance(ex))) {
                    LOG.debugf("Unable to reassemble cached result set", new Object[0]);
                    this.cacheRegion.evict(key);
                    return null;
                }
                throw ex;
            }
        }
        return result;
    }

    protected boolean isUpToDate(Set spaces, Long timestamp) {
        LOG.debugf("Checking query spaces are up-to-date: %s", spaces);
        return this.updateTimestampsCache.isUpToDate(spaces, timestamp);
    }

    @Override
    public void destroy() {
        try {
            this.cacheRegion.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyQueryCache(this.cacheRegion.getName(), e.getMessage());
        }
    }

    @Override
    public QueryResultsRegion getRegion() {
        return this.cacheRegion;
    }

    public String toString() {
        return "StandardQueryCache(" + this.cacheRegion.getName() + ')';
    }

    private static void logCachedResultDetails(QueryKey key, Set querySpaces, Type[] returnTypes, List result) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        LOG.trace("key.hashCode=" + key.hashCode());
        LOG.trace("querySpaces=" + querySpaces);
        if (returnTypes == null || returnTypes.length == 0) {
            LOG.trace("Unexpected returnTypes is " + (returnTypes == null ? "null" : "empty") + "! result" + (result == null ? " is null" : ".size()=" + result.size()));
        } else {
            StringBuffer returnTypeInfo = new StringBuffer();
            for (int i = 0; i < returnTypes.length; ++i) {
                returnTypeInfo.append("typename=").append(returnTypes[i].getName()).append(" class=").append(returnTypes[i].getReturnedClass().getName()).append(' ');
            }
            LOG.trace("unexpected returnTypes is " + returnTypeInfo.toString() + "! result");
        }
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object result) {
        Object[] objectArray;
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (result instanceof Object[]) {
            objectArray = (Object[])result;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = result;
        }
        StandardQueryCache.logCachedResultRowDetails(returnTypes, objectArray);
    }

    private static void logCachedResultRowDetails(Type[] returnTypes, Object[] tuple) {
        if (!LOG.isTraceEnabled()) {
            return;
        }
        if (tuple == null) {
            LOG.trace(" tuple is null; returnTypes is " + returnTypes == null ? "null" : "Type[" + returnTypes.length + "]");
            if (returnTypes != null && returnTypes.length > 1) {
                LOG.trace("Unexpected result tuple! tuple is null; should be Object[" + returnTypes.length + "]!");
            }
        } else {
            if (returnTypes == null || returnTypes.length == 0) {
                LOG.trace("Unexpected result tuple! tuple is null; returnTypes is " + (returnTypes == null ? "null" : "empty"));
            }
            LOG.trace(" tuple is Object[" + tuple.length + "]; returnTypes is Type[" + returnTypes.length + "]");
            if (tuple.length != returnTypes.length) {
                LOG.trace("Unexpected tuple length! transformer= expected=" + returnTypes.length + " got=" + tuple.length);
            } else {
                for (int j = 0; j < tuple.length; ++j) {
                    if (tuple[j] == null || returnTypes[j].getReturnedClass().isInstance(tuple[j])) continue;
                    LOG.trace("Unexpected tuple value type! transformer= expected=" + returnTypes[j].getReturnedClass().getName() + " got=" + tuple[j].getClass().getName());
                }
            }
        }
    }
}

