/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.request;

import java.io.IOException;
import java.io.InputStream;

public class ByteSequenceMatcher {
    private static final int ZERO_READS_NUMBER = 20;
    private byte[] buffer;
    private int readLength = 0;
    private int zeroReadCounter = 20;
    private boolean bufferEOF = false;
    private boolean isEOF = false;
    private boolean isMatched = false;
    private InputStream inputStream;
    private BytesHandler bytesHandler;

    public ByteSequenceMatcher(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.buffer = new byte[bufferSize];
    }

    public BytesHandler getBytesHandler() {
        return this.bytesHandler;
    }

    public void setBytesHandler(BytesHandler bytesHandler) {
        this.bytesHandler = bytesHandler;
    }

    protected void prefillBuffer(int usedLength) throws IOException {
        int remaining;
        if (usedLength > this.readLength) {
            throw new IllegalArgumentException();
        }
        if (usedLength != this.readLength && usedLength != 0) {
            System.arraycopy(this.buffer, usedLength, this.buffer, 0, this.readLength - usedLength);
        }
        this.readLength -= usedLength;
        while (!this.bufferEOF && (remaining = this.buffer.length - this.readLength) > 0) {
            int read = this.inputStream.read(this.buffer, this.readLength, remaining);
            if (read > 0) {
                this.readLength += read;
                continue;
            }
            if (read == 0) {
                --this.zeroReadCounter;
                if (this.zeroReadCounter != 0) continue;
                throw new IllegalStateException("Maximum number of zero reads reached");
            }
            if (read >= 0) continue;
            this.bufferEOF = true;
        }
    }

    private boolean match(int startOffset, byte[] ... sequences) {
        int index = startOffset;
        byte[][] arr$ = sequences;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] bs;
            for (byte b : bs = arr$[i$]) {
                if (index >= this.readLength) {
                    return false;
                }
                if (this.buffer[index] != b) {
                    return false;
                }
                ++index;
            }
        }
        return true;
    }

    public void findSequence(int limit, byte[] ... sequences) throws IOException {
        this.isMatched = false;
        int userLimit = limit;
        if (userLimit <= 0) {
            userLimit = Integer.MAX_VALUE;
        }
        this.prefillBuffer(0);
        int sequencesLength = 0;
        for (byte[] bs : sequences) {
            sequencesLength += bs.length;
        }
        int i = 0;
        while (!this.isMatched && i <= this.readLength - sequencesLength) {
            if (this.match(i, sequences)) {
                this.isMatched = true;
                this.bytesHandler.handle(this.buffer, i);
                this.prefillBuffer(i + sequencesLength);
                continue;
            }
            int sequenceLimit = this.readLength - sequencesLength + 1;
            int realLimit = sequenceLimit < userLimit ? sequenceLimit : userLimit;
            if (realLimit > 0 && i == realLimit - 1) {
                this.bytesHandler.handle(this.buffer, realLimit);
                this.prefillBuffer(realLimit);
                i = 0;
                continue;
            }
            ++i;
        }
        if (!this.isMatched && this.readLength > 0) {
            this.bytesHandler.handle(this.buffer, this.readLength);
            this.prefillBuffer(this.readLength);
        }
        if (this.readLength == 0) {
            this.isEOF = true;
        }
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    public boolean isMatched() {
        return this.isMatched;
    }

    public boolean isMatchedAndNotEOF() {
        return this.isMatched() && !this.isEOF();
    }

    public static interface BytesHandler {
        public void handle(byte[] var1, int var2) throws IOException;
    }
}

