/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.component.UIDndParam;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.renderkit.AttributeParametersEncoder;

public class DnDParametersEncoder
implements AttributeParametersEncoder {
    private static DnDParametersEncoder instance = null;
    private static final String DEFAULT = "default";
    private static final String DRAG = "drag";
    private static final String DROP = "drop";
    private static final String MESSAGE_CAST = "DnD parameter [{0}] of type [{1}] applied to component [{2}] has been ignored because component doesn''t implement [{3}]!";
    private static final String MESSAGE_UNK_TYPE = "DnD parameter [{0}] is of unknown type [{1}]!";

    private DnDParametersEncoder() {
    }

    public static synchronized DnDParametersEncoder getInstance() {
        if (instance == null) {
            instance = new DnDParametersEncoder();
        }
        return instance;
    }

    public void doEncode(FacesContext context, UIComponent component) throws IOException {
        Map params = this.doEncodeAsMap(context, component);
        ResponseWriter responseWriter = context.getResponseWriter();
        Set entrySet = params.entrySet();
        for (Map.Entry entry : entrySet) {
            String name = (String)entry.getKey();
            JSONObject dndParams = (JSONObject)entry.getValue();
            if (dndParams == null) continue;
            responseWriter.writeAttribute("rich:" + name + "dndparams", (Object)dndParams.toString(), null);
        }
    }

    private void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.renderChild(facesContext, child);
            }
        }
    }

    private void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public String doEncodeAsString(FacesContext context, UIComponent component) throws IOException {
        JSONObject merged = new JSONObject();
        try {
            Map map = this.doEncodeAsMap(context, component);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                JSONObject object = (JSONObject)entry.getValue();
                Iterator keys = object.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    merged.put(key, object.get(key));
                }
            }
        }
        catch (JSONException e) {
            IOException exception = new IOException(e.getMessage());
            exception.initCause(e.getCause());
            throw exception;
        }
        return merged.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map doEncodeAsMap(FacesContext context, UIComponent component) throws IOException {
        boolean isDropzone;
        LinkedHashMap<String, JSONObject> params = new LinkedHashMap<String, JSONObject>();
        params.put(DEFAULT, new JSONObject());
        boolean isDraggable = component instanceof Draggable;
        if (isDraggable) {
            params.put(DRAG, new JSONObject());
        }
        if (isDropzone = component instanceof Dropzone) {
            params.put(DROP, new JSONObject());
        }
        try {
            if (component.getChildCount() != 0) {
                List children = component.getChildren();
                for (Object object : children) {
                    FacesMessage message;
                    String messageString;
                    if (!(object instanceof UIDndParam)) continue;
                    UIDndParam dndParam = (UIDndParam)((Object)object);
                    String type = dndParam.getType();
                    JSONObject dndParams = null;
                    if (DRAG.equals(type)) {
                        if (isDraggable) {
                            dndParams = (JSONObject)params.get(DRAG);
                        } else {
                            messageString = MessageFormat.format(MESSAGE_CAST, MessageUtil.getLabel((FacesContext)context, (UIComponent)dndParam), type, MessageUtil.getLabel((FacesContext)context, (UIComponent)component), Draggable.class.getSimpleName());
                            message = new FacesMessage(messageString, messageString);
                            context.addMessage(component.getClientId(context), message);
                        }
                    } else if (DROP.equals(type)) {
                        if (isDropzone) {
                            dndParams = (JSONObject)params.get(DROP);
                        } else {
                            messageString = MessageFormat.format(MESSAGE_CAST, MessageUtil.getLabel((FacesContext)context, (UIComponent)dndParam), type, MessageUtil.getLabel((FacesContext)context, (UIComponent)component), Dropzone.class.getSimpleName());
                            message = new FacesMessage(messageString, messageString);
                            context.addMessage(component.getClientId(context), message);
                        }
                    } else if (type == null || type.length() == 0 || DEFAULT.equals(type)) {
                        dndParams = (JSONObject)params.get(DEFAULT);
                    } else {
                        messageString = MessageFormat.format(MESSAGE_UNK_TYPE, MessageUtil.getLabel((FacesContext)context, (UIComponent)dndParam), type);
                        throw new IllegalArgumentException(messageString);
                    }
                    if (dndParams == null || !dndParam.isRendered()) continue;
                    ResponseWriter responseWriter = context.getResponseWriter();
                    StringWriter dumpWriter = new StringWriter();
                    try {
                        context.setResponseWriter(responseWriter.cloneWithWriter((Writer)dumpWriter));
                        if (dndParam.getChildCount() == 0) {
                            context.getResponseWriter().writeText(dndParam.getValue(), null);
                        } else {
                            List paramChildren = dndParam.getChildren();
                            for (UIComponent paramChild : paramChildren) {
                                this.renderChild(context, paramChild);
                            }
                        }
                        context.getResponseWriter().flush();
                    }
                    finally {
                        context.setResponseWriter(responseWriter);
                    }
                    String childContent = dumpWriter.getBuffer().toString();
                    dndParams.put(dndParam.getName(), (Object)childContent);
                }
            }
            Set entrySet = params.entrySet();
            for (Map.Entry entry : entrySet) {
                JSONObject dndParams = (JSONObject)entry.getValue();
                if (dndParams.length() != 0) continue;
                entry.setValue(null);
            }
        }
        catch (JSONException e) {
            IOException exception = new IOException(e.getMessage());
            exception.initCause(e.getCause());
            throw exception;
        }
        return params;
    }
}

