/*
 * Decompiled with CFR 0.152.
 */
package netscape.oji;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class ProxyClassLoaderFactory {
    private static HashMap mClassLoaders = new HashMap();

    static void debug(String message) {
        System.out.println("<<< " + message + " >>>");
    }

    private static byte[] getMRJPluginClassFile(String path) {
        try {
            String homeDir = System.getProperty("netscape.oji.plugin.home");
            ZipFile jarFile = new ZipFile(new File(homeDir, "MRJPlugin.jar"));
            ZipEntry classEntry = jarFile.getEntry(path);
            int size = (int)classEntry.getSize();
            if (size > 0) {
                byte[] data = new byte[size];
                DataInputStream input = new DataInputStream(jarFile.getInputStream(classEntry));
                input.readFully(data);
                input.close();
                jarFile.close();
                return data;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static native void holdSecureEnv(int var0);

    private static native void releaseSecureEnv(int var0);

    public static ClassLoader createClassLoader(String documentURL, int secureEnv) throws MalformedURLException {
        ProxyClassLoader loader = null;
        try {
            loader = new ProxyClassLoader(documentURL, secureEnv);
            mClassLoaders.clear();
            mClassLoaders.put(documentURL, new WeakReference<ProxyClassLoader>(loader));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return loader;
    }

    static /* synthetic */ byte[] access$000(String x0) {
        return ProxyClassLoaderFactory.getMRJPluginClassFile(x0);
    }

    private static class ProxyClassLoader
    extends URLClassLoader {
        private int secureEnv = 0;
        private String documentURL = null;
        private static byte[] data = ProxyClassLoaderFactory.access$000("netscape/oji/LiveConnectProxy.class");

        ProxyClassLoader(String documentURL, int secureEnv) throws MalformedURLException {
            super(new URL[]{new URL(documentURL)});
            this.documentURL = documentURL;
            this.secureEnv = secureEnv;
            ProxyClassLoaderFactory.holdSecureEnv(secureEnv);
            if (data != null) {
                Class<?> proxyClass = this.defineClass("netscape.oji.LiveConnectProxy", data, 0, data.length, new CodeSource(new URL(documentURL), (Certificate[])null));
                ProxyClassLoaderFactory.debug("ProxyClassLoader: defined LiveConnectProxy class.");
                ProxyClassLoaderFactory.debug("Here're the permissions you've got:");
                ProxyClassLoaderFactory.debug(proxyClass.getProtectionDomain().getPermissions().toString());
            } else {
                ProxyClassLoaderFactory.debug("ProxyClassLoader: failed to define LiveConnectProxy class.");
            }
        }

        protected void finalize() throws Throwable {
            ProxyClassLoaderFactory.releaseSecureEnv(this.secureEnv);
            mClassLoaders.remove(this.documentURL);
            super.finalize();
        }
    }
}

