/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.tuple.AbstractComponentTuplizer;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.util.ReflectHelper;

public class PojoComponentTuplizer
extends AbstractComponentTuplizer {
    private final Class componentClass;
    private transient BulkBean optimizer;
    private transient FastClass fastClass;
    private final Getter parentGetter;
    private final Setter parentSetter;
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };
    private static final Class[] CALLBACK_TYPES = new Class[]{MethodInterceptor.class, NoOp.class};

    public PojoComponentTuplizer(Component component) {
        super(component);
        this.componentClass = component.getComponentClass();
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        String parentPropertyName = component.getParentProperty();
        if (parentPropertyName == null) {
            this.parentSetter = null;
            this.parentGetter = null;
        } else {
            PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(null);
            this.parentSetter = pa.getSetter(this.componentClass, parentPropertyName);
            this.parentGetter = pa.getGetter(this.componentClass, parentPropertyName);
        }
        if (this.hasCustomAccessors || !Environment.useReflectionOptimizer()) {
            this.fastClass = null;
            this.optimizer = null;
        } else {
            this.fastClass = ReflectHelper.getFastClass(this.componentClass);
            this.optimizer = ReflectHelper.getBulkBean(this.componentClass, getterNames, setterNames, propTypes, this.fastClass);
            if (this.optimizer == null) {
                this.fastClass = null;
            }
        }
    }

    public Class getMappedClass() {
        return this.componentClass;
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        if (this.optimizer != null) {
            try {
                return this.optimizer.getPropertyValues(component);
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        return super.getPropertyValues(component);
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        if (this.optimizer != null) {
            try {
                this.optimizer.setPropertyValues(component, values);
                return;
            }
            catch (Throwable t) {
                throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.componentClass, ReflectHelper.getPropertyName(t, this.optimizer));
            }
        }
        super.setPropertyValues(component, values);
    }

    public Object getParent(Object component) {
        return this.parentGetter.get(component);
    }

    public boolean hasParentProperty() {
        return this.parentGetter != null;
    }

    public boolean isMethodOf(Method method) {
        for (int i = 0; i < this.propertySpan; ++i) {
            Method getterMethod = this.getters[i].getMethod();
            if (getterMethod == null || !getterMethod.equals(method)) continue;
            return true;
        }
        return false;
    }

    public void setParent(Object component, Object parent, SessionFactoryImplementor factory) {
        this.parentSetter.set(component, parent, factory);
    }

    protected Instantiator buildInstantiator(Component component) {
        if (component.isEmbedded() && ReflectHelper.isAbstractClass(component.getComponentClass())) {
            return new ProxiedInstantiator(component);
        }
        return new PojoInstantiator(component, this.fastClass);
    }

    protected Getter buildGetter(Component component, Property prop) {
        return prop.getGetter(component.getComponentClass());
    }

    protected Setter buildSetter(Component component, Property prop) {
        return prop.getSetter(component.getComponentClass());
    }

    private static class PassThroughInterceptor
    implements MethodInterceptor {
        private HashMap data = new HashMap();
        private final String proxiedClassName;

        public PassThroughInterceptor(String proxiedClassName) {
            this.proxiedClassName = proxiedClassName;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            boolean hasSetterSignature;
            String name = method.getName();
            if ("toString".equals(name)) {
                return this.proxiedClassName + "@" + System.identityHashCode(obj);
            }
            if ("equals".equals(name)) {
                return args[0] instanceof Factory && ((Factory)args[0]).getCallback(0) == this ? Boolean.TRUE : Boolean.FALSE;
            }
            if ("hashCode".equals(name)) {
                return new Integer(System.identityHashCode(obj));
            }
            boolean hasGetterSignature = method.getParameterTypes().length == 0 && method.getReturnType() != null;
            boolean bl = hasSetterSignature = method.getParameterTypes().length == 1 && (method.getReturnType() == null || method.getReturnType() == Void.TYPE);
            if (name.startsWith("get") && hasGetterSignature) {
                String propName = name.substring(3);
                return this.data.get(propName);
            }
            if (name.startsWith("is") && hasGetterSignature) {
                String propName = name.substring(2);
                return this.data.get(propName);
            }
            if (name.startsWith("set") && hasSetterSignature) {
                String propName = name.substring(3);
                this.data.put(propName, args[0]);
                return null;
            }
            return null;
        }
    }

    private static class ProxiedInstantiator
    implements Instantiator {
        private final Class proxiedClass;
        private final Class proxyClass;
        private final Factory factory;

        public ProxiedInstantiator(Component component) {
            this.proxiedClass = component.getComponentClass();
            this.proxyClass = this.buildProxyClass();
            this.factory = this.buildFactory();
        }

        public Object instantiate(Serializable id) {
            throw new AssertionFailure("ProxiedInstantiator can only be used to instantiate component");
        }

        public Object instantiate() {
            try {
                return this.factory.newInstance(new Callback[]{new PassThroughInterceptor(this.proxyClass.getName()), NoOp.INSTANCE});
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to instantiate proxy instance");
            }
        }

        public boolean isInstance(Object object) {
            return this.proxiedClass.isInstance(object);
        }

        private Class buildProxyClass() {
            Enhancer en = new Enhancer();
            en.setUseCache(false);
            en.setInterceptDuringConstruction(false);
            en.setUseFactory(true);
            en.setCallbackTypes(CALLBACK_TYPES);
            en.setCallbackFilter(FINALIZE_FILTER);
            if (this.proxiedClass.isInterface()) {
                en.setInterfaces(new Class[]{this.proxiedClass});
            } else {
                en.setSuperclass(this.proxiedClass);
            }
            return en.createClass();
        }

        private Factory buildFactory() {
            try {
                return (Factory)this.proxyClass.newInstance();
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to build CGLIB Factory instance");
            }
        }
    }
}

