/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi.work;

import javax.resource.NotSupportedException;
import javax.transaction.xa.Xid;

/**
 * An execution context provides context information for work, e.g.
 * transaction, security, etc.
 */
public class ExecutionContext
{
   /** The xid */
   private Xid xid;
   /** The timeout */
   private long timeout = WorkManager.UNKNOWN;

   /**
	 * Get the xid
	 * 
	 * @return the xid
	 */
   public Xid getXid()
   {
      return xid;
   }

   /**
	 * Set the xid
	 * 
	 * @param xid the xid
	 */
   public void setXid(Xid xid)
   {
      this.xid = xid;
   }

   /**
	 * Get the transaction timeout
	 * 
	 * @return the transaction timeout or WorkManager.UNKNOWN for an invalid or
	 *         unspecified value
	 */
   public long getTransactionTimeout()
   {
      return timeout;
   }

   /**
	 * Set the transaction timeout
	 * 
	 * @param timeout the timeout
	 * @throws NotSupportedException for an invalid timeout
	 */
   public void setTransactionTimeout(long timeout) throws NotSupportedException
   {
      if (timeout < 0)
         throw new NotSupportedException("Illegal timeout " + timeout);
      this.timeout = timeout;
   }
}