/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.devstudio.core.intro.action;

import com.jboss.devstudio.core.Activator;
import com.jboss.devstudio.core.Messages;
import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenPerspectiveIntroURLAction
implements IIntroAction {
    private IWorkbenchWindow workbenchWindow;

    public void run(IIntroSite site, Properties params) {
        if (params == null || params.getProperty("perspectiveId", null) == null) {
            return;
        }
        String perspectiveId = params.getProperty("perspectiveId", null);
        this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.workbenchWindow == null) {
            return;
        }
        if (perspectiveId != null && perspectiveId.trim().length() > 0) {
            if (this.openNewWindow()) {
                try {
                    IWorkbench workbench = this.getWorkbench();
                    IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                    workbench.openWorkbenchWindow(perspectiveId, input);
                }
                catch (WorkbenchException e) {
                    Activator.logError("com.jboss.devstudio.core", e);
                }
            } else {
                IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
                    IPerspectiveDescriptor perspectiveDescr = reg == null ? null : reg.findPerspectiveWithId(perspectiveId);
                    IPerspectiveDescriptor activePerspectiveDescr = activePage.getPerspective();
                    if (perspectiveDescr != null && perspectiveDescr != activePerspectiveDescr) {
                        activePage.setPerspective(perspectiveDescr);
                    } else {
                        IIntroManager intro;
                        IIntroPart part;
                        if (perspectiveDescr == null) {
                            String errorText = MessageFormat.format(Messages.INTRO_PERSPECTIVE_NOT_FOUND, perspectiveId);
                            Activator.logError("com.jboss.devstudio.core", errorText);
                        }
                        if ((part = (intro = activePage.getWorkbenchWindow().getWorkbench().getIntroManager()).getIntro()) == null) {
                            return;
                        }
                        if (!intro.isIntroStandby(part)) {
                            intro.setIntroStandby(part, true);
                        }
                    }
                } else {
                    try {
                        IWorkbench workbench = this.getWorkbench();
                        IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                        this.getWorkbench().getActiveWorkbenchWindow().openPage(perspectiveId, input);
                    }
                    catch (WorkbenchException e) {
                        Activator.logError("com.jboss.devstudio.core", e);
                    }
                }
            }
        }
    }

    boolean openNewWindow() {
        try {
            IPreferenceStore store = PrefUtil.getInternalPreferenceStore();
            IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return activePage != null && activePage.getPerspective() != null && 2 == store.getInt("OPEN_PERSPECTIVE_MODE");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

