/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * A IllegalStateException is thrown when a method has been invoked on an
 * object which is in the wrong state to execute the method.
 */
public class IllegalStateException extends ResourceException
{
   /**
	 * Create an exception.
	 */
   public IllegalStateException()
   {
      super();
   }
   /**
	 * Create an exception with a reason.
	 */
   public IllegalStateException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an exception with a reason and an errorCode.
	 */
   public IllegalStateException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
    * Create an exception with a reason and cause.
    * 
    * @param reason the reason
    * @param cause the cause
    */
   public IllegalStateException(String reason, Throwable cause)
   {
      super(reason, cause);
   }

   /**
    * Create an exception with a cause.
    * 
    * @param cause the cause
    */
   public IllegalStateException(Throwable cause)
   {
      super(cause);
   }
}