/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class CreateCommand
extends MBeanServerCommand {
    private String className;
    private ObjectName objectName;
    private ObjectName loaderName;

    public CreateCommand() {
        super("create", "Create an MBean");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <class> [<name>]");
        out.println();
        out.println("options:");
        out.println("    -l, --loader=<name>    Treat object name as a query");
        out.println("    --                     Stop processing options");
        out.flush();
    }

    private boolean processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:l:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("loader", 2, null, 108)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block2 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.className = arg;
                            this.log.debug((Object)("class name: " + this.className));
                            break block2;
                        }
                        case 1: {
                            try {
                                this.objectName = new ObjectName(arg);
                                this.log.debug((Object)("mbean name: " + this.objectName));
                                break block2;
                            }
                            catch (MalformedObjectNameException e) {
                                throw new CommandException("Invalid object name: " + arg);
                            }
                        }
                    }
                    throw new CommandException("Unused argument: " + arg);
                }
                case 108: {
                    String arg = getopt.getOptarg();
                    try {
                        this.loaderName = new ObjectName(arg);
                        this.log.debug((Object)("loader name: " + this.loaderName));
                        break;
                    }
                    catch (MalformedObjectNameException e) {
                        throw new CommandException("Invalid loader object name: " + arg);
                    }
                }
            }
        }
        return true;
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.className == null) {
            throw new CommandException("Missing class name");
        }
        MBeanServerConnection server = this.getMBeanServer();
        ObjectInstance obj = this.loaderName == null ? server.createMBean(this.className, this.objectName) : server.createMBean(this.className, this.objectName, this.loaderName);
        if (!this.context.isQuiet()) {
            PrintWriter out = this.context.getWriter();
            out.println(obj.getObjectName());
            out.flush();
        }
    }
}

