 /*******************************************************************************
  * Copyright (c) 2007 Red Hat, Inc.
  * Distributed under license by Red Hat, Inc. All rights reserved.
  * This program is made available under the terms of the
  * Eclipse Public License v1.0 which accompanies this distribution,
  * and is available at http://www.eclipse.org/legal/epl-v10.html
  *
  * Contributors:
  *     Red Hat, Inc. - initial API and implementation
  ******************************************************************************/
package org.jboss.tools.seam.internal.core.validation;

import java.util.Set;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamTextSourceReference;

/**
 * @author Alexey Kazakov
 */
public interface IValidationErrorManager {

	/**
	 * Adds a marker to the resource
	 * @param messageId
	 * @param preferenceKey
	 * @param messageArguments
	 * @param location
	 * @param target
	 */
	void addError(String messageId, String preferenceKey,
			String[] messageArguments, ISeamTextSourceReference location,
			IResource target);

	/**
	 * Adds a marker to the resource
	 * @param messageId
	 * @param preferenceKey
	 * @param messageArguments
	 * @param target
	 */
	void addError(String messageId, String preferenceKey,
			String[] messageArguments,
			IResource target);

	/**
	 * Adds a marker to the resource
	 * @param messageId
	 * @param preferenceKey
	 * @param location
	 * @param target
	 */
	void addError(String messageId, String preferenceKey,
			ISeamTextSourceReference location, IResource target);

	/**
	 * Adds a marker to the resource
	 * @param messageId
	 * @param preferenceKey
	 * @param messageArguments
	 * @param length
	 * @param offset
	 * @param target
	 */
	void addError(String messageId, String preferenceKey,
			String[] messageArguments, int length, int offset, IResource target);

	/**
	 * Adds a marker to the resource
	 * @param messageId
	 * @param severity
	 * @param messageArguments
	 * @param length
	 * @param offset
	 * @param target
	 */
	void addError(String messageId, int severity, String[] messageArguments, int length, int offset, IResource target);

	/**
	 * Displays a subtask in the progress view. 
	 * @param messageId
	 */
	void displaySubtask(String messageId);

	/**
	 * Displays a subtask in the progress view.
	 * @param messageId
	 * @param messageArguments
	 */
	void displaySubtask(String messageId, String[] messageArguments);

	/**
	 * Removes all markers for the resources
	 * @param resources
	 */
	void removeMessagesFromResources(Set<IResource> resources);

	/**
	 * Sets seam project
	 * @param project
	 */
	void setProject(ISeamProject project);

	/**
	 * Remove all validation messages for the resource.
	 * @param resource
	 */
	void removeAllMessagesFromResource(IResource resource);
}