package com.jboss.jbds.installer.bean;

import com.jboss.jbds.installer.CommonTestData;

import junit.framework.TestCase;

public class ServerBeanLoaderTest extends TestCase {
	public void testLoadAs328SP1() {
		ServerBean expected = new ServerBean(
				CommonTestData.AS_3_2_8_SP1.getPath(),
				CommonTestData.AS_3_2_8_SP1.getName(),
				ServerType.AS,
				"3.2");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.AS_3_2_8_SP1);
		assertEquals(expected,real);
	}
	
	public void testLoadAs405GA () {
		ServerBean expected = new ServerBean(
				CommonTestData.AS_4_0_5_GA.getPath(),
				CommonTestData.AS_4_0_5_GA.getName(),
				ServerType.AS,
				"4.0");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.AS_4_0_5_GA);
		assertEquals(expected,real);
	}
	
	public void testLoadAs422GA () {
		ServerBean expected = new ServerBean(
				CommonTestData.AS_4_2_2_GA.getPath(),
				CommonTestData.AS_4_2_2_GA.getName(),
				ServerType.AS,
				"4.2");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.AS_4_2_2_GA);
		assertEquals(expected,real);
	}
	
	public void testLoadAs423GA () {
		ServerBean expected = new ServerBean(
				CommonTestData.AS_4_2_3_GA.getPath(),
				CommonTestData.AS_4_2_3_GA.getName(),
				ServerType.AS,
				"4.2");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.AS_4_2_3_GA);
		assertEquals(expected,real);
	}
	
	public void testLoadEap430GACP1 () {
		ServerBean expected = new ServerBean(
				CommonTestData.EAP_4_3_0_GA_CP1.getPath(),
				CommonTestData.EAP_4_3_0_GA_CP1.getName(),
				ServerType.EAP,
				"4.3");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.EAP_4_3_0_GA_CP1);
		assertEquals(expected,real);
	}
	public void testLoadSoap430GA () {
		ServerBean expected = new ServerBean(
				CommonTestData.SOAP_4_3_0_GA.getPath(),
				CommonTestData.SOAP_4_3_0_GA.getName(),
				ServerType.SOAP,
				"4.3");
		ServerBean real = new ServerBeanLoader().loadFromLoaction(CommonTestData.SOAP_4_3_0_GA);
		assertEquals(expected,real);
	}
}
