package com.jboss.jbds.installer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.regex.Pattern;

import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.installer.ResourceManager;
import com.jboss.jbds.installer.bean.ServerBean;
import com.jboss.jbds.installer.bean.ServerBeanLoader;
import com.jboss.jbds.installer.bean.ServerListBean;
import com.jboss.jbds.installer.bean.ServerType;

public class ServerListPanel extends JPanel {

	private static final long serialVersionUID = 1256443616359329176L;
	private static final Dimension TABLE_PREF_SIZE = new Dimension(600, 60);
	private static Pattern ELEMENT_NAME_DEFAULT_PATTERN = Pattern.compile("[a-zA-Z0-9_][ a-zA-Z0-9_\\.\\-\\(\\)]*");

	private JTable table;
	private JScrollPane scrollPane;
	private LocaleDatabase langpack = null;
	private ServerListActionsPanel buttonPanel;
	String installedASName = "JBoss Application Server 4.2";
	
	ServerListBean serverListBean = new ServerListBean();
	File storedFolder = new File("/home/eskimo/exadel-projects/jbds-ganymede/plugins/devstudio-installer/src/test-resources/servers/jboss-4.0.5.GA");
	
	
	public ServerListPanel(LocaleDatabase langpack, ServerListBean serverListBean) {
		this(langpack);
		this.serverListBean = serverListBean;
	}
	
	public ServerListPanel(LocaleDatabase langpack) {
		
		GridBagLayout layout = new GridBagLayout();
		setLayout(layout);
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = 0;
		c.gridy = 0;
		c.gridheight = 2;
		c.gridwidth = 1;
		c.weightx = 1.0;
		c.weighty = 1.0;
		c.fill = GridBagConstraints.BOTH;
		this.langpack = langpack; 
		
		table = new JTable(new ServerListTableModel(serverListBean,langpack));
		    	table.getColumnModel().getColumn(0).setPreferredWidth(120);
		    	table.getColumnModel().getColumn(3).setPreferredWidth(300);
		    	table.getColumnModel().getColumn(2).setPreferredWidth(25);
		    	table.getColumnModel().getColumn(1).setPreferredWidth(15);

		scrollPane = new JScrollPane(table);
		table.setPreferredScrollableViewportSize(TABLE_PREF_SIZE);
		add(scrollPane, c);
		
		buttonPanel = new ServerListActionsPanel(new ServerListAction[] {
			new FindAction(),
			new AddAction(),
			new EditAction(),
			new RemoveAction()});
		c.gridx = 1;
		c.weightx = c.weighty = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		c.insets = new Insets(5,5,5,5);
		add(buttonPanel, c);
		c.gridx = 1;
		c.gridy = 1;
		c.weightx = 0; c.weighty = 1.0;
		c.gridheight = 1;
		c.gridwidth = 1;
		JPanel panel = new JPanel();
		add(panel,c);

	}
	
	public void setSelection(int[] selection) {
		table.getSelectionModel().setValueIsAdjusting(true);
		for (int i = 0; i < selection.length; i++) {
			table.getSelectionModel().addSelectionInterval(selection[i], selection[i]);
		}
		table.getSelectionModel().setValueIsAdjusting(false);
	}

	public void setTableEnabled(boolean flag){
		table.setEnabled(flag);
		table.setBackground(flag? Color.white :Color.lightGray);
		table.setGridColor(flag? Color.white :Color.lightGray);
		table.setRowSelectionAllowed(flag);
		scrollPane.getViewport().setBackground(flag? Color.white :Color.lightGray);
		Stack stack = new Stack();
		stack.push(Arrays.asList(flag?scrollPane.getComponents():getComponents()).iterator());
		while(!stack.isEmpty()) {
			Iterator iter = (Iterator)stack.peek(); 
			while(iter.hasNext()){
				Component comp = (Component)iter.next();
				comp.setEnabled(flag);
				if(comp instanceof JButton) {
					JButton bt = (JButton)comp;
					if(bt.getAction()!=null)
					bt.getAction().setEnabled(flag);
				} else if(comp instanceof Container) {
					Container cont = (Container)comp;
					if(cont.getComponents().length>0) {
						stack.push(Arrays.asList(cont.getComponents()).iterator());
						break;
					}
				}	
			}
			if(!iter.hasNext())
				stack.pop();	
		}
		if(flag) {
			validateButtons();
		}
	}
	
	public void validateButtons(){
		buttonPanel.valueChanged(null);
	}
	
	public boolean isValidated(){
		return true;
	}

	private JComboBox versionCombo = null;
	private JRadioButton type1=null, type2=null, type3=null;

	
	class VersionModel extends DefaultComboBoxModel implements ActionListener {

		String[] versions = ServerType.UNKNOWN.getVersions();
		
		public VersionModel(ServerType type){
			versions = type.getVersions();
		}
		
		public Object getElementAt(int index) {
			return versions[index];
		}

		public int getSize() {
			return versions.length;
		}

		public void actionPerformed(ActionEvent e) {
			JRadioButton selection = (JRadioButton)e.getSource();
			ServerType type = ServerType.getType(selection.getText());
			versions = type.getVersions();
			fireContentsChanged(this, 0, 0);
		}
	}
	
	public static class ServerListTableModel extends AbstractTableModel implements PropertyChangeListener {
		ServerListBean serverList;
		LocaleDatabase langpack;
		
		public ServerListTableModel(ServerListBean list,LocaleDatabase langpack){
			this.serverList = list;
			this.langpack = langpack;
			list.addPropertyChangeListener(this);
		}

		public Class getColumnClass(int columnIndex) {
			switch(columnIndex) {
				case 0:
					return String.class;
				case 1:
					return ServerType.class;
				case 2:
					return String.class;
				case 3:
					return String.class;
			}
			return String.class;
		}

		public int getColumnCount() {
			return 4;
		}

		public String getColumnName(int columnIndex) {
			switch(columnIndex){
			case 0:
				return langpack.getString("JBossAsSelectPanel.NameColumn");
			case 1:
				return langpack.getString("JBossAsSelectPanel.TypeColumn");
			case 2:
				return langpack.getString("JBossAsSelectPanel.VersionColumn");
			case 3:
				return langpack.getString("JBossAsSelectPanel.LocationColumn");
			}
			return null;
		}

		public int getRowCount() {
			return serverList.getServers().size();
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			switch(columnIndex) {
				case 0:
					return serverList.getServers().get(rowIndex).getName();
				case 1:
					return serverList.getServers().get(rowIndex).getType();
				case 2:
					return serverList.getServers().get(rowIndex).getVersion();
				case 3:
					return serverList.getServers().get(rowIndex).getLocation();
			}
			throw new IllegalArgumentException("Column index is " + columnIndex + ". It cannot be more than " + getColumnCount() + ".");
		}
		
		public boolean isCellEditable(int rowIndex, int columnIndex) {
			return false;
		}

		public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		}

		public void propertyChange(PropertyChangeEvent evt) {
			if(evt instanceof IndexedPropertyChangeEvent) {
				IndexedPropertyChangeEvent event = (IndexedPropertyChangeEvent)evt;
				fireTableRowsUpdated(event.getIndex(),event.getIndex());
			} else {
				fireTableDataChanged();
			}
		}
	}

	public List<ServerBean> getServerList() {
		return serverListBean.getServers();
	}
	
	/**
	 * @author eskimo
	 *
	 */
	public class ServerPanel extends JPanel {

		private EditDialog editDialog;
		private static final int PREF_WIDTH = 450;
		JTextField locationField;
		JTextField nameField;
		ButtonGroup typeGroup;
		JLabel sversionName;
		VersionModel versionModel;
		ServerBean bean;
		ServerBean originalBean;
		Validator validator = new Validator();
		
		public ServerPanel(EditDialog dialog, ServerBean bean) {
			ImageIcon image = null;
			this.bean = bean;
			this.originalBean = new ServerBean(bean);
			editDialog = dialog;
			ValidatorAdapter validatorAdapter =  new ValidatorAdapter();
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.weighty = 1.0;
		    c.weightx = 1.0;
			c.fill = GridBagConstraints.HORIZONTAL;
			
			JPanel bodyPanel = this;
			bodyPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
			bodyPanel.setLayout(new GridBagLayout());
			
			JLabel locationLabel = new JLabel(langpack.getString("JBossAsSelectPanel.Location"));
			c = new GridBagConstraints();
		    c.fill = GridBagConstraints.HORIZONTAL;
		    c.insets = new Insets(5, 5, 5, 5);
		    c.gridx = 0;
		    c.gridy = 0;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = c.weighty = 0.0;
			bodyPanel.add(locationLabel,c);
			
			locationField = new JTextField(30);

		    c.gridx = 1;
		    c.gridy = 0;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 1.0;
		    c.weighty = 0.0;
			bodyPanel.add(locationField,c);
			
			JButton locationButton = new JButton(langpack.getString("JBossAsSelectPanel.Brows"));
			locationButton.addActionListener(new BrowseAction());
			
		    c.gridx = 2;
		    c.gridy = 0;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 0.0;
		    c.weighty = 0.0;
			bodyPanel.add(locationButton,c);
			
			JLabel nameLabel = new JLabel(langpack.getString("JBossAsSelectPanel.Name"));
		    c.gridx = 0;
		    c.gridy = 1;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 0.0;
		    c.weighty = 0.0;
		    c.fill = GridBagConstraints.HORIZONTAL;
			bodyPanel.add(nameLabel,c);
			
			nameField = new JTextField(20);

		    c.gridx = 1;
		    c.gridy = 1;
		    c.gridwidth = 2;
		    c.gridheight = 1;
		    c.weightx = 1.0;
		    c.weighty = 0.0;
		    c.fill = GridBagConstraints.HORIZONTAL;
			bodyPanel.add(nameField,c);
			
			versionModel = new VersionModel(bean.getType());
			
			JLabel typeLabel = new JLabel(langpack.getString("JBossAsSelectPanel.Type"));
		    c.gridx = 0;
		    c.gridy = 2;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 0.0;
		    c.weighty = 0.0;
			bodyPanel.add(typeLabel,c);
			
			JPanel typePanel = new JPanel();
			typePanel.setLayout(new BoxLayout(typePanel, BoxLayout.LINE_AXIS));
			
			type1 = new JRadioButton(langpack.getString("JBossAsSelectPanel.Type1"));
			type1.setSelected(bean.getType().getType().equals(type1.getText()));

			typePanel.add(type1);
			
			typePanel.add(Box.createHorizontalStrut(5));
			
			type2 = new JRadioButton(langpack.getString("JBossAsSelectPanel.Type2"));
			type2.setSelected(bean.getType().getType().equals(type2.getText()));
			typePanel.add(type2);
			
			typePanel.add(Box.createHorizontalStrut(5));

			type3 = new JRadioButton(langpack.getString("JBossAsSelectPanel.Type3"));
			type3.setSelected(bean.getType().getType().equals(type3.getText()));
			typePanel.add(type3);
			
			typeGroup = new ButtonGroup();
			typeGroup.add(type1);
			typeGroup.add(type2);
			typeGroup.add(type3);
			Enumeration types = typeGroup.getElements();
			while(types.hasMoreElements()) {
				JRadioButton type = (JRadioButton)types.nextElement();
				if(type.isSelected()) {
					type.doClick();
				}
			}
		    c.gridx = 1;
		    c.gridy = 2;
		    c.gridwidth = 2;
		    c.gridheight = 1;
		    c.weightx = 1.0;
		    c.weighty = 0.0;
			bodyPanel.add(typePanel,c);
			
			JLabel sversionLabel = new JLabel(langpack.getString("JBossAsSelectPanel.Version"));
			c.gridx = 0;
		    c.gridy = 3;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 0.0;
		    c.weighty = 0.0;
			bodyPanel.add(sversionLabel,c);
			versionModel.setSelectedItem(bean.getVersion());
			versionCombo = new JComboBox(versionModel);

		    c.gridx = 1;
		    c.gridy = 3;
		    c.gridwidth = 1;
		    c.gridheight = 1;
		    c.weightx = 0.0;
		    c.weighty = 0.0;
		    c.fill = GridBagConstraints.NONE;
		    c.anchor = GridBagConstraints.LINE_START;
		    versionCombo.setPreferredSize(new Dimension(60, versionCombo.getPreferredSize().height));
		    
			bodyPanel.add(versionCombo,c);
			
			c.gridx = 0;
		    c.gridy = 4;
		    c.gridwidth = 3;
		    c.gridheight = 1;
		    c.weightx = 1.0;
		    c.weighty = 1.0;
		    c.fill = GridBagConstraints.BOTH;
		    c.anchor = GridBagConstraints.LINE_START;
			bodyPanel.add(new JPanel(),c);
		    
		    locationField.setText(bean.getLocation());
		    nameField.setText(bean.getName());
		    
		    // Init Validation first and it will called after all changes propagated
		    locationField.getDocument().addDocumentListener(validatorAdapter);
		    nameField.getDocument().addDocumentListener(validatorAdapter);
			type1.addActionListener(validatorAdapter);
			type2.addActionListener(validatorAdapter);
			type3.addActionListener(validatorAdapter);
			versionCombo.addActionListener(validatorAdapter);
			
			locationField.getDocument().addDocumentListener(new DocumentListener(){
				public void changedUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setLocation(locationField.getText().trim());
				}
				public void insertUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setLocation(locationField.getText().trim());
				}
				public void removeUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setLocation(locationField.getText().trim());
				}});
			nameField.getDocument().addDocumentListener(new DocumentListener(){
				public void changedUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setName(nameField.getText().trim());
				}
				public void insertUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setName(nameField.getText().trim());
				}
				public void removeUpdate(DocumentEvent e) {
					ServerPanel.this.bean.setName(nameField.getText().trim());
				}});
			type1.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					ServerPanel.this.bean.setType(ServerType.getType(type1.getText()));
//					ServerBean defaul	ts = new ServerBeanLoader().loadFromLoaction(new File(ServerPanel.this.bean.getLocation()));
//					if(!ServerBean.EMPTY.equals(defaults.getVersion())) {
//						String[] versions = ServerPanel.this.bean.getType().getVersions();
//						if(Arrays.asList(versions).contains(defaults.getVersion()) ) {
//							versionCombo.setSelectedItem(defaults.getVersion());
//							ServerPanel.this.bean.setVersion(defaults.getVersion());
//						} else {
//							versionCombo.setSelectedItem(ServerBean.EMPTY);
//							ServerPanel.this.bean.setVersion(ServerBean.EMPTY);
//						}
//					}
				}});
			type2.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					ServerPanel.this.bean.setType(ServerType.getType(type2.getText()));
//					ServerBean defaults = new ServerBeanLoader().loadFromLoaction(new File(ServerPanel.this.bean.getLocation()));
//					if(!ServerBean.EMPTY.equals(defaults.getVersion())) {
//						String[] versions = ServerPanel.this.bean.getType().getVersions();
//						if(Arrays.asList(versions).contains(defaults.getVersion()) ) {
//							versionCombo.setSelectedItem(defaults.getVersion());
//							ServerPanel.this.bean.setVersion(defaults.getVersion());
//						} else {
//							versionCombo.setSelectedItem(ServerBean.EMPTY);
//							ServerPanel.this.bean.setVersion(ServerBean.EMPTY);
//						}
//					}
				}});
			type3.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent e) {
					ServerPanel.this.bean.setType(ServerType.getType(type3.getText()));
//					ServerBean defaults = new ServerBeanLoader().loadFromLoaction(new File(ServerPanel.this.bean.getLocation()));
//					if(!ServerBean.EMPTY.equals(defaults.getVersion())) {
//						String[] versions = ServerPanel.this.bean.getType().getVersions();
//						if(Arrays.asList(versions).contains(defaults.getVersion()) ) {
//							versionCombo.setSelectedItem(defaults.getVersion());
//							ServerPanel.this.bean.setVersion(defaults.getVersion());
//						} else {
//							versionCombo.setSelectedItem(ServerBean.EMPTY);
//							ServerPanel.this.bean.setVersion(ServerBean.EMPTY);
//						}
//					}
				}});
			type1.addActionListener(versionModel);
			type2.addActionListener(versionModel);
			type3.addActionListener(versionModel);
			
			versionCombo.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					ServerPanel.this.bean.setVersion(versionCombo.getSelectedItem().toString());
				}
				
			});
			validateBean();
		}

		@Override
		public Dimension getPreferredSize() {
			// TODO Auto-generated method stub
			return new Dimension(PREF_WIDTH,super.getPreferredSize().height);
		}
		
		public void setEditDialog(EditDialog editDialog) {
			this.editDialog = editDialog;
		}
		
		public void loadDefaults(File selectedFile) {
			JFrame parentFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, ServerListPanel.this);

			ServerBean defaults = new ServerBeanLoader().loadFromLoaction(selectedFile);
			
			if(defaults.getType()== ServerType.UNKNOWN) {
				JOptionPane.showMessageDialog(parentFrame, 
						langpack.getString("ServerDialog_TypeAndVersionCannotBeDefined")
						+ "\n" 
						+ langpack.getString("ServerDialog_YouNeedToFillThemManually"));
			} else if(defaults.getVersion().length()==0) {
				JOptionPane.showMessageDialog(parentFrame, 
						langpack.getString("ServerDialog_VersionCannotBeDefined")
						+ "\n" 
						+ langpack.getString("ServerDialog_YouNeedToFillItManually"));
			}
			
			getValidator().setDisabled(true);
			locationField.setText(selectedFile.getPath());
			// TODO remove forbidden characters from name or allow all what is allowed for file name
			nameField.setText(defaults.getName());
			for (Enumeration types = typeGroup.getElements();
				types.hasMoreElements(); ) {
				AbstractButton radio = (AbstractButton)types.nextElement();
				if(radio.getText().equals(defaults.getType().getType())) {
					radio.doClick();
				}
			}
			versionModel.setSelectedItem(defaults.getVersion());
			doLayout();
			getValidator().setDisabled(false);
			validateBean();
		}
		
		public void validateBean() {
			if(!getValidator().isDisabled()) {
				ValidationResult result = validator.validate(originalBean,bean,serverListBean.getServers());
				String message = langpack.getString(result.getMessageKey());
				if(result.getSeverety() == ValidationResult.ERROR) {
					editDialog.setErrorMessage(message);
					editDialog.setComplete(false);
				} else if(result.getSeverety() == ValidationResult.WARNING) {
					editDialog.setWarningMessage(message);
					editDialog.setComplete(!originalBean.equals(bean));
				} else if(result.getSeverety() == ValidationResult.OK) {
					editDialog.setInfoMessage(message);
					editDialog.setComplete(!originalBean.equals(bean));
				}
			}
		}
		
		public void setValidator(Validator validator) {
			this.validator = validator;
		}
		
		public Validator getValidator() {
			return validator;
		}
		
		/**
		 * @author eskimo
		 */
		public class BrowseAction extends AbstractAction {
		

			/* (non-Javadoc)
			 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
			 */
			public void actionPerformed(ActionEvent event){
				JFileChooser chooser;
				if(storedFolder != null)
					chooser = new JFileChooser(storedFolder);
				else
					chooser = new JFileChooser();
				
				chooser.setDialogTitle(langpack.getString("JBossAsSelectPanel.FileChooserTitle"));
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int returnValue = chooser.showDialog(SwingUtilities.getAncestorOfClass(JDialog.class, ServerPanel.this), langpack.getString("JBossAsSelectPanel.FileChooserButton"));
				if(returnValue == JFileChooser.APPROVE_OPTION){
					File selectedFile = chooser.getSelectedFile();
					storedFolder = selectedFile.getParentFile();
					loadDefaults(selectedFile);
				}
			}
		}
		
		public class ValidatorAdapter implements DocumentListener,
				ActionListener {

			public void changedUpdate(DocumentEvent e) {
				if(!getValidator().isDisabled()) {
					validateBean();
				}
			}

			public void insertUpdate(DocumentEvent e) {
				changedUpdate(e);
			}

			public void removeUpdate(DocumentEvent e) {
				changedUpdate(e);
			}

			public void actionPerformed(ActionEvent e) {
				if(!getValidator().isDisabled()) {
					validateBean();
				}
			}
		}
	}
	
	public static class Validator {
		static final ServerBean EMPTY_BEAN = new ServerBean();
		static public String ERR_LOCATION_DOESNT_EXIST = "ServerDialog_ErrLocationDoesntExist";
		static public String ERR_LOCATION_IS_EMPTY = "ServerDialog_ErrLocationIsEmpty";
		static public String ERR_NAME_IS_EMPTY = "ServerDialog_ErrNameIsEmpty";
		static public String ERR_NAME_IS_NOT_CORRECT = "ServerDialog_ErrNameIsNotCorrect";
		static public String ERR_SERVER_TYPE_IS_NOT_SELECTED = "ServerDialog_ErrServerTypeDoesntSelected";
		static public String ERR_SERVER_VERSION_IS_NOT_SELECTED = "ServerDialog_ErrVersionIsNotSelected";
		static public String ERR_SERVER_VERSION_IS_NOT_SUPPORTED = "ServerDialog_ErrVersionIsNotSupported";
		static public String ERR_SERVER_NAME_IS_ALREADY_USED = "ServerDialog_ErrNameIsAlreadyUsed";
		static public String OK_NEW_DEFAULT = "ServerDialog_DefaultNewServerMessage";
		static public String OK_EDIT_DEFAULT = "ServerDialog_DefaultEditServerMessage";
		static public String WARN_SERVER_UNKNOWN = "ServerDialog_WarnUnknownServerSelected";
		static public String WARN_SERVER_TYPE_VERSION_DONT_MATCH = "ServerDialog_ServerTypeVersionDoesntMatch";
		static public String WARN_SERVER_VERSION_DONT_MATCH = "ServerDialog_ServerVersionDoesntMatch";
		static public String WARN_SERVER_TYPE_DONT_MATCH = "ServerDialog_ServerTypeDoesntMatch";
		static public String NO_ERRORS = "";
		
		private boolean disabled = false;
		
		public ValidationResult validate(ServerBean originalBean, ServerBean bean, List<ServerBean> servers) {
			if(!disabled)  {
				if(bean.equals(originalBean)) {
					if(bean.equals(EMPTY_BEAN)) {
						// Show default message when dialog is empty, which means:
						// location and name is empty, type and version are not seleted
						return createOkResult(OK_NEW_DEFAULT);
					} else {
						return createOkResult(OK_EDIT_DEFAULT);
					}
				} else {
					//------------------------
					// validate entered values
					//------------------------
					File location = new File(bean.getLocation());
					if(EMPTY_BEAN.getLocation().equals(bean.getLocation().trim())) {
						// validate selected location is not empty
						return createErrorResult(ERR_LOCATION_IS_EMPTY);
					} else if (!location.exists() || !location.isDirectory()) {
						// validate selected location exists
						return createErrorResult(ERR_LOCATION_DOESNT_EXIST);
					} else if (EMPTY_BEAN.getName().equals(bean.getName())) {
						// Validate name is entered validateBean
						return createErrorResult(ERR_NAME_IS_EMPTY);
					} else if (!ServerListPanel.ELEMENT_NAME_DEFAULT_PATTERN.matcher(bean.getName()).matches()) {
						// and match pattern
						return createErrorResult(ERR_NAME_IS_NOT_CORRECT);
					} else if (!originalBean.getName().equals(bean.getName()) && isNameInList(bean.getName(),servers)) {
						// validate that name haven't used yet only if it was changed
						return createErrorResult(ERR_SERVER_NAME_IS_ALREADY_USED);
					} else if (ServerType.UNKNOWN==bean.getType()) {
						// validate type is selected
						return createErrorResult(ERR_SERVER_TYPE_IS_NOT_SELECTED);
					} else if (EMPTY_BEAN.getVersion().equals(bean.getVersion())) {
						// validate version is selected
						return createErrorResult(ERR_SERVER_VERSION_IS_NOT_SELECTED);
					} else if (!Arrays.asList(bean.getType().getVersions()).contains(bean.getVersion())) {
						// check that selected server type is support selected version
						return createErrorResult(ERR_SERVER_VERSION_IS_NOT_SUPPORTED);
					}

					ServerBean defaults = new ServerBeanLoader().loadFromLoaction(new File(bean.getLocation()));
					if(ServerType.UNKNOWN==defaults.getType()) {
						// validation strategy for unknown server
						return createWarningResult(WARN_SERVER_UNKNOWN);
					} else {
						// validation strategy for known server
						if(defaults.getType()!= bean.getType() 
							&& !defaults.getVersion().equals(bean.getVersion()) ) {
							return createWarningResult(WARN_SERVER_TYPE_VERSION_DONT_MATCH);
						} else if(defaults.getType()!= bean.getType()) {
							return createWarningResult(WARN_SERVER_TYPE_DONT_MATCH);
						} else if(!defaults.getVersion().equals(bean.getVersion())) {
							return createWarningResult(WARN_SERVER_VERSION_DONT_MATCH);
						}
					}
				}
				if(originalBean.equals(EMPTY_BEAN)) {
					// New Server Dialog default message
					return createOkResult(OK_NEW_DEFAULT);
				} else {
					// Edit Server Dialog Default message
					return createOkResult(OK_EDIT_DEFAULT);
				}
			}
			return createOkResult(NO_ERRORS);
		}
		
		private static boolean isNameInList(String name, List<ServerBean> servers) {
			for (ServerBean serverBean : servers) {
				if(serverBean.getName().equals(name)) {
					return true;
				}
			}
			return false;
		}
		
		private static ValidationResult createErrorResult(String messageKey) {
			return new ValidationResult(ValidationResult.ERROR,messageKey);
		}
		
		private static ValidationResult createWarningResult(String messageKey) {
			return new ValidationResult(ValidationResult.WARNING,messageKey);
		}
		
		private static ValidationResult createOkResult(String messageKey) {
			return new ValidationResult(ValidationResult.OK,messageKey);
		}
		
		public boolean isDisabled() {
			return disabled;	
		}
		
		public void setDisabled(boolean set) {
			this.disabled = set;
		}
	}
	
	public static class ValidationResult {
		public static final int OK = 0;
		public static final int ERROR = 1;
		public static final int WARNING = 2;
		private int severety = ERROR;
		private String messageKey = null;
		
		public ValidationResult(int severety, String messageKey) {
			this.severety = severety;
			this.messageKey = messageKey;
		}

		public String getMessageKey() {
			return messageKey;
		}

		public int getSeverety() {
			return severety;
		}
	}
	
	public abstract class ServerListAction extends AbstractAction {
		
		private int[] selection;

		public ServerListAction() {
			super();
		}

		public ServerListAction(String name) {
			super(name);
		}
		
		public void setSelection(int[] selection) {
			this.selection = selection;
			selectionChanged();
		}
		
		public abstract void selectionChanged();

		public void setTarget(ServerListBean bean) {
			
		}
		
		public int[] getSelection() {
			return selection;
		}

	}
	
	public class FindAction extends ServerListAction {
		public FindAction() {
			super(langpack.getString("JBossAsSelectPanel.FindButton"));
		}
		
		public void actionPerformed(ActionEvent e) {
			JFrame parentFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, ServerListPanel.this);
			JFileChooser chooser;
			if(storedFolder != null)
				chooser = new JFileChooser(storedFolder);
			else
				chooser = new JFileChooser();
			
			chooser.setDialogTitle(langpack.getString("JBossAsSelectPanel.FileChooserTitle"));
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			int returnValue = chooser.showDialog(parentFrame, langpack.getString("JBossAsSelectPanel.FileChooserButton"));
			if(returnValue == JFileChooser.APPROVE_OPTION){
				final ServersSearchProgressPanel ex1 = new ServersSearchProgressPanel();
				JDialog f = new JDialog(parentFrame,langpack.getString("ServerSearchDailog_Title"));
			        WindowListener l = new WindowAdapter() {
			            public void windowClosing(WindowEvent e) {
			            	ex1.pressCancel();
			            }};
		        f.addWindowListener(l); 

		        Container contentPane = f.getContentPane();

		        ex1.selectedFile = chooser.getSelectedFile();
		        ex1.serverListBean = serverListBean;
		        contentPane.setLayout(new GridLayout(1, 0));
		        contentPane.add(ex1);
		        f.pack();
		        f.setBounds(f.getX(),f.getY(),300,f.getHeight());
		        f.setLocation(parentFrame.getLocation().x+parentFrame.getSize().width/2-f.getSize().width/2, parentFrame.getLocation().y+parentFrame.getSize().height/2-f.getSize().height/2);
		        f.setModal(true);
		        f.show();
			}
		}
		
		public void selectionChanged() {
			setEnabled(true);
		}
	}
	
	public interface FindActionNotifier {
		public void serverAdded(ServerBean bean);
	}
	
	public static class FindActionHandler {
		public List<ServerBean> findServeres(File startLocation,List<ServerBean> servers, FindActionNotifier notifier) throws InterruptedException {
			FileFilter dirFilter = new FileFilter() {
				public boolean accept(File pathname) {
					return pathname.isDirectory() && pathname.canRead();
				}};
			ServerBeanLoader loader = new ServerBeanLoader();
			int sameNameCounter = 0;
			List<File> parents = new ArrayList<File>();
			parents.add(startLocation);
			while(!parents.isEmpty()) {
				List<File> parentsCopy = new ArrayList<File>(parents);
				parents.clear();
				Iterator iter = parentsCopy.iterator(); 
				while(iter.hasNext()){
	                if (Thread.interrupted()) {
	                    throw new InterruptedException();
	                }
					File file = (File)iter.next();
	
					if(file.isDirectory() && file.canRead()) {
						// -----------------------------
						ServerBean bean = loader.loadFromLoaction(file);
						String beanName = bean.getName();
						//------------------------------
						if(bean.getType() != ServerType.UNKNOWN) {
							// Do not add servers with the same location
							// So if find ran with the same location twice
							// nothing bad would happen and list wouldn't changed 
							// after second attempt to find servers
							boolean exists = false;
							for (ServerBean server : servers) {
								if(server.getLocation().equals(bean.getLocation())) {
									exists = true;
									break;
								}
							}
							if(exists) continue;
							doItAgain:
							for (ServerBean server : servers) {
								if(server.getName().equals(beanName)) {
									sameNameCounter++;
									beanName = bean.getName() + "(" + sameNameCounter + ")";
									continue doItAgain;
								}
							}
							bean.setName(beanName);
							notifier.serverAdded(bean);
							servers.add(bean);
							continue;
						} 
		
						File[] children = file.listFiles(dirFilter);
						if(children.length>0) {
							List<File> childrenList = Arrays.asList(children);
							Collections.sort(childrenList);
							parents.addAll(childrenList);
						}
					}	
				}
			}
			return servers;
		}
	}
	
	public class AddAction extends ServerListAction {
		public AddAction() {
			super(langpack.getString("JBossAsSelectPanel.AddButton"));
		}
		public void actionPerformed(ActionEvent e) {
			JFrame parent = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)e.getSource());
			ImageIcon image = null;
			try{
				image = ResourceManager.getInstance().getImageIconResource("JBossAsSelectPanel.create.image");
			}catch(Exception ex){
			}
			EditDialog dialog = new EditDialog(parent, true,  image);
			dialog.setTitle(langpack.getString("JBossAsSelectPanel.AddDialogTitle"));
			ServerBean bean = new ServerBean();
			dialog.setContent(new ServerPanel(dialog, bean));
			
			dialog.setLocation(parent.getLocation().x+parent.getSize().width/2-dialog.getSize().width/2, parent.getLocation().y+parent.getSize().height/2-dialog.getSize().height/2);
			dialog.doLayout();
			dialog.pack();
			dialog.setResizable(false);
			dialog.setVisible(true);
			if(dialog.isOkPressed()) {
				List<ServerBean> servers = serverListBean.getServers();
				servers.add(bean);
				serverListBean.setServers(servers);
			}
		}
		
		public void selectionChanged() {
			setEnabled(true);
		}
	}
	
	public class EditAction extends ServerListAction {
		public EditAction() {
			super(langpack.getString("JBossAsSelectPanel.EditButton"));
			setEnabled(false);
		}
		public void actionPerformed(ActionEvent e) {
			JFrame parent = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, (Component)e.getSource());
			ImageIcon image = null;
			try{
				image = ResourceManager.getInstance().getImageIconResource("JBossAsSelectPanel.edit.image");
			}catch(Exception ex){
			}
			EditDialog dialog = new EditDialog(parent, true,  image);
			dialog.setTitle(langpack.getString("JBossAsSelectPanel.EditDialogTitle"));
			dialog.setLocation(parent.getLocation().x+parent.getSize().width/2-dialog.getSize().width/2, parent.getLocation().y+parent.getSize().height/2-dialog.getSize().height/2);
			ServerBean beanCopy = new ServerBean();
			ServerBean bean = serverListBean.getServers(getSelection()[0]);
			beanCopy.setLocation(bean.getLocation());
			beanCopy.setName(bean.getName());
			beanCopy.setType(bean.getType());
			beanCopy.setVersion(bean.getVersion());
			
			dialog.getContentPane().add(new ServerPanel(dialog, beanCopy));
			dialog.doLayout();
			dialog.pack();
			dialog.setResizable(false);
			dialog.setVisible(true);
			if(dialog.isOkPressed()) {
				serverListBean.setServers(getSelection()[0], beanCopy);
			}
		}
		
		public void selectionChanged() {
			setEnabled(getSelection().length==1);
		}
	}
	
	public class RemoveAction extends ServerListAction {
		public RemoveAction() {
			super(langpack.getString("JBossAsSelectPanel.RemoveButton"));
			setEnabled(false);
		}
		
		public void actionPerformed(ActionEvent e) {
			List<ServerBean> newList = new ArrayList<ServerBean>(serverListBean.getServers());
			List<ServerBean> removeList = new ArrayList<ServerBean>();
 			for(int i = 0; i<getSelection().length;i++) {
 				removeList.add(newList.get(getSelection()[i]));
			}
 			newList.removeAll(removeList);
 			serverListBean.setServers(newList);
		}
		
		public void selectionChanged() {
			setEnabled(getSelection().length>0);
		}
	}
	
	public class ServerListActionsPanel extends JPanel implements ListSelectionListener{
		
		ServerListAction[] actions =  new ServerListAction[0];
		
		List<ServerBean> beans = new ArrayList<ServerBean>();
		
		public ServerListActionsPanel(ServerListAction[] actions) {
			GridLayout layout = new GridLayout();
			this.actions = actions;
			layout.setRows(actions.length);
			layout.setVgap(5);
			setLayout(layout);
			
			for (ServerListAction serverListAction : actions) {
				add(new JButton(serverListAction));
			}
			table.getSelectionModel().addListSelectionListener(this);
		}

		public void valueChanged(ListSelectionEvent e) {
			for (ServerListAction action : actions) {
				action.setSelection(table.getSelectedRows());
			}
		}
	}
	
	public class EditDialog extends JDialog {
		
		protected final Object OK = new Object();
		protected final Object CANCEL = new Object();
		
		ImageIcon image = null;
		JLabel titleLabel = null;
		JTextArea messageLabel = null;
		
		JButton okButton;
		
		boolean okPressed = false;
		
		public EditDialog(Frame owner, boolean modal, ImageIcon image)
				throws HeadlessException {
			this(owner,"",modal,image);
		}

		public EditDialog(Frame owner, String title, boolean modal, ImageIcon image)
				throws HeadlessException {
			super(owner, title, modal);
			this.image = image;
			
			//head panel
			JPanel headPanel = new JPanel();
			headPanel.setLayout(new GridBagLayout());
			headPanel.setBackground(Color.white);
			
			// title
			titleLabel = new JLabel(langpack.getString("JBossAsSelectPanel.EditDialogName"));
			titleLabel.setFont(new Font("default", Font.BOLD, 12));
			titleLabel.setBorder( BorderFactory.createEmptyBorder(7,10,3,10));
			GridBagConstraints c = new GridBagConstraints();
			c.gridx = 0;
			c.gridy = 0;
			c.weighty = 0.0;
		    c.weightx = 1.0;
			c.fill = GridBagConstraints.HORIZONTAL;
			headPanel.add(titleLabel,c);
			
			// message
			messageLabel = new JTextArea();
			messageLabel.setEditable(false);
			messageLabel.setWrapStyleWord(true);
			messageLabel.setLineWrap(true);
			messageLabel.setRows(2);
			messageLabel.setBorder( BorderFactory.createEmptyBorder(0,10,0,10));
			messageLabel.setBackground(Color.WHITE);
			c.gridy = 1;
			JScrollPane scroll = new JScrollPane(messageLabel);
			scroll.setBorder( BorderFactory.createEmptyBorder(0,0,0,0));
			scroll.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
			scroll.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
			headPanel.add(scroll,c);
			
			JLabel imageLabel = new JLabel(image);
			c.gridx = 2;
			c.gridy = 0;
			c.gridheight = 2;
			c.weighty = c.weightx = 0;
			headPanel.add(imageLabel,c);
			
			add(headPanel,BorderLayout.NORTH);
			
			// button panel
			JPanel buttonPanel = new JPanel();
			buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 8,
	                8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), ""
	                		, TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.CENTER, new Font(
	                        "Dialog", Font.PLAIN, 10))));
			buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.LINE_AXIS));
			
			buttonPanel.add(Box.createHorizontalGlue());
			
			okButton = new JButton(langpack.getString("JBossAsSelectPanel.Ok"));
			okButton.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent event){
					setVisible(false);
					okPressed = true;
				}
			});
			buttonPanel.add(okButton);
			
			buttonPanel.add(Box.createHorizontalStrut(5));
			
			JButton cancelButton = new JButton(langpack.getString("JBossAsSelectPanel.Cancel"));
			cancelButton.setAlignmentX(Component.RIGHT_ALIGNMENT);
			cancelButton.addActionListener(new ActionListener(){
				public void actionPerformed(ActionEvent event){
					setVisible(false);
				}
			});
			buttonPanel.add(cancelButton);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		}
		
		public void setContent(ServerPanel content) {
			add(content,BorderLayout.CENTER);
			content.setEditDialog(this);
		}
		
		public void setErrorMessage(String text) {
			 messageLabel.setText(text);
			 messageLabel.setForeground(Color.RED);
		}
		
		public void setComplete(boolean b) {
			 okButton.setEnabled(b);
		}

		public void setWarningMessage(String text) {
			 messageLabel.setText(text);
			 messageLabel.setForeground(Color.BLACK);
		}
		
		public void setInfoMessage(String text) {
			 messageLabel.setText(text);
			 messageLabel.setForeground(Color.BLACK);
		}
		
		public boolean isOkPressed() {
			return okPressed;
		}
	}
	
	/**
	 * This is the 3rd version of SwingWorker (also known as
	 * SwingWorker 3), an abstract class that you subclass to
	 * perform GUI-related work in a dedicated thread.  For
	 * instructions on using this class, see:
	 * 
	 * http://java.sun.com/docs/books/tutorial/uiswing/misc/threads.html
	 *
	 * Note that the API changed slightly in the 3rd version:
	 * You must now invoke start() on the SwingWorker after
	 * creating it.
	 */
	public static abstract class SwingWorker {
	    private Object value;  // see getValue(), setValue()
	    private Thread thread;

	    /** 
	     * Class to maintain reference to current worker thread
	     * under separate synchronization control.
	     */
	    private static class ThreadVar {
	        private Thread thread;
	        ThreadVar(Thread t) { thread = t; }
	        synchronized Thread get() { return thread; }
	        synchronized void clear() { thread = null; }
	    }

	    private ThreadVar threadVar;

	    /** 
	     * Get the value produced by the worker thread, or null if it 
	     * hasn't been constructed yet.
	     */
	    protected synchronized Object getValue() { 
	        return value; 
	    }

	    /** 
	     * Set the value produced by worker thread 
	     */
	    private synchronized void setValue(Object x) { 
	        value = x; 
	    }

	    /** 
	     * Compute the value to be returned by the <code>get</code> method. 
	     */
	    public abstract Object construct();

	    /**
	     * Called on the event dispatching thread (not on the worker thread)
	     * after the <code>construct</code> method has returned.
	     */
	    public void finished() {
	    }

	    /**
	     * A new method that interrupts the worker thread.  Call this method
	     * to force the worker to stop what it's doing.
	     */
	    public void interrupt() {
	        Thread t = threadVar.get();
	        if (t != null) {
	            t.interrupt();
	        }
	        threadVar.clear();
	    }

	    /**
	     * Return the value created by the <code>construct</code> method.  
	     * Returns null if either the constructing thread or the current
	     * thread was interrupted before a value was produced.
	     * 
	     * @return the value created by the <code>construct</code> method
	     */
	    public Object get() {
	        while (true) {  
	            Thread t = threadVar.get();
	            if (t == null) {
	                return getValue();
	            }
	            try {
	                t.join();
	            }
	            catch (InterruptedException e) {
	                Thread.currentThread().interrupt(); // propagate
	                return null;
	            }
	        }
	    }


	    /**
	     * Start a thread that will call the <code>construct</code> method
	     * and then exit.
	     */
	    public SwingWorker() {
	        final Runnable doFinished = new Runnable() {
	           public void run() { finished(); }
	        };

	        Runnable doConstruct = new Runnable() { 
	            public void run() {
	                try {
	                    setValue(construct());
	                }
	                finally {
	                    threadVar.clear();
	                }

	                SwingUtilities.invokeLater(doFinished);
	            }
	        };

	        Thread t = new Thread(doConstruct);
	        threadVar = new ThreadVar(t);
	    }

	    /**
	     * Start the worker thread.
	     */
	    public void start() {
	        Thread t = threadVar.get();
	        if (t != null) {
	            t.start();
	        }
	    }
	}
	
	public class ServersSearchProgressPanel extends JPanel {
	    JProgressBar progressBar = new JProgressBar();
	    JLabel statusField = new JLabel("Click Start to begin", JLabel.CENTER);
	    SwingWorker worker;
	    JButton startButton;
	    JButton interruptButton;
	    Border spaceBelow = BorderFactory.createEmptyBorder(0, 0, 5, 0);
	    public File selectedFile;
	    public ServerListBean serverListBean;
	    JButton getStartButton() {
	        return startButton;
	    }

	    /**
	     * When the worker needs to update the GUI we do so by queuing
	     * a Runnable for the event dispatching thread with 
	     * SwingUtilities.invokeLater().  In this case we're just
	     * changing the progress bars value.
	     */
	    void updateStatus(final int i) {
	        Runnable doSetProgressBarValue = new Runnable() {
	            public void run() {
	                progressBar.setValue(i);
	            }
	        };
	        SwingUtilities.invokeLater(doSetProgressBarValue);
	    }

	    
	    /**
	     * This method represents the application code that we'd like to 
	     * run on a separate thread.  It simulates slowly computing 
	     * a value, in this case just a string 'All Done'.  It updates the 
	     * progress bar every half second to remind the user that
	     * we're still busy.
	     */
	    Object doWork() {
	    	List<ServerBean> newServers = new ArrayList<ServerBean>(serverListBean.getServers());
	        try {
	        	FindActionNotifier notifier = new FindActionNotifier() {
	        		public void serverAdded(final ServerBean server) {
	        			SwingUtilities.invokeLater(new Runnable() {
	        				public void run() {
	        					List<ServerBean> list = serverListBean.getServers();
	        					list.add(server);
	        					serverListBean.setServers(list);
	        				}
	        			});
	        			
	        		}
	        	};
	        	newServers = new FindActionHandler().findServeres(selectedFile,new ArrayList<ServerBean>(serverListBean.getServers()),notifier);

	        }
	        catch (InterruptedException e) {
	            updateStatus(0);
	        }
	        return newServers;         // or this
	    }



	    /**
	     * This action listener, called by the "Cancel" button, interrupts
	     * the worker thread which is running this.doWork().  Note that
	     * the doWork() method handles InterruptedExceptions cleanly.
	     */
	    ActionListener interruptListener = new ActionListener() {
	        public void actionPerformed(ActionEvent event) {
	            interruptButton.setEnabled(false);
	            worker.interrupt();
	        }
	    };

	    /** 
	     * And now for a little assembly.  Put together the buttons, progress 
	     * bar and status text field.  
	     */
	    ServersSearchProgressPanel(String name) {
	    	this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
	        progressBar.setIndeterminate(true);

	        interruptButton = new JButton("Cancel");
	        interruptButton.addActionListener(interruptListener);
	        interruptButton.setEnabled(false);

	        JComponent buttonBox = new JPanel();
	        buttonBox.add(interruptButton);

	        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
	        statusField.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 5));
	        add(statusField);
	        add(progressBar);
	        add(buttonBox);
	        
	        statusField.setAlignmentX(CENTER_ALIGNMENT);

	        buttonBox.setBorder(spaceBelow);
	        Border pbBorder = progressBar.getBorder();
	        progressBar.setBorder(BorderFactory.createCompoundBorder(
	                                        spaceBelow,
	                                        pbBorder));
	        SwingUtilities.invokeLater(new Runnable() {
	        	public void run() {
	        		start();
	        	}
	        });
	    }

	    public void pressCancel() {
	    	interruptButton.doClick();
	    }
	    
	    ServersSearchProgressPanel() {
	        this("Searching for servers ...");
	    }
	    
	    public void start() {
	    	  	interruptButton.setEnabled(true);
	            statusField.setText(langpack.getString("ServerSearchDailog_StatusMessage"));

	            /* Invoking start() on the SwingWorker causes a new Thread
	             * to be created that will call construct(), and then
	             * finished().  Note that finished() is called even if
	             * the worker is interrupted because we catch the
	             * InterruptedException in doWork().
	             */
	            worker = new SwingWorker() {
	                public Object construct() {
	                    return doWork();
	                }
	                public void finished() {
	                    interruptButton.setEnabled(false);
	                    statusField.setText(get().toString());
	                    JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, ServersSearchProgressPanel.this);
	                    dialog.hide();
	                }
	            };
	            worker.start();
	    }
	    
	    public List<ServerBean> getValue() {
	    	return (List<ServerBean>)worker.getValue();
	    }
	}


}