package com.jboss.jbds.installer;

import java.io.File;

import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;

// Referenced classes of package com.izforge.izpack.panels:
//            PathInputPanel, PathSelectionPanel



public class JREPathPanel extends PathInputPanel
{
	private static final long serialVersionUID = 1256443616359329172L;
    private static final String winTestFiles[];
    private static final String linTestFiles[];
    private String variableName;
    private static final String gnuVersion = "gij ";
    private static final String minVersion = "java version \"1.5.";
    private static final String maxVersion = "java version \"1.6.";
    
    private String detectedVersion;
    
    
    protected JRadioButton rb1,rb2;

    static 
    {
        winTestFiles = (new String[] {
                "bin" + File.separator + "javaw.exe",
                "jre" + File.separator + "bin" + File.separator + "javaw.exe"
            });
        linTestFiles = (new String[] {
                "bin" + File.separator + "java",
                "jre" + File.separator + "bin" + File.separator + "java"
            });
    }
    
    protected boolean pathIsValid()
    {
        if (existFiles == null) return true;
        for (int i = 0; i < existFiles.length; ++i)
        {
            File path = new File(pathSelectionPanel.getPath(), existFiles[i]).getAbsoluteFile();
            if (path.exists()) return true;
        }
        return false;
    }
    
    public JREPathPanel(InstallerFrame parent, InstallData idata)
    {
        //super(parent, idata);
    	super(parent, idata, new IzPanelLayout());
        // Set default values
        emptyTargetMsg = getI18nStringForClass("empty_target", "TargetPanel");
        warnMsg = getI18nStringForClass("warn", "TargetPanel");
         
        String introText = getI18nStringForClass("intro", "PathInputPanel");
        
        add(new JLabel(introText), NEXT_LINE);
        
        
        rb1 = new JRadioButton("Default Java VM", true);
        rb2 = new JRadioButton("Specific Java VM", false);
        add(rb1, NEXT_LINE);
        add(rb2, NEXT_LINE);
        
        ButtonGroup group = new ButtonGroup();
        group.add(rb1);
        group.add(rb2);

        pathSelectionPanel = new PathSelectionPanel(this, idata);
        add(pathSelectionPanel, NEXT_LINE);
        pathSelectionPanel.setEnabled(false);
        rb1.addChangeListener(new ChangeListener(){
        	public void stateChanged(ChangeEvent e){
        		if(rb1.isSelected()){
        			pathSelectionPanel.setEnabled(false);
        		}else{
        			pathSelectionPanel.setEnabled(true);
        		}
        	}
        });
        createLayoutBottom();
        getLayoutHelper().completeLayout();
    	// // //
        setMustExist(true);
        if(OsVersion.IS_WINDOWS)
            setExistFiles(winTestFiles);
        else if(OsVersion.IS_LINUX)
            setExistFiles(linTestFiles);
        setVariableName("JREPath");
    }

    public boolean isValidated()
    {
        if(idata.getVariable("PANEL_LAYOUT_TEST") != null)
            return true;
        
        if(rb1.isSelected()){
    		//idata.setVariable(getVariableName(), "");
    		//return (true);
            pathSelectionPanel.setPath((new File(idata.getVariable("JAVA_HOME"))).getPath());
        }
        
        String chosenPath = pathSelectionPanel.getPath();
        boolean ok = true;

        // We put a warning if the specified target is nameless
        if (chosenPath.length() == 0)
        {
        	emitError(parent.langpack.getString("installer.error"), parent.langpack
                    .getString(getI18nStringForClass("empty", "PathInputPanel")));
            return false;
        }
        
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        pathSelectionPanel.setPath(chosenPath);
        if (!path.exists())
        {
            emitError(parent.langpack.getString("installer.error"), "The direcotory "+chosenPath+" does not exist.");
            return false;
        }
        if (!pathIsValid())
        {
            emitError(parent.langpack.getString("installer.error"), parent.langpack
                    .getString(getI18nStringForClass("notValid", "PathInputPanel")));
            return false;
        }else {
        	int status = verifyVersion(); 
        	if (status == 0)
            {
        		if(rb1.isSelected())
            		idata.setVariable(getVariableName(), "");
                else
                	idata.setVariable(getVariableName(), pathSelectionPanel.getPath());
        		
                return (true);
            }
        	if(status == -2){
        		emitError(parent.langpack.getString("installer.error"),
        				"The directory "+chosenPath+"\ncontains a "+detectedVersion+" Java VM. It needs to be a Java 5 compatible version of Java.");
        	}
        	if(status == -1){
        		emitError(parent.langpack.getString("installer.error"), parent.langpack
        				.getString(getI18nStringForClass("badVersion2", "PathInputPanel")));
        	}
        	return (false);
        }
    }

    public void panelActivate()
    {
        super.panelActivate();
        String chosenPath="";
        
        chosenPath = idata.getVariable(getVariableName());
        if(chosenPath == null || "".equals(chosenPath))
        	chosenPath = (new File(idata.getVariable("JAVA_HOME"))).getPath();
        
        //if(!pathIsValid())
        //    chosenPath = "";
        
        pathSelectionPanel.setPath(chosenPath);
    }
    
	@Override
	public void panelDeactivate() {
		super.panelDeactivate();
		String installPath = idata.getVariable("INSTALL_PATH");
		idata.setVariable("NORMALIZED_INSTALL_PATH", installPath.replace('\\', '/'));
	}
	
    public String getVariableName()
    {
        return variableName;
    }

    public void setVariableName(String string)
    {
        variableName = string;
    }

    public String getSummaryBody()
    {
    	if(rb1.isSelected())
    		return "default";
    	else
    		return idata.getVariable(getVariableName());
    }

    private int verifyVersion()
    {
    	
        String[] params = {
                pathSelectionPanel.getPath() + File.separator + "bin" + File.separator + "java",
                "-version"
                };
        File path = new File(pathSelectionPanel.getPath() + File.separator + "bin").getAbsoluteFile();
        if(!path.exists()){
        	params[0] = pathSelectionPanel.getPath() + File.separator + "jre"+File.separator + "bin" + File.separator + "java"; 
        }
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
        // "My" VM writes the version on stderr :-(
        String vs = (output[0].length() > 0) ? output[0] : output[1];
        int i = vs.indexOf("java version \"");
        if(i < 0){
        	detectedVersion = "<not found>";
        }else{
        	int j = vs.indexOf("\"",i+14);
        	if(j>=0)
        		detectedVersion = vs.substring(i+13,j+1);
        	else
        		detectedVersion = vs.substring(i+13,vs.length());
        }
        //emitError(pathSelectionPanel.getPath(), vs);
        if(vs.indexOf(gnuVersion) >= 0) return -1;
        if(vs.indexOf(minVersion) < 0 && vs.indexOf(maxVersion) < 0) return -2;
        return 0;
    }

}