package com.jboss.jbds.installer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.OsVersion;

public class CreateLinkPanel extends IzPanel {

	private static final long serialVersionUID = 1256443616359329171L;
	private static final String winTestFiles[];
	private static final String linTestFiles[];
	private String testFiles[] = null;
	private int index = -1;

	static {
		winTestFiles = (new String[] { "bin" + File.separator + "javaw.exe",
				"jre" + File.separator + "bin" + File.separator + "javaw.exe" });
		linTestFiles = (new String[] { "bin" + File.separator + "java",
				"jre" + File.separator + "bin" + File.separator + "java" });
	}

	public CreateLinkPanel(InstallerFrame parent, InstallData idata) {
		super(parent, idata);
		setHidden(true);
	}

	private void validatePath() {
		if (OsVersion.IS_WINDOWS)
			testFiles = winTestFiles;
		else if (OsVersion.IS_LINUX)
			testFiles = linTestFiles;

		String jdkPath = idata.getVariable("JREPath");

		for (int i = 0; i < testFiles.length; ++i) {
			File path = new File(jdkPath, testFiles[i]).getAbsoluteFile();
			if (path.exists()) {
				index = i;
				return;
			}
		}
	}

	public void panelActivate() {
		// String group = idata.getVariable("INSTALL_GROUP");

		//createLink("jbds.link", "/studio");

		writeProperty("application_platforms.properties");

		addJREPath();

		parent.skipPanel();
	}

	public void writeProperty(String fileName) {
		String installPath = idata.getVariable("INSTALL_PATH");

		File folder = new File(installPath, "studio");

		Properties servers = (Properties) idata.getAttribute("AS_SERVERS");
		if (!servers.isEmpty()) {
			if (!folder.exists()) {
				folder.mkdirs();
			}
			File file = new File(folder, fileName);
			FileOutputStream stream = null;
			try {
				file.createNewFile();
				stream = new FileOutputStream(file);
				servers.store(stream, null);
				stream.flush();
				stream.close();
			} catch (IOException e) {
				if (stream != null) {
					try {
						stream.close();
					} catch (IOException e1) {
					}
				}
				e.printStackTrace();
			}
		}
	}

	public void createLink(String fileName, String folderName) {
		String installPath = idata.getVariable("INSTALL_PATH");
		String path;
		path = installPath + File.separator + "eclipse" + File.separator
				+ "links";

		File folder = new File(path);

		try {
			if (!folder.exists())
				folder.mkdir();
			path += File.separator + fileName;
			File file = new File(path);
			String str = "path=" + installPath.replace("\\", "/") + folderName;
			FileOutputStream stream = new FileOutputStream(file);
			stream.write(str.getBytes());
			stream.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public void addJREPath() {
		String installPath = idata.getVariable("INSTALL_PATH");
		String jdkPath = idata.getVariable("JREPath");

		if (jdkPath == null || "".equals(jdkPath))
			return;

		validatePath();

		if (index == -1)
			return;

		String path;
		path = installPath + File.separator + "eclipse" + File.separator
				+ "eclipse.ini";

		try {
			File file = new File(path);
			FileInputStream is = new FileInputStream(file);

			byte[] b = new byte[is.available()];
			is.read(b);
			is.close();

			String str = new String(b);
			str = "-vm\n" + jdkPath + File.separator + testFiles[index] + "\n"
					+ str;

			FileOutputStream stream = new FileOutputStream(file);
			stream.write(str.getBytes());
			stream.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}

	}
}
