/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package javax.jms;

/**
 * <P> This exception must be thrown when a JMS client attempts to read a 
 *     write-only message.
 **/

public class MessageNotReadableException extends JMSException {

  /** Constructs a <CODE>MessageNotReadableException</CODE> with the specified 
   *  reason and error code.
   *
   *  @param  reason        a description of the exception
   *  @param  errorCode     a string specifying the vendor-specific
   *                        error code
   *                        
   **/
  public 
  MessageNotReadableException(String reason, String errorCode) {
    super(reason, errorCode);
  }

  /** Constructs a <CODE>MessageNotReadableException</CODE> with the specified 
   *  reason. The error code defaults to null.
   *
   *  @param  reason        a description of the exception
   **/
  public 
  MessageNotReadableException(String reason) {
    super(reason);
  }

}
