/*******************************************************************************
 * Copyright (c) 2007-2010 Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributor:
 *     Red Hat, Inc. - initial API and implementation
 ******************************************************************************/
package org.jboss.tools.vpe.docbook.test;

import org.jboss.tools.vpe.base.test.ComponentContentTest;
import org.junit.Test;

/**
 * Tests for the context that was generated by Docbook templates
 * 
 * @author Denis Vinnichek (dvinnichek)
 */
public class DocbookComponentContentTest extends ComponentContentTest {
	
	private static final String DOC_BOOK_EDITOR_ID = "org.jboss.tools.jst.jsp.jspeditor.DocBookEditor"; //$NON-NLS-1$

	/**
	 * The Constructor
	 * 
	 * @param name
	 *            a test case name
	 */
	public DocbookComponentContentTest() {
		setCheckWarning(false);
	}

	@Test
	public void testXref() throws Throwable {
		performContentTest("components/xref/xref.xml"); //$NON-NLS-1$
	}

	@Test
	public void testLiteral() throws Throwable {
		performContentTest("components/literal/literal.xml"); //$NON-NLS-1$
	}

	@Test
	public void testNote() throws Throwable {
		performContentTest("components/note/note.xml"); //$NON-NLS-1$
	}

	@Test
	public void testTip() throws Throwable {
		performContentTest("components/tip/tip.xml"); //$NON-NLS-1$
	}

	@Test
	public void testWarning() throws Throwable {
		performContentTest("components/warning/warning.xml"); //$NON-NLS-1$
	}

	@Test
	public void testCaution() throws Throwable {
		performContentTest("components/caution/caution.xml"); //$NON-NLS-1$
	}

	@Test
	public void testImportant() throws Throwable {
		performContentTest("components/important/important.xml"); //$NON-NLS-1$
	}

	@Test
	public void testProgramlisting() throws Throwable {
		performContentTest("components/programlisting/programlisting.xml"); //$NON-NLS-1$
	}

	@Override
	protected String getTestProjectName() {
		return DocbookAllTests.IMPORT_PROJECT_NAME;
	}

	@Override
	protected String getEditorID() {
		return DOC_BOOK_EDITOR_ID;
	}
}
