/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

public abstract class PolicyConfigurationFactory {
    private static final String FACTORY_PROP = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final String DEFAULT_FACTORY_NAME = "org.jboss.security.jacc.JBossPolicyConfigurationFactory";
    private static PolicyConfigurationFactory factory;
    static /* synthetic */ Class class$0;

    public static PolicyConfigurationFactory getPolicyConfigurationFactory() throws ClassNotFoundException, PolicyContextException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (factory == null) {
            String factoryName = null;
            Class clazz = null;
            try {
                LoadAction action = new LoadAction();
                try {
                    clazz = (Class)AccessController.doPrivileged(action);
                    factoryName = action.getName();
                }
                catch (PrivilegedActionException ex) {
                    factoryName = action.getName();
                    Exception e = ex.getException();
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    throw new PolicyContextException("Failure during load of class: " + action.getName(), e);
                }
                factory = (PolicyConfigurationFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Failed to find PolicyConfigurationFactory : " + factoryName;
                throw new ClassNotFoundException(msg, e);
            }
            catch (IllegalAccessException e) {
                String msg = "Unable to access class : " + factoryName;
                throw new PolicyContextException(msg, e);
            }
            catch (InstantiationException e) {
                String msg = "Failed to create instance of: " + factoryName;
                throw new PolicyContextException(msg, e);
            }
            catch (ClassCastException e) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(factoryName)).append(" Is not a PolicyConfigurationFactory, ").append("PCF.class.CL: ");
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("javax.security.jacc.PolicyConfigurationFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz2.getClassLoader()).append("PCF.class.CS: ");
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("javax.security.jacc.PolicyConfigurationFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String msg = stringBuffer2.append(clazz3.getProtectionDomain().getCodeSource()).append("clazz.CL: ").append(clazz.getClassLoader()).append("clazz.CS: ").append(clazz.getProtectionDomain().getCodeSource()).append("clazz.super.CL: ").append(clazz.getSuperclass().getClassLoader()).append("clazz.super.CS: ").append(clazz.getSuperclass().getProtectionDomain().getCodeSource()).toString();
                ClassCastException cce = new ClassCastException(msg);
                cce.initCause(e);
            }
        }
        return factory;
    }

    public abstract PolicyConfiguration getPolicyConfiguration(String var1, boolean var2) throws PolicyContextException;

    public abstract boolean inService(String var1) throws PolicyContextException;

    private static class LoadAction
    implements PrivilegedExceptionAction {
        private String name;

        LoadAction() {
        }

        public String getName() {
            return this.name;
        }

        public Object run() throws Exception {
            this.name = System.getProperty(PolicyConfigurationFactory.FACTORY_PROP);
            if (this.name == null) {
                this.name = PolicyConfigurationFactory.DEFAULT_FACTORY_NAME;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(this.name);
            return factoryClass;
        }
    }
}

