/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAbstractSerializable;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAckRequestedSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMCloseSequenceResponseSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMCloseSequenceSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMCreateSequenceResponseSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMCreateSequenceSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSequenceAcknowledgementSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSequenceFaultSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSequenceSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMTerminateSequenceResponseSerializer;
import org.jboss.ws.extensions.wsrm.common.serialization.RMTerminateSequenceSerializer;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMAckRequested;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCloseSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCloseSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequenceResponse;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceAcknowledgement;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequenceFault;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMTerminateSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMTerminateSequenceResponse;

final class RMSerializationRepository {
    private static final Map<Class<? extends RMSerializable>, RMSerializer> SERIALIZER_REGISTRY = new HashMap<Class<? extends RMSerializable>, RMSerializer>();

    private RMSerializationRepository() {
    }

    public static void serialize(RMAbstractSerializable object, SOAPMessage soapMessage) throws RMException {
        RMSerializationRepository.getSerializer(object).serialize(object, object.getProvider(), soapMessage);
    }

    public static void deserialize(RMAbstractSerializable object, SOAPMessage soapMessage) throws RMException {
        RMSerializationRepository.getSerializer(object).deserialize(object, object.getProvider(), soapMessage);
    }

    private static RMSerializer getSerializer(RMSerializable object) {
        for (Class<? extends RMSerializable> serializable : SERIALIZER_REGISTRY.keySet()) {
            if (!serializable.isAssignableFrom(object.getClass())) continue;
            return SERIALIZER_REGISTRY.get(serializable);
        }
        throw new IllegalArgumentException();
    }

    static {
        SERIALIZER_REGISTRY.put(RMAckRequested.class, RMAckRequestedSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMCloseSequence.class, RMCloseSequenceSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMCloseSequenceResponse.class, RMCloseSequenceResponseSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMCreateSequence.class, RMCreateSequenceSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMCreateSequenceResponse.class, RMCreateSequenceResponseSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMSequenceAcknowledgement.class, RMSequenceAcknowledgementSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMSequenceFault.class, RMSequenceFaultSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMSequence.class, RMSequenceSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMTerminateSequence.class, RMTerminateSequenceSerializer.getInstance());
        SERIALIZER_REGISTRY.put(RMTerminateSequenceResponse.class, RMTerminateSequenceResponseSerializer.getInstance());
    }
}

