/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.feature.JsonEncodingFeature;
import org.jboss.wsf.spi.util.ServiceLoader;

public class RemoteConnectionFactory {
    public RemoteConnection getRemoteConnection(EndpointInfo epInfo) {
        String targetAddress = epInfo.getTargetAddress();
        if (targetAddress == null) {
            throw new IllegalArgumentException("Cannot obtain target address from: " + epInfo);
        }
        String key = null;
        if (targetAddress.startsWith("http")) {
            key = RemoteConnection.class.getName() + ".http";
        } else if (targetAddress.startsWith("jms")) {
            key = RemoteConnection.class.getName() + ".jms";
        }
        if (key == null) {
            throw new IllegalArgumentException("Cannot obtain remote connetion for: " + targetAddress);
        }
        if (epInfo.isFeatureEnabled(FastInfosetFeature.class)) {
            key = key + ".fastinfoset";
        } else if (epInfo.isFeatureEnabled(JsonEncodingFeature.class)) {
            key = key + ".json";
        }
        RemoteConnection con = (RemoteConnection)ServiceLoader.loadService((String)key, null);
        if (con == null) {
            throw new IllegalArgumentException("Cannot obtain remote connetion for: " + key);
        }
        return con;
    }
}

