/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.Agent;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.SWTResourceCompositeData;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.SWTResourceMonitorMXBean;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.StackTraceElementCompositeData;

public class SWTResourceMonitorMXBeanImpl
implements SWTResourceMonitorMXBean {
    private static final String DISPLAY_CLASS = "org.eclipse.swt.widgets.Display";
    private static final String DEVICE_CLASS = "org.eclipse.swt.graphics.Device";
    private static final String FONT_DATA_CLASS = "org.eclipse.swt.graphics.FontData";
    private static final String COLOR_CLASS = "org.eclipse.swt.graphics.Color";
    private static final String FONT_CLASS = "org.eclipse.swt.graphics.Font";
    private static final String TRACKING_LOCK_FIELD = "trackingLock";
    private static final String TRACKING_FIELD = "tracking";
    private static final String OBJECTS_FIELD = "objects";
    private static final String ERRORS_FIELD = "errors";
    private static final String GET_STYLE_METHOD = "getStyle";
    private static final String GET_HEIGHT_METHOD = "getHeight";
    private static final String GET_NAME_METHOD = "getName";
    private static final String GET_FONT_DATA_METHOD = "getFontData";
    private static final String GET_BLUE_METHOD = "getBlue";
    private static final String GET_GREEN_METHOD = "getGreen";
    private static final String GET_RED_METHOD = "getRed";
    private static final String GET_DEFAULT_METHOD = "getDefault";
    private Object displayObject;
    private Class<?> displayClass;
    private Class<?> deviceClass;
    private Class<?> fontClass;
    private Class<?> fontDataClass;
    private Class<?> colorClass;
    private SWTResourceCompositeData[] resources;
    private Instrumentation inst;

    public SWTResourceMonitorMXBeanImpl(Instrumentation inst) {
        this.inst = inst;
        this.initialize();
    }

    @Override
    public void setTracking(boolean tracking) {
        if (tracking && (this.displayClass == null || this.deviceClass == null)) {
            this.initialize();
        }
        if (!this.isSuppoted()) {
            return;
        }
        try {
            if (tracking && !this.isTracking()) {
                this.clear();
            }
            Field field = this.deviceClass.getDeclaredField(TRACKING_FIELD);
            field.setAccessible(true);
            field.set(this.getDisplayObject(), tracking);
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot set SWT resource tracking state.", new Object[0]);
        }
    }

    @Override
    public boolean isTracking() {
        if (!this.isSuppoted()) {
            return false;
        }
        try {
            Field field = this.deviceClass.getDeclaredField(TRACKING_FIELD);
            field.setAccessible(true);
            return (Boolean)field.get(this.getDisplayObject());
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot get SWT resource tracking state.", new Object[0]);
            return false;
        }
    }

    @Override
    public SWTResourceCompositeData[] getResources() {
        if (!this.isSuppoted()) {
            return new SWTResourceCompositeData[0];
        }
        try {
            this.refresh();
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot get SWT resources.", new Object[0]);
        }
        return this.resources;
    }

    @Override
    public void clear() {
        if (!this.isSuppoted()) {
            return;
        }
        try {
            Field field = this.deviceClass.getDeclaredField(ERRORS_FIELD);
            field.setAccessible(true);
            field.set(this.getDisplayObject(), new Error[127]);
            field = this.deviceClass.getDeclaredField(OBJECTS_FIELD);
            field.setAccessible(true);
            field.set(this.getDisplayObject(), new Object[127]);
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot clear SWT resource tracking data", new Object[0]);
        }
    }

    public boolean isSuppoted() {
        return this.displayClass != null && this.deviceClass != null;
    }

    private void initialize() {
        Class[] classArray = this.inst.getAllLoadedClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            String className = clazz.getName();
            if (DISPLAY_CLASS.equals(className)) {
                this.displayClass = clazz;
            } else if (DEVICE_CLASS.equals(className)) {
                this.deviceClass = clazz;
            } else if (FONT_CLASS.equals(className)) {
                this.fontClass = clazz;
            } else if (FONT_DATA_CLASS.equals(className)) {
                this.fontDataClass = clazz;
            } else if (COLOR_CLASS.equals(className)) {
                this.colorClass = clazz;
            }
            ++n2;
        }
        if (this.deviceClass == null) {
            return;
        }
        try {
            Field field = this.deviceClass.getDeclaredField(TRACKING_LOCK_FIELD);
            field.setAccessible(true);
            field.set(this.getDisplayObject(), new Object());
        }
        catch (Throwable t) {
            this.deviceClass = null;
            this.displayClass = null;
        }
    }

    private void refresh() throws SecurityException, Throwable {
        Field field = this.deviceClass.getDeclaredField(OBJECTS_FIELD);
        field.setAccessible(true);
        Object[] objects = (Object[])field.get(this.getDisplayObject());
        field = this.deviceClass.getDeclaredField(ERRORS_FIELD);
        field.setAccessible(true);
        Error[] errors = (Error[])field.get(this.getDisplayObject());
        if (objects == null || errors == null || objects.length != errors.length) {
            this.resources = new SWTResourceCompositeData[0];
            return;
        }
        ArrayList<SWTResourceCompositeData> resourcesList = new ArrayList<SWTResourceCompositeData>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] != null) {
                SWTResourceCompositeData resource = new SWTResourceCompositeData(this.getName(objects[i]), SWTResourceMonitorMXBeanImpl.getStackTrace(errors[i]));
                resourcesList.add(resource);
            }
            ++i;
        }
        this.resources = resourcesList.toArray(new SWTResourceCompositeData[resourcesList.size()]);
    }

    private static List<StackTraceElementCompositeData> getStackTrace(Error error) {
        ArrayList<StackTraceElementCompositeData> list = new ArrayList<StackTraceElementCompositeData>();
        if (error != null) {
            StackTraceElement[] stackTraceElementArray = error.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                list.add(new StackTraceElementCompositeData(element));
                ++n2;
            }
        }
        return list;
    }

    private Object getDisplayObject() throws Throwable {
        if (this.displayObject == null) {
            Method method = this.displayClass.getDeclaredMethod(GET_DEFAULT_METHOD, new Class[0]);
            this.displayObject = method.invoke(null, new Object[0]);
        }
        return this.displayObject;
    }

    private String getName(Object object) throws Throwable {
        if (FONT_CLASS.equals(object.getClass().getName())) {
            if (this.fontClass == null || this.fontDataClass == null) {
                this.searchFontClass();
            }
            if (this.fontClass != null && this.fontDataClass != null) {
                return this.getFontName(object);
            }
        } else if (COLOR_CLASS.equals(object.getClass().getName())) {
            if (this.colorClass == null) {
                this.searchColorClass();
            }
            if (this.colorClass != null) {
                return this.getColorName(object);
            }
        }
        return String.valueOf(object.getClass().getSimpleName()) + " {hashCode=" + System.identityHashCode(object) + "}";
    }

    private void searchColorClass() {
        Class[] classArray = this.inst.getAllLoadedClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            String className = clazz.getName();
            if (COLOR_CLASS.equals(className)) {
                this.colorClass = clazz;
            }
            ++n2;
        }
    }

    private void searchFontClass() {
        Class[] classArray = this.inst.getAllLoadedClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            String className = clazz.getName();
            if (FONT_CLASS.equals(className)) {
                this.fontClass = clazz;
            } else if (FONT_DATA_CLASS.equals(className)) {
                this.fontDataClass = clazz;
            }
            ++n2;
        }
    }

    private String getColorName(Object object) throws Throwable {
        Method method = this.colorClass.getDeclaredMethod(GET_RED_METHOD, new Class[0]);
        Integer red = (Integer)method.invoke(object, new Object[0]);
        method = this.colorClass.getDeclaredMethod(GET_GREEN_METHOD, new Class[0]);
        Integer green = (Integer)method.invoke(object, new Object[0]);
        method = this.colorClass.getDeclaredMethod(GET_BLUE_METHOD, new Class[0]);
        Integer blue = (Integer)method.invoke(object, new Object[0]);
        return "Color {r=" + red + ", g=" + green + ", b=" + blue + ", hashCode=" + System.identityHashCode(object) + "}";
    }

    private String getFontName(Object object) throws Throwable {
        String styleString;
        Method method = this.fontClass.getDeclaredMethod(GET_FONT_DATA_METHOD, new Class[0]);
        Object[] fontData = (Object[])method.invoke(object, new Object[0]);
        method = this.fontDataClass.getDeclaredMethod(GET_NAME_METHOD, new Class[0]);
        String name = (String)method.invoke(fontData[0], new Object[0]);
        method = this.fontDataClass.getDeclaredMethod(GET_HEIGHT_METHOD, new Class[0]);
        Integer height = (Integer)method.invoke(fontData[0], new Object[0]);
        method = this.fontDataClass.getDeclaredMethod(GET_STYLE_METHOD, new Class[0]);
        Integer style = (Integer)method.invoke(fontData[0], new Object[0]);
        if (style == 0) {
            styleString = "SWT.NORMAL";
        } else if (style == 1) {
            styleString = "SWT.BOLD";
        } else if (style == 2) {
            styleString = "SWT.ITALIC";
        } else {
            throw new IllegalStateException();
        }
        return "Font {name=" + name + ", height=" + height + ", style=" + styleString + ", hashCode=" + System.identityHashCode(object) + "}";
    }
}

