/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.agent;

import org.jboss.tools.jmx.jvmmonitor.internal.agent.Config;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.FrameNode;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.RuntimeModel;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.ThreadNode;

public class CpuBciProfiler {
    private static RuntimeModel model;

    public static void stepInto(String className, String methodName) {
        if (!Config.getInstance().isProfilerEnabled()) {
            return;
        }
        long time = System.currentTimeMillis();
        String thread = Thread.currentThread().getName();
        ThreadNode threadNode = model.getThread(thread);
        FrameNode previousFrame = threadNode.getCurrentFrame();
        FrameNode frame = previousFrame == null ? threadNode.getRootFrame(className, methodName) : previousFrame.getChild(className, methodName);
        threadNode.setCurrentFrame(frame);
        frame.setStepIntoTime(time, System.currentTimeMillis() - time);
    }

    public static void stepReturn(String className, String methodName) {
        if (!Config.getInstance().isProfilerEnabled()) {
            return;
        }
        long time = System.currentTimeMillis();
        String thread = Thread.currentThread().getName();
        ThreadNode threadNode = model.getThread(thread);
        FrameNode previousFrame = threadNode.getCurrentFrame();
        if (previousFrame == null) {
            return;
        }
        threadNode.setCurrentFrame(previousFrame.getParent());
        long overhead = System.currentTimeMillis() - time;
        previousFrame.setStepReturnTime(time + overhead, overhead);
    }

    public static void dropToFrame(String className, String methodName, String exception) {
        if (!Config.getInstance().isProfilerEnabled()) {
            return;
        }
        long time = System.currentTimeMillis();
        String thread = Thread.currentThread().getName();
        ThreadNode threadNode = model.getThread(thread);
        FrameNode previousFrame = threadNode.getCurrentFrame();
        if (previousFrame == null) {
            return;
        }
        FrameNode frame = previousFrame.searchFrame(className, methodName);
        threadNode.setCurrentFrame(frame);
        long overhead = System.currentTimeMillis() - time;
        if (frame.equals(previousFrame)) {
            previousFrame.incrementOverhead(overhead);
            return;
        }
        FrameNode iterator = previousFrame;
        while (!frame.equals(iterator)) {
            iterator.setStepReturnTime(time + overhead, overhead);
            iterator = iterator.getParent();
        }
    }

    protected static void initialize() {
        model = new RuntimeModel();
    }

    protected static RuntimeModel getModel() {
        return model;
    }
}

