package tutorial.ejb;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

/**
 * @author John Doe
 * 
 * @ejb.bean  name = "Fibo"
 *            display-name = "Fibo EJB"
 *            description = "EJB that computes Fibonacci suite"
 *            view-type = "remote"
 *            jndi-name = "ejb/tutorial/Fibo"
 */
public class FiboBean implements SessionBean {

	public FiboBean() {
		super();
	}

	/**
	 * Default create method
	 * @throws CreateException
	 * @ejb.create-method
	 */
	public void ejbCreate() throws CreateException {
	}

	public void ejbActivate() throws EJBException, RemoteException {
	}

	public void ejbPassivate() throws EJBException, RemoteException {
	}

	public void ejbRemove() throws EJBException, RemoteException {
	}

	public void setSessionContext(SessionContext arg0)
		throws EJBException, RemoteException {
	}

	/**
	 * @param number
	 * @return
	 * 
	 * @ejb.interface-method view-type = "remote"
	 */
	public double[] compute(int number) {
		if (number < 0) {
			throw new EJBException("Argument should be positive");
		}

		double[] suite = new double[number + 1];
		suite[0] = 0;

		if (number == 0) {
			return suite;
		}

		suite[1] = 1;

		for (int i = 2; i <= number; i++) {
			suite[i] = suite[i - 1] + suite[i - 2];
		}

		return suite;
	}
}
