package org.jbpm.gd.jpdl.ui.properties;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Script;

public class ScriptConfigurationComposite implements SelectionListener, FocusListener {
	
	public static ScriptConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		ScriptConfigurationComposite result = new ScriptConfigurationComposite();
		result.widgetFactory = widgetFactory;
		result.parent = parent;
		result.create();
		return result;
	}
	
	private TabbedPropertySheetWidgetFactory widgetFactory;
	private Composite parent;
	
	private Group scriptInfoGroup;
	private Label nameLabel;
	private Text nameText;
	private Button acceptPropagatedEventsButton;
	private Label scriptLabel;
	private Text scriptText;
	
	private Script script;
	
	private ScriptConfigurationComposite() {}
	
	public void setScript(Script script) {
		if (this.script == script) return;
		unhookListeners();
		this.script = script;
		if (script == null) {
			clearControls();
		} else {
			updateControls();
			hookListeners();
		}
	}
	
	public Script getScript() {
		return script;
	}
	
	private void hookListeners() {
		nameText.addSelectionListener(this);
		nameText.addFocusListener(this);
		scriptText.addSelectionListener(this);
		scriptText.addFocusListener(this);
		acceptPropagatedEventsButton.addSelectionListener(this);
	}
	
	private void unhookListeners() {
		nameText.removeSelectionListener(this);
		nameText.removeFocusListener(this);
		scriptText.removeSelectionListener(this);
		scriptText.removeFocusListener(this);
		acceptPropagatedEventsButton.removeSelectionListener(this);
	}
	
	private void clearControls() {
		nameText.setText("");
		acceptPropagatedEventsButton.setSelection(true);
		scriptText.setText("");
	}
	
	private void updateControls() {
		nameText.setText(script.getName() == null ? "" : script.getName());
		acceptPropagatedEventsButton.setSelection("true".equals(script.getAcceptPropagatedEvents()));
		scriptText.setText(script.getScript() == null ? "" : script.getScript());
	}
	
	private void create() {
		scriptInfoGroup = widgetFactory.createGroup(parent, "Script Info");
		scriptInfoGroup.setLayout(new FormLayout());
		scriptInfoGroup.setLayoutData(createScriptInfoGroupLayoutData());
		nameLabel = widgetFactory.createLabel(scriptInfoGroup, "Name");
		nameText = widgetFactory.createText(scriptInfoGroup, "");
		acceptPropagatedEventsButton = widgetFactory.createButton(scriptInfoGroup, "Accept Propagated Events", SWT.CHECK);
		scriptLabel = widgetFactory.createLabel(scriptInfoGroup, "Script");
		scriptText = widgetFactory.createText(scriptInfoGroup, "", SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		nameLabel.setLayoutData(createNameLabelLayoutData());
		nameText.setLayoutData(createNameTextLayoutData());
		acceptPropagatedEventsButton.setLayoutData(createAcceptPropagatedEventsButtonLayoutData());
		scriptLabel.setLayoutData(createScriptLabelLayoutData());
		scriptText.setLayoutData(createScriptTextLayoutData());
	}
	
	private FormData createNameLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		return data;
	}
	
	private FormData createNameTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(nameLabel, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(50, 0);
		return data;
	}
	
	private FormData createAcceptPropagatedEventsButtonLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(nameText, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}
	
	private FormData createScriptLabelLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(nameText, 5);
		return data;
	}

	private FormData createScriptTextLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(scriptLabel, 5);
		data.top = new FormAttachment(nameText, 5);
		data.right = new FormAttachment(100, -5);
		data.bottom = new FormAttachment(100, -5);
		data.height = 50;
		return data;
	}

	private FormData createScriptInfoGroupLayoutData() {
		FormData data = new FormData();
		data.left = new FormAttachment(0, 5);
		data.top = new FormAttachment(0, 5);
		data.right = new FormAttachment(100, -5);
		return data;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == nameText) {
			script.setName(nameText.getText());
		} else if (e.widget == scriptText) {
			script.setScript(scriptText.getText());
		}
	}

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == acceptPropagatedEventsButton) {
			script.setAcceptPropagatedEvents(acceptPropagatedEventsButton.getSelection() ? "true" : "false");
		}
	}

	public void focusGained(FocusEvent e) {
	}

	public void focusLost(FocusEvent e) {
		if (e.widget == nameText) {
			script.setName(nameText.getText());
		} else if (e.widget == scriptText) {
			script.setScript(scriptText.getText());
		}
	}
	
}
