package org.jbpm.gd.jpdl.ui.outline.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.Swimlane;

public class SwimlaneListOutlineEditPart extends JpdlElementOutlineEditPart {
	
	public SwimlaneListOutlineEditPart(ProcessDefinition model) {
		super(model);
	}
	
	protected String getIconName() {
		return "swimlanes_multiple.gif";
	}
	
	protected String getText() {
		return "Swimlanes";
	}
	
	protected List getModelChildren() {
		List result = new ArrayList();
		Swimlane[] swimlanes = ((ProcessDefinition)getModel()). getSwimlanes();
		for (int i = 0; i < swimlanes.length; i++) {
			result.add(swimlanes[i]);
		}
		return result;
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("swimlaneAdd")) {
			handleChildAdd(evt.getNewValue());
		} else if (eventName.equals("swimlaneRemove")) {
			refreshChildren();
			getViewer().select(this);
		} else {
			super.propertyChange(evt);
		}
	}
}
