package org.jbpm.gd.jpdl.ui.outline.part;

import java.net.URL;

import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.jpdl.model.JpdlElement;
import org.jbpm.gd.jpdl.ui.JpdlPlugin;
import org.jbpm.gd.jpdl.ui.JpdlSharedImages;

public abstract class JpdlOutlineEditPart extends AbstractTreeEditPart {
	
	private static final String ICON_LOCATION = "/icons/full/obj16/";

	private Image image;
	
	public JpdlOutlineEditPart(JpdlElement model) {
		setModel(model);
	}
	
	protected abstract String getIconName();
	
	protected Image getImage() {
		if (image == null) {
			String name = ICON_LOCATION + getIconName();
			URL url = JpdlPlugin.getDefault().getBundle().getEntry(name);
			ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
			image = JpdlSharedImages.INSTANCE.getImage(descriptor);
		}
		return image;
	}

}
