package org.jbpm.gd.jpdl.ui.notation;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.jpdl.model.NamedElement;

public class JpdlLabel extends Label {
	
	public void setSemanticElement(Object semanticElement) {
		super.setSemanticElement(semanticElement);
		setText(((NamedElement)semanticElement).getName());
	}

	public void propertyChange(PropertyChangeEvent evt) {
		String eventName = evt.getPropertyName();
		if (eventName.equals("name")) {
			setText((String)evt.getNewValue());
			firePropertyChange("text", evt.getOldValue(), evt.getNewValue());
		}
	}
	
}
