package org.jbpm.gd.common.figure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.JpdlElement;
import org.jbpm.gd.jpdl.model.SuperState;
import org.jbpm.gd.jpdl.ui.JpdlLabelProvider;

public class NodeFigureFactory {
	
	public static NodeFigureFactory INSTANCE = new NodeFigureFactory();
	
	private NodeFigureFactory() {
	}
	
	public IFigure createFigure(AbstractNotationElement notationElement) {
		Object semanticElement = notationElement.getSemanticElement();
		String label = null;
		ImageDescriptor imageDescriptor = null;
		if (semanticElement instanceof JpdlElement) {
			imageDescriptor = 
				JpdlLabelProvider.getImageDescriptor((JpdlElement)semanticElement);
			label = JpdlLabelProvider.getLabel((JpdlElement)semanticElement);
		}
		if (imageDescriptor == null) return null;
		if (semanticElement instanceof SuperState) {
			return new NodeContainerFigure();
		} else if (label != null) {
			return new NodeFigure(label, imageDescriptor);
		} else {
			return null;
		}
	}

}
