package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Transition;

public class StartStateDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"task", "transition", "event", "exception-handler"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("task", "task");
			NODE_TYPES.put("transition", "transition");
			NODE_TYPES.put("event", "event");
			NODE_TYPES.put("exception-handler", "exception-handler");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		StartState startState = (StartState)getJpdlElement();
		if (startState != null) {
			setAttribute("async", startState.getAsync());
			setAttribute("name", startState.getName());
			addElement(startState.getTask());
			addElements(startState.getTransitions());
			addElements(startState.getEvents());
			addElements(startState.getExceptionHandlers());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		StartState startState = (StartState)jpdlElement;
		startState.setAsync(getAttribute("async"));
		startState.setName(getAttribute("name"));
		startState.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("task".equals(evt.getPropertyName())) {
			setElement("task", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("taskRemove".equals(evt.getPropertyName())) {
			removeElement((Task)evt.getOldValue());
		} else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition)evt.getNewValue());
		} else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition)evt.getOldValue());
		} else if ("eventAdd".equals(evt.getPropertyName())) {
			addElement((Event)evt.getNewValue());
		} else if ("eventRemove".equals(evt.getPropertyName())) {
			removeElement((Event)evt.getOldValue());
		} else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
			addElement((ExceptionHandler)evt.getNewValue());
		} else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
			removeElement((ExceptionHandler)evt.getOldValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}

	protected void doModelUpdate(String name, String newValue) {
		StartState startState = (StartState)getJpdlElement();
		if ("name".equals(name)) {
			startState.setName(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		StartState startState = (StartState)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(child.getElementType());
		child.initialize(jpdlElement);
		if ("task".equals(type)) {
			startState.setTask((Task)jpdlElement);
		} else if ("transition".equals(type)) {
			startState.addTransition((Transition)jpdlElement);
		} else if ("event".equals(type)) {
			startState.addEvent((Event)jpdlElement);
		} else if ("exception-handler".equals(type)) {
			startState.addExceptionHandler((ExceptionHandler)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		StartState startState = (StartState)getJpdlElement();
		if ("task".equals(type)) {
			startState.setTask(null);
		} else if ("transition".equals(type)) {
			startState.removeTransition((Transition)child.getJpdlElement());
		} else if ("event".equals(type)) {
			startState.removeEvent((Event)child.getJpdlElement());
		} else if ("exception-handler".equals(type)) {
			startState.removeExceptionHandler((ExceptionHandler)child.getJpdlElement());
		}
	}

}
