package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.Condition;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;

public class ConditionDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Condition condition = (Condition)jpdlElement;
		condition.setScript(getTextContent());
		condition.setExpression(getAttribute("expression"));
		condition.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		Condition condition = (Condition)getJpdlElement();
		if (condition != null) {
			setTextContent(condition.getScript());
			setAttribute("expression", condition.getExpression());
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("script".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("expression".equals(evt.getPropertyName())) {
			setAttribute("expression", (String)evt.getNewValue());
		}
	}	
	
	protected void doModelUpdate(String name, String newValue) {
		Condition condition = (Condition)getJpdlElement();
		if ("#text".equals(name)) {
			condition.setScript(newValue);
		} else if ("expression".equals(name)) {
			condition.setExpression(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a controller cannot have any child nodes
	}
	
}
