package org.jbpm.gd.jpdl.model;


public class StartState extends AbstractNode {
	
	// override timer async
	
	private Task task;
	private String name;
	
	public void setAsync(String newAsync) {
		// the async attribute is not supported on end states
	}
	
	public String getAsync() {
		// the async attribute is not supported on end states
		return null;
	}
	
	public void addTimer(Timer timer) {
		// No timers can be added to a decision node
	}
	
	public void removeTimer(Timer timer) {
		// No timers can be added to a decision node
	}
	
	public Timer[] getTimers() {
		// No timers can be added to a decision node
		return new Timer[0];
	}
	
	public void setTask(Task newTask) {
		Task oldTask = task;
		task = newTask;
		firePropertyChange("task", oldTask, newTask);
	}
	
	public Task getTask() {
		return task;
	}
	
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		firePropertyChange("name", oldName, newName);
	}
	
	public String getName() {
		return name;
	}
	
	public boolean isPossibleChildOf(NodeElementContainer nodeElementContainer) {
		return nodeElementContainer instanceof ProcessDefinition && ((ProcessDefinition)nodeElementContainer).getStartState() == null;
	}
	
	public void initializeName(ProcessDefinition processDefinition) {
		setName(getNamePrefix());
	}

}
