package org.jbpm.gd.jpdl.model;


public class Decision extends AbstractNode {
	
	private Handler handler;
	private String expression;
	
	public void addTimer(Timer timer) {
		// No timers can be added to a decision node
	}
	
	public void removeTimer(Timer timer) {
		// No timers can be added to a decision node
	}
	
	public Timer[] getTimers() {
		// No timers can be added to a decision node
		return new Timer[0];
	}
	
	public void setHandler(Handler newHandler) {
		Handler oldHandler = handler;
		handler = newHandler;
		firePropertyChange("handler", oldHandler, newHandler);
	}
	
	public Handler getHandler() {
		return handler;
	}
	
	public void setExpression(String newExpression) {
		String oldExpression = expression;
		expression = newExpression;
		firePropertyChange("expression", oldExpression, newExpression);
	}
	
	public String getExpression() {
		return expression;
	}

}
