package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.List;

public class ConfigInfoElement extends AbstractJpdlElement {
	
	private String name;
	private String value;
	private List configInfoElements = new ArrayList();
	
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		firePropertyChange("name", oldName, newName);
	}
	
	public String getName() {
		return name;
	}
	
	public void setValue(String newValue) {
		String oldValue = value;
		value = newValue;
		firePropertyChange("value", oldValue, newValue);
	}
	
	public String getValue() {
		return value;
	}
	
	public void addConfigInfoElement(ConfigInfoElement configInfoElement) {
		configInfoElements.add(configInfoElement);
		firePropertyChange("configInfoElementAdd", null, configInfoElement);
	}
	
	public void removeConfigInfoElement(ConfigInfoElement configInfoElement) {
		configInfoElements.remove(configInfoElement);
		firePropertyChange("configInfoElementRemove", configInfoElement, null);
	}
	
	public ConfigInfoElement[] getConfigInfoElements() {
		return (ConfigInfoElement[])configInfoElements.toArray(new Object[configInfoElements.size()]);
	}
	
	

}
