package org.jbpm.gd.jpdl.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


public abstract class AbstractJpdlElement implements JpdlElement {
	
	private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	private String elementId;
	
	protected void firePropertyChange(String name, Object oldValue, Object newValue) {
		if ((oldValue == newValue) || (oldValue != null && oldValue.equals(newValue))) return;
		propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}
	
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}
	
	public void setElementId(String id) {
		this.elementId = id;
	}
	
	public String getElementId() {
		return elementId;
	}
	
}
