/* { dg-options "-O2 -mam33 -g0 -fno-unroll-loops -fno-unroll-all-loops" } */
/* { dg-do compile } */
/* { dg-final { scan-assembler "mov_lne" } } */

/* Check that that compiler can generate a combined MOV and LOOP instruction.
   -am33 is used because the MN10300 does not have LIW instructions.
   -O2 is used because at least this much optimization is needed in order to synthesise LIW instructions.
   -g0 is used because (currently) debug info generation inserts labels that prevent LIW synthesis.
   -fno-unroll-loops and -fno-unroll-all-loops are used because we need the loops to be present.  */

int z = 8;
int in[10];
int out[10];

int
foo (int arg)
{
  int b = 0;

  while (arg < z)
    {
      out[arg] = b;
      b = in[arg];
      arg ++;
    }
    
  return arg;
}

int
main (void)
{
  return foo (4);
}
