; { dg-output "pass" }

;; Various helper functions

(defmacro call-with-i18n-file (file mode encoding . thunk)
  `(let ((p #f))
     (dynamic-wind
      (lambda () (set! p (open-file ,file ,mode ,encoding)))
      (lambda () (,@thunk p))
      (lambda () (close-port p)))))

(defmacro call-with-iso-8859-1-input-file (file . thunk)
  `(call-with-i18n-file ,file OPEN_READ *iso-8859-1* ,@thunk))

(defmacro call-with-iso-8859-1-output-file (file . thunk)
  `(call-with-i18n-file ,file OPEN_WRITE *iso-8859-1* ,@thunk))

;; Given a latin1 encoded text file, return a string
;; containing the contents of that file.

(define (latin1-file->string file)
  (call-with-iso-8859-1-input-file file
    (lambda (p)
      (let ((s ""))
        (letrec ((read-loop
                  (lambda (s)
                    (let ((c (read-char p)))
                      (if (not (eof-object? c))
                          (read-loop (string-append s (string c)))
                          s)))))
          (read-loop s))))))

;; Load a latin1 encoded text FILE into a string. 
;; Write and read this string to and from a file.
;; Compare the end result string with the initial string.

(define (latin1-file-test file)
  (let ((n (latin1-file->string file))) 

    (call-with-iso-8859-1-output-file "tmp.iso-8859-1"
      (lambda (p)
	(write n p)))

    (if (string=? n (call-with-iso-8859-1-input-file "tmp.iso-8859-1"
						     (lambda (p)
						       (read p))))
	'pass
	'fail)))

;; Perform the test!

(display (latin1-file-test (test-file "news2.txt")))

						    