; $Id: run-test.scm,v 1.1.1.1 2003/02/18 20:59:33 green Exp $

;;;
;;; test-file returns a replative path to the file x in the
;;; appropriate testsuite dir. It is redefined with the -p option.
;;;

(define test-file (lambda (x) x))

;;; The correct way to invoke run-test is:
;;;
;;;   guile -q -b run-test.scm [-fFEATURE] -t TESTFILE
;;;
;;; where FEATURE is a symbol that may be in the *features* list.
;;; If FEATURE is not in the *features* list, a message is
;;; printed and the program exits.
;;; If FEATURE is in the *features* list, TESTFILE is loaded.             

(define (feature-test f)
  (if (not (memq (string->symbol f) *features*))
      (begin
	(display "unsupported feature: ")
	(display f)
	(display "\n")
	(quit))))

(dynamic-wind
 (lambda () #t)

 (lambda ()
   (set! program-arguments
	 (let* ((prog-name (car (program-arguments)))
		(remaining-argv
		 (let loop ((argv (cdr (program-arguments))))
		   (get-option argv
			       #f
		               '(:f :p :t)
			       (lambda (opt arg argv)
				 (case opt
				   ((:f)	(feature-test arg)
						(loop argv))
				   ((:p)        (set! test-file
						      (lambda (x)
							(string-append
							 arg "/" x)))
						(loop argv))
				   ((:t)	(catch #t 
						       (lambda () 
							 (let ((stderr (current-error-port)))
							   (dynamic-wind
							    (lambda () (set-current-error-port (current-output-port)))
							    (lambda () (load arg))
							    (lambda () (set-current-error-port stderr)))))
						       (lambda (key a b) 
							 (display "Caught error in run-test. Exiting.")
							 (quit)))
						(loop argv))
				   (else argv))))))
		(args (cons prog-name remaining-argv)))
	   (lambda () args))))

 (lambda () (if batch? (quit))))
