;; a program that spawns off a couple of threads that communicate with
;; a pipe.  this is a thread version of the typical UNIX fork() example.

(require 'debug)

(define (rchild fd)
  (letrec ((iport (%fdopen fd "r"))
	   (c #t)
	   (get-chars
	    (lambda ()
	      (begin
		(set! c (read-char iport))
		(if (not (eof-object? c))
		    (get-chars))))))
    (print (input-port? iport))
;;    (print iport)
;;    (print (%fileno iport))
    (get-chars)
    (close-input-port iport)))



(define (sample-thread delay)
  (begin
    (monitor
     (print "this thread was invoked with a delay of " delay)
     (print "About to go to sleep:"))
    (force-output)
    (sleep delay)
    (monitor
     (print delay "-> done with sleeping"))
    (force-output)))

;; arrange the threads we are creating in a list
(define list-of-threads (list (make-thread (lambda () (sample-thread 40)))
			      (make-thread (lambda () (sample-thread 90)))
			      (make-thread (lambda () (sample-thread 70)))
			      (make-thread (lambda () (sample-thread 55)))))

;; now invoke join-thread: this makes sure that the guile "read"
;; statement (which waits for the next scheme expression) does not
;; block out the threads: join-thread will make sure they have all
;; finished executing.
(for-each join-thread list-of-threads)

(newline) (newline)
(print "all threads seem to have terminated")
